<?php
/**
 * The default template for displaying content with Featured image. Used in page-blog.php.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 1.0
 */
?>

<!-- Begin Article -->
<div id="datebook-post-<?php the_ID(); ?>" <?php post_class('datebook-custom-card card mb-3'); ?>>
	<div class="card-body">

		<header class="datebook-entry-header">

			<h1><?php the_title(); ?></h1>

		</header>

	<div class="border-top border-bottom border-dark mb-4 p-2 datebook-article-meta">

		<?php datebook_entry_meta(); ?>

	</div>
	<!--end article-meta-->
	
	<?php if (get_post_thumbnail_id()) { ?>

		<div class="datebook-article-media thumbnail">

			<?php the_post_thumbnail();?>

		</div>
		<!--end article-media-->

	<?php } ?>

	<div class="datebook-article-content">

		<?php

		the_content();

		wp_link_pages( array( 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'datebook' ), 'after' => '</div>' ) );

		?>

	</div>
	<!--end article-content--> 

</div>

	<div class="card-footer datebook-article-meta-footer">
		
		<?php datebook_entry_meta_footer(); ?>
		
	</div>
	<!--end article-meta-footer-->

</div>
<!-- End  Article -->

<?php edit_post_link( esc_html__( 'Edit this post', 'datebook' ), '<div class="datebook-custom-card card mb-3 datebook-blogs-page"><div class="card-body">', '</div></div>', 0, 'btn btn-secondary btn-sm edit-link' );