<?php
/**
 * Header
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 2.0
 */

?>

<div id="datebook-header" class="bg-dark mb-3">
	<div class="datebook-front-view">

		<?php if (get_theme_mod( 'datebook_show_top_menu', 1 ) == '1' && (has_nav_menu('datebook-top-menu-left-' . DATEBOOK_WPLANG) || has_nav_menu('datebook-top-menu-right-' . DATEBOOK_WPLANG))) { ?>

		<div class="datebook-top-menu">
			<nav class="navbar navbar-expand-md navbar-dark shadow-none pt-1 pb-1">
				<div class="container">

					<button class="navbar-toggler m-auto black" type="button" data-toggle="collapse" data-target="#navbarTopContent" aria-controls="navbarTopContent" aria-expanded="false" aria-label="<?php esc_html_e( 'Menu', 'datebook' ); ?>"><span class="navbar-toggler-icon"></span></button>

					<div class="collapse navbar-collapse ml-auto" id="navbarTopContent">

						<?php

						if ( has_nav_menu( 'datebook-top-menu-left-' . DATEBOOK_WPLANG ) ) {

							wp_nav_menu(array(
								'theme_location'  => 'datebook-top-menu-left-' . DATEBOOK_WPLANG,
								'container'       => 'div',
								'container_id'    => 'datebook-top-menu-left-' . DATEBOOK_WPLANG,
								'container_class' => 'mr-auto',
								'menu_id'         => false,
								'menu_class'      => 'navbar-nav datebook-top-menu-left',
								'depth'           => 2,
								'fallback_cb'     => 'bs4navwalker::fallback',
								'walker'          => new bs4navwalker()
							));

						}

						if ( has_nav_menu( 'datebook-top-menu-right-' . DATEBOOK_WPLANG ) ) {

							wp_nav_menu(array(
								'theme_location' => 'datebook-top-menu-right-' . DATEBOOK_WPLANG,
								'container'       => 'div',
								'container_id'    => 'datebook-top-menu-right-' . DATEBOOK_WPLANG,
								'container_class' => 'ml-auto',
								'menu_id'         => false,
								'menu_class'      => 'navbar-nav datebook-top-menu-right',
								'depth'           => 2,
								'fallback_cb'     => 'bs4navwalker::fallback',
								'walker'          => new bs4navwalker()
							));

						}

						?>

					</div>
				</div>
			</nav>
		</div>

		<?php } ?>

		<nav class="navbar navbar-dark navbar-expand-lg shadow-none">

			<div class="container">

				<?php

				if (get_theme_mod( 'datebook_logo' ) != '') {

					echo '<a class="navbar-brand datebook-logo" href="' . esc_url(home_url()) . '/" title="' . esc_attr(get_bloginfo('name')) . ' - ' . esc_attr(get_bloginfo('description')) . '"><img src="' . esc_url(get_theme_mod( 'datebook_logo' )) . '" alt="' . esc_attr(get_bloginfo('name')) . '" /></a>';

				} else {

					echo '<h1 class="navbar-brand mb-0 h1"><a class="datebook-logo" href="' . esc_url(home_url()) . '/" title="' . esc_attr(get_bloginfo('name')) . ' - ' . esc_attr(get_bloginfo('description')) . '">' . esc_attr(get_bloginfo('name')) . '</a></h1>';

				}

				?>

				<button class="navbar-toggler grey darken-3" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php esc_html_e( 'Menu', 'datebook' ); ?>"><span class="navbar-toggler-icon"></span></button>

				<div class="collapse navbar-collapse" id="navbarSupportedContent">

				<?php

				if ( has_nav_menu( 'datebook-primary-menu-' . DATEBOOK_WPLANG ) ) {

					wp_nav_menu(array(
						'theme_location'	=> 'datebook-primary-menu-' . DATEBOOK_WPLANG,
						'container'			=> 'div',
						'container_id'		=> 'datebook-primary-menu-' . DATEBOOK_WPLANG,
						'container_class'	=> '',
						'menu_id'			=> false,
						'menu_class'		=> 'navbar-nav mr-auto datebook-primary-menu',
						'depth'				=> 5,
						'fallback_cb'		=> 'bs4navwalker::fallback',
						'walker'			=> new bs4navwalker()
					));
					
				} else {

					$datebook_default_menu = wp_nav_menu(array(
						'depth'				=> 5,
						'echo'				=> false
					));

					if ($datebook_default_menu) {

						wp_nav_menu(array(
							'container'			=> 'div',
							'container_id'		=> 'datebook-primary-menu-' . DATEBOOK_WPLANG,
							'container_class'	=> '',
							'menu_id'			=> false,
							'menu_class'		=> 'navbar-nav mr-auto datebook-primary-menu',
							'depth'				=> 5,
							'fallback_cb'		=> 'bs4navwalker::fallback',
							'walker'			=> new bs4navwalker()
						));

					} else {
						
						?>

						<div id="datebook-primary-menu-en_US" class="menu-primary-container">
							<ul class="navbar-nav m-auto datebook-primary-menu">

								<?php

									wp_list_pages(
										array(
											'match_menu_classes' => true,
											'show_sub_menu_icons' => true,
											'title_li' => false,
											'walker'   => new DateBook_Pages_Walker_Page(),
										)
									);
								
								?>

							</ul>
						</div>

				<?php

					}

				}

				?>

				</div>
			</div>
		</nav>
	</div>
</div>