<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {

	echo '<div class="alert alert-warning">';

	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', esc_html__( 'You must be logged in to checkout.', 'datebook' ) ) );

	echo '</div>';

	return;
}

?>

<div class="datebook-custom-card card tooltip-demo">
	<div class="card-body">

		<h2><?php esc_html_e( 'Checkout', 'datebook' ); ?></h2>
        
		<?php
        
		/**
		 * My Account navigation.
		 *
		 * @since 2.6.0
		 */

		do_action( 'woocommerce_account_navigation' ); 

		do_action( 'woocommerce_before_checkout_form', $checkout );
		
		if(function_exists('of_get_option')){

			$my_checkout_page = of_get_option('my_checkout_page');

		} else {

			$my_checkout_page = '';

		}

		?>
        
		<div class="card border-0 datebook-transparent">
        
        	<div class="woocommerce-MyAccount-content">
            
				<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url(get_permalink($my_checkout_page)); ?>" enctype="multipart/form-data">

				<?php if ( $checkout->get_checkout_fields() ) : ?>

					<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

					<div class="col2-set" id="customer_details">

						<?php do_action( 'woocommerce_checkout_billing' ); ?>

					</div>

					<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

				<?php endif; ?>

				<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>

				<h3 id="order_review_heading"><?php esc_html_e( 'Your order', 'datebook' ); ?></h3>

				<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

				<div id="order_review" class="woocommerce-checkout-review-order">
					<?php do_action( 'woocommerce_checkout_order_review' ); ?>
				</div>

				<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

				</form>            

            </div>

		</div>
        
        
        <?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
        
        
	</div>
</div>