<?php
/**
 * Orders
 *
 * Shows orders on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/orders.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_orders', $has_orders ); ?>

<?php if ( $has_orders ) : ?>

	<table class="table table-sm">
		<thead>
			<tr>
				<?php foreach ( wc_get_account_orders_columns() as $column_id => $column_name ) : ?>
					<th class="woocommerce-orders-table__header woocommerce-orders-table__header-<?php echo esc_attr( $column_id ); ?>"><span class="nobr"><?php echo esc_html( $column_name ); ?></span></th>
				<?php endforeach; ?>
			</tr>
		</thead>

		<tbody>
			<?php foreach ( $customer_orders->orders as $customer_order ) :
				$order      = wc_get_order( $customer_order );
				$item_count = $order->get_item_count();
				?>
				<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr( $order->get_status() ); ?> order">
					<?php foreach ( wc_get_account_orders_columns() as $column_id => $column_name ) : ?>
						<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-<?php echo esc_attr( $column_id ); ?>" data-title="<?php echo esc_attr( $column_name ); ?>">
							<?php if ( has_action( 'woocommerce_my_account_my_orders_column_' . $column_id ) ) : ?>
								<?php do_action( 'woocommerce_my_account_my_orders_column_' . $column_id, $order ); ?>

							<?php elseif ( 'order-number' === $column_id ) : ?>
								
									<?php echo _x( '#', 'hash before order number', 'datebook' ) . $order->get_order_number(); ?>
								

							<?php elseif ( 'order-date' === $column_id ) : ?>
								<time datetime="<?php echo esc_attr( $order->get_date_created()->date( 'c' ) ); ?>"><?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?></time>

							<?php elseif ( 'order-status' === $column_id ) : ?>
								<?php 

								if($order->get_status() == 'completed'){
									echo '<span style="padding: 1px 5px 3px; background: #08b908; color:white; border-radius: 3px">' . esc_html(wc_get_order_status_name($order->get_status())) . '</span>';
								} else if($order->get_status() == 'on-hold'){
									echo '<span style="padding: 1px 5px 3px; background: orange; color:white; border-radius: 3px">' . esc_html(wc_get_order_status_name($order->get_status())) . '</span>';
								} else {
									echo esc_html(wc_get_order_status_name($order->get_status()));
								}

								?>

							<?php elseif ( 'order-total' === $column_id ) : ?>
								<?php
								/* translators: 1: formatted order total 2: total order items */
								printf( _n( '%1$s for %2$s item', '%1$s for %2$s items', $item_count, 'datebook' ), $order->get_formatted_order_total(), $item_count );
								?>

							<?php elseif ( 'order-actions' === $column_id ) : ?>
								<?php
								$actions = wc_get_account_orders_actions( $order );
								
								if(function_exists('of_get_option')){
									$my_upgrade_page = of_get_option('my_upgrade_page');
									$my_checkout_page = of_get_option('my_checkout_page');
								} else {
									$my_upgrade_page = '';
									$my_checkout_page = '';
								}

								$action_view_url = wc_get_endpoint_url( 'view-order', $order->get_order_number(), get_permalink($my_upgrade_page) );
								
								$action_checkout_url = wc_get_endpoint_url( 'order-pay', $order->get_order_number(), get_permalink($my_checkout_page) );
								
								$action_cancel_url = wc_get_endpoint_url( 'orders', $order->get_order_number(), get_permalink($my_upgrade_page));

								if ( ! empty( $actions ) ) {
									foreach ( $actions as $key => $action ) {
										
										if($key == 'view'){
											$action['url'] = $action_view_url;
										} else {
											$action['url'] = $action['url'];
										}

										if($key == 'pay'){
											$exploded_url = explode('?', $action['url']);
											$action['url'] = $action_checkout_url . '?' . $exploded_url[1];
										} else {
											$action['url'] = $action['url'];
										}

										if($key == 'cancel'){
											$exploded_url = explode('?', $action['url']);
											$action['url'] = $action_cancel_url . '?' . $exploded_url[1];
										} else {
											$action['url'] = $action['url'];
										}

										echo '<a href="' . esc_url( $action['url'] ) . '" class="woocommerce-button button ' . sanitize_html_class( $key ) . '">' . esc_html( $action['name'] ) . '</a> ';
									}
								}
								?>
							<?php endif; ?>
						</td>
					<?php endforeach; ?>
				</tr>
			<?php endforeach; ?>
		</tbody>
	</table>

	<?php do_action( 'woocommerce_before_account_orders_pagination' ); ?>

	<?php if ( 1 < $customer_orders->max_num_pages ) : ?>
    
    	<hr/>

		<div class="woocommerce-pagination woocommerce-pagination--without-numbers woocommerce-Pagination">
			<?php if ( 1 !== $current_page ) : ?>
				<a class="woocommerce-button woocommerce-button--previous woocommerce-Button woocommerce-Button--previous button" href="<?php echo esc_url( wc_get_endpoint_url( 'orders', $current_page - 1 ) ); ?>"><?php esc_html_e( 'Previous', 'datebook' ); ?></a>
			<?php endif; ?>

			<?php if ( intval( $customer_orders->max_num_pages ) !== $current_page ) : ?>
				<a class="woocommerce-button woocommerce-button--next woocommerce-Button woocommerce-Button--next button" href="<?php echo esc_url( wc_get_endpoint_url( 'orders', $current_page + 1 ) ); ?>"><?php esc_html_e( 'Next', 'datebook' ); ?></a>
			<?php endif; ?>
		</div>
	<?php endif; ?>

<?php else : ?>

	<p><?php esc_html_e( 'No order has been made yet.', 'datebook' ); ?></p>

<?php endif; ?>

<?php do_action( 'woocommerce_after_account_orders', $has_orders ); ?>
