<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' );

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-page' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-page' ) ? 1 : 0;
}


?>


<!-- content -->
<div class="row">

<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-9 col-sm-9 datebook-padding-less <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

<?php endif; ?>

		<div class="mb-3 datebook-blogs-page">
			<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">
				<div class="datebook-custom-card card">
					<div class="card-body">

					<?php
					/**
					 * woocommerce_before_main_content hook.
					 *
					 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
					 * @hooked woocommerce_breadcrumb - 20
					 */
					do_action( 'woocommerce_before_main_content' );
					?>

					<?php while ( have_posts() ) : the_post(); ?>

						<?php wc_get_template_part( 'content', 'single-product' ); ?>

					<?php endwhile; // end of the loop. ?>

					<?php
					/**
					 * woocommerce_after_main_content hook.
					 *
					 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
					 */
					do_action( 'woocommerce_after_main_content' );
					?>

					</div>
				</div>
			</div>
		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-3 col-sm-3 datebook-padding-less <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php
			/**
			 * woocommerce_sidebar hook.
			 *
			 * @hooked woocommerce_get_sidebar - 10
			 */
			do_action( 'woocommerce_sidebar' );
			?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->


<?php get_footer( 'shop' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
