<?php
/**
 * The template for displaying comments
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package WordPress
 * @subpackage DateBook
 * @since DateBook 1.0
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */

if ( post_password_required() ) {
	return;
}

?>

<div class="datebook-custom-card card">

	<div id="comments" class="card-header">
		<h2 class="datebook-comments-title"><?php printf( _n( 'One comment', '%1$s comments', get_comments_number(), 'datebook' ), number_format_i18n( get_comments_number() ) ); ?></h2>
	</div>

	<div class="card-body">

		<div id="datebook-comments" class="datebook-comments-area">

			<?php if ( have_comments() ) : ?>

				<ul class="list-unstyled">
					<?php wp_list_comments( array( 'callback' => 'datebook_comment', 'style' => 'ul' ) ); ?>
				</ul>
				<!-- /comment-list -->
			
				<?php the_comments_navigation(); ?>

			<?php else : ?>
			
				<p><?php esc_html_e( 'No comments yet', 'datebook' ); ?></p>
			
			<?php endif; // Check for have_comments(). ?>

		</div>
	</div>

	<?php 

	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	
	?>

		<div class="card-footer">
			<?php esc_html_e( 'Comments are closed.', 'datebook' ); ?>
		</div>

	<?php endif; ?>

	<?php datebook_comment_form(); ?>

</div>
<!-- /comments-area -->