<?php
/**
 * All functions
 */


/**
 * Define default language
 *
 * @return array
 */
if (!defined('DATEBOOK_WPLANG')) {
	define('DATEBOOK_WPLANG', get_locale());
}


/**
 * Catch first image in post
 *
 * @return array
 */
function datebook_catch_first_post_image() {

	global $post;

	$first_img = '';

	ob_start();

	ob_end_clean();

	$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);

	$first_img = isset( $matches[1][0] ) ? $matches[1][0] : null;

    if ( empty( $first_img ) ) {
		$first_img = get_template_directory_uri() . '/assets/images/blog-no-image.jpg'; // path to default image.
    }

	return $first_img;

}


/**
 * Get Color Schemes list
 *
 * @return array
 */
function datebook_get_color_schemes_theme() {
	
	$datebook_color_array = array();
	$datebook_color_array[''] = esc_html__('Default', 'datebook' );
	
	$get_template_directory = get_template_directory();

	$datebook_color_array['none'] = 'No theme';

	// Material Design for Bootstrap. Version: MDB FREE. https://mdbootstrap.com
	$datebook_color_array['mdbootstrap'] = 'Material Design for Bootstrap';

	$folders_bootswatch = glob( $get_template_directory . '/assets/css/colors/bootswatch/*', GLOB_ONLYDIR);
	
	foreach ( $folders_bootswatch as $file ) {
		
		$file = str_replace($get_template_directory . '/assets/css/colors/bootswatch/', '', $file);

		$datebook_color_array['bootswatch_' . $file] = $file;

	}

	$files = glob( $get_template_directory . '/assets/css/colors/' . '/*.css' );

	foreach ( $files as $file ) {

		$fileParts = pathinfo( $file );
		
		$file_basename = substr( $fileParts[ 'basename' ], 0, strpos( $fileParts[ 'basename' ], '.' ) );

		$datebook_color_array[$file_basename] = $file_basename;

	}

	return $datebook_color_array;

}


// Show date information for current post
if ( ! function_exists( 'datebook_entry_date' ) ) :
function datebook_entry_date() {

	if (class_exists('DateBook_Utilities')){
		$get_the_date = DateBook_Utilities::datebook_date_i18n(1, get_the_date(), true);
	} else {
		$get_the_date = get_the_date();
	}

	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		$get_the_date,
		esc_attr( get_the_modified_date( 'c' ) ),
		get_the_modified_date()
	);

	printf( '<li class="list-inline-item"><span class="posted-on"><i class="fa fa-calendar"></i> <a class="text-dark" href="%1$s" rel="bookmark">%2$s</a></span></li> ',
		esc_url( get_permalink() ),
		$time_string
	);

}
endif;


// Show meta information for the date, author, comments
if ( ! function_exists( 'datebook_entry_meta' ) ) :
function datebook_entry_meta() {

	if ( in_array( get_post_type(), array( 'post', 'page', 'attachment' ) ) ) {

		echo '<ul class="list-inline datebook-blog-info small">';

		datebook_entry_date();

		//printf( '<li class="list-inline-item"><span class="author vcard"><i class="fa fa-user"></i> <a class="url fn n" href="%1$s">%2$s</a></span></li>', esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), get_the_author());

		if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {

			printf( '<li class="list-inline-item"><span class="comments-link"><i class="fa fa-comments"></i></span> <a class="text-dark" href="%2$s#comments">%1$s</a></li>',
			sprintf( _n( '%s comment', '%s comments', get_comments_number(), 'datebook' ), number_format_i18n( get_comments_number() ) ),
			get_permalink());

		}

		echo '</ul>';
	
	}
	
}
endif;


// Determine whether blog/site has more than one category.
function datebook_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'datebook_categories' ) ) ) {

		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'datebook_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 0 ) {
		// This blog has more than 1 category so datebook_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so datebook_categorized_blog should return false.
		return false;
	}

}


// Show category and tags for current post
if ( ! function_exists( 'datebook_entry_taxonomies' ) ) :
function datebook_entry_taxonomies() {

	$categories_list = get_the_category_list( _x( ', ', 'Used between list items, there is a space after the comma.', 'datebook' ) );
	if ( $categories_list && datebook_categorized_blog() ) {
		
		printf( '<li class="list-inline-item"><i class="fa fa-folder"></i> <span class="cat-links">%1$s</span></li>',
			$categories_list
		);
	}

	$tags_list = get_the_tag_list( '', _x( ', ', 'Used between list items, there is a space after the comma.', 'datebook' ) );
	if ( $tags_list ) {
		printf( '<li class="list-inline-item"><i class="fa fa-tags"></i> <span class="tags-links">%1$s</span></li>',
			$tags_list
		);
	}

}
endif;


// Show meta information for the categories, tags
if ( ! function_exists( 'datebook_entry_meta_footer' ) ) :
function datebook_entry_meta_footer() {

	echo '<ul class="list-inline datebook-blog-info small">';
	
	if ( 'post' === get_post_type() ) {

		datebook_entry_taxonomies();

	}

	echo '</ul>';
	
}
endif;


// Display an optional post thumbnail
if ( ! function_exists( 'datebook_post_thumbnail' ) ) :
function datebook_post_thumbnail() {

	if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
		return;
	}

	if ( is_singular() ) :
	?>

	<div class="post-thumbnail">
		<?php the_post_thumbnail(); ?>
	</div>

	<?php else : ?>

	<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
		<?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => the_title_attribute( 'echo=0' ) ) ); ?>
	</a>

	<?php endif; // End is_singular()

}
endif;


/**
 * Set constants for Sidebar and Main Content layout
 *
 */
function datebook_set_sidebar_layout() {

	if (get_theme_mod( 'datebook_sidebar_layout', 0 ) == 0) {
		
		define('DATEBOOK_CONTENT_SIDE', 'order-lg-2');
		define('DATEBOOK_SIDEBAR_SIDE', 'order-lg-1');

	} else {
		
		define('DATEBOOK_CONTENT_SIDE', 'order-lg-1');
		define('DATEBOOK_SIDEBAR_SIDE', 'order-lg-2');

	}
}
datebook_set_sidebar_layout();