<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 1.0
 */

?>

<!-- Begin Article -->
<div id="datebook-post-<?php the_ID(); ?>" <?php post_class('datebook-custom-card card mb-3'); ?>>
	<div class="card-body">

		<header class="datebook-entry-header">

			<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>

		</header><!-- .entry-header -->

		<?php if (get_post_thumbnail_id()) { ?>
			<div class="datebook-article-media thumbnail">
				<?php the_post_thumbnail();?>
			</div>
			<!--end article-media--> 
		<?php } ?>
	

		<div class="datebook-entry-content">

			<?php

			the_content();

			//echo do_shortcode(get_the_content());

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'datebook' ),
				'after'  => '</div>',
			) );
			?>
		</div>

	</div><!-- .entry-content -->
</div>
<!-- End  Article -->