jQuery(document).ready(function($) {

	"use strict";
	
	// Logout user after some period of inactivity
	if( $('body').hasClass('logged-in') ){

		auto_logout.init();

	}

});


	var auto_logout = {

		timeoutID : 0,

		endTimmer : function() {
			"use strict";
			document.removeEventListener("mousemove", auto_logout.resetTimer, false);
			document.removeEventListener("mousedown", auto_logout.resetTimer, false);
			document.removeEventListener("keypress", auto_logout.resetTimer, false);
			document.removeEventListener("DOMMouseScroll", auto_logout.resetTimer, false);
			document.removeEventListener("mousewheel", auto_logout.resetTimer, false);
			document.removeEventListener("touchmove", auto_logout.resetTimer, false);
			document.removeEventListener("MSPointerMove", auto_logout.resetTimer, false);
		},

		goInactive : function() {
			"use strict";
				var data = {
					'action': 'logout',
					'time': true,
				};
				jQuery.post(datebook_logout_url.ajax_url, data, function(response) {
					auto_logout.endTimmer();
					alert('You have been logged out due to inactivity.');
				});
		},

		startTimer : function() {
			"use strict";
			var timeout_defined = datebook_logout_url.datebook_idle_time * 60000; // Minutes
    		auto_logout.timeoutID = window.setTimeout(auto_logout.goInactive, timeout_defined); // Three minutes logout
		},

	 	goActive : function() {
			"use strict";
 			 auto_logout.startTimer();
	 	},

		resetTimer : function() {
			"use strict";
    		window.clearTimeout(auto_logout.timeoutID);
	    	auto_logout.goActive();
		},

		init : function() {
			"use strict";
		    document.addEventListener("mousemove", auto_logout.resetTimer, false);
	    	document.addEventListener("mousedown", auto_logout.resetTimer, false);
		    document.addEventListener("keypress", auto_logout.resetTimer, false);
		    document.addEventListener("DOMMouseScroll", auto_logout.resetTimer, false);
	    	document.addEventListener("mousewheel", auto_logout.resetTimer, false);
		    document.addEventListener("touchmove", auto_logout.resetTimer, false);
		    document.addEventListener("MSPointerMove", auto_logout.resetTimer, false);
		},

	};

