/*
 * DateBook Reviews
 */
jQuery(document).ready(function($) {

	"use strict";

	function datebook_apply_rating( rating, obj ) {
    	obj.parent( 'p.datebook-review-rating.allow-edit' ).find( "span" ).removeClass( 'rating-on' );
		var i = 0;
	    for ( i = 1; i <= rating; i++ ) {
    	    obj.parent( 'p.datebook-review-rating.allow-edit' ).find( "span.rate-" + i ).addClass( 'rating-on' );
	    }
    	var off_rating = 5 - rating;
	    for ( i = 1; i <= off_rating; i++ ) {
    	    var a = i + rating;
        	obj.parent( 'p.datebook-review-rating.allow-edit' ).find( "span.rate-" + a ).addClass( 'rating-off' );
	    }
	}

	$(document).on('click', '.datebook-review-rating.allow-edit > span', function() {
        var rating = jQuery( this ).data( "rating" );
        datebook_apply_rating( rating, jQuery( this ) );
		$(this).parent( 'p.datebook-review-rating' ).find( 'input[name="datebook_review_rating"]' ).val( rating );
    } );

	$(".datebook-review-rating.allow-edit > span").on({mouseenter: function(){
		var rating = $(this).data("rating");
		datebook_apply_rating(rating, $(this));
		},
		mouseleave: function () {
			var rating = $(this).parent('p.datebook-review-rating').find('input[name="datebook_review_rating"]').val();
			datebook_apply_rating(rating, $(this));
	    }
	});
	
} );

