<?php
/**
 * Create Profile Form.
 *
 * @class DateBook_Profile_Form_Table
 * @author Pagick Themes
 * @since 1.6
 */
	 

class Options_Framework_Profile_Form {
	

	/**
	 * This function renders our profile form
	 *
	 */
	static function get_all_forms($get_profile_form_array) {

		$all_forms = array();

		$all_forms['registration_form'] = array('form_name' => 'registration_form', 'title' => esc_html__( 'Registration form', 'datebook' ), 'shortcode' => 'registration_form', 'description' => esc_html__( 'All fields are visible on the registration page only but not visible on the profile page and to the public', 'datebook' ), 'notice' => esc_html__( 'Notice: it is recommended to add the same fields in the registration and settings forms', 'datebook' ), 'fields' => $get_profile_form_array);
		$all_forms['settings_form'] = array('form_name' => 'settings_form', 'title' => esc_html__( 'Settings form', 'datebook' ), 'shortcode' => 'settings_form', 'description' => esc_html__( 'All fields are visible on the settings page only but not visible on the profile page and to the public', 'datebook' ), 'notice' => esc_html__( 'Notice: it is recommended to add the same fields in the registration and settings forms', 'datebook' ), 'fields' => $get_profile_form_array);
		$all_forms['profile_form'] = array('form_name' => 'profile_form', 'title' => esc_html__( 'Profile form', 'datebook' ), 'shortcode' => 'profile_form', 'description' => esc_html__( 'All fields are visible on the edit profile page, profile page and the public', 'datebook' ), 'notice' => esc_html__( 'Notice: it is recommended to add the same fields in the Profile and Search forms.', 'datebook' ), 'fields' => $get_profile_form_array);
		//$all_forms['search_form_front'] = array('form_name' => 'search_form_front', 'title' => 'Search form on Front page', 'shortcode' => 'search_form_front', 'description' => '', 'fields' => $get_profile_form_array);
		$all_forms['search_form_other'] = array('form_name' => 'search_form_other', 'title' => esc_html__( 'Search form on Search page', 'datebook' ), 'shortcode' => 'search_form_other', 'description' => esc_html__( 'All fields are visible on the search page and the public', 'datebook' ), 'notice' => esc_html__( 'Notice: it is recommended to add the same fields in the Profile and Search forms.', 'datebook' ), 'fields' => $get_profile_form_array);
		//$all_forms['profile_on_search'] = array('form_name' => 'profile_on_search', 'title' => 'Profile on Search page', 'shortcode' => 'profile_on_search', 'description' => '', 'fields' => $get_profile_form_array);

		return $all_forms;

	}


	/**
	 * Search for slug in array
	 *
	 */
	static function datebook_search_in_array($needle, $haystack) {

		$found = false;
		
		if(isset($haystack) && !empty($haystack) && is_array($haystack)){

			foreach ($haystack as $item) {
				if ($item === $needle) {
					$found = true;
						break;
				} elseif (is_array($item)) {
					$found = self::datebook_search_in_array($needle, $item);
					if($found) {
						break;
					}
				}
			}
		}
		return $found;
	}


	/**
	 * Re-order array as parent and children tree
	 *
	 */
	static function datebook_reorder_array(array $elements, $parentId = 0) {

		$branch = array();
		foreach ($elements as $element) {
			if ($element['parent_id'] == $parentId) {
				$children = self::datebook_reorder_array($elements, $element['id']);
				if ($children) {
					$element['children'] = $children;
				}
				$branch[] = $element;
			}
		}
		return $branch;
	}


	/**
	 * Re-orders array to parent and children
	 *
	 * @param $items
	 */
	static function datebook_fields_array_order($items) {

		$data = array();

		if(is_array($items)) {

			$count = $countrow = $countcolumn = $counttitle = 0;
			$quantity_columns = 1;

			$first_order_array = array();

			foreach($items as $key => $value){

				$key_array = explode('_', $key);

				if($key_array[0] == 'nonce' || $key_array[0] == 'page' || $key_array[0] == 'formname' || $key_array[0] == 'formtitle' || $key_array[0] == 'save') continue;

				$count++;

				if($key_array[0] == 'onecolumnrow' || $key_array[0] == 'twocolumnrow' || $key_array[0] == 'threecolumnrow' || $key_array[0] == 'dividerrow'){
					$countrow++;
					$count_title_column = $count;
					if($key_array[0] == 'onecolumnrow'){
						$quantity_columns = 1;
						$row_type = 'column';
					} else if($key_array[0] == 'twocolumnrow'){
						$quantity_columns = 2;
						$row_type = 'column';
					} else if($key_array[0] == 'threecolumnrow'){
						$quantity_columns = 3;
						$row_type = 'column';
					} else if($key_array[0] == 'dividerrow'){
						$quantity_columns = 0;
						$row_type = 'divider';
					}

					$first_order_array[] = array('id' => $count, 'name' => 'row', 'quantity_columns' => $quantity_columns, 'parent_id' => 0, 'row_type' => $row_type);
				} else if($key_array[0] == 'rowTitle'){
					$first_order_array[] = array('id' => $count, 'name' => 'title', $key_array[0] => $value, 'parent_id' => $count_title_column);
				} else if($key_array[0] == 'rowColumn'){
					$countcolumn = $count;
					$first_order_array[] = array('id' => $count, 'name' => 'column', $key_array[0] => $value, 'parent_id' => $count_title_column);
				} else {
					$first_order_array[] = array('id' => $count, 'name' => 'field', 'slug' => $key_array[0], 'parent_id' => $countcolumn);
				}

			}

			$data['form_fields'] = self::datebook_reorder_array($first_order_array);
			
			$formname = isset($items['formname']) ? $items['formname'] : 'common_form';
			$data['formname'] = $formname;
			
			$formtitle = isset($items['formtitle']) ? $items['formtitle'] : 'Standard form';
			$data['formtitle'] = $formtitle;


			if (is_array($data)) {

				$data['success'] = true;
				
			} else {

				$data['success'] = false;
				$data['error_message'] = esc_html__( 'Oops! Something went wrong.', 'datebook' );

			}

		} else {

			$data['success'] = false;
			$data['error_message'] = esc_html__( 'Oops! Something went wrong.', 'datebook' );

		}

		return $data;

	}


	/**
	 * This function renders our profile form
	 *
	 */
	static function render_form_field($value) {
		
		if(is_array($value)){
			
			// if foreign language do not exist, then show title in English
			$value['field_items'] = isset($value['field_items_' . DATEBOOK_WPLANG]) ? $value['field_items_' . DATEBOOK_WPLANG] : $value['field_items_en_US'];

			$value['field_items'] = explode('<br />', strtr($value['field_items'], array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

			switch ( $value['type'] ) {

				case 'text': ?> 

					<input name="<?php echo esc_attr($value['slug']); ?>" type="hidden" value="1" />
					<input name="" type="<?php echo esc_attr($value['type']); ?>" value="" />

				<?php 

				break;

				case 'textarea' : 

				?>
								
					<input name="<?php echo esc_attr($value['slug']); ?>" type="hidden" value="1" />

					<textarea name="" rows="4" cols="50" style="width:100%"></textarea>

				<?php

				break;

				case 'select':

				?>

					<input name="<?php echo esc_attr($value['slug']); ?>" type="hidden" value="1" />
					<select name="">

					<?php foreach ($value['field_items'] as $key => $val) { ?>

						<option value="<?php echo esc_attr($key); ?>"><?php echo ucfirst(esc_attr($val)); ?></option>

					<?php } ?>

					</select>

				<?php 

				break;

				case 'checkbox':

				?>
								
					<input name="<?php echo esc_attr($value['slug']); ?>" type="hidden" value="1" />

					<?php foreach ($value['field_items'] as $key => $val) { ?>

						<input type="checkbox" name="" value="" /> <?php echo ucfirst(esc_attr($val)) ?><br />

					<?php } ?>

				<?php 

				break;

				case 'radio':

				?>
								
					<input name="<?php echo esc_attr($value['slug']); ?>" type="hidden" value="1" />

					<?php foreach ($value['field_items'] as $key => $val) { ?>

						<input type="radio" name="" value="" /> <?php echo ucfirst(esc_attr($val)) ?><br />

					<?php } ?>

				<?php 

				break;

			} // end switch

		}
		
	}


	/**
	 * This function renders our profile form
	 *
	 */
	static function datebook_profile_form_edit($get_profile_form_array, $get_profile_custom_fields) {

		if(is_array($get_profile_form_array)){

			$profiletype_order_in_registration = of_get_option('profiletype_order_in_registration') == 'profiletype_before_registration' ? 1 : 0;

			foreach($get_profile_form_array as $key => $value){

				$datebook_random_key = DateBook_Utilities::datebook_random_symbols(12);

				if(isset($value['name']) && $value['name'] == 'row') {

					if(isset($value['quantity_columns']) && $value['quantity_columns'] == 0){
						$count_columns = 'dividerrow-column';
						$input_columns = 'dividerrow';
						$input_title = 'dividertitle';
					} else if(isset($value['quantity_columns']) && $value['quantity_columns'] == 1){
						$count_columns = 'onerow-column';
						$input_columns = 'onecolumnrow';
						$input_title = 'onecolumntitle';
					} else if(isset($value['quantity_columns']) && $value['quantity_columns'] == 2){
						$count_columns = 'tworow-column';
						$input_columns = 'twocolumnrow';
						$input_title = 'twocolumntitle';
					} else if(isset($value['quantity_columns']) && $value['quantity_columns'] == 3){
						$count_columns = 'threerow-column';
						$input_columns = 'threecolumnrow';
						$input_title = 'threecolumntitle';
					}

					if(isset($value['row_type']) && $value['row_type'] == 'divider'){
						$row_type = 'divider';
					} else {
						$row_type = 'column';
					}

					echo '<div class="datebook-child-box ' . esc_attr($count_columns) . '">';

					echo '<input name="' . esc_attr($input_columns) . '_' . esc_attr($datebook_random_key) . '" value="1" type="hidden">';

					echo '<div class="datebook-row-header ui-droppable">';
					echo '<button type="button" class="btn button button-small datebook-delete-item" data-function="datebook-deleterow" title="Remove">x</button>';
					echo '<a class="sort ui-sortable-handle" title="' . esc_html__( 'Drag me up or down to move', 'datebook' ) . '"> ☰ </a> ';

					if($row_type == 'divider'){

						echo esc_html__( 'Form divider', 'datebook' );

					} else {

						echo '<select name="rowTitle_' . esc_attr($datebook_random_key) . '" class="datebook-select-title">';
						echo '<option value="">' . esc_html__( 'Select title', 'datebook' ) . '</option>';

						foreach($get_profile_custom_fields as $key => $field){

							if (isset($field['active']) && $field['active'] != 1) continue;
							if (isset($field['type']) && $field['type'] != 'title') continue;

							if (isset($value['children'][0]['rowTitle']) && $value['children'][0]['rowTitle'] == $key) {$selected_title = ' selected'; } else { $selected_title = ''; }

							// if foreign language do not exist, then show title in English
							$field['name'] = isset($field['name_' . DATEBOOK_WPLANG]) && !empty($field['name_' . DATEBOOK_WPLANG]) ? $field['name_' . DATEBOOK_WPLANG] : $field['name_en_US'];

							echo '<option value="' . esc_attr($key) . '" ' . $selected_title . '>' . esc_attr($field['name']) . '</option>';

						}

						echo '</select>';
						
					}

					echo '</div>';

					$align_column_right = '';
					$count_columns = $key = 0;

					if(isset($value['children']) && !empty($value['children']) && is_array($value['children'])){

						foreach ( $value['children'] as $key => $columns ) {

							if(isset($columns['name']) && $columns['name'] == 'column'){

								if(isset($value['quantity_columns']) && $value['quantity_columns'] == 1){

									echo '<div class="datebook-drag-box-saved datebook-drag-box datebook-full-column datebook-column-0 ui-sortable ui-droppable">';
									echo '<input name="rowColumn_0_' . esc_attr($datebook_random_key) . '" value="1" type="hidden">';

								} else if(isset($value['quantity_columns']) && $value['quantity_columns'] == 2){

									if($key == 2) $align_column_right = 'right';

									echo '<div class="datebook-drag-box-saved datebook-drag-box datebook-half-column ' . esc_attr($align_column_right) . ' datebook-column-' . esc_attr($key) . ' ui-sortable ui-droppable">';
									echo '<input name="rowColumn_' . esc_attr($key) . '_' . esc_attr($datebook_random_key) . '" value="1" type="hidden">';

								} else {

									if($key == 3) $align_column_right = 'right';

									echo '<div class="datebook-drag-box-saved datebook-drag-box datebook-half-column ' . esc_attr($align_column_right) . ' datebook-column-' . esc_attr($key) . ' ui-sortable ui-droppable">';
									echo '<input name="rowColumn_' . esc_attr($key) . '_' . esc_attr($datebook_random_key) . '" value="1" type="hidden">';

								}

								if(isset($columns['children'])){

									foreach ( $columns['children'] as $key => $column ) {

										$count_columns++;

										if(isset($get_profile_custom_fields[$column['slug']])){

											$value = $get_profile_custom_fields[$column['slug']];

											// if foreign language do not exist, then show title in English
											$value['name'] = isset($get_profile_form_array['get_formname']) && $get_profile_form_array['get_formname'] == 'search_form_other' && isset($value['name_' . DATEBOOK_WPLANG]) && !empty($value['name_' . DATEBOOK_WPLANG]) ? $value['name_' . DATEBOOK_WPLANG] : $value['name_en_US'];

											echo '<div data-id="' . esc_attr($column['slug']) . '" class="ui-droppable ui-state-highlight">';
											echo '<button type="button" class="btn button button-small datebook-delete-item" data-function="datebook-deletefield" title="Remove">x</button>';
											echo '<label><a class="sort ui-sortable-handle" title="' . esc_html__( 'Drag me up or down to move', 'datebook' ) . '"> ☰ </a> ' . esc_attr($value['name']);
											if(!isset($get_profile_custom_fields[$column['slug']]['active']) || (isset($get_profile_custom_fields[$column['slug']]['active']) && $get_profile_custom_fields[$column['slug']]['active'] == 0)){
												echo ' <sup style=" background-color:red; color: white; padding:1px 3px; border-radius: 8px">' . esc_html__( 'disabled', 'datebook' ) . '</sup>';
											}
										
											if($column['slug'] == 'profiletypereserved' && $profiletype_order_in_registration == 1){

												echo ' <sup style=" background-color:red; color: white; padding:1px 3px; border-radius: 8px">' . esc_html__( 'Profile type has been selected to be displayed before the registration form', 'datebook' ) . '</sup>';

											}

											echo '</label>';
											echo '<span>';

											// Render field
											self::render_form_field($value);

											echo '</span>';
											echo '</div>';

										}
									}
								}

								$display_drag_message = $count_columns > 0 ? 'display: none' : '';

								echo '<span class="datebook-drag-here" style="' . $display_drag_message . '">' . esc_html__( 'Drag and drop fields here', 'datebook' ) . '</span>';

								echo '</div>';

							}
						}
					}

					echo '</div>';

				}
			}

			$display_notice_add_row = 'none';

		} else {

			$display_notice_add_row = '';

		}

		?>

		<div class="datebook-column-notice" style="display: <?php echo esc_attr($display_notice_add_row); ?>">
			<?php esc_html_e( 'First, add a row!', 'datebook' ); ?>
		</div>

		<?php

	}


	/**
	 * List page handler
	 *
	 * This function renders our custom table
	 * Notice how we display message about successfull deletion
	 * Actualy this is very easy, and you can add as many features
	 * as you want.
	 *
	 * Look into /wp-admin/includes/class-wp-*-list-table.php for examples
	 */
	static function display_form_edit() {

		global $wp_locale_all, $datebook_reserved_fields;

		$message = '';
		$notice = '';

		// Get profile form array
		$get_profile_form_array = get_option('datebook_profile_form');

		// here we are verifying does this request is post back and have correct nonce
		if (isset($_POST['nonce']) && wp_verify_nonce($_POST['nonce'], basename(__FILE__))) {

			// validate data, and if all ok save item to database
			$item_data = self::datebook_fields_array_order($_POST);

			if ($item_data['success'] === true) {

				$item_data_save = $item_data['form_fields'];

				$get_profile_forms = isset($get_profile_form_array) && is_array($get_profile_form_array) ? $get_profile_form_array : array();

				if(isset($get_profile_forms[$item_data['formname']]) && is_array($get_profile_forms[$item_data['formname']])){

					// Clean form
					unset($get_profile_forms[$item_data['formname']]);

					//Alter the options array appropriately
					$get_profile_forms[$item_data['formname']] = array_merge($item_data_save, array('formtitle' => $item_data['formtitle']));

				} else {

					//Alter the options array appropriately
					$add_profile_forms = array($item_data['formname'] => array_merge($item_data_save, array('formtitle' => $item_data['formtitle'])));

					$get_profile_forms = array_merge($get_profile_forms, $add_profile_forms);

				}

				//Update entire array
				$result = update_option('datebook_profile_form', $get_profile_forms);

				if( $result === FALSE){
					$notice = esc_html__('Changes have NOT been saved', 'datebook');
				} else {
					$message = esc_html__('Form has been successfully saved', 'datebook');
				}

			} else {

				// if $item_data not true it contains error message(s)
				$notice = $item_data['error_message'];

			}

		}

		$get_formname = isset($_GET['form']) ? $_GET['form'] : (isset($_POST['formname']) ? $_POST['formname'] : '');

		// Get profile form array
		$get_profile_form_array = get_option('datebook_profile_form');
		$get_profile_form_array = isset($get_profile_form_array[$get_formname]) ? $get_profile_form_array[$get_formname] : array();
		$get_profile_form_array['get_formname'] = $get_formname;

		// Get all forms array
		$all_forms = self::get_all_forms($get_profile_form_array);

		

		// get languages
		$languages_array = array();

		$languages_array['en_US'] = esc_html__( 'English', 'datebook' );

		$languages = DateBook_Localization::datebook_all_available_language_files();

		foreach($languages as $language) {
			if($language['checked'] == 1){
				$languages_array[$language['locale']] = $wp_locale_all[$language['locale']];
			}
		}

		// Get custom fields
		$all_custom_fields = get_option('datebook_profile_custom_fields') ? get_option('datebook_profile_custom_fields') : array();

		// Get taxonomy
		$datebook_profiletypes = array();
		$profiletypes_array = get_terms(array('orderby' => 'term_id', 'order' => 'ASC','taxonomy' => DATEBOOK_PROFILES_TAX, 'hide_empty' => false));
		foreach ($profiletypes_array as $key => $value ){
			$datebook_profiletypes[] = isset($value->name) ? $value->name : '';
		}
		$profiletypes = implode("\r\n", $datebook_profiletypes);

		foreach ($all_custom_fields as $key => $value) {
			if(isset($datebook_reserved_fields[$key])){
				$datebook_reserved_fields[$key] = array(
					'slug' => $key, 
					'type' => $datebook_reserved_fields[$key]['type'], 
					'searchable' => isset($value['searchable']) && $value['searchable'] > 0 ? 1 : 0, 
					'required' => isset($value['required']) && $value['required'] > 0 ? 1 : 0, 
					'active' => isset($value['active']) && $value['active'] > 0 ? 1 : 0, 
					'limittext' => $value['limittext']
				);

				foreach ( $languages_array as $language_key => $language_name ) {

					if (isset($value['name_' . $language_key])) {
						$datebook_reserved_fields[$key]['name_' . $language_key] =  $value['name_' . $language_key];
					}
					if (isset($value['field_items_' . $language_key])) {
						if($key == 'profiletypereserved'){
							$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $profiletypes;
						} else {
							$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $value['field_items_' . $language_key];
						}
					}
				}
			}
		}

		// Merge custom and reserved fields
		$get_profile_custom_fields = array_merge($all_custom_fields, $datebook_reserved_fields);


		$menu = Options_Framework_Admin::menu_settings();

		$menu_profile_form_slug = ( isset( $menu['menu_profile_form_slug'] ) ) ? $menu['menu_profile_form_slug'] : '';

		$form_title = isset($all_forms[$get_formname]['title']) ? $all_forms[$get_formname]['title'] : esc_html__('Form', 'datebook');

		$form_shortcode = isset($all_forms[$get_formname]['shortcode']) ? '[datebook_shortcode name="' . $all_forms[$get_formname]['shortcode'] . '"]' : '';
		
		

		?>

		<div class="wrap">

			<h1 class="wp-heading-inline"><?php esc_html_e('Edit form', 'datebook')?></h1>
			
			<a class="page-title-action" href="<?php echo get_admin_url(get_current_blog_id(), 'admin.php?page=' . $menu_profile_form_slug); ?>"><?php esc_html_e('Back to all forms', 'datebook'); ?></a>

			<hr class="wp-header-end">

			<div id="message" class="bg-white">

			<p><?php esc_html_e('On this page you can add, edit, delete custom fields to forms', 'datebook')?></p>

		</div>

		<?php if (!empty($notice)): ?>

			<div id="notice" class="error below-h2">
				<p><?php echo esc_attr($notice); ?></p>
			</div>

		<?php endif;?>

		<?php if (!empty($message)): ?>

			<div id="message" class="updated below-h2">
				<p><?php echo esc_attr($message) ?></p>
			</div>

		<?php endif;?>

		<div class="datebok-container">
			<div class="datebook-draggable-area">
				<div class="datebook-form-area">

					<form id="profile_custom_fields-table" method="POST">

						<input type="hidden" name="nonce" value="<?php echo wp_create_nonce(basename(__FILE__))?>"/>
						<input type="hidden" name="page" value="<?php if ( isset($menu_profile_form_slug) ) { echo esc_attr($menu_profile_form_slug); } ?>"/>
						<input type="hidden" name="formname" value="<?php echo esc_attr($get_formname); ?>"/>
						
						<div class="datebook-draggable-header">

							<h2 class="editor-post-title wp-post-title post-title"><?php echo esc_html__( 'Form title', 'datebook' ); ?></h2>

							<p><input name="formtitle" type="text" value="<?php echo esc_attr($form_title); ?>" style="width: 100%" required /></p>
							<p><?php echo esc_html__( 'Shortcode', 'datebook' ); ?>: <span style="padding:1px 6px 3px; background-color:#F0F0F0"><?php echo esc_attr($form_shortcode); ?></span></p>
							
							<p><?php esc_html_e( 'Start with adding ONE or TWO columns', 'datebook' ); ?></p>
						
						</div>

						<div id="repeatable-container" class="sortable ui-sortable datebook-form-lab">

							<?php self::datebook_profile_form_edit($get_profile_form_array, $get_profile_custom_fields); ?>

						</div>

						<div class="datebook-footer">
							<a data-function="addonecolumn" class="add-row btn button" href="#"><?php esc_html_e( 'Add ONE column row', 'datebook' ); ?></a> 
							<a data-function="addtwocolumn" class="add-row btn button" href="#"><?php esc_html_e( 'Add TWO column row', 'datebook' ); ?></a> 
							<a data-function="addthreecolumn" class="add-row btn button" href="#"><?php esc_html_e( 'Add THREEE column row', 'datebook' ); ?></a> 
							
							<?php if($get_formname == 'registration_form'){ ?>

							<a data-function="addformdivider" class="add-row btn button" href="#"><?php esc_html_e( 'Add form DIVIDER', 'datebook' ); ?></a> 
							<?php } ?>

							<input class="btn button-primary right" name="save" value="<?php esc_html_e( 'Save', 'datebook' ); ?>" type="submit" />
						</div>
					</form>

					<div class="datebook-child-box empty-row onerow-column screen-reader-text">
						<div class="datebook-row-header ui-droppable">
							<button type="button" class="btn button button-small datebook-delete-item" data-function="datebook-deleterow" title="<?php esc_html_e( 'Remove', 'datebook' ); ?>">x</button>
							<a class="sort ui-sortable-handle" title="<?php esc_html_e( 'Drag me up or down to move', 'datebook' ); ?>"> ☰ </a> 

							<select class="datebook-select-title">
								<option value=""><?php esc_html_e( 'Select title', 'datebook' ); ?></option>

								<?php

								foreach($get_profile_custom_fields as $key => $value){

									if (isset($value['active']) && $value['active'] != 1) continue;
									if (isset($value['type']) && $value['type'] != 'title') continue;
									
									// if foreign language do not exist, then show title in English
									$value['name'] = isset($value['name_' . DATEBOOK_WPLANG]) && !empty($value['name_' . DATEBOOK_WPLANG]) ? $value['name_' . DATEBOOK_WPLANG] : $value['name_en_US'];

									echo '<option value="' . esc_attr($key) . '">' . esc_attr($value['name']) . '</option>';

								}

								?>

							</select>

						</div>
						<div class="datebook-drag-box datebook-full-column datebook-column-0 ui-sortable ui-droppable">
							<span class="datebook-drag-here"><?php esc_html_e( 'Drag and drop fields here', 'datebook' ); ?></span>
						</div>
					</div>

					<div class="datebook-child-box empty-row tworow-column screen-reader-text">
						<div class="datebook-row-header ui-droppable">
							<button type="button" class="btn button button-small datebook-delete-item" data-function="datebook-deleterow" title="<?php esc_html_e( 'Remove', 'datebook' ); ?>">x</button>
							<a class="sort ui-sortable-handle" title="<?php esc_html_e( 'Drag me up or down to move', 'datebook' ); ?>"> ☰ </a> 

							<select class="datebook-select-title">
								<option value=""><?php esc_html_e( 'Select title', 'datebook' ); ?></option>

								<?php

								foreach($get_profile_custom_fields as $key => $value){

									if (isset($value['active']) && $value['active'] != 1) continue;
									if (isset($value['type']) && $value['type'] != 'title') continue;

									// if foreign language do not exist, then show title in English
									$value['name'] = isset($value['name_' . DATEBOOK_WPLANG]) && !empty($value['name_' . DATEBOOK_WPLANG]) ? $value['name_' . DATEBOOK_WPLANG] : $value['name_en_US'];

									echo '<option value="' . esc_attr($key) . '">' . esc_attr($value['name']) . '</option>';

								}

								?>

							</select>

						</div>
						<div class="datebook-drag-box datebook-half-column datebook-column-1 ui-sortable ui-droppable">
							<span class="datebook-drag-here"><?php esc_html_e( 'Drag and drop fields here', 'datebook' ); ?></span>
						</div>
						<div class="datebook-drag-box datebook-half-column right datebook-column-2 ui-sortable ui-droppable">
							<span class="datebook-drag-here"><?php esc_html_e( 'Drag and drop fields here', 'datebook' ); ?></span>
						</div>
					</div>
					
					
					<div class="datebook-child-box empty-row threerow-column screen-reader-text">
						<div class="datebook-row-header ui-droppable">
							<button type="button" class="btn button button-small datebook-delete-item" data-function="datebook-deleterow" title="<?php esc_html_e( 'Remove', 'datebook' ); ?>">x</button>
							<a class="sort ui-sortable-handle" title="<?php esc_html_e( 'Drag me up or down to move', 'datebook' ); ?>"> ☰ </a> 

							<select class="datebook-select-title">
								<option value=""><?php esc_html_e( 'Select title', 'datebook' ); ?></option>

								<?php

								foreach($get_profile_custom_fields as $key => $value){

									if (isset($value['active']) && $value['active'] != 1) continue;
									if (isset($value['type']) && $value['type'] != 'title') continue;

									// if foreign language do not exist, then show title in English
									$value['name'] = isset($value['name_' . DATEBOOK_WPLANG]) && !empty($value['name_' . DATEBOOK_WPLANG]) ? $value['name_' . DATEBOOK_WPLANG] : $value['name_en_US'];

									echo '<option value="' . esc_attr($key) . '">' . esc_attr($value['name']) . '</option>';

								}

								?>

							</select>

						</div>
						<div class="datebook-drag-box datebook-half-column datebook-column-1 ui-sortable ui-droppable">
							<span class="datebook-drag-here"><?php esc_html_e( 'Drag and drop fields here', 'datebook' ); ?></span>
						</div>
						<div class="datebook-drag-box datebook-half-column datebook-column-2 ui-sortable ui-droppable">
							<span class="datebook-drag-here"><?php esc_html_e( 'Drag and drop fields here', 'datebook' ); ?></span>
						</div>
						<div class="datebook-drag-box datebook-half-column right datebook-column-3 ui-sortable ui-droppable">
							<span class="datebook-drag-here"><?php esc_html_e( 'Drag and drop fields here', 'datebook' ); ?></span>
						</div>
					</div>
					
					
					<div class="datebook-child-box empty-row dividerrow-column screen-reader-text">
						<div class="datebook-row-header ui-droppable">
							<button type="button" class="btn button button-small datebook-delete-item" data-function="datebook-deleterow" title="<?php esc_html_e( 'Remove', 'datebook' ); ?>">x</button>
							<a class="sort ui-sortable-handle" title="<?php esc_html_e( 'Drag me up or down to move', 'datebook' ); ?>"> ☰ </a>							
							<?php esc_html_e( 'Form divider', 'datebook' ); ?>

						</div>
					</div>
					
					
				</div>

				<div id="form-fields" class="datebook-fields-area">
					<h3><?php esc_html_e( 'Available fields', 'datebook' ); ?></h3>
					<p><?php esc_html_e( 'Drag and drop fields to the form', 'datebook' ); ?></p>
					
					<div class="datebook-fields-inside">

					<?php

					if (is_array($get_profile_custom_fields)){

						foreach($get_profile_custom_fields as $key => $value){

							if (isset($key) && !empty($key)){

							//if (isset($value['active'])){
								
								if (isset($value['type']) && $value['type'] == 'title') continue;

								$found_field = self::datebook_search_in_array($value['slug'], $get_profile_form_array) ? 'display: none;' : '';

								// if foreign language do not exist, then show title in English
								$value['name'] = isset($value['name_' . DATEBOOK_WPLANG]) && !empty($value['name_' . DATEBOOK_WPLANG]) ? $value['name_' . DATEBOOK_WPLANG] : $value['name_en_US'];

								$reserved_field_color = isset($datebook_reserved_fields[$value['slug']]) && in_array($value['slug'], $datebook_reserved_fields[$value['slug']]) ? 'background-color:#E0F6FD;' : '';

								echo '<div class="datebook-form-field" data-id="' . esc_attr($key) . '" style="' . $found_field . $reserved_field_color . '">';
								echo '<button type="button" class="btn button button-small datebook-delete-item" data-function="datebook-deletefield" title="' . esc_html__( 'Remove', 'datebook' ) . '">x</button>';
								echo '<label><a class="sort ui-sortable-handle" title="' . esc_html__( 'Drag me up or down to move', 'datebook' ) . '"> ☰ </a> ' . esc_attr($value['name']);
								if (!isset($value['active']) || (isset($value['active']) && $value['active'] == 0)){
									echo ' <sup style=" background-color:red; color: white; padding:1px 2px; border-radius: 8px">' . esc_html__( 'disabled', 'datebook' ) . '</sup>';
								}
								echo '</label>';
								echo '<span>';

								// Render field
								self::render_form_field($value);

								echo '</span>';
								echo '</div>';

							//}
							}
						}
					}

					?>
					
					</div>

					</div>
				</div>
			</div>
		</div>

		<?php

	}


	/**
	 * This function renders our profile form
	 *
	 */
	static function display_all_forms() {

		//Get profile form array
		$get_profile_form_array = get_option('datebook_profile_form');

		$all_forms = self::get_all_forms($get_profile_form_array);

		echo '<h1 class="wp-heading-inline">' . esc_html__('Forms', 'datebook') . '</h1>';
		echo '<hr class="wp-header-end">';
		echo '<div id="message" class="bg-white">';
		echo '<p>' . esc_html__('On this page you can add, edit, delete forms', 'datebook') . '</p>';
		echo '</div>';
		echo '<div class="datebok-container">';
		echo '<div class="datebook-draggable-area">';

		//if(is_array($get_profile_form_array)){
			
			$menu = Options_Framework_Admin::menu_settings();

			if ( isset( $menu['menu_profile_form_slug'] ) ) {
				$menu_profile_form_slug = $menu['menu_profile_form_slug'];
			}

			foreach($all_forms as $key => $value){

				echo '<div class="datebook-form-child-box">';
				echo '<div class="datebook-form-child-body">';
				echo '<div class="datebook-form-row-header">';
				echo '<h3>' . $value['title'] . '</h3>';
				echo '<p>[datebook_shortcode name="' . $value['shortcode'] . '"]</p>';
				echo '<p>' . $value['description'] . '</p>';
				echo '<p><em>' . $value['notice'] . '</em></p>';
				echo '<a class="btn button" href="' . get_admin_url(get_current_blog_id(), 'admin.php?page=' . $menu_profile_form_slug . '&subpage=edit_form&form=' . $value['form_name']) . '">' . esc_html__( 'Edit', 'datebook' ) . '</a>';
				echo '</div>';
				echo '</div>';
				echo '</div>';

			}
		//}
		
		echo '</div>';
		echo '</div>';
		
	}


	/**
	 * List page handler
	 *
	 * This function renders our custom table
	 * Notice how we display message about successfull deletion
	 * Actualy this is very easy, and you can add as many features
	 * as you want.
	 *
	 * Look into /wp-admin/includes/class-wp-*-list-table.php for examples
	 */
	static function datebook_page_handler() {

		?>

		<div class="wrap">

		<?php

		if (isset($_GET['subpage']) && $_GET['subpage'] == 'edit_form') {

			self::display_form_edit();

		} else {

			self::display_all_forms();

		}

		?>

		</div>

		<?php

	}


}