/*
 * Admin Reviews
 */
jQuery( document ).ready( function () {
	
	"use strict";
	
    jQuery( ".datebook-review-rating.allow-edit > span" ).click( function () {
        var rating = jQuery( this ).data( "rating" );
        datebook_apply_rating( rating, jQuery( this ) );
        jQuery( this ).parent( 'p.datebook-review-rating' ).find( 'input[name="datebook_review_rating"]' ).val( rating );
    } );
    jQuery( ".datebook-review-rating.allow-edit > span" ).hover( function () {
        var rating = jQuery( this ).data( "rating" );
        datebook_apply_rating( rating, jQuery( this ) );
    }, function () {
        var rating = jQuery( this ).parent( 'p.datebook-review-rating' ).find( 'input[name="datebook_review_rating"]' ).val();
        datebook_apply_rating( rating, jQuery( this ) );
    } );
} );

function datebook_apply_rating( rating, obj ) {
	
	"use strict";

    obj.parent( 'p.datebook-review-rating.allow-edit' ).find( "span" ).removeClass( 'rating-on' );

	var i = 0;

    for ( i = 1; i <= rating; i++ ) {
        obj.parent( 'p.datebook-review-rating.allow-edit' ).find( "span.rate-" + i ).addClass( 'rating-on' );
    }
    var off_rating = 5 - rating;
    for ( i = 1; i <= off_rating; i++ ) {
        var a = i + rating;
        obj.parent( 'p.datebook-review-rating.allow-edit' ).find( "span.rate-" + a ).addClass( 'rating-off' );
    }
}

var reviewsBox;

jQuery( document ).ready( function ( $ ) {
	
	"use strict";

    datebook_where_show_reviews();
    jQuery( ".show-reviews" ).click( function () {
        datebook_where_show_reviews();
    } );

    reviewsBox = {
        st: 0,
        get: function ( total, num ) {

            var st = this.st, data;
            if ( !num ){
                num = 20;
			}

            this.st += num;
            this.total = total;
            $( '#commentsdiv .spinner' ).addClass( 'is-active' );

            data = {
                'action': 'get_reviews',
                'mode': 'single',
                '_ajax_nonce': $( '#add_comment_nonce' ).val(),
                'p': $( '#post_ID' ).val(),
                'start': st,
                'number': num
            };

            $.post( ajaxurl, data,
                function ( r ) {

                    r = wpAjax.parseAjaxResponse( r );
                    $( '#commentsdiv .widefat' ).show();
                    $( '#commentsdiv .spinner' ).removeClass( 'is-active' );

                    if ( 'object' === typeof r && r.responses[0] ) {
                        $( '#the-comment-list' ).append( r.responses[0].data );

                        theList = theExtraList = null;
                        $( 'a[className*=\':\']' ).unbind();

                        if ( commentsBox.st > commentsBox.total ){
							$( '#show-comments' ).hide();
						} else {
							$( '#show-comments' ).show().children( 'a' ).html( reviews_object.showcomm );
						}

                        return;
                    } else if ( 1 === r ) {
                        $( '#show-comments' ).html( reviews_object.endcomm );
                        return;
                    }

                    $( '#the-comment-list' ).append( '<tr><td colspan="2">' + wpAjax.broken + '</td></tr>' );
                }
            );

            return false;
        }
    };

    $( ".row-actions a" ).click( function () {
        setTimeout( function () {
            datebook_update_pending( -1 );
        }, 1000 );
    } );
    jQuery( ".datebook-revs-translate .dashicons-no" ).click( function () {
        var data = {
            'action': 'datebook_hide_translate_notice'
        };
        jQuery.post( ajaxurl, data, function ( response ) {
            jQuery( ".datebook-revs-translate" ).hide( "slow" );
        } );
    } );
} );

( function ( $ ) {
	
	"use strict";

    // we create a copy of the WP inline edit post function
    var $wp_inline_edit = commentReply.open;

    // and then we overwrite the function with our own code
    commentReply.open = function ( $comment_id ) {

        // "call" the original WP edit function
        // we don't want to leave WordPress hanging
        $wp_inline_edit.apply( this, arguments );

        // now we take care of our business

        if ( $comment_id > 0 ) {
            // define the edit row
            var $edit_row = $( '#replyrow' );
            var $post_row = $( '#comment-' + $comment_id );

            // get the data
            var $review_title = $( '.column-rating', $post_row ).find( ".review-title" ).html();
            var $review_rating = $( '.column-rating', $post_row ).find( ".datebook-review-rating" ).data( "current_rating" );
            // populate the data
            $( ':input[name="datebook_review_title"]', $edit_row ).val( $review_title );
            datebook_apply_rating( $review_rating, jQuery( "#replyrow .datebook-review-rating.allow-edit > span.rate-1" ) );
            //$( ':input[name="datebook_review_rating"]', $edit_row ).val( $review_rating );
        }
    };

} )( jQuery );

function datebook_update_pending( diff ) {
	
	"use strict";
	
    jQuery( '#adminmenu span.pending-count, #wp-admin-bar-comments span.pending-count' ).each( function () {
        var a = jQuery( this ), n = datebook_getCount( a ) + diff;
        if ( n < 1 ){
			n = 0;
		}
        a.closest( '.awaiting-mod' )[ 0 === n ? 'addClass' : 'removeClass' ]( 'count-0' );
        datebook_update_count( a, n );
    } );
}

function datebook_getCount( el ) {
	"use strict";
    var n = parseInt( el.html().replace( /[^0-9]+/g, '' ), 10 );
    if ( isNaN( n ) ){
		return 0;
	}
    return n;
}

function datebook_update_count( el, n ) {
	"use strict";
    var n1 = '';
    if ( isNaN( n ) ){
		return;
	}
    n = n < 1 ? '0' : n.toString();
    if ( n.length > 3 ) {
        while ( n.length > 3 ) {
            n1 = thousandsSeparator + n.substr( n.length - 3 ) + n1;
            n = n.substr( 0, n.length - 3 );
        }
        n = n + n1;
    }
    el.html( n );
}

function datebook_where_show_reviews() {
	"use strict";
    jQuery( ".show-reviews" ).each( function () {
        if ( jQuery( this ).is( ':checked' ) ) {
            jQuery( this ).nextAll( "div.enabled-where:first" ).show();
        } else {
            jQuery( this ).nextAll( "div.enabled-where:first" ).hide();
        }
    } );
}