jQuery(document).ready(function($){

	var optionsframework_upload;
	var optionsframework_selector;

	function optionsframework_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		optionsframework_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( optionsframework_upload ) {
			optionsframework_upload.open();
		} else {
			// Create the media frame.
			optionsframework_upload = wp.media.frames.optionsframework_upload =  wp.media({
				// Set the title of the modal.
				title: $el.data('choose'),

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: $el.data('update'),
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			optionsframework_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = optionsframework_upload.state().get('selection').first();
				optionsframework_upload.close();
				optionsframework_selector.find('.upload').val(attachment.attributes.url);
				if ( attachment.attributes.type == 'image' ) {
					optionsframework_selector.find('.screenshot').empty().hide().append('<img src="' + attachment.attributes.url + '"><a class="remove-image">Remove</a>').slideDown('fast');
				}
				optionsframework_selector.find('.upload-button').unbind().addClass('remove-file').removeClass('upload-button').val(optionsframework_l10n.remove);
				optionsframework_selector.find('.of-background-properties').slideDown();
				optionsframework_selector.find('.remove-image, .remove-file').on('click', function() {
					optionsframework_remove_file( $(this).parents('.section-upload') );
				});
			});

		}

		// Finally, open the modal.
		optionsframework_upload.open();
	}

	function optionsframework_remove_file(selector) {
		selector.find('.remove-image').hide();
		selector.find('.upload').val('');
		selector.find('.of-background-properties').hide();
		selector.find('.screenshot').slideUp();
		selector.find('.remove-file').unbind().addClass('upload-button').removeClass('remove-file').val(optionsframework_l10n.upload);
		// We don't display the upload button if .upload-notice is present
		// This means the user doesn't have the WordPress 3.5 Media Library Support
		if ( $('.section-upload .upload-notice').length > 0 ) {
			$('.upload-button').remove();
		}
		selector.find('.upload-button').on('click', function(event) {
			optionsframework_add_file(event, $(this).parents('.section-upload'));
		});
	}

	$('.remove-image, .remove-file').on('click', function() {
		optionsframework_remove_file( $(this).parents('.section-upload') );
    });

    $('.upload-button').on('click', function( event ) {
    	optionsframework_add_file(event, $(this).parents('.section-upload'));
    });


	// Process multi images
	var optionsframework_upload_multi;
	var optionsframework_selector_multi;

	function optionsframework_add_multi_single_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		optionsframework_selector_multi = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( optionsframework_upload_multi ) {
			optionsframework_upload_multi.open();
		} else {
			// Create the media frame.
			optionsframework_upload_multi = wp.media.frames.optionsframework_upload_multi =  wp.media({
				// Set the title of the modal.
				title: $el.data('choose'),

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: $el.data('update'),
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			optionsframework_upload_multi.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = optionsframework_upload_multi.state().get('selection').first();
				optionsframework_upload_multi.close();
				optionsframework_selector_multi.find('.upload').val(attachment.attributes.url);
				if ( attachment.attributes.type == 'image' ) {
					optionsframework_selector_multi.find('.parent-screenshot').empty().hide().append('<img src="' + attachment.attributes.url + '"><a class="remove-multi-image">Remove</a>').slideDown('fast');
				}
				optionsframework_selector_multi.find('.upload-multi-button').unbind().addClass('remove-multi-file').removeClass('upload-multi-button').val(optionsframework_l10n.remove);
				optionsframework_selector_multi.find('.of-background-properties').slideDown();
				optionsframework_selector_multi.find('.remove-multi-image, .remove-multi-file').on('click', function() {
					optionsframework_remove_multi_file( $(this).parents('.section-multiupload') );
				});
			});

		}

		// Finally, open the modal.
		optionsframework_upload_multi.open();
	}

	function optionsframework_add_multi_file(event, selector) {

		var upload = $('.uploaded-multi-file'), frame;
		var $el = $(this);
		optionsframework_selector_multi = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( optionsframework_upload_multi ) {
			optionsframework_upload_multi.open();
		} else {
			// Create the media frame.
			optionsframework_upload_multi = wp.media.frames.optionsframework_upload_multi =  wp.media({
				// Set the title of the modal.
				title: $el.data('choose'),
				multiple: 'add',

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: $el.data('update'),
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When images is selected, run a callback.
			optionsframework_upload_multi.on( 'select', function() {
				// Grab the selected attachments
				var length = optionsframework_upload_multi.state().get("selection").length;
				var images = optionsframework_upload_multi.state().get("selection").models;

				optionsframework_upload_multi.close();

				for(var iii = 0; iii < length; iii++){

					var image_url = images[iii].changed.url;
					var image_type = images[iii].changed.type;
					
					var image_caption = images[iii].changed.caption;
					var image_title = images[iii].changed.title;
					var image_description = images[iii].changed.description;

					//this object contains URL for medium, small, large and full sizes URL.
					var sizes = images[iii].changed.sizes;
					
					var d = new Date();
					var image_time = d.getTime();
					var str = iii + "-" + image_time + "-" + image_title;
					image_id = str.replace(/\s+/g, '-').toLowerCase();

					if ( image_type === 'image' ) {
						optionsframework_selector_multi.find('.parent-screenshot').append('<div class="screenshot screenshot-multi ' + image_id + '" data-id="' + image_id + '"><input type="hidden" name="datebook[featured_background_images][]" value="' + image_url + '"><img src="' + image_url + '"><a class="remove-multi-image" data-id="' + image_id + '">Remove</a></div>').slideDown('fast');
					}
				}

			});

		}

		// Finally, open the modal.
		optionsframework_upload_multi.open();
	}

	$('.upload-multi-button').on('click', function( event ) {
    	optionsframework_add_multi_file(event, $(this).parents('.section-multiupload'));
    });

	function optionsframework_remove_multi_file(selector, image_id) {
		selector.find('.parent-screenshot .' + image_id).remove();
		// We don't display the upload button if .upload-notice is present
		// This means the user doesn't have the WordPress 3.5 Media Library Support
		if ( $('.section-multiupload .upload-notice').length > 0 ) {
			$('.upload-multi-button').remove();
		}
		selector.find('.upload-multi-button').on('click', function(event) {
			optionsframework_add_multi_single_file(event, $(this).parents('.section-multiupload'));
		});
	}
	
	$(document).on('click', '.remove-multi-image, .remove-multi-file', function() {
		var image_id = $(this).data("id");
		optionsframework_remove_multi_file( $(this).parents('.section-multiupload'), image_id );
    });

});