<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Administrator_Panel
 *
 * @class DateBook_Administrator_Panel
 * @package DateBook/Classes/Administrator
 * @author Pagick Themes
 */
class DateBook_Administrator_Panel {


	/**
	 * Hook actions and filters.
	 * 
	 * @since 1.0
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_administrator_header', array( __CLASS__, 'update_data') ); 
		add_action( 'datebook_administrator_panel', array( __CLASS__, 'process_administrator_panel' ) );
		add_action( 'datebook_moderator_panel', array( __CLASS__, 'process_moderator_panel' ) );

		add_shortcode( 'datebook_administrator_panel', array( __CLASS__, 'pre_process_administrator_panel' ) );
		add_shortcode( 'datebook_moderator_panel', array( __CLASS__, 'pre_process_moderator_panel' ) );

	}


	/**
	 * Delete profile
	 *
	 * @access private
	 * @return void
	 */
	public static function delete_profile($profile_id, $user_id) {

		// Delete profile account
		if (isset($_POST['action']) && $_POST['action'] == 'delete_profile' && is_super_admin() && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			$profile_delete = isset($_POST['profile_delete']) && $_POST['profile_delete'] > 0 ? (int)$_POST['profile_delete'] : 0;

			if (isset($profile_id) && $profile_id == $profile_delete) {

				$profile_deleted = DateBook_Utilities::final_delete_profile($profile_id, $user_id);

				if ($profile_deleted) {
					wp_redirect(home_url());
					exit();
				} else {
					wp_redirect(get_permalink($profile_id));
					exit();
				}
			}
		}
	}


	/**
	 * Moderation - Approve profile
	 *
	 * @access private
	 * @return void
	 */
	private static function moderate_approve_profile() { 

		if (is_super_admin() && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			// Approve profile
			$profile_id = (int)$_GET['id'];
			if ($profile_id == 0) { die(); }

			$publish_profile = array( 'ID' => $profile_id, 'post_status' => 'publish' );

			// Get the edited content
			if(of_get_option('suspend_profile_after_edit') == 2){
				$datebook_get_aboutyou = get_post_meta($profile_id, 'edited_profile_content', true);
				if(isset($datebook_get_aboutyou) && strlen($datebook_get_aboutyou) > 0){
					$publish_profile['post_content'] = $datebook_get_aboutyou;
					delete_post_meta($profile_id, 'edited_profile_content');
				}
			}

			wp_update_post($publish_profile);
			
			
			$profile_data = get_post($profile_id);
			$profile_status = $profile_data->post_status;

			$user_id = isset($profile_data->post_author) ? $profile_data->post_author : 0;
			$currentauth = get_userdata($user_id);
			$current_user_id = $currentauth->ID;
			// Delete user email hash. Profile published without email verification
			delete_user_meta( $current_user_id, 'emailhash' );

			$data = array();
			$data['successtext'] = '<div class="alert alert-success">' . esc_html__( 'Profile has been approved', 'datebook' ) . '</div>';
			$data['profileid'] = $profile_id;

			// Show result by JSON
			wp_send_json($data);

			exit;

		}
	}


	/**
	 * Moderation - Delete profile
	 *
	 * @access private
	 * @return void
	 */
	private static function moderate_delete_profile() { 

		if (is_super_admin() && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			// Approve profile
			$profile_id = (int)$_GET['id'];
			if ($profile_id == 0) { die(); }

			$profile_deleted = DateBook_Utilities::final_delete_profile($profile_id);

			if ($profile_deleted) {
				$data = array();
				$data['successtext'] = '<div class="alert alert-success">' . esc_html__( 'Profile has been deleted', 'datebook' ) . '</div>';
				$data['profileid'] = $profile_id;

				// Show result by JSON
				wp_send_json($data);

				exit;
			}
		}
	}


	/**
	 * Update all data
	 *
	 * @access public
	 * @return void
	 */
	public static function update_data() {
		
		if (is_super_admin()) {

			if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

				if (isset($_GET['action']) && $_GET['action'] == 'datebook_ajax_admin' ) {

					$whatisit = isset( $_GET['whatisit'] ) ? $_GET['whatisit'] : '';

					if ($whatisit == 'profile_approve_moderate') {

						// Approve profile
						self::moderate_approve_profile();

					} else if ($whatisit == 'profile_delete_moderate') {

						// Approve profile
						self::moderate_delete_profile();

					} else if ($whatisit == 'approve_defaultimage') {

						// Approve image
						self::moderate_approve_image();

					}

					die();

				}

			} else {

				if (isset($_POST['profile_id'])) {
					$profile_id = absint($_POST['profile_id']);
				} else {
					$profile_id = absint(get_the_ID());
				}

				if (isset($_POST['action']) && $_POST['action'] == 'upgradeprofile' && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

					$profile = DateBook_Utilities::detect_post_slug(DATEBOOK_POST_TYPE);
					$profile_id = isset($profile->ID) ? $profile->ID : 0;

					// Set Featured status
					if (isset($_POST['featuredends'])) {
						$end = preg_replace("/([^0-9\/])/", '', sanitize_text_field($_POST['featuredends']));
						$end = explode('/', $end);
						if (count($end) == 3) {
							$featured_expiration = mktime(23, 59, 59, $end[1], $end[0], $end[2]);
							update_post_meta($profile_id, 'featured', '1');
							update_post_meta($profile_id, 'featured_ends', $featured_expiration);
							unset($_POST['featuredends']);
						}
					}

					// Cancel Featured status
					if (isset($_POST['delete_from_featured'])) {
						update_post_meta($profile_id, 'featured', '0');
						delete_post_meta($profile_id, 'featured_ends');
						delete_post_meta($profile_id, 'featured_ends_notice');
					}

					// Set Top status
					if (isset($_POST['topends'])) {
						$end = preg_replace("/([^0-9\/])/", '', sanitize_text_field($_POST['topends']));
						$end = explode('/', $end);
						if (count($end) == 3) {
							$topad_expiration = mktime(23, 59, 59, $end[1], $end[0], $end[2]);
							update_post_meta($profile_id, 'topad', '1');
							update_post_meta($profile_id, 'topad_ends', $topad_expiration);
							unset($_POST['topends']);
						}
					}
					
					// Cancel Top status
					if (isset($_POST['delete_from_topad'])) {
						update_post_meta($profile_id, 'topad', '0');
						delete_post_meta($profile_id, 'topad_ends');
						delete_post_meta($profile_id, 'topad_ends_notice');
					}

				} else if (isset($_POST['action']) && $_POST['action'] == 'publish_profile' && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

					// Activate private profile
					if (isset($_POST['approve'])) {

						$profile_data = get_post($profile_id);

						$profile_id = isset($profile_data->ID) ? $profile_data->ID : 0;
						
						if($profile_id > 0){
						
							$profile_status = $profile_data->post_status;

							$user_id = isset($profile_data->post_author) ? $profile_data->post_author : 0;
							$currentauth = get_userdata($user_id);
							$current_user_id = $currentauth->ID;

							$notactive = get_post_meta($profile_id, 'notactive', true);

							if ($profile_status == 'publish') {

								if ($_POST['approve'] == 'suspend') {

									$profile_status = 'private';

									if($notactive == 1){
										$notactive = '0';
									} else {
										$notactive = '1';
									}

								} else if ($_POST['approve'] == 'publish') {

									$profile_status = 'private';
									$notactive = '0';
								
								}

								$subject_in_email = esc_html__( 'Your profile has been suspended', 'datebook' );
								$select_email_template = 'profile_suspended_to_profile';

							} else {

								if ($_POST['approve'] == 'suspend') {

									$profile_status = 'private';

									if($notactive == 1){
										$notactive = '0';
									} else {
										$notactive = '1';
									}

								} else if ($_POST['approve'] == 'publish') {

									$profile_status = 'publish';
									$notactive = '0';

									// Delete user email hash. Profile published without email verification
									delete_user_meta( $current_user_id, 'emailhash' );

								}

								$subject_in_email = esc_html__( 'Your profile has been activated', 'datebook' );
								$select_email_template = 'profile_activated_to_profile';

							}

							update_post_meta($profile_id, 'notactive', $notactive);

							$publish_profile = array( 'ID' => $profile_id, 'post_status' => $profile_status );

							// Get the edited content
							if(of_get_option('suspend_profile_after_edit') == 2){
								$datebook_get_aboutyou = get_post_meta($profile_id, 'edited_profile_content', true);
								if(isset($datebook_get_aboutyou) && strlen($datebook_get_aboutyou) > 0){
									$publish_profile['post_content'] = $datebook_get_aboutyou;
									delete_post_meta($profile_id, 'edited_profile_content');
								}
							}

							wp_update_post($publish_profile);

							// Send email notification to user
							if (isset($_POST['email_notification']) && $_POST['email_notification'] == 1 && isset($_POST['current_user_id']) && $_POST['current_user_id'] > 0) {

								$datebook_user_info = get_userdata($_POST['current_user_id']);

								$to_email = $datebook_user_info->user_email;

								$profile_get_permalink = get_permalink($profile_id);

								// Put all data to an array
								$datebook_email_var = array(
									'profile_name' => $datebook_user_info->display_name,
									'user_login' => $datebook_user_info->user_login,
									'emailaddress' => $datebook_user_info->user_email,
									'profile_get_permalink' => $profile_get_permalink
								);

								set_query_var( 'datebook_email_var', $datebook_email_var );

								include DateBook_Template_Loader::locate( 'misc/email-templates' );

								// Send email to profile
								$datebook_mail = DateBook_Utilities::datebook_email_send(NULL, NULL, $to_email, $subject_in_email, $body);
							}
						}
					}

					// Activate Verification
					if ( isset($_POST['verified']) ) {
					
						$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
						$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();
					
						$verified = isset($datebook_get_data['verified']) ? $datebook_get_data['verified'] : 0;

						if ($verified == '1') {
							$verified = '0';
						} else {
							$verified = '1';
						}

						// Save the post meta
						$datebook_get_data['verified'] = $verified;

						// Update the post meta
						update_post_meta($profile_id, 'profile_personal_data', $datebook_get_data);

					}

					//wp_redirect(get_permalink($profile_id));
					//exit();

				} else if (isset($_POST['action']) && $_POST['action'] == 'notification_from_admin') {

					// Notification from Admin
					$notification_from_admin = sanitize_text_field(wp_strip_all_tags($_POST['notification_from_admin']));
					update_post_meta($profile_id, 'notification_from_admin', $notification_from_admin);

				} else if (isset($_POST['action']) && $_POST['action'] == 'manuallyactivatetour') {

					// Activate the tour
					$tour_id = absint($_POST['tour_id']);
					$post_tour = array( 'ID' => $tour_id, 'post_status' => 'publish' );
					wp_update_post( $post_tour );
					
					echo '<div class="alert alert-success">' . esc_html__( 'The tour has been activated', 'datebook' ) . '</div>';

				}
			}
		}
	}


	/**
	 * Return administrator panel on Single Profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_process_administrator_panel() {

		if (is_super_admin()) {

			// display the Administration Panel on Single Profile page above
			return DateBook_Template_Loader::load( 'admin/administrator-panel' );

		}

	}


	/**
	 * Show administrator panel on Single Profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_administrator_panel() {

		echo self::pre_process_administrator_panel();

	}


	/**
	 * Return moderator panel in Header on All pages
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_process_moderator_panel() {

		if (is_super_admin()) {

			// Load this javascript file only for moderation
			wp_enqueue_script('datebook-moderate', DATEBOOK_URL . 'assets/js/datebook-moderate.js', array(), false, true );

			// display the Moderation panel
			return DateBook_Template_Loader::load( 'admin/moderator-header' );

		}

	}


	/**
	 * Show moderator panel in Header on All pages
	 *
	 * @access public
	 * @return void
	 */
	public static function process_moderator_panel() {

		//echo self::pre_process_moderator_panel();

	}


}

DateBook_Administrator_Panel::init();