<?php
/**
 * Display Notifications
 *
 * @class Options_Framework_Notifications
 * @author Pagick Themes
 * @since 3.3
 */

class Class_DateBook_Notification {

	function __construct() {

		add_action( 'wp_enqueue_scripts', array($this, 'add_datebook_notice_scripts_styles' ) );
		add_action( 'datebook_gps_add_defer_js', array($this, 'add_datebook_gps_scripts' ) );
		add_action( 'datebook_gps_add_preload_css', array($this, 'add_datebook_gps_styles' ) );
		add_action( 'wp_footer', array( $this, 'display_frontend_notification' ) );

	}

	function add_datebook_notice_scripts_styles() {

		$datebook_js_ver  = date("ymd-Gis", filemtime( DATEBOOK_DIR . 'framework/js/notification/datebook-notice.js' ));
		wp_register_script( 'datebook-notice-js', DATEBOOK_URL . 'framework/js/notification/datebook-notice.js', array('jquery'), $datebook_js_ver, true );
		wp_enqueue_script( 'datebook-notice-js' );

		$datebook_css_ver = date("ymd-Gis", filemtime( DATEBOOK_DIR . 'framework/css/notification/datebook-notice.css' ));
		wp_register_style( 'datebook-notice-style', DATEBOOK_URL . 'framework/css/notification/datebook-notice.css', false, $datebook_css_ver );
		wp_enqueue_style( 'datebook-notice-style' );

		$datebook_css_ver = date("ymd-Gis", filemtime( DATEBOOK_DIR . 'framework/css/notification/datebook-notice-dynamic.css' ));
		wp_register_style( 'datebook-notice-dynamic-style', DATEBOOK_URL . 'framework/css/notification/datebook-notice-dynamic.css', false, $datebook_css_ver );
		wp_enqueue_style( 'datebook-notice-dynamic-style' );

	}

	function datebook_notice_show($datebook_notice_id,$page_id) {

		global $wpdb;

		$table_name = strtolower($wpdb->prefix) . 'datebook_notifications';
		$check_notifications = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name));

		if($check_notifications == $table_name && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			$datebook_notice = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table_name WHERE id = %s", $datebook_notice_id) );

			$datebook_notice_post_id = $datebook_notice->post_ID;
			$notification_title = $datebook_notice->title;
			$datebook_notice_post = get_post($datebook_notice_post_id);
			$datebook_notice_enabled = $datebook_notice->enabled;
			$datebook_notice_user_types = $datebook_notice->user_types;
			$datebook_notice_content = (isset($datebook_notice_post->post_content)) ? do_shortcode($datebook_notice_post->post_content) : null;
			$datebook_design = $datebook_notice->design_id;
			$datebook_notice_device = $datebook_notice->device_class;
			$datebook_animation = $datebook_notice->animation_id;
			$notification_notice_delay = $datebook_notice->delay;
			$notification_notice_display_in = $datebook_notice->display_in;
			$notification_notice_show_time = $datebook_notice->show_time;
			$datebook_notice_show = true;

			if ($datebook_notice_user_types == 'only-logged-users' && !is_user_logged_in()) {
				$datebook_notice_show = false;
			}

			if ($datebook_notice_user_types == 'only-guests' && is_user_logged_in()) {
				$datebook_notice_show = false;
			}

			if (get_post_status($datebook_notice_post_id) != 'publish') {
				$datebook_notice_show = false;
			}

			if ($datebook_notice_enabled != 'enabled') {
				$datebook_notice_show = false;
			}

			return $datebook_notice_show;

		}
	}

	function is_showing_post($datebook_notice_id) {

		global $wpdb;

		$table_name = strtolower($wpdb->prefix) . 'datebook_notifications';
		$check_notifications = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name));

		if($check_notifications == $table_name && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {

			$datebook_notice = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table_name WHERE id = %s", $datebook_notice_id) );
			$notification_notice_display_in = $datebook_notice->display_in;
			$get_page_id = get_the_ID();
			$disable_all_notifications_page = 'disable_all_notifications_page_' . $get_page_id;
			$get_disable_all_notifications_page = get_post_meta($get_page_id, $disable_all_notifications_page, true);
			$notification_display = 'display_notification_' . $datebook_notice_id . '_page_' . $get_page_id;
			$get_notification_display = get_post_meta($get_page_id, $notification_display, true);

			$return = false;

			$page_post_type_name = get_post_type($get_page_id);
			$check_post_type = strpos($notification_notice_display_in, $page_post_type_name);
			if ($check_post_type !== false && !$get_disable_all_notifications_page) {
				$return = true;
			} elseif ($get_notification_display == $datebook_notice_id) {
				$return = true;
			}

			return $return;

		}
	}

	function display_frontend_notification() {

		global $wpdb;
	
		$table_name = strtolower($wpdb->prefix) . 'datebook_notifications';
		$check_notifications = $wpdb->get_var($wpdb->prepare("show tables like %s", $table_name));

		if($check_notifications == $table_name && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {
	
			$post = get_post();

			$datebook_notices = $wpdb->get_results( "SELECT * FROM $table_name ORDER BY delay DESC");
			$get_page_id = get_the_ID();
			$datebook_locations = get_posts(array(
				'posts_per_page'=> -1,
				'post_type' => 'datebook_locations',
			));

			$print_page = '';
			$print_default_location = '<div id="datebook-notice-default-location">' . PHP_EOL;
			$datebook_notice_default_location_count = 0;

			foreach ($datebook_notices as $notification_notice_values) {

				if ( $notification_notice_values->location_id == null || $notification_notice_values->location_id == 'default' ) {

					$notification_notice_id = $notification_notice_values->id;
					$datebook_notice_post_id = $notification_notice_values->post_ID;
					$datebook_notice_post = get_post($datebook_notice_post_id);
					$datebook_notice_enabled = $notification_notice_values->enabled;
					$datebook_notice_content = (isset($datebook_notice_post->post_content)) ? do_shortcode($datebook_notice_post->post_content) : null;
					$datebook_design = $notification_notice_values->design_id;
					$datebook_notice_device = $notification_notice_values->device_class;
					$datebook_animation = $notification_notice_values->animation_id;
					$datebook_animout_id = $notification_notice_values->animation_out_id;
					$datebook_notice_delay = $notification_notice_values->delay;
					$datebook_notice_show_time = $notification_notice_values->show_time;
					$notification_notice_display_in = $notification_notice_values->display_in;

					$datebook_notice_close_button = get_post_meta( $datebook_notice_post_id, "click_on_close_button_datebook_notice_option", true );
					$datebook_notice_close_button_days = get_post_meta( $datebook_notice_post_id, "days_click_on_close_button_datebook_notice_option", true );
					$datebook_notice_limitations = get_post_meta( $datebook_notice_post_id, "limitations_datebook_notice_option", true );
					$datebook_notice_limitations_times = get_post_meta( $datebook_notice_post_id, "times_custom_limitations_datebook_notice_option", true );
					$datebook_notice_limitations_days = get_post_meta( $datebook_notice_post_id, "days_custom_limitations_datebook_notice_option", true );
					$datebook_animout_post_option_animation_speed = get_post_meta( $datebook_animout_id, "datebook_animout_post_option_animation_speed", true );
					if ($datebook_animout_post_option_animation_speed == '' || $datebook_animout_post_option_animation_speed == null || $datebook_animout_post_option_animation_speed < 0) {
						$datebook_animout_post_option_animation_speed = 0;
					}

					if ( $datebook_notice_close_button == 'cancel-for' ) {
						$datebook_notice_close_button_val = $datebook_notice_close_button_days;
					} else {
						$datebook_notice_close_button_val = 0;
					}

					if ( $datebook_notice_limitations == 'custom-limitations' ) {
						$datebook_notice_limitations_times_val = $datebook_notice_limitations_times;
						$datebook_notice_limitations_days_val = $datebook_notice_limitations_days;
					} else {
						$datebook_notice_limitations_times_val = 0;
						$datebook_notice_limitations_days_val = 0;
					}

					if( self::datebook_notice_show($notification_notice_id,$get_page_id) && self::is_showing_post($notification_notice_id) ) {

						if ($datebook_design == null) {
							$datebook_design_class = 'datebook-notice datebook-notice-class-success alert alert-success';
							$datebook_notice_close_design = 'close-datebook-notice-success';
						} else {
							$datebook_design_class = 'datebook-notice datebook-notice-class-' . $datebook_design . ' alert alert-' . $datebook_design;
							$datebook_notice_close_design = 'close-datebook-notice-' . $datebook_design;
						}

						if ($datebook_animation == null || $datebook_animation == 'default') {
							$datebook_animation = 'datebook-notice-animation-default';
						} else {
							$datebook_animation = 'datebook-notice-animation-id-' . $datebook_animation;
						}

						$print_default_location .= '<div class="datebook-notice-bg">'.PHP_EOL;
						$print_default_location .= '	<div id="datebook-notice-id-' . $notification_notice_id . '" class="' . $datebook_design_class . ' ' . $datebook_notice_device . ' ' . $datebook_animation . ' delay" data-datebook-notice-id="' . $notification_notice_id . '" data-datebook-notice-delay="' . $datebook_notice_delay . '" data-datebook-notice-show-time="' . $datebook_notice_show_time . '" data-datebook-notice-limitations-times="' . $datebook_notice_limitations_times_val . '" data-datebook-notice-limitations-days="' . $datebook_notice_limitations_days_val . '" data-datebook-notice-animation-out-class="datebook-notice-animation-out-id-' . $datebook_animout_id . '" data-datebook-notice-animation-out-speed="' . $datebook_animout_post_option_animation_speed . '">'.PHP_EOL;

						if ( get_post_meta( $datebook_design, "datebook_notice_close_button_position_option_disable", true ) != 'yes' ) {
							$print_default_location .= '	<span id="close-datebook-notice-id-' . $notification_notice_id . '" class="' . $datebook_notice_close_design . '" tabIndex="0" title="close box button" data-datebook-notice-close-button="' . $datebook_notice_close_button_val . '">&#x2715;</span>'.PHP_EOL;
						}

						$print_default_location .= wpautop($datebook_notice_content);
						$print_default_location .= '	</div>'.PHP_EOL;
						$print_default_location .= '</div>';
						$datebook_notice_default_location_count++;

					}
				}
			}

			$print_default_location .= '</div>';

			if ($datebook_notice_default_location_count > 0) {
				$print_page .= $print_default_location;
			}

			foreach ( $datebook_locations as $location ) {

				$datebook_location_id = get_post_meta( $location->ID, "datebook_location_id", true );
				$print_page .= '<div id="datebook-notice-location-id-' . $datebook_location_id . '">' . PHP_EOL;

				foreach ($datebook_notices as $notification_notice_values) {

					if ( $notification_notice_values->location_id == $datebook_location_id ) {

						$notification_notice_id = $notification_notice_values->id;
						$datebook_notice_post_id = $notification_notice_values->post_ID;
						$datebook_notice_post = get_post($datebook_notice_post_id);
						$datebook_notice_enabled = $notification_notice_values->enabled;
						$datebook_notice_content = (isset($datebook_notice_post->post_content)) ? do_shortcode($datebook_notice_post->post_content) : null;
						$datebook_design = $notification_notice_values->design_id;
						$datebook_notice_device = $notification_notice_values->device_class;
						$datebook_animation = $notification_notice_values->animation_id;
						$datebook_animout_id = $notification_notice_values->animation_out_id;
						$datebook_notice_delay = $notification_notice_values->delay;
						$datebook_notice_show_time = $notification_notice_values->show_time;
						$notification_notice_display_in = $notification_notice_values->display_in;

						$datebook_notice_close_button = get_post_meta( $datebook_notice_post_id, "click_on_close_button_datebook_notice_option", true );
						$datebook_notice_close_button_days = get_post_meta( $datebook_notice_post_id, "days_click_on_close_button_datebook_notice_option", true );
						$datebook_notice_limitations = get_post_meta( $datebook_notice_post_id, "limitations_datebook_notice_option", true );
						$datebook_notice_limitations_times = get_post_meta( $datebook_notice_post_id, "times_custom_limitations_datebook_notice_option", true );
						$datebook_notice_limitations_days = get_post_meta( $datebook_notice_post_id, "days_custom_limitations_datebook_notice_option", true );
						$datebook_animout_post_option_animation_speed = get_post_meta( $datebook_animout_id, "datebook_animout_post_option_animation_speed", true );
						if ($datebook_animout_post_option_animation_speed == '' || $datebook_animout_post_option_animation_speed == null) {
							$datebook_animout_post_option_animation_speed = 1;
						} elseif ($datebook_animout_post_option_animation_speed < 0) {
							$datebook_animout_post_option_animation_speed = 0;
						}

						if ( $datebook_notice_close_button == 'cancel-for' ) {
							$datebook_notice_close_button_val = $datebook_notice_close_button_days;
						} else {
							$datebook_notice_close_button_val = 0;
						}

						if ( $datebook_notice_limitations == 'custom-limitations' ) {
							$datebook_notice_limitations_times_val = $datebook_notice_limitations_times;
							$datebook_notice_limitations_days_val = $datebook_notice_limitations_days;
						} else {
							$datebook_notice_limitations_times_val = 0;
							$datebook_notice_limitations_days_val = 0;
						}

						if( self::datebook_notice_show($notification_notice_id,$get_page_id) && self::is_showing_post($notification_notice_id) ) {
							if ($datebook_design == null) {
								$datebook_design_class = 'datebook-notice datebook-notice-class-success alert alert-success';
								$datebook_notice_close_design = 'close-datebook-notice-success';
							} else {
								$datebook_design_class = 'datebook-notice datebook-notice-class-' . $datebook_design . ' alert alert-' . $datebook_design;
								$datebook_notice_close_design = 'close-datebook-notice-' . $datebook_design;
							}
							if ($datebook_animation == null || $datebook_animation == 'default') {
								$datebook_animation = 'datebook-notice-animation-default';
							} else {
								$datebook_animation = 'datebook-notice-animation-id-' . $datebook_animation;
							}

							$print_page .= '<div class="datebook-notice-bg">'.PHP_EOL;
							$print_page .= '	<div id="datebook-notice-id-' . $notification_notice_id . '" class="' . $datebook_design_class . ' ' . $datebook_notice_device . ' ' . $datebook_animation . ' delay" data-datebook-notice-id="' . $notification_notice_id . '" data-datebook-notice-delay="' . $datebook_notice_delay . '" data-datebook-notice-show-time="' . $datebook_notice_show_time . '" data-datebook-notice-limitations-times="' . $datebook_notice_limitations_times_val . '" data-datebook-notice-limitations-days="' . $datebook_notice_limitations_days_val . '" data-datebook-notice-animation-out-class="datebook-notice-animation-out-id-' . $datebook_animout_id . '" data-datebook-notice-animation-out-speed="' . $datebook_animout_post_option_animation_speed . '">'.PHP_EOL;

							if ( get_post_meta( $datebook_design, "datebook_notice_close_button_position_option_disable", true ) != 'yes' ) {
								$print_page .= '	<span id="close-datebook-notice-id-' . $notification_notice_id . '" class="' . $datebook_notice_close_design . '" tabIndex="0" title="close box button" data-datebook-notice-close-button="' . $datebook_notice_close_button_val . '">&#x2715;</span>'.PHP_EOL;
							}

							$print_page .= wpautop($datebook_notice_content);
							$print_page .= '	</div>'.PHP_EOL;
							$print_page .= '</div>';

						}
					}
				}

				$print_page .= '</div>';
			}

			$print_page = (isset($print_page)) ? $print_page : '';

			echo $print_page;

		}
	}

}

$Class_DateBook_Notification = new Class_DateBook_Notification;