<?php

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Implements DateBook_WC_Subscription_Cart Class
 *
 * @class   DateBook_WC_Subscription_Cart
 * @package DateBook WooCommerce Subscription
 * @since   3.0
 */
if ( !class_exists( 'DateBook_WC_Subscription_Cart' ) ) {

	/**
	 * Class DateBook_WC_Subscription_Cart
	 */
	class DateBook_WC_Subscription_Cart {

        /**
         * Single instance of the class
         *
         */
        protected static $instance;

		public $post_type_name = 'datebook_subscribe';

        /**
         * Returns single instance of the class
         *
         */
        public static function get_instance() {
            if ( is_null( self::$instance ) ) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        /**
         * Constructor
         *
         */
        public function __construct() {

            add_filter('woocommerce_cart_item_price', array($this, 'change_price_in_cart_html'), 10, 3);
            add_filter('woocommerce_cart_item_subtotal', array($this, 'change_price_in_cart_html'), 10, 3);

        }


		public function change_price_in_cart_html(  $price, $cart_item, $cart_item_key ) {

			$product_id = ! empty( $cart_item['variation_id'] ) ? $cart_item['variation_id'] : $cart_item['product_id'];

            if ( !DateBook_WC_Start()->is_subscription( $product_id ) ) {
                return $price;
            }

            $product = $cart_item['data'];

            $price_is_per = datebook_get_prop( $product, '_wcaddon_price_is_per' );
            $price_time_option = datebook_get_prop( $product, '_wcaddon_price_time_option' );
			$price_is_per = datebook_wc_get_price_per_string( $price_is_per,$price_time_option);

            $price .=  ' / '. $price_is_per; //' / '. $price_is_per. ' '. $price_time_option;

            return $price;

        }
    }
}

/**
 * Unique access to instance of DateBook_WC_Subscription_Cart class
 *
 */
function DateBook_WC_Subscription_Cart() {
    return DateBook_WC_Subscription_Cart::get_instance();
}