<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Post_Type_Notification
 *
 * @class DateBook_Post_Type_Notification
 * @package DateBook/Classes/Post_Types
 * @author Pagick Themes
 */
class DateBook_Post_Type_Notification {


	/**
	 * Hook actions and filters.
	 * 
	 * @since 3.3
	 * @access public
	 */
	public static function init() {

		add_action( 'init', array( __CLASS__, 'datebook_definition' ) );
		
	}
	
	
	/**
	 * Custom post type definition
	 *
	 * @access public
	 * @return void
	 */
	public static function datebook_definition() {
		
		
		$args = array(
	        'labels' => array(
				'name'               => esc_html__( 'Notifications', 'datebook' ),
				'singular_name'      => _x( 'Notification', 'post type singular name', 'datebook' ),
				'menu_name'          => _x( 'Notifications', 'admin menu', 'datebook' ),
				'name_admin_bar'     => _x( 'Notification', 'add new on admin bar', 'datebook' ),
				'add_new'            => _x( 'Add New', 'Post Type', 'datebook' ),
				'add_new_item'       => esc_html__( 'Add New Notification', 'datebook' ),
				'new_item'           => esc_html__( 'New Notification', 'datebook' ),
				'edit_item'          => esc_html__( 'Edit Notification', 'datebook' ),
				'view_item'          => esc_html__( 'View Notification', 'datebook' ),
				'all_items'          => esc_html__( 'Notification', 'datebook' ),
				'search_items'       => esc_html__( 'Search', 'datebook' ),
				'parent_item_colon'  => esc_html__( 'Parent Notification:', 'datebook' ),
				'not_found'          => esc_html__( 'No Notification found.', 'datebook' ),
				'not_found_in_trash' => esc_html__( 'No Notification found in Trash.', 'datebook' ),
			),

			// Frontend // Admin
			'supports'              => array( 'title', 'editor' ),
			'hierarchical'          => true,
			'public'                => false,
			'show_ui'               => true,
			'show_in_menu'          => false,
			'menu_position'         => 54,
			'menu_icon'             => 'dashicons-megaphone',
			'show_in_admin_bar'     => false,
			'show_in_nav_menus'     => false,
			'can_export'            => true,
			'has_archive'           => false,
			'exclude_from_search'   => true,
			'publicly_queryable'    => true,
			'capabilities' => array(
					'create_posts' => true
			),
			'map_meta_cap'          => true

	    );
		
		register_post_type( DATEBOOK_NOTIFICATION_TYPE, $args );


		$args = array(
	        'labels' => array(
				'name'               => esc_html__( 'Notification Animations In', 'datebook' ),
				'singular_name'      => _x( 'Notification Animations In', 'post type singular name', 'datebook' ),
				'menu_name'          => _x( 'Notification Animations In', 'admin menu', 'datebook' ),
				'name_admin_bar'     => _x( 'Notification Animations In', 'add new on admin bar', 'datebook' ),
				'add_new'            => _x( 'Add New', 'Post Type', 'datebook' ),
				'add_new_item'       => esc_html__( 'Add New Animation In', 'datebook' ),
				'new_item'           => esc_html__( 'New Notification Animation In', 'datebook' ),
				'edit_item'          => esc_html__( 'Edit Notification Animation In', 'datebook' ),
				'view_item'          => esc_html__( 'View Notification Animation In', 'datebook' ),
				'all_items'          => esc_html__( 'Notification Animations In', 'datebook' ),
				'search_items'       => esc_html__( 'Search', 'datebook' ),
				'parent_item_colon'  => esc_html__( 'Parent Notification:', 'datebook' ),
				'not_found'          => esc_html__( 'No Notification Animation In found.', 'datebook' ),
				'not_found_in_trash' => esc_html__( 'No Notification Animation In found in Trash.', 'datebook' ),
			),

			// Frontend // Admin
			'supports'              => array( 'title'),
			'hierarchical'          => true,
			'public'                => false,
			'show_ui'               => true,
			'show_in_menu'          => false,
			'menu_position'         => 54,
			'menu_icon'             => 'dashicons-megaphone',
			'show_in_admin_bar'     => false,
			'show_in_nav_menus'     => false,
			'can_export'            => true,
			'has_archive'           => false,
			'exclude_from_search'   => true,
			'publicly_queryable'    => true,
			'capabilities' => array(
					'create_posts' => true
			),
			'map_meta_cap'          => true
    	);
		
		register_post_type( DATEBOOK_ANIMATION_TYPE, $args );
		
		
		$args = array(
        	'labels' => array(
				'name'               => esc_html__( 'Notification Animations Out', 'datebook' ),
				'singular_name'      => _x( 'Notification Animations Out', 'post type singular name', 'datebook' ),
				'menu_name'          => _x( 'Notification Animations Out', 'admin menu', 'datebook' ),
				'name_admin_bar'     => _x( 'Notification Animations Out', 'add new on admin bar', 'datebook' ),
				'add_new'            => _x( 'Add New', 'Post Type', 'datebook' ),
				'add_new_item'       => esc_html__( 'Add New Animation Out', 'datebook' ),
				'new_item'           => esc_html__( 'New Notification Animation Out', 'datebook' ),
				'edit_item'          => esc_html__( 'Edit Notification Animation Out', 'datebook' ),
				'view_item'          => esc_html__( 'View Notification Animation Out', 'datebook' ),
				'all_items'          => esc_html__( 'Notification Animations Out', 'datebook' ),
				'search_items'       => esc_html__( 'Search', 'datebook' ),
				'parent_item_colon'  => esc_html__( 'Parent Notification:', 'datebook' ),
				'not_found'          => esc_html__( 'No Notification Animation Out found.', 'datebook' ),
				'not_found_in_trash' => esc_html__( 'No Notification Animation Out found in Trash.', 'datebook' ),
			),

			// Frontend // Admin
			'supports'              => array( 'title'),
			'hierarchical'          => true,
			'public'                => false,
			'show_ui'               => true,
			'show_in_menu'          => false,
			'menu_position'         => 54,
			'menu_icon'             => 'dashicons-megaphone',
			'show_in_admin_bar'     => false,
			'show_in_nav_menus'     => false,
			'can_export'            => true,
			'has_archive'           => false,
			'exclude_from_search'   => true,
			'publicly_queryable'    => true,
			'capabilities' => array(
					'create_posts' => true
			),
			'map_meta_cap'          => true
    	);
		
		register_post_type( DATEBOOK_ANIMATION_OUT_TYPE, $args );
		
		
		$args = array(
        	'labels' => array(
				'name'               => esc_html__( 'Notification Designs', 'datebook' ),
				'singular_name'      => _x( 'Notification Designs', 'post type singular name', 'datebook' ),
				'menu_name'          => _x( 'Notification Designs', 'admin menu', 'datebook' ),
				'name_admin_bar'     => _x( 'Notification Designs', 'add new on admin bar', 'datebook' ),
				'add_new'            => _x( 'Add New', 'Post Type', 'datebook' ),
				'add_new_item'       => esc_html__( 'Add New Design', 'datebook' ),
				'new_item'           => esc_html__( 'New Notification Design', 'datebook' ),
				'edit_item'          => esc_html__( 'Edit Notification Design', 'datebook' ),
				'view_item'          => esc_html__( 'View Notification Design', 'datebook' ),
				'all_items'          => esc_html__( 'Notification Designs', 'datebook' ),
				'search_items'       => esc_html__( 'Search', 'datebook' ),
				'parent_item_colon'  => esc_html__( 'Parent Notification:', 'datebook' ),
				'not_found'          => esc_html__( 'No Notification Design found.', 'datebook' ),
				'not_found_in_trash' => esc_html__( 'No Notification Design found in Trash.', 'datebook' ),
			),

			// Frontend // Admin
			'supports'              => array( 'title'),
			'hierarchical'          => true,
			'public'                => false,
			'show_ui'               => true,
			'show_in_menu'          => false,
			'menu_position'         => 54,
			'menu_icon'             => 'dashicons-megaphone',
			'show_in_admin_bar'     => false,
			'show_in_nav_menus'     => false,
			'can_export'            => true,
			'has_archive'           => false,
			'exclude_from_search'   => true,
			'publicly_queryable'    => true,
			'capabilities' => array(
					'create_posts' => true
			),
			'map_meta_cap'          => true
    	);
		
		register_post_type( DATEBOOK_DESIGN_TYPE, $args );
		
		
		$args = array(
        	'labels' => array(
				'name'               => esc_html__( 'Notification Locations', 'datebook' ),
				'singular_name'      => _x( 'Notification Locations', 'post type singular name', 'datebook' ),
				'menu_name'          => _x( 'Notification Locations', 'admin menu', 'datebook' ),
				'name_admin_bar'     => _x( 'Notification Locations', 'add new on admin bar', 'datebook' ),
				'add_new'            => _x( 'Add New', 'Post Type', 'datebook' ),
				'add_new_item'       => esc_html__( 'Add New Location', 'datebook' ),
				'new_item'           => esc_html__( 'New Notification Location', 'datebook' ),
				'edit_item'          => esc_html__( 'Edit Notification Location', 'datebook' ),
				'view_item'          => esc_html__( 'View Notification Location', 'datebook' ),
				'all_items'          => esc_html__( 'Notification Locations', 'datebook' ),
				'search_items'       => esc_html__( 'Search', 'datebook' ),
				'parent_item_colon'  => esc_html__( 'Parent Notification:', 'datebook' ),
				'not_found'          => esc_html__( 'No Notification Location found.', 'datebook' ),
				'not_found_in_trash' => esc_html__( 'No Notification Location found in Trash.', 'datebook' ),
			),

			// Frontend // Admin
			'supports'              => array( 'title'),
			'hierarchical'          => true,
			'public'                => false,
			'show_ui'               => true,
			'show_in_menu'          => false,
			'menu_position'         => 54,
			'menu_icon'             => 'dashicons-megaphone',
			'show_in_admin_bar'     => false,
			'show_in_nav_menus'     => false,
			'can_export'            => true,
			'has_archive'           => false,
			'exclude_from_search'   => true,
			'publicly_queryable'    => true,
			'capabilities' => array(
					'create_posts' => true
			),
			'map_meta_cap'          => true
	    );
		
		register_post_type( DATEBOOK_LOCATION_TYPE, $args );
		
	}

}

DateBook_Post_Type_Notification::init();