<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Latest profiles

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'datebook_latest_profiles_widgets' );

// Register widget.
function datebook_latest_profiles_widgets() {
	register_widget( 'DateBook_Latest_Profiles_widget' );
}

// Widget class.
class DateBook_Latest_Profiles_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function __construct() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'datebook-latest-profiles-widget', 'description' => esc_html__( 'Displays latest profiles.', 'datebook' ) );

		parent::__construct( 'datebook_latest_profiles_widget', esc_html__( 'DateBook: Latest Profiles', 'datebook' ), $widget_ops );

	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['posts_per_page'] = strip_tags($new_instance['posts_per_page']);
		$instance['sort_by'] = strip_tags($new_instance['sort_by']);
		$instance['enabled_country'] = !empty($new_instance['enabled_country']) ? 1 : 0;
		$instance['round_image'] = !empty($new_instance['round_image']) ? 1 : 0;
		$instance['enabled_phone'] = !empty($new_instance['enabled_phone']) ? 1 : 0;
		$instance['enabled_sms'] = !empty($new_instance['enabled_sms']) ? 1 : 0;

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'title' => 'Latest Profiles',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$title = isset( $instance['title'] ) ? $instance['title'] : '';
		$posts_per_page = (isset($instance['posts_per_page'])) ? strip_tags($instance['posts_per_page']) : 5;
		$sort_by = !empty($instance['sort_by']) ? strip_tags($instance['sort_by']) : 'descending';
		$enabled_country = isset($instance['enabled_country']) ? (bool) $instance['enabled_country'] : true;
		$enabled_phone = isset($instance['enabled_phone']) ? (bool) $instance['enabled_phone'] : true;
		$enabled_sms = isset($instance['enabled_sms']) ? (bool) $instance['enabled_sms'] : true;
		$round_image = isset($instance['round_image']) ? (bool) $instance['round_image'] : true;
		
		?>

		<!-- Widget Title: Text Input -->

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e('Title:', 'datebook' ) ?></label>
			<input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
        <input id="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'posts_per_page' )); ?>" type="text" value="<?php echo esc_attr($posts_per_page); ?>" size="3" />
		<label for="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>"><?php esc_html_e( 'Number of Profiles', 'datebook' ); ?></label>		
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('sort_by')); ?>"><?php esc_html_e('Sort by date', 'datebook' );?></label>
			<?php $answers = array('desc' => 'New first','asc' => 'Old first','rand' => 'Random'); ?>
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('sort_by')); ?>" name="<?php echo esc_attr($this->get_field_name('sort_by')); ?>">
				<?php foreach ($answers as $key => $answer ): ?>
				<option <?php if ($sort_by == $key ) { echo 'selected="selected"'; } ?> value="<?php echo sanitize_key($key);?>"><?php echo esc_attr($answer);?></option>
				<?php endforeach; ?>
			</select>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('enabled_country'));?>" name="<?php echo esc_attr($this->get_field_name('enabled_country')); ?>" <?php checked($enabled_country); ?> /> <?php esc_html_e("Show City and Country", 'datebook' );?>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('enabled_phone')); ?>" name="<?php echo esc_attr($this->get_field_name('enabled_phone')); ?>" <?php checked($enabled_phone); ?> /> <?php esc_html_e("Show Phone", 'datebook' );?>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('enabled_sms')); ?>" name="<?php echo esc_attr($this->get_field_name('enabled_sms')); ?>" <?php checked($enabled_sms); ?> /> <?php esc_html_e("Show SMS button", 'datebook' );?>
		</p>
		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('round_image')); ?>" name="<?php echo esc_attr($this->get_field_name('round_image')); ?>" <?php checked($round_image); ?> /> <?php esc_html_e("Round images", 'datebook' );?>
		</p>

		<?php
	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$posts_per_page = (isset($instance['posts_per_page'])) ? strip_tags($instance['posts_per_page']) : '3_2';
		$enabled_country = isset($instance['enabled_country']) ? (bool)$instance['enabled_country'] : 1;
		$enabled_phone = isset($instance['enabled_phone']) ? (bool)$instance['enabled_phone'] : 1;
		$enabled_sms = isset($instance['enabled_sms']) ? (bool)$instance['enabled_sms'] : 1;
		$round_image = isset($instance['round_image']) && $instance['round_image'] > 0 ? '' : 'latest-profile-img';
		
		$sort_by = "RAND";
		if(!empty($instance['sort_by']) && is_array($instance['sort_by'])):
			$sort_by =  array_filter($instance['sort_by']);
		elseif(!empty($instance['sort_by'])):
			$sort_by = $instance['sort_by'];
		endif;
		

		/* Display Widget */
		?>

		<!-- sidebar -->

		<?php

			/* Before widget (defined by themes). */
			echo $before_widget;

			// display the Loop
			global $datebook_gender_titles, $allowedposttags;

			$args = array(
				'post_type' => DATEBOOK_POST_TYPE,
				'post_status' => 'publish',
				'orderby' => $sort_by,
				'posts_per_page' => $posts_per_page
			);

			$the_query = new WP_Query( $args );

			if ( $the_query->have_posts()) :

				$display_phone = 0;
				
				// Check if Retina enabled in Theme Options
				$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

				if ($enabled_phone){

					$enable_subscription = DateBook_Utilities::check_if_gateway_activated() ? 1 : 0;

					if($enable_subscription == 1){

						$get_subscription_plans = get_option('datebook_subscription_plans');

						$profile_subscription_plan = isset($datebook_get_data['profile_subscription']['subscription_id']) ? $datebook_get_data['profile_subscription']['subscription_id'] : '';

						// Phone allowed in a Subscription plan
						$enable_phone = isset($get_subscription_plans[$profile_subscription_plan]['enter_phone']) && $get_subscription_plans[$profile_subscription_plan]['enter_phone'] > 0 ? 1 : 0;

						if ($enable_phone == 1 && DateBook_Utilities::datebook_show_field('phone', 1) && !empty($datebook_get_data['phone'])) {

							$show_phone_to_admin = DateBook_Utilities::datebook_show_field('phone', 4) ? 1 : 0;

							if($show_phone_to_admin == 0 || is_super_admin()){

								$display_phone = 1;

							}
						}
					}
				}

				?>

				<div class="card-header">
					<h4 class="mb-0 datebook-title-aside"><?php esc_html_e( 'Latest profiles', 'datebook' ); ?></h4>
				</div>

				<ul class="list-group">

				<?php

				while ( $the_query->have_posts() ) : $the_query->the_post();

					$profile_id = absint(get_the_ID());
			
					$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
					$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

					if(isset($datebook_get_data['city'])){

						$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
						$city = isset($term_data->city) ? $term_data->city : '';
						$country = isset($term_data->country) ? $term_data->country : '';

					}

					$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) . ' ' . esc_html__( 'years old', 'datebook' ) . ', ' : '';
					$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

					if ($gender == 1) {
						$gender_icon = 'fa fa-venus';
					} else if ($gender == 2) {
						$gender_icon = 'fa fa-mars';
					} else {
						$gender_icon = 'fa fa-user';
					}

					$location_tooltip = (isset($enabled_country) && $enabled_country == 1) ? '<br />' . $city . ', ' . $country : '';

					$get_the_title = get_the_title();

					$title_for_alt = $get_the_title . ', ' . $age;

					if (isset($city)) {
						$title_for_alt .= esc_attr($city);
					}
					if (!empty($city) && !empty($country)) {
						$title_for_alt .= ", ";
					}
					if (isset($country)) {
						$title_for_alt .= esc_attr($country);
					}

					$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_latest_profiles_sidebar', $gender, true);

				?>

					<li class="list-group-item">

				 	<h5 class="datebook-profile-heading datebook-ellipsis small"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr($get_the_title); ?>"><?php echo esc_attr($get_the_title); ?></a></h5>

					<a class="thumbnail float-left" style="max-width:30%" href="<?php the_permalink(); ?>" title="<?php echo esc_attr($get_the_title); ?>"><img src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="<?php echo esc_attr($title_for_alt); ?>" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>
					
					<p class="float-left text-truncate datebook-profile-text" style="max-width:70%">

					<span title="<?php echo esc_attr($age); ?> <?php esc_html_e( 'years old', 'datebook' ); ?>"><?php echo esc_attr($age); ?></span><span title="<?php if(isset($datebook_gender_titles[$gender])){ echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); } ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span>
					
					<?php
					
					if (isset($city) || isset($country)) {
						
						echo '<br /><span class="small text-grey">';
					
						if (isset($city)) {
							echo esc_attr($city);
						}
						if (!empty($city) && !empty($country)) {
							echo ", ";
						}
						if (isset($country)) {
							echo esc_attr($country);
						}

						echo '</span>';

					}
					
					if (!empty($datebook_get_data['phone'])){

						if ($display_phone == 1){

							echo '<br /><a class="small text-dark" href="tel:' . esc_attr($datebook_get_data['phone']) . '"><i class="fas fa-mobile-alt fa-lg text-grey"></i> ' . esc_attr($datebook_get_data['phone']) . '</a>';

						}

						if ($enabled_sms && $display_phone == 1){

							echo ' <a class="small" href="sms:' . esc_attr($datebook_get_data['phone']) . '?body=' . esc_html__( 'Hi', 'datebook' ) . ' ' . esc_attr($get_the_title) . '"><i class="fa fa-envelope-o fa-lg amber-text"></i> ' . esc_html__( 'SMS me!', 'datebook' ) . '</a>';

						}

					}

					?>

					</p>
					
				</li>
				
				<?php endwhile; ?>
				

			</ul>
			
		<?php

		endif;

		wp_reset_postdata();

		/* After widget (defined by themes). */
		echo $after_widget;


		?>

		<!-- /sidebar -->

		<?php
	}

}