<?php
/*
 * Content template for Single Classified page
 */

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$datebook_field_titles = get_query_var('datebook_field_titles');
if (is_array($datebook_field_titles)) {
	extract($datebook_field_titles);
}

// Check if Retina enabled in Theme Options
$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;


if (isset($datebook_alert_error) && $_POST['action'] == 'contacting') {

	echo '<div class="alert alert-danger">' . esc_attr($datebook_alert_error_text) . '</div>';
}

if (isset($alert_success) && $_POST['action'] == 'contacting') {

	echo '<div class="alert alert-succes">' . esc_attr($alert_success_text) . '</div>';
}

?>

<div class="datebook-custom-card card mb-3">
	<div class="card-body">

		<h4><?php esc_html_e('Classified ad details', 'datebook'); ?></h4>

		<hr />

		<?php

		while (have_posts()) : the_post();

			$classifieds_id = get_the_ID();

			$profile_id = get_post_meta($classifieds_id, 'profile_classifieds_id', true);

			$profile_data = get_post($profile_id);
			$user_id = $profile_data->post_author;

			if (!empty($profile_id) && $profile_id > 1) {

				$term_list = wp_get_post_terms($classifieds_id, DATEBOOK_CLASSIFIEDS_TAX, array('fields' => 'all'));

				$term_vals = isset($term_list[0]->term_id) ? get_term_meta($term_list[0]->term_id) : '';

				$subject_name = isset($term_vals['datebook_classcat_' . DATEBOOK_WPLANG][0]) ? $term_vals['datebook_classcat_' . DATEBOOK_WPLANG][0] : (isset($term_list[0]->name) ? $term_list[0]->name : esc_html__('Common', 'datebook'));

		?>
				<h1>
					<?php the_title(); ?>
				</h1>
				<div class="row">

					<!--begin: classified-->
					<div class="col-lg-7 col-md-7 col-sm-7">
						<p class="mb-2 small"><strong><?php echo esc_html__('Placed', 'datebook'); ?>:</strong> <?php echo esc_attr(DateBook_Utilities::datebook_date_i18n(1, get_the_date(), true)); ?></p>
						<p class="small"><strong>
								<?php esc_html_e('Subject', 'datebook'); ?>
								:</strong> <?php echo esc_attr($subject_name); ?></p>
						<hr />
						<p><?php echo nl2br(get_the_content()); ?></p>
					</div>
					<!--end: classified-->

					<?php

					if (!empty($profile_data) && $profile_data->post_status == 'publish') {

						$get_profile_data = get_post_meta($profile_id, "profile_personal_data", true);
						$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

						$country = $region = $city = '';

						if (isset($datebook_get_data['city'])) {

							$term_data = DateBook_Utilities::datebook_get_term_by('id', $datebook_get_data['city']);
							$city = isset($term_data->city) ? $term_data->city : '';
							$country = isset($term_data->country) ? $term_data->country : '';
						}

						$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday'])) / 31556926) . ' ' . esc_html__('years old', 'datebook') : '';
						$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;
						$sexualorientation = isset($datebook_get_data['sexualorientation']) ? $datebook_get_data['sexualorientation'] : '';

						if ($gender == 1) {
							$gender_icon = 'fa fa-venus fa-lg';
						} else if ($gender == 2) {
							$gender_icon = 'fa fa-mars fa-lg';
						} else {
							$gender_icon = 'fa fa-user fa-lg';
						}

					?>

						<!--begin: user-->
						<div class="col-lg-5 col-md-5 col-sm-5">
							<?php $thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_classifieds_other_page', $gender, true, $datebook_get_data); ?>
							<a class="float-left mr-3 mb-4" href="<?php echo esc_url(get_permalink($profile_id)); ?>"><img class="rounded-circle shadow" src="<?php echo esc_url($thumbnail_url['img_full_url']); ?>" width="<?php echo esc_attr($thumbnail_url['width']); ?>" height="<?php echo esc_attr($thumbnail_url['height']); ?>" alt="" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>
							<h6 class="mt-0 mb-2"><a href="<?php echo esc_url(get_permalink($profile_id)); ?>"><?php echo esc_attr($profile_data->post_title); ?></a></h6>
							<p class="small mb-1"> <?php echo esc_attr($age); ?>
								<?php

								if (isset($datebook_sexualorientation_titles[$sexualorientation])) {

									$sexualorientation = $sexualorientation == 2 && isset($gender) && $gender > 0 ? $gender.$sexualorientation . '00' : $sexualorientation;
									?>
									<span class="badge badge-info"><?php echo esc_html__($datebook_sexualorientation_titles[$sexualorientation], 'datebook'); ?></span>
								<?php } ?>
								&nbsp;<span title="<?php if (isset($datebook_gender_titles[$gender])) {
														echo esc_html__($datebook_gender_titles[$gender], 'datebook');
													} ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span> </p>
							<p class="small">
								<?php

								if (isset($city)) {

									echo esc_attr($city);
								}

								if (isset($city) && isset($country)) {

									echo ", ";
								}

								if (isset($country)) {

									echo esc_attr($country);
								}
								
								
								$add_item_link = add_query_arg( array(
									'action' => 'read',
									'sid' => absint($user_id),
									'rid' => absint($current_user_id),									
								), get_permalink(of_get_option('my_messages_page')) );


								?>
							</p>
							<div id="datebook-contactpanel">
								<?php if (of_get_option('contact_method') == '1') { ?>
									<a id="datebook-chatpopup" class="btn btn-primary btn-message" href="<?php echo esc_url($add_item_link); ?>" onclick="return false;"><i class="fa fa-envelope mr-2"></i>
										<?php esc_html_e('Write a message', 'datebook'); ?>
									</a>
								<?php } else { ?>
									<div id="datebook-emailpopup" class="btn-group">
										<button data-toggle="dropdown" class="btn btn-primary btn-message" type="button"><i class="fa fa-envelope"></i>
											<?php esc_html_e('Write a message', 'datebook'); ?>
										</button>
										<button data-toggle="dropdown" class="btn btn-secondary btn-message dropdown-toggle" type="button">
											<?php

											if (isset($datebook_alert_error) && $_POST['action'] == "contacting") {
												echo '<span>&#x25B2;</span>';
											} else {
												echo '<span>&#x25BC;</span>';
											}
											?>
										</button>
									</div>
								<?php

									include DateBook_Template_Loader::locate('profile/profile-contact-form');
								}

								?>
							</div>
						</div>
						<!--end: user-->

					<?php } ?>
				</div>
			<?php } ?>
		<?php endwhile; ?>
	</div>
</div>