<?php
/*
 * Comment form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wp_query;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$profile_id = get_the_ID();

$basepath = implode('/', array_slice(explode('/', $_SERVER['SCRIPT_NAME']), 0, -1)) . '/';
$uri = substr($_SERVER['REQUEST_URI'], strlen($basepath));
if (strstr($uri, '?')) $uri = substr($uri, 0, strpos($uri, '?'));
$profile_slug = basename(trim($uri, '/'));

$comment_page_permalink = get_permalink($profile_id);

$comment_args = array(
	'orderby' => 'comment_date_gmt',
	'order' => 'DESC',
	'status'  => 'approve',
	'post_id' => $profile_id,
	'meta_key' => 'comment_type',
    'meta_value' => DATEBOOK_COMMENT_TYPE,
	'no_found_rows' => false,
	'update_comment_meta_cache' => false
);

$comment_args = apply_filters( 'comments_template_query_args', $comment_args );
$comment_query = new WP_Comment_Query( $comment_args );
$comments_flat = $comment_query->comments;
$wp_query->comments = apply_filters( 'comments_array', $comments_flat, $profile_id );
$comments = &$wp_query->comments;
$wp_query->comment_count = count($wp_query->comments);

?>

<div class="datebook-profile-comments">

		<h2 class="mb-4"><?php esc_html_e( 'Comments', 'datebook' ); ?> <span class="badge indigo"><?php echo absint($wp_query->comment_count); ?></span></h2>

		<?php

		if ( $wp_query->comment_count > 0 ) {
			
			// Check if Retina enabled in Theme Options
			$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;
		
			foreach ( $comments as $comment ) {
				
				$comment_id = $comment->comment_ID;
				$commenter_id = get_user_meta( $comment->user_id, "profile_postid", true);
				$commenter_data = get_post($commenter_id);

				$get_profile_data = get_post_meta($commenter_data->ID, "profile_personal_data", true);
				$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

				$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;
				
				$comment_post_time = DateBook_Utilities::datebook_date_i18n(2, $comment->comment_date);
				
				$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($commenter_id, 'image_avatar', $gender, true, $datebook_get_data);

				?>

				<div class="media">
					<div class="media-left">

						<a id="commentid_<?php echo absint($comment_id); ?>" href="<?php echo esc_url(get_permalink($commenter_id)); ?>" title="<?php echo esc_attr($commenter_data->post_title); ?>"><img class="rounded-circle" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>

					</div>
					<div class="media-body">

						<?php

						if ($current_user_id == $comment->user_id || is_super_admin()) {
							
							$delete_comment_url = add_query_arg( array(
								'show' => 'comments',
								'action' => 'deletecomment',
								'sid' => $comment_id
							), $comment_page_permalink );

							?>

							<a class="btn btn-sm btn-grey float-right" href="<?php echo esc_url($delete_comment_url); ?>" title="<?php esc_html_e( 'Delete this comment', 'datebook' ); ?>"><i class="fa fa-trash"></i></a>

						<?php } ?>

						<h5 class="datebook-profile-heading datebook-ellipsis small"><a href="<?php echo esc_url(get_permalink($commenter_id)); ?>" title="<?php echo esc_attr($commenter_data->post_title); ?>"><?php echo esc_attr($commenter_data->post_title); ?></a> <span class="small text-grey">(<?php echo esc_attr($comment_post_time); ?>)</span></h5>
						
						<p><?php echo wp_kses_post($comment->comment_content); ?></p>

					</div>
				</div>
				<?php } ?>

			<?php } else { ?>

				<div class="card border-0 mb-3">
					<div class="card-body text-center">

						<h4 class="card-title"><?php esc_html_e( 'No comments', 'datebook' ); ?></h4>

					</div>
                    
					<img class="card-img-top" src="<?php echo esc_url(DATEBOOK_URL . 'assets/images/icon-profile-no-comments.png');?>" alt="" />
                    
				</div>

			<?php } ?>

		<div class="datebook-registerpage">

			<?php if (is_user_logged_in()) {

				$comment_form_url = add_query_arg( array(
					'show' => 'comments'
				), $comment_page_permalink );
				
				?>

				<form action="<?php echo esc_url($comment_form_url);?>" method="post">

					<input type="hidden" name="action" value="submit_comment" />

					<div class="form-group">
						<label for="datebook-comment-description" class="control-label"><?php esc_html_e( 'Write your comment', 'datebook' ); ?></label>
						<textarea name="comment_description" rows="2" cols="50" id="datebook-comment-description" class="form-control"></textarea>
						<div class="datebook-charcount">
			    	        <div class="progress">
            				  <div id="datebook-progressslide" class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
			            	</div>
						</div>
					</div>
					<div class="form-group">
						<button type="submit" name="submit" class="btn btn-primary"><?php esc_html_e( 'Submit', 'datebook' ); ?></button> <div id="datebook-count" class="badge badge-light float-right"> <?php echo esc_attr(of_get_option('comment_max_chars'))." ".esc_html__( 'characters max', 'datebook' ); ?> </div>
					</div>
				</form>

			<?php

			} else {

				echo '<div class="alert alert-warning">'.esc_html__( 'You need to', 'datebook' ).' <a class="btn-link" href="'.esc_url(get_permalink(of_get_option('registration_page'))).'">'.esc_html__( 'register', 'datebook' ).'</a> '.esc_html__( 'or', 'datebook' ).' <a class="btn-link" href="'.esc_url(get_permalink(of_get_option('login_page'))).'">'.esc_html__( 'login', 'datebook' ).'</a> '.esc_html__( 'to be able to post a comment', 'datebook' ).'</div>';
				
			}

			?>

		</div>
	</div>