<?php
/**
 * Profile menu: quantity of registered users. Used in page-header.php
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ($shortcode == 1){

	echo DateBook_Utilities::count_all_profiles($shortcode, $style, $size);

} else {

	$is_front_page = (is_front_page()) ? 1: 0;

	$registered_members_layout = (($is_front_page == 1 && (of_get_option( 'logo_position_front' ) == "underprimarymenu" || of_get_option( 'logo_position_front' ) == "top") || ($is_front_page == 0 && (of_get_option( 'logo_position_other' ) == "underprimarymenu" || of_get_option( 'logo_position_other' ) == "top")))) ? 'pt-2 pb-3 w-100' : 'text-right mt-auto mb-auto';

?>

	<span class="d-block small datebook-quantity-registered-users <?php echo esc_attr($registered_members_layout);?>"><?php echo esc_attr(DateBook_Utilities::count_all_profiles($shortcode));?> <?php esc_html_e( 'registered members', 'datebook' ); ?></span>
	
	<?php /*?><div class="mr-3 ml-3 text-white <?php echo esc_attr($registered_members_layout);?>"><span class="badge badge-info"><?php echo esc_attr(DateBook_Utilities::count_all_profiles($shortcode));?> <?php esc_html_e( 'registered members', 'datebook' ); ?></span>
	</div><?php */?>

	<?php /*?><div class="mb-3 text-white"><span class="badge badge-info"><?php echo esc_attr(DateBook_Utilities::count_all_profiles($shortcode));?></span> <?php esc_html_e( 'registered members', 'datebook' ); ?></div><?php */?>

	<?php /*?><ul class="nav justify-content-center datebook-register-links-left">

		<li class="nav-item"><a class="nav-link" href="<?php echo esc_url(get_permalink(of_get_option("search_results_page")));?>" title=""><span class="badge badge-info"><?php echo esc_attr(DateBook_Utilities::count_all_profiles($shortcode));?></span> <?php esc_html_e( 'registered members', 'datebook' ); ?></a></li>

	</ul><?php */?>

<?php }