<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

?>

<div class="datebook-custom-card card tooltip-demo">
	<div class="card-body">

		<h2><?php esc_html_e( 'Subscription panel', 'datebook' ); ?></h2>
		
		<?php
            
		// Display Subscription plans and WooCommerce Subscription plans as well if available
		do_action( 'datebook_profile_subscription_navigation' );

		?>

		<h3><?php esc_html_e( 'Plan has been selected successfully!', 'datebook' ); ?></h3>

		<?php
		
		$gateway_options = get_option('datebook_gateways');

		if(isset($gateway_options['bank']['enabled']) && $gateway_options['bank']['enabled'] == 1) {

			$gateway_option_bank = isset($gateway_options['bank']) ? $gateway_options['bank'] : '';

			?>

            <div class="alert alert-info">
			
				<h4 class="alert-heading"><?php esc_html_e( 'Payment is pending', 'datebook' ); ?></h4>

				<p class="card-text"><?php esc_html_e( 'Bank Transfer can take several business days before we can see your payment. Send a copy of the receipt to email shown below. You must include the invoice number sent to your email as a reference.', 'datebook' ); ?></p>

				<p class="card-text"><?php echo sanitize_email($gateway_option_bank['email']); ?></p>

			</div>

			<h4 class="alert-heading"><?php esc_html_e( 'Bank details', 'datebook' ); ?></h4>
			<p class="card-text"><?php echo nl2br(esc_attr($gateway_option_bank['bank_details'])); ?></p>

			<?php if(isset($gateway_option_bank['logo_url'])) { ?>

				<img src="<?php echo esc_url($gateway_option_bank['logo_url']); ?>" alt="" />

			<?php } ?>
			
		<?php } ?>

	</div>
</div>