<?php
/*
 * Profile Registration page with Profile types
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="datebook-custom-card card text-center">
	<div class="card-body">

		<h1><?php esc_html_e( 'Registration', 'datebook' ); ?></h1>

		<hr />

		<div class="pricing-header pb-md-4 mx-auto">
			<h3><?php esc_html_e( 'Select a profile type', 'datebook' ); ?></h3>
		</div>
		
		
		<div class="row justify-content-center">
		
		<div class="card-deck col-md-12 mb-3 text-center">
		
			<?php

			if(!empty($categories)){

				foreach ( $categories as $category ) :

					echo '<div class="datebook-custom-card card shadow-none mb-4">';

					echo '<form action="' . esc_url(get_permalink(of_get_option('registration_page'))) . '" method="post" class="form-horizontal">';
					
					echo '<input type="hidden" name="action" value="profiletype" />';
					echo '<input type="hidden" name="profiletypereserved" value="' . absint($category->term_id) . '" />';
					
					$term_names = get_term_meta($category->term_id, 'datebook_profiletype_' . DATEBOOK_WPLANG);
					
					$category_name = isset($term_names[0]) && !empty($term_names[0]) ? $term_names[0] : $category->name;

					echo '<div class="card-body p-0">';

					echo '<h5 class="card-title">' . esc_html($category_name) . '</h5>';
					
					$term_image = get_term_meta($category->term_id, 'datebook-profiletype-image-id');
					
					if(isset($term_image[0])){

						// Echo the image
						echo wp_get_attachment_image( $term_image[0], 'large' );

					}

					if(isset($category->description) && !empty($category->description)){

						echo '<p>' . esc_attr($category->description) . '</p>';

					}

					echo '<div class="card-foot mt-2">';
					echo '<button type="submit" name="submit" class="btn btn-primary btn-lg">' . esc_html__( 'Select', 'datebook' ) . '</button>';
					echo '</div>';

					echo '</form>';
					
					echo '</div>';
					
					echo '</div>';

				endforeach;

				?>

				</div>

			<?php } ?>
			
			</div>

		</div>
	</div>
</div>