<?php
/*
 * Profile Tour form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_get_data, $datebook_field_titles, $datebook_alert_error, $datebook_alert_text;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

if (is_user_logged_in() && isset($_REQUEST['action']) && $_REQUEST['action'] == 'edittour' && isset($_REQUEST['tour_id']) && $_REQUEST['tour_id'] > 0) {
	
	$tour_id = absint($_REQUEST['tour_id']);

	$tour = get_post($tour_id);
	$datebook_get_data['title'] = $tour->post_title;
	$datebook_get_data['description'] = $tour->post_content;

	$datebook_get_data['country'] = get_post_meta($tour_id, 'country', true);
	$datebook_get_data['region'] = get_post_meta($tour_id, 'region', true);
	$datebook_get_data['city'] = get_post_meta($tour_id, 'city', true);
	
	if(isset($datebook_get_data['city'])){

		$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
		$datebook_get_data['country'] = isset($term_data->country) ? $term_data->country : '';
		$datebook_get_data['country_id'] = isset($term_data->country_id) ? $term_data->country_id : '';
		$datebook_get_data['region'] = isset($term_data->region) ? $term_data->region : '';
		$datebook_get_data['region_id'] = isset($term_data->region_id) ? $term_data->region_id : '';
		$datebook_get_data['city'] = isset($term_data->city) ? $term_data->city : '';
		$datebook_get_data['city_id'] = isset($term_data->city_id) ? $term_data->city_id : '';

	}
	
	$datebook_get_data['start'] = get_post_meta($tour_id,'start', true);
	$datebook_get_data['end'] = get_post_meta($tour_id,'end', true);
	$edittour = 1;
	
}

?>

<div class="datebook-custom-card card">
	<div class="card-body">

		<h2><?php esc_html_e( 'My tours', 'datebook' ); ?></h2>

		<div class="card border">
			<div class="card-header">

				<?php if (isset($edittour) && $edittour == 1) { esc_html_e( 'Edit Tour', 'datebook' ); } else { esc_html_e( 'Add Tour', 'datebook' ); } ?>

			</div>

			<div class="card-body">

				<form class="datebook-addtour" action="<?php echo esc_url(get_permalink(of_get_option('my_tours_page'))); ?>" method="post">

					<input id="datebook-alllocations" name="alllocations" type="hidden" value="1" />

					<?php if (isset($edittour) && $edittour == 1) { ?>

					<input type="hidden" name="tour_id" value="<?php echo absint($tour_id); ?>" />
					<input type="hidden" name="action" value="edittour" />

					<?php } else { ?>

					<input type="hidden" name="action" value="addtour" />

					<?php } ?>

					<div class="form-group row <?php if (isset($datebook_alert_text['title'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['title'])); } ?>">

						<label for="datebook-title" class="col-sm-3 control-label"><?php esc_html_e( 'Title', 'datebook' ); ?></label>

						<div class="col-sm-9">

							<input type="text" name="title" id="datebook-title" value="<?php if (isset($datebook_get_data['title'])) { echo esc_attr($datebook_get_data['title']); } ?>" class="form-control" />

							<?php
							
							if (isset($datebook_alert_text['title'])) {
								
								echo '<em class="text-error">'.esc_attr($datebook_alert_text['title'])."</em>";
								
							}
							
							?>

						</div>
					</div>

					<div class="form-group row <?php if (isset($datebook_alert_text['city'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['city'])); } ?>">

						<label for="datebook-tourcity" class="col-sm-3 control-label"><?php esc_html_e( 'Location', 'datebook' ); ?></label>

						<div class="col-sm-9 datebook-profile-country">

							<?php
							
							$datebook_get_country = (isset($_POST['country']) && $_POST['country'] > 0) ? $_POST['country'] : (isset($datebook_get_data['country_id']) && $datebook_get_data['country_id'] > 0 ? $datebook_get_data['country_id'] : '');
							$datebook_get_region = (isset($_POST['region']) && $_POST['region'] > 0) ? $_POST['region'] : (isset($datebook_get_data['region_id']) && $datebook_get_data['region_id'] > 0 ? $datebook_get_data['region_id'] : '');
							$datebook_get_city = (isset($_POST['city']) && $_POST['city'] > 0) ? $_POST['city'] : (isset($datebook_get_data['city_id']) && $datebook_get_data['city_id'] > 0 ? $datebook_get_data['city_id'] : '');
							
							?>

							<input id="datebook-locationcountry" name="country" type="hidden" value="<?php echo esc_attr($datebook_get_country);?>" />
							<input id="datebook-locationregion" name="region" type="hidden" value="<?php echo esc_attr($datebook_get_region);?>" />
							<input id="datebook-locationcity" name="city" type="hidden" value="<?php echo esc_attr($datebook_get_city);?>" />
							<?php
							
							$search_countrycity = '';
							
							if (isset($_POST['countrycity']) && !empty($_POST['countrycity'])) {
								
								$search_countrycity = $_POST['countrycity'];
								
							} else {
								
								if (isset($datebook_get_data['city']) && !empty($datebook_get_data['city'])){
									$search_countrycity .= $datebook_get_data['city'] . ', ';
								}
								
								if (isset($datebook_get_data['region']) && !empty($datebook_get_data['region'])){
									$search_countrycity .= $datebook_get_data['region'] . ', ';
								}
								
								if (isset($datebook_get_data['country']) && !empty($datebook_get_data['country'])){
									$search_countrycity .= $datebook_get_data['country'];
								}
								
							}
							
							?>


							<input id="datebook-location" class="form-control datebook-search-btn" name="countrycity" readonly type="text" value="<?php echo esc_attr($search_countrycity);?>" aria-label="<?php esc_html_e( 'Location', 'datebook' ); ?>" data-toggle="modal" data-target="#dbmodalcountriespanel" all-locations="1" />
				
							<?php echo DateBook_Search::datebook_countries_popup('tour', 1); ?>

							<?php
							
							if (isset($datebook_alert_text['city'])) {
								
								echo '<em class="text-error">'.esc_attr($datebook_alert_text['city'])."</em>";
								
							}
							
							?>

						</div>
					</div>

					<div class="form-group row <?php if (isset($datebook_alert_text['start'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['start'])); } ?>">

						<label for="datebook-start" class="col-sm-3 control-label"><?php esc_html_e( 'Start date', 'datebook' ); ?></label>

						<div class="col-sm-9">

							<input type="text" name="start" id="datebook-start" value="<?php if (isset($datebook_get_data['start'])) { echo date("d/m/Y", $datebook_get_data['start']); } ?>" class="form-control" />

							<?php
							
							if (isset($datebook_alert_text['start'])) {
								
								echo '<em class="text-error">'.esc_attr($datebook_alert_text['start'])."</em>";
								
							}
							
							?>

						</div>
					</div>

					<div class="form-group row <?php if (isset($datebook_alert_text['end'])) { echo esc_attr(sanitize_html_class($datebook_alert_error['end'])); } ?>">

						<label for="datebook-end" class="col-sm-3 control-label"><?php esc_html_e( 'End date', 'datebook' ); ?></label>

						<div class="col-sm-9">

							<input type="text" name="end" id="datebook-end" value="<?php if (isset($datebook_get_data['end'])) { echo date("d/m/Y", $datebook_get_data['end']); } ?>" autocomplete="off" class="form-control" />

							<?php 

							if (isset($datebook_alert_text['end'])) {

								echo '<em class="text-error">'.esc_attr($datebook_alert_text['end'])."</em>";

							}

							?>

						</div>
					</div>

					<div class="form-group row">

						<label for="datebook-description" class="col-sm-3 control-label"><?php esc_html_e( 'About tour', 'datebook' ); ?></label>

						<div class="col-sm-9">

							<textarea name="description" id="datebook-description" rows="4" cols="42" class="form-control"><?php if (isset($datebook_get_data['description'])) { echo esc_textarea($datebook_get_data['description']); } ?>
</textarea>

						</div>
					</div>

					<div class="form-group row">

						<label class="col-sm-3 control-label"> </label>

						<div class="col-sm-9">

							<button type="submit" name="submit" class="btn btn-primary"><?php if (isset($edittour) && $edittour == 1) { esc_html_e( 'Save', 'datebook' ); } else { esc_html_e( 'Submit', 'datebook' ); } ?></button>

						</div>
					</div>

				</form>

			</div>
		</div>
	</div>
</div>