<?php
/*
 * Profile Views page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if (!defined('ABSPATH')){
	exit;
}

if (method_exists('DateBook_Utilities', 'protect_if_not_loggedin'))
{
	DateBook_Utilities::protect_if_not_loggedin();
}

global $wpdb, $datebook_field_titles, $datebook_alert_error, $datebook_alert_text;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$datebook_field_titles = get_query_var('datebook_field_titles');
if (is_array($datebook_field_titles)) {
	extract($datebook_field_titles);
}

$table_profile_views = strtolower($wpdb->prefix) . 'datebook_profile_views';

$users_who_visited = $wpdb->get_results($wpdb->prepare("SELECT `visitor_id`, `viewdate` FROM {$table_profile_views} WHERE `profile_id` = '%d' ORDER BY viewdate DESC", $current_user_id));

?>

	<div class="datebook-custom-card card datebook-profilepage">
		<div class="card-body">

			<h2><?php esc_html_e('Who viewed me', 'datebook'); ?></h2>

			<hr />

			<?php

		   if ($users_who_visited) {

			   $show_profile_details = of_get_option( 'show_profile_details_on_who_viewed_me' );

				$show_name = isset($show_profile_details['name']) && $show_profile_details['name'] == 1 ? 1 : 0;
				$show_age = isset($show_profile_details['age']) && $show_profile_details['age'] == 1 && DateBook_Utilities::datebook_show_field('birthdate', 1) ? 1 : 0;
				$show_gender = isset($show_profile_details['gender']) && $show_profile_details['gender'] == 1 && DateBook_Utilities::datebook_show_field('gender', 1) && (of_get_option('gender_allowed') != '' || of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '') ? 1 : 0;
				$show_sexual_orientation = isset($show_profile_details['sexorientation']) && $show_profile_details['sexorientation'] == 1 && DateBook_Utilities::datebook_show_field('sexualorientation', 1) && (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '') ? 1 : 0;
				$show_city = isset($show_profile_details['city']) && $show_profile_details['city'] == 1 && DateBook_Utilities::datebook_show_field('countrycity', 1) ? 1 : 0;
				$show_country = isset($show_profile_details['country']) && $show_profile_details['country'] == 1 && DateBook_Utilities::datebook_show_field('countrycity', 1) ? 1 : 0;

				$mobile_detect = DateBook_Utilities::mobile_detect() == 'mobile' ? 1 : 0;
				$open_profile_new_tab = of_get_option('open_profile_new_tab') ? ($mobile_detect == 1 ? '_self' : '_blank') : '_self';

				foreach ($users_who_visited as $key) {

				   $visitor_id = $key->visitor_id;

				   $viewdate = DateBook_Utilities::datebook_date_i18n(2, $key->viewdate);

				   $profile_postid = get_user_meta($visitor_id, 'profile_postid', true);

				   if (isset($profile_postid) && $profile_postid > 0){

					   $post = get_post($profile_postid);

					   $profile_id = isset($post->ID) && $post->ID > 0 ? $post->ID : 0;
					   if ($profile_id > 0){

						   $profile_title = $post->post_title;

						   $get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
						   $datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

							if (isset($datebook_get_data['city'])){

							   $term_data = DateBook_Utilities::datebook_get_term_by('id', $datebook_get_data['city']);
							   $country = isset($term_data->country) ? $term_data->country : '';
							   $region = isset($term_data->region) ? $term_data->region : '';
							   $city = isset($term_data->city) ? $term_data->city : '';

						   }

						   $age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday'])) / 31556926) . ' ' . esc_html__('years old', 'datebook') : '';
						   $gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

						   if ($gender == 1){
							   $gender_icon = 'fa fa-venus fa-lg';
						   } else if ($gender == 2) {
							   $gender_icon = 'fa fa-mars fa-lg';
						   } else {
							   $gender_icon = 'fa fa-user fa-lg';
							}

							$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_avatar', $gender, true);

							?>

							<div class="card border-0 mb-4 datebook-transparent">
								<div class="row">
									<div class="col-lg-6 col-md-7 col-sm-7">

										<a class="float-left mr-3 mb-3" title="<?php echo esc_attr($profile_title); ?>" href="<?php echo esc_url(get_permalink($profile_id)); ?>" target="_blank"><img alt="" src="<?php echo esc_url($thumbnail_url['img_full_url']); ?>" class="thumbnail rounded" /></a> 

										<?php if ($show_name == 1 || $show_age == 1 || $show_gender == 1) { ?>
											<h6 class="datebook-profile-heading datebook-ellipsis">
												<?php $show_comma = 0; if ($show_name == 1) { ?>
												<a href="<?php echo esc_url(get_permalink($profile_id)); ?>" target="<?php echo esc_attr($open_profile_new_tab); ?>"><?php echo esc_attr($profile_title); ?></a><?php $show_comma = 1; }
												if ($show_age == 1) { if ($show_comma > 0) { ?>, <?php } ?><span class="text-muted small"><?php echo esc_attr($age); ?></span><?php $show_comma = 1; }
												if ($show_gender == 1) { if ($show_comma > 0) { ?>, <?php } ?><span class="small"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span><?php } ?>
											</h6>
										<?php } ?>

										<p class="mb-1"><?php do_action('datebook_online_status', $visitor_id, $gender, 1, 'full'); ?></p>

										<p class="small mb-0 text-muted">

										<?php

										if ($show_city == 1 && isset($city)) {
											echo esc_attr($city);
										}
										if ($show_city == 1 && !empty($city) && $show_country == 1 && !empty($country)) {
											echo ', ';
										}
										if ($show_country == 1 && isset($country)) {
											echo esc_attr($country);
										}

										?>

										</p>

									</div>

									<div class="col-lg-6 col-md-5 col-sm-5 text-right">

										<span class="small"><?php echo esc_html__('Visited on', 'datebook') . ': ' . esc_attr($viewdate); ?></span>

									</div>
								</div>
							</div>

						<?php

						   }
					   }
				   }

			   } else {

				   ?>

					<div class="jumbotron shadow-none datebook-transparent">
						<div class="row">
							<div class="col-lg-4 col-md-4 col-sm-4">
								<div class="jumbotron-photo text-center"> 

									<img class="img-responsive" alt="" src="<?php echo esc_url(DATEBOOK_URL . 'assets/images/no-image-front-medium-m.png'); ?>" /> 

								</div>
							</div>
							<div class="col-lg-8 col-md-8 col-sm-8">
								<div class="jumbotron-contents">

									<h3><?php esc_html_e('No one viewed your profile yet', 'datebook'); ?></h3>

									<hr class="my-4">

									<p class="lead"><?php esc_html_e('Here will be a list of users who viewed your profile', 'datebook'); ?></p>

								</div>
							</div>
						</div>
					</div>

				<?php } ?>

		</div>
	</div>