<?php
/*
 * Single Profile not active yet
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

// Show Administrator Dashboard to control Profile
do_action('datebook_administrator_panel');

?>

<div class="datebook-custom-card card mb-3 text-center">

	<!-- Card image -->
	<img class="card-img-top" src="<?php echo esc_url(DATEBOOK_URL . 'assets/images/not-active-profile.png');?>" alt="" />

	<div class="card-header">

	<?php if (isset($currentauth->ID) && $currentauth->ID > 0 && $currentauth->ID == $current_user_id) { ?>

		<h1 class="card-header-title"><?php echo esc_html__( 'Your profile is not active yet!', 'datebook' ); ?></h1>

	<?php } else { ?>

		<h1 class="card-title"><?php echo esc_html__( 'This profile is not active!', 'datebook' ); ?></h1>

	<?php } ?>

	</div>

	<div class="card-body">

	<?php if (isset($currentauth->ID) && $currentauth->ID > 0 && $currentauth->ID == $current_user_id) { ?>

		<p><?php echo esc_html__( 'In order to see your profile you must complete it.', 'datebook' ); ?></p>
		<p><?php echo esc_html__( 'Some required information is missing.', 'datebook' ); ?></p>
		<p><?php echo esc_html__( 'Follow the link below and complete the form.', 'datebook' ); ?></p>

		<a class="btn btn-primary btn-lg" href="<?php echo esc_url(get_permalink(of_get_option('my_settings_page'))); ?>"><?php esc_html_e( 'Click here to complete', 'datebook' ); ?></a>

	<?php } else { ?>

		<p><?php echo esc_html__( 'Author of the profile did not provide the required data yet.', 'datebook' ); ?></p>
		<p><?php echo esc_html__( 'Please, try to come here again in some days.', 'datebook' ); ?></p>
		<p><?php echo esc_html__( 'We apologize for inconvenience.', 'datebook' ); ?></p>

	<?php } ?>

	</div>
</div>