<?php
/**
 * The default template for displaying Profiles on Search page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

global $datebook_image_sizes;

$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

// Mobile devices (Smartphones: iPhones, Galaxy Phones, Google Pixel, HTC Phones, Windows Phone)
$how_many_columns_on_search_mobile = of_get_option('how_many_columns_on_search_mobile');
switch($how_many_columns_on_search_mobile) {
	case 1 : $mobile_columns = 'col-sm-12'; $columns_mobile_clear = 1; break; // 1 columns
	case 2 : $mobile_columns = 'col-sm-6 col-6'; $columns_mobile_clear = 2; break; // 2 columns
	case 3 : $mobile_columns = 'col-sm-4 col-4'; $columns_mobile_clear = 3; break; // 3 columns
	case 4 : $mobile_columns = 'col-sm-3 col-3'; $columns_mobile_clear = 4; break; // 4 columns
	case 5 : $mobile_columns = 'col-sm-2 col-2'; $columns_mobile_clear = 6; break; // 6 columns
	default: $mobile_columns = 'col-sm-12'; $columns_mobile_clear = 1; break; // 1 columns
}

// Mobile devices (Tablets: iPads, Galaxy Tablets, Nexus Tablets, Kindle Fire)
$how_many_columns_on_search_tablet = of_get_option('how_many_columns_on_search_tablet');
switch($how_many_columns_on_search_tablet) {
	case 1 : $tablet_columns = 'col-md-6'; $columns_tablet_clear = 2; break; // 2 columns
	case 2 : $tablet_columns = 'col-md-4'; $columns_tablet_clear = 3; break; // 3 columns
	case 3 : $tablet_columns = 'col-md-3'; $columns_tablet_clear = 4; break; // 4 columns
	case 4 : $tablet_columns = 'col-md-2'; $columns_tablet_clear = 6; break; // 6 columns
	case 5 : $tablet_columns = 'col-md-12'; $columns_tablet_clear = 1; break; // 1 columns
	default: $tablet_columns = 'col-md-6'; $columns_tablet_clear = 2; break; // 2 columns
}

// Normal screens (Desktops)
$how_many_columns_on_search_normal = of_get_option('how_many_columns_on_search_normal');
switch($how_many_columns_on_search_normal) {
	case 1 : $normal_columns = 'col-lg-6'; $columns_normal_clear = 2; $columns_image_format = 'image_medium'; break; // 2 columns
	case 2 : $normal_columns = 'col-lg-4'; $columns_normal_clear = 3; $columns_image_format = 'image_search'; break; // 3 columns
	case 3 : $normal_columns = 'col-lg-3'; $columns_normal_clear = 4; $columns_image_format = 'image_medium'; break; // 4 columns
	case 4 : $normal_columns = 'col-lg-2'; $columns_normal_clear = 6; $columns_image_format = 'image_medium'; break; // 6 columns
	default: $normal_columns = 'col-lg-6'; $columns_normal_clear = 2; $columns_image_format = 'image_medium'; break; // 2 columns
}

// Large screens (Widescreen desktop and Laptops)
$how_many_columns_on_search_large = of_get_option('how_many_columns_on_search_large');
switch($how_many_columns_on_search_large) {
	case 1 : $large_columns = 'col-xl-6'; $columns_large_clear = 2; $columns_image_format = 'image_search'; break; // 2 columns
	case 2 : $large_columns = 'col-xl-4'; $columns_large_clear = 3; $columns_image_format = 'image_search'; break; // 3 columns
	case 3 : $large_columns = 'col-xl-3'; $columns_large_clear = 4; $columns_image_format = 'image_search'; break; // 4 columns
	case 4 : $large_columns = 'col-xl-2'; $columns_large_clear = 6; $columns_image_format = 'image_search'; break; // 6 columns
	case 5 : $large_columns = 'col-xl-1'; $columns_large_clear = 12; $columns_image_format = 'image_search'; break; // 12 columns
	default: $large_columns = 'col-xl-6'; $columns_large_clear = 2; $columns_image_format = 'image_search'; break; // 2 columns
}


$quantity_columns_class = $mobile_columns . ' ' . $tablet_columns . ' ' . $normal_columns . ' ' . $large_columns;

// Check if Retina enabled in Theme Options
$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

$enable_profile_comments = of_get_option('enable_profile_comments') == '1' ? 1 : 0;

$datebook_profile_details = of_get_option('show_profile_details_on_search');

$search_default_thumbnail = of_get_option('search_default_thumbnail') ? 1 : 0;

$style_profile = of_get_option('style_profile_on_search');

$favorites_style = of_get_option('favorites_style');
$favorite_normal_icon_color = of_get_option('favorite_normal_icon_color') ? of_get_option('favorite_normal_icon_color') : 'rgb(0, 152, 255)';
$favorite_added_icon_color = of_get_option('favorite_added_icon_color') ? of_get_option('favorite_added_icon_color') : 'rgb(0, 228, 54)';

$show_age = DateBook_Utilities::datebook_show_field('birthdate', 1) ? 1 : 0;

$show_sexual_orientation = (DateBook_Utilities::datebook_show_field('sexualorientation', 1) && (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '')) ? 1 : 0;

$show_gender = (DateBook_Utilities::datebook_show_field('gender', 1) && (of_get_option('gender_allowed') != '' || of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '')) ? 1 : 0;

$show_location = DateBook_Utilities::datebook_show_field('countrycity', 1) ? 1 : 0;

$border_mode = '';
if($border_width == '0' && is_numeric($border_width)) {
	$border_bootstrap = '';
	$border_width_out = ' border-width: 0px !important;';
} else if($border_width > 0 && is_numeric($border_width)) {
	$border_bootstrap = ' border';
	$border_width_out = ' border-width: ' . $border_width . 'px !important;';
} else if ( preg_match('/^\d+(?:,\d+)*$/', $border_width) ){
	$border_bootstrap = ' border';
	$get_border_number = explode(',', $border_width);
	$border_mode = 'random';
} else {
	$border_bootstrap = '';
	$border_width_out = '';
}

$border_style_out = !empty($border_style) ? 'border-style:' . $border_style . ';' : '';


// set up cache folder
$upload_dir = wp_upload_dir();
$cache_url  = trailingslashit( $upload_dir['baseurl'] . '/' . DATEBOOK_OPTIONS_FOLDER . '/images');

$i = 0;

while ( $all->have_posts() ) : $all->the_post();

	$profile_id = absint(get_the_ID());

	$post = get_post($profile_id);
	$date = $post->post_date;
	$user_id = $post->post_author;
	$currentauth = get_userdata($user_id);

	$currentauth_ID = isset($currentauth->ID) && $currentauth->ID > 0 ? $currentauth->ID : 0;

	$all_photos_args = array(
		'post_parent' => $profile_id, 
		'post_status' => 'inherit', 
		'post_type' => 'attachment', 
		'post_mime_type' => 'image',
		'posts_per_page' => -1,
		'meta_query' => array(
			array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
		)
	);

	$all_photos_query = new WP_Query( $all_photos_args );
	$all_photos_count = $all_photos_query->found_posts - 1;
	$all_photos_count = ($all_photos_count > 0) ? $all_photos_count : 0;
	
	$profile_name = get_the_title();

	$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
	$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

	$topad = get_post_meta($profile_id, 'topad', true);
	$featured = get_post_meta($profile_id, 'featured', true);

	// City
	$country = $region = $city = '';
	if(isset($datebook_get_data['city'])){

		$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $datebook_get_data['city'] );
		$city = isset($term_data->city) ? $term_data->city : '';
		$region = isset($term_data->region) ? $term_data->region : '';
		$country = isset($term_data->country) ? $term_data->country : '';

	}

	// Age
	if(isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday'])){
		$age = floor((time() - strtotime($datebook_get_data['birthday']))/31556926);
	} else {
		$age_array = get_post_meta($profile_id, 'birthday', true);

		if(!empty($age_array)){
			$age = floor((time() - strtotime($age_array))/31556926);
		} else {
			$age = '';
		}
	}
	
	$sexualorientation = isset($datebook_get_data['sexualorientation']) ? $datebook_get_data['sexualorientation'] : '';
	$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;
	$wishtravel = isset($datebook_get_data['wishtravel']) ? $datebook_get_data['wishtravel'] : 0;
	$verified = isset($datebook_get_data['verified']) ? $datebook_get_data['verified'] : 0;


	// if some data do not exist then do not show this profile (name, age, city, country)
	$main_profile_fields_exist = ($profile_name || ($show_age == 1 && isset($age) && $age > 0) || ($show_location == 1 && isset($city) && strlen($city) > 0 && isset($country) && strlen($country) > 0)) ? 1 : 0;

	$i++;

	if ($gender == 1) {
		$gender_icon = 'fa fa-venus fa-lg';
	} else if ($gender == 2) {
		$gender_icon = 'fa fa-mars fa-lg';
	} else {
		$gender_icon = 'fa fa-user fa-lg';
	}

	
	$location = '';

	if (isset($city) && isset($datebook_profile_details['city']) && $datebook_profile_details['city'] == '1') {
		$location .= esc_attr($city);
	}
	if (!empty($city) && isset($datebook_profile_details['city']) && $datebook_profile_details['city'] == '1' && !empty($country) && isset($datebook_profile_details['country']) && $datebook_profile_details['country'] == '1') {
		$location .= ',';
	}
	if (isset($country) && isset($datebook_profile_details['country']) && $datebook_profile_details['country'] == '1') {
		$location .= ' ';
		$location .= esc_attr($country);
	}

	$title_for_alt = $profile_name;

	if($show_age == 1 && isset($age) && $age > 0){
		$title_for_alt .= ', ' . $age . ' ' . esc_html__( 'years old', 'datebook' );
	}

	if ($show_sexual_orientation == 1 && isset($datebook_sexualorientation_titles[$sexualorientation])){
		
		$sexualorientation = $sexualorientation == 2 && isset($gender) && $gender > 0 ? $gender.$sexualorientation . '00' : $sexualorientation;
		
		$title_for_alt .= ', ';
		$title_for_alt .= esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' );
	}

	if ($show_gender == 1 && $gender > 0 && isset($datebook_gender_titles[$gender])){
		$title_for_alt .= ', ';
		$title_for_alt .= esc_html__( $datebook_gender_titles[$gender], 'datebook' );
	}

	if ($show_location == 1 && (!empty($city) && isset($datebook_profile_details['city']) && $datebook_profile_details['city'] == '1' && !empty($country) && isset($datebook_profile_details['country']) && $datebook_profile_details['country'] == '1')) {
		$title_for_alt .= ', ';
		$title_for_alt .= $location;
	}

	

	if($border_mode == 'random'){
		$first_border = (isset($get_border_number[0]) && is_numeric($get_border_number[0])) ? $get_border_number[0] > 0 ? $get_border_number[0] : 1 : 1;
		$last_border = (isset($get_border_number[1]) && is_numeric($get_border_number[1])) ? $get_border_number[1] > 0 ? $get_border_number[1] : 12 : 12;
		$border_width_out = ' border-width: ' . mt_rand($first_border, $last_border) . 'px !important;';
	}

	if(!empty($border_color)){
		$border_color_out = 'border-color: ' . $border_color . ' !important;';
	} else if(isset($color_gamma)){
		$border_color_out = 'border-color: ' . DateBook_Utilities::create_random_color($border_color, $color_gamma) . ' !important;';
	} else {
		$border_color_out = '';
	}
	
	$featured_class = $featured == 1 ? $border_width_out . $border_style_out . $border_color_out : '';
	
	$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, $columns_image_format, $gender, true, $datebook_get_data, $search_default_thumbnail);
	
	if($thumbnail_url['image_exists'] == 'yes'){

		$profile_image_url = $thumbnail_url['img_full_url'];

	} else {

		$profile_image_url = $cache_url . $columns_image_format . '.png';

	}

	?>

	<div class="<?php echo esc_attr($quantity_columns_class); ?> datebook-padding-less">
		<div class="datebook-profiles-list<?php if($style_profile == 2){ ?> view overlay zoom<?php } else if($style_profile == 3){ ?> datebook-hide datebook-profiles<?php } ?>">
			<div class="card" style=" <?php echo esc_attr($featured_class); ?>">

				<div class="view overlay datebook-profile-caption">

					<a class="datebook-profile-inline-caption white" href="<?php the_permalink(); ?>" title="<?php echo esc_attr($title_for_alt); ?>" style="background-image: url(<?php echo esc_url($thumbnail_url['img_full_url']); ?>); background-repeat: no-repeat; background-position: center; background-size: 60%"><img class="card-img-top img-fluid" width="<?php echo esc_attr($thumbnail_url['width']); ?>" height="<?php echo esc_attr($thumbnail_url['height']); ?>" src="<?php echo esc_url($profile_image_url); ?>" alt="<?php echo esc_attr($title_for_alt); ?>" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a> 

					<?php 

					$top_profile_label = '';

					if ($topad == '1') {

						echo '<span class="badge badge-warning amber darken-2 shadow-none datebook-top-label">'.esc_html__( 'Top', 'datebook' ).'</span>';

					}

					echo DateBook_Utilities::datebook_new_profile_labels($date);
					
					$profile_favorites = isset($datebook_get_data['favorites']) && $datebook_get_data['favorites'] > 0 ? $datebook_get_data['favorites'] : 0;

					$favorite_options = array(
						'profile_id' => $profile_id, 
						'currentauth_ID' => $currentauth_ID, 
						'current_user_id' => $current_user_id, 
						'profile_favorites' => $profile_favorites, 
						'show_count' => 0, 
						'style' => $favorites_style, 
						'normal_icon_color' => $favorite_normal_icon_color, 
						'added_icon_color' => $favorite_added_icon_color, 
						'what_page' => 0
					);

					echo DateBook_Profile_Edit::process_favorite_button($favorite_options);

					if ($enable_profile_comments == '1' && isset($datebook_profile_details['comments']) && $datebook_profile_details['comments'] == '1') { 

						$count_profile_comments = DateBook_Utilities::datebook_count_profile_comments($profile_id);

					?>

						<span class="datebook-profile-comment-caption" title="<?php echo esc_attr($count_profile_comments); ?> <?php esc_html_e( 'Comments', 'datebook' );?>"><i class="fa fa-comments"></i> <?php echo esc_attr($count_profile_comments); ?></span>

					<?php } ?>

					<?php if (isset($datebook_profile_details['images']) && $datebook_profile_details['images'] == '1') { ?>

						<span class="datebook-profile-pictures-caption" title="<?php echo absint($all_photos_count); ?> <?php echo esc_html__( 'more photos', 'datebook' ); ?>"><i class="fa fa-camera"></i> <?php echo absint($all_photos_count); ?> </span>

					<?php } ?>

					<?php if (isset($datebook_profile_details['travel']) && $datebook_profile_details['travel'] == '1' && $wishtravel) { ?>

						<span class="datebook-profile-search-travel" title="<?php echo esc_html__( 'Ready to travel', 'datebook' ); ?>"><span><i class="fa fa-suitcase"></i></span></span>

					<?php } ?>

					<?php

					if ($currentauth_ID > 0 && $columns_large_clear < 6) {

						if ($columns_large_clear > 3) {
							$force_small = 'small';
						} else {
							$force_small = 'full';
						}

						do_action('datebook_online_status', $currentauth_ID, $gender, 2, $force_small);

					}

					?>

				</div>

				<?php

				if((isset($profile_name) && strlen($profile_name) > 0) || $verified == '1' || ($show_age == 1 && isset($age) && $age > 0) || ($show_sexual_orientation == 1 && isset($datebook_profile_details['sexorientation']) && $datebook_profile_details['sexorientation'] == '1' && !empty($sexualorientation)) || ($show_gender == 1 && $gender > 0) || ($show_location == 1 && (isset($datebook_profile_details['city']) && $datebook_profile_details['city'] == '1' && isset($city) && strlen($city) > 0) || (isset($datebook_profile_details['country']) && $datebook_profile_details['country'] == '1' && isset($country) && strlen($country) > 0))){

				?>
				
				<div class="card-body p-2 <?php if($style_profile == 2){ ?> mask flex-center rgba-white-strong<?php } else if($style_profile == 3){ ?> datebook-hide-body<?php } ?> datebook-search-profile-body over">
					<div class="datebook-profile-body datebook-card-body-featured datebook-ellipsis-width">

						<?php if(isset($profile_name) && strlen($profile_name) > 0){ ?>
							<h5 class="card-title mb-0 datebook-profile-heading datebook-ellipsis"> <a href="<?php the_permalink(); ?>" title="<?php echo esc_attr($profile_name); ?>"><?php echo esc_html($profile_name); ?></a>
						

						<?php

						if ($verified == '1') {

							echo ' <i class="fas fa-check-square text-green" title="'.esc_html__( 'Verified', 'datebook' ).'"></i>';

						}

						?>

						</h5>
						<?php } ?>

						<?php if(($show_age == 1 && isset($age) && $age > 0) || ($show_sexual_orientation == 1 && isset($datebook_profile_details['sexorientation']) && $datebook_profile_details['sexorientation'] == '1' && !empty($sexualorientation)) || ($show_gender == 1 && $gender > 0)){ ?>

							<p class="card-text mt-1 mb-1">

							<?php if($show_age == 1 && isset($age) && $age > 0){ ?>

								<span class="mr-1" title="<?php echo esc_attr($age) . ' ' . esc_html__( 'years old', 'datebook' ); ?>"><span><?php echo esc_attr($age); ?></span> <span class="d-none d-sm-inline"><?php echo esc_html__( 'years old', 'datebook' ); ?></span></span> 

							<?php } ?>

							<?php if ($show_sexual_orientation == 1 && isset($datebook_profile_details['sexorientation']) && $datebook_profile_details['sexorientation'] == '1' && !empty($sexualorientation)) { ?>

							<span class="badge badge-pill badge-info shadow-none"><?php if(isset($datebook_sexualorientation_titles[$sexualorientation])){
								$sexualorientation = $sexualorientation == 2 && isset($gender) && $gender > 0 ? $gender.$sexualorientation . '00' : $sexualorientation;
								echo esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' ); } ?></span> 

							<?php }

							if ($show_gender == 1 && $gender > 0 && isset($datebook_gender_titles[$gender])){ ?>

								<?php if ($gender > 2) { ?>

									<span><?php echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); ?></span>

								<?php } else { ?>

									<span title="<?php if(isset($datebook_gender_titles[$gender])){ echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); } ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span>

								<?php } ?>

							<?php } ?>	

							</p>

						<?php } ?>

						<?php if ($show_location == 1 && (isset($datebook_profile_details['city']) && $datebook_profile_details['city'] == '1' || isset($datebook_profile_details['country']) && $datebook_profile_details['country'] == '1')) { ?>
							<p class="card-text mt-1 datebook-ellipsis" title="<?php echo esc_attr($location); ?>"><?php echo esc_attr($location); ?></p>
						<?php } ?>

					</div>
				</div>
				
				<?php } ?>
				
			</div>
		</div>
	</div>

	<?php 

	if ($i % $columns_large_clear == 0) {
		echo '<div class="d-none d-lg-block"></div>';
	}
	if ($i % $columns_normal_clear == 0) {
		echo '<div class="d-none d-md-block"></div>';
	}
	if ($i % $columns_tablet_clear == 0) {
		echo '<div class="d-none d-sm-block"></div>';
	}


endwhile;

unset($featured_class);

wp_reset_postdata();