<?php
/*
 * Show Profiles on Search page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Select profile type
$get_term_slug = $tax_array = '';

if(is_tax(DATEBOOK_PROFILES_TAX)) {

	$get_term_slug = get_query_var(DATEBOOK_PROFILES_TAX);

	$tax_array = array(
		array (
			'taxonomy' => DATEBOOK_PROFILES_TAX,
			'field' => 'slug',
			'terms' => $get_term_slug,
		)
	);

	$term_active = '';

} else {

	$term_active = ' active';

}

$display_only_profiles_with_images_on_search = $display_only_profiles_with_images_on_search == 1 ? array( 'key' => 'profile_photo_id', 'value' => '', 'compare' => '!=' ) : '';


// Top profiles
$topad_args = array(
	'post_type' => DATEBOOK_POST_TYPE,
	'post_status' => 'publish',
	'posts_per_page' => $posts_per_page_main,
	'orderby' => 'modified',
	'order' => 'DESC',
	'paged' => $paged,
	'post__in' => $r,
	'meta_query' => array(
		array('key' => 'topad', 'value' => '1', 'compare' => '=' )
	)
	,
	'tax_query' => $tax_array
);

$topad = new WP_Query( $topad_args );

// Count Top profiles
$topad_args = array(
	'post_type' => DATEBOOK_POST_TYPE,
	'post_status' => 'publish',
	'posts_per_page' => $posts_per_page_main,
	'orderby' => 'modified',
	'order' => 'DESC',
	'post__in' => $r,
	'meta_query' => array(
		array('key' => 'topad', 'value' => '1', 'compare' => '=' )
	),
	'tax_query' => $tax_array
);

$topad_count = new WP_Query( $topad_args );

if ($paged == $topad->max_num_pages) {
	$normal_offset = 0;
	$posts_per_page = $posts_per_page_main - count($topad->posts);
} else if ($paged > $topad->max_num_pages) {
	$normal_offset = $posts_per_page_main * ($paged-1) - $topad_count->found_posts;
	$posts_per_page = $posts_per_page_main;
} else {
	$normal_offset = 0;
	$posts_per_page = $posts_per_page_main - $topad->found_posts;
}


// Normal profiles
$normal_args = array(
	'post_type' => DATEBOOK_POST_TYPE,
	'post_status' => 'publish',
	'posts_per_page' => $posts_per_page,
	'orderby' => 'modified',
	'order' => 'DESC',
	'paged' => $paged,
	'offset' => $normal_offset,
	'post__in' => $r,
	'meta_query' => array(
		'relation' => 'AND',
		array(
			'relation' => 'OR',
			array( 'key' => 'topad', 'value' => '', 'compare' => 'NOT EXISTS' ),
			array( 'key' => 'topad', 'value' => '0', 'compare' => '=' )
		),
		$display_only_profiles_with_images_on_search
	),
	'tax_query' => $tax_array
);

$normal = new WP_Query( $normal_args );


$all = $topad;

if (count($topad->posts) < $posts_per_page_main) {
	if ($paged > $topad->max_num_pages) {
		$q = $normal->posts;
	} else {
		$q = array_merge($topad->posts, $normal->posts);
	}						
	$all->post_count = count($q);
	$all->posts = $q;
}

$number_of_posts = $topad_count->found_posts + $normal->found_posts;

$total = ceil($number_of_posts / $posts_per_page_main);

if ( $all->have_posts() ) {
	
	if($show_no_found_message == 1){
		
		if(of_get_option('if_search_results_empty') == 1 || of_get_option('if_search_results_empty') == 2){

			// display message No Profiles found
			include DateBook_Template_Loader::locate( 'search/no-profiles' );

		}

	} else if(of_get_option('display_number_of_profiles') == 1){

			?>

			<div class="datebook-custom-card card mb-3">
				<div class="card-body"> 

					<?php echo esc_html__( 'Number of found profiles', 'datebook' ) . ': ' . $number_of_posts; ?> 

				</div>
			</div>

	<?php } ?>

	<?php if($number_of_posts > 0 || of_get_option('if_search_results_empty') == 1 || of_get_option('if_search_results_empty') == 3){ ?>

	<div class="col-sm-12 col-md-12 col-lg-12 datebook-padding-less datebook-search-profiles">
		<div class="row">

			<?php

			// display Profiles
			include DateBook_Template_Loader::locate( 'search/content-profile' );

			?>

		</div>
	</div>
	
	<?php } ?>

	<?php

	if ($number_of_posts > $posts_per_page) {

		DateBook_Utilities::datebook_search_pagination($total, $paged, $search_query_link_array);

	}

} else {

	// display message No Profiles found
	echo DateBook_Template_Loader::load( 'search/no-profiles' );

}

wp_reset_postdata();