<?php
/**
 * The default template for displaying Tours on Tour page
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }


$tour_id = absint(get_the_ID());

$profile_id = get_post_meta($tour_id, 'profile_tour_id', true);
$profile_data = get_post($profile_id);

if (isset($profile_data->ID) && $profile_data->ID > 0 && isset($profile_data->post_status) && $profile_data->post_status == 'publish') {
	
	// Check if Retina enabled in Theme Options
	$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

	$city_id = get_post_meta($tour_id, 'city', true);

	if(isset($city_id)){

		$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
		$country = isset($term_data->country) ? $term_data->country : '';
		$city = isset($term_data->city) ? $term_data->city : '';

	}

	$tour_title = get_the_title();
	$tour_description = get_the_content();


	$profile_title = $profile_data->post_title;

	$get_profile_data = get_post_meta($profile_data->ID, 'profile_personal_data', true);
	$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

	$age = isset($datebook_get_data['birthday']) && !empty($datebook_get_data['birthday']) ? floor((time() - strtotime($datebook_get_data['birthday']))/31556926) : '';
	$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;
	
	if ($gender == 1) {
		$gender_icon = 'fa fa-venus';
	} else if ($gender == 2) {
		$gender_icon = 'fa fa-mars';
	} else {
		$gender_icon = 'fa fa-user';
	}

	$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_avatar', $gender, true);

	?>

<hr />

<div class="datebook-tours-body">

	<div class="row">
		<div class="col-lg-5 col-md-5 col-sm-5">

			<a class="float-left mr-3" href="<?php echo esc_url(get_permalink($profile_id)); ?>" title="<?php echo esc_attr($profile_title); ?>"><img class="thumbnail" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>

				<h6 class="mt-0 mb-1 datebook-ellipsis">
					<a href="<?php echo esc_url(get_permalink($profile_id)); ?>" title="<?php echo esc_attr($profile_title); ?>"><?php echo esc_html($profile_title); ?></a><?php if(!empty($age)){ ?>, <span title="<?php echo esc_attr($age) . ' ' . esc_html__( 'years old', 'datebook' ); ?>"><?php echo esc_attr($age); ?></span><?php } ?>
					<?php if(isset($datebook_gender_titles[$gender])){ ?>
					<span title="<?php echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span>
					<?php } ?>
				</h6>

				<div class="datebook-profile-text">

					<p class="small mb-1">

						<?php esc_html_e( 'is going to', 'datebook' ); ?>

						<?php 
						
						if (isset($city)) {
							echo  esc_attr($city);
						}
						if (!empty($city) && !empty($country)) {
							echo ", ";
						}
						if (isset($country)) {
							echo esc_attr($country);
						}

						?>

						<br />

						<?php esc_html_e( 'on', 'datebook' ); ?>

						<?php echo date("d M Y", get_post_meta($tour_id,'start', true)); ?> &#8212; <?php echo date("d M Y", get_post_meta($tour_id,'end', true)); ?> </p>

				</div>

		</div>

		<?php if ($tour_description != '') { ?>

		<div class="col-lg-7 col-md-7 col-sm-7">
			<div class="datebook-tour-content col-lg-12 col-md-12 col-sm-12">
			
				<div id="datebook-tour-collaspe-more">
					<h5><a href="<?php the_permalink() ?>" title="<?php echo esc_attr($tour_title); ?>"><?php echo esc_attr($tour_title); ?></a></h5>
					<p class="collapse font-italic mb-2" id="collapseTourmore<?php echo esc_attr($tour_id); ?>"><?php echo esc_html($tour_description); ?></p>
					<a class="small datebook-button-more" data-toggle="collapse" href="#collapseTourmore<?php echo esc_attr($tour_id); ?>" aria-expanded="false" aria-controls="<?php echo esc_attr($tour_id); ?>">+<?php echo esc_html__( 'read more', 'datebook' ); ?></a>
				</div>
				

			</div>
		</div>

		<?php } ?>

	</div>
</div>

<?php

}

unset($profile_id);