<?php
/**
 * The default template for displaying content as "Quote". Used in page-blog.php.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.0
 * @version 1.0
 */
?>

<!-- Begin Article -->
<div id="datebook-post-<?php the_ID(); ?>" <?php post_class('datebook-custom-card card mb-3 datebook-article-quote'); ?>>
	<div class="card-body">

		<?php
		
		$get_content = str_replace('<blockquote', '<blockquote class="blockquote"', get_the_content());
		$get_content = str_replace('<cite>', '<footer class="blockquote-footer"><cite>', $get_content);
		$get_content = str_replace('</cite>', '</cite></footer>', $get_content);

		if(strlen($get_content) > 0 && $get_content != '&nbsp;'){

			$content = wp_specialchars_decode(esc_html($get_content), ENT_QUOTES);
			echo do_shortcode(wpautop($content));

		}

		?>

	</div>
	<!--end article-content--> 

</div>
<!-- End  Article -->

<?php edit_post_link( esc_html__( 'Edit this post', 'datebook' ), '<div class="datebook-custom-card card mb-3 datebook-blogs-page"><div class="card-body">', '</div></div>', 0, 'btn btn-secondary btn-sm edit-link' );