<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit;

?>


<div class="datebook-custom-card card tooltip-demo">
	<div class="card-body">
	
		<h2><?php esc_html_e( 'Cart', 'datebook' ); ?></h2>
        
		<?php
        
        /**
		 * My Account navigation.
		 *
		 * @since 2.6.0
		 */

		do_action( 'woocommerce_account_navigation' ); 

		?>


		<div class="card border-0 datebook-transparent">
        
			<?php

			/*
			 * @hooked wc_empty_cart_message - 10
			 */
			do_action( 'woocommerce_cart_is_empty' );

			?>

		</div>
	</div>
</div>