( function ( $ ) {
	
	"use strict";

    $( document ).ready( function () {
		
		// initialize color picker
		$( '.datebook_cookies_color' ).wpColorPicker();

		// refuse option
		$( '#datebook_cookies_refuse_opt' ).change( function () {
			if ( $( this ).is( ':checked' ) ) {
				$( '#datebook_cookies_refuse_opt_container' ).slideDown( 'fast' );
			} else {
				$( '#datebook_cookies_refuse_opt_container' ).slideUp( 'fast' );
			}
		} );
		
		// privacy policy option
		$( '#datebook_cookies_see_more' ).change( function () {
			if ( $( this ).is( ':checked' ) ) {
				$( '#datebook_cookies_see_more_opt' ).slideDown( 'fast' );
			} else {
				$( '#datebook_cookies_see_more_opt' ).slideUp( 'fast' );
			}
		} );

		// privacy policy option
		$( '#datebook_cookies_on_scroll' ).change( function () {
			if ( $( this ).is( ':checked' ) ) {
				$( '#datebook_cookies_on_scroll_offset' ).slideDown( 'fast' );
			} else {
				$( '#datebook_cookies_on_scroll_offset' ).slideUp( 'fast' );
			}
		} );

		// privacy policy link
		$( '#datebook_cookies_see_more_link-custom, #datebook_cookies_see_more_link-page' ).change( function () {
			if ( $( '#datebook_cookies_see_more_link-custom:checked' ).val() === 'custom' ) {
				$( '#datebook_cookies_see_more_opt_page' ).slideUp( 'fast', function () {
					$( '#datebook_cookies_see_more_opt_link' ).slideDown( 'fast' );
				} );
			} else if ( $( '#datebook_cookies_see_more_link-page:checked' ).val() === 'page' ) {
				$( '#datebook_cookies_see_more_opt_link' ).slideUp( 'fast', function () {
					$( '#datebook_cookies_see_more_opt_page' ).slideDown( 'fast' );
				} );
			}
		} );
		
		$( '#datebook_cookies_refuse_code_fields' ).find( 'a' ).click( function ( e ) {
			e.preventDefault();

			$( '#datebook_cookies_refuse_code_fields' ).find( 'a' ).removeClass( 'nav-tab-active' );
			$( '.refuse-code-tab' ).removeClass( 'active' );

			var id = $( this ).attr( 'id' ).replace( '-tab', '' );

			$( '#' + id ).addClass( 'active' );
			$( this ).addClass( 'nav-tab-active' );
		} );
    } );

	$( document ).on( 'click', 'input#reset_cookie_notice_options', function () {
		return confirm( DateBookCookiesArgs.resetToDefaults );
	} );

} )( jQuery );