<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DateBook_Matching
 *
 * @class DateBook_Matching
 * @package DateBook/Classes
 * @author Pagick Themes
 */

class DateBook_Matching {


	private static $datebook_options = null;

    public function __construct($datebook_options_array) {

		self::$datebook_options = $datebook_options_array;

		self::init();

	}


	/**
	 * Hook actions and filters.
	 * 
	 * @since 4.5.9
	 * @access public
	 */
	public static function init() {

		add_action( 'datebook_profile_matching', array( __CLASS__, 'process_profile_matching' ) );

		add_shortcode( 'datebook_profile_matching', array( __CLASS__, 'pre_process_matching' ) );

	}


	/**
	 * Find matched fields
	 *
	 */
	public static function find_matched_fields($value, $profile_edit_form_data, $custom_field_title) {

		if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
			exit();
		}

		$show_fields = $show_field_layout = array();

		if(is_array($value) && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)){

			$get_user_filled_fields = array();

			if (isset($profile_edit_form_data[$value['slug']])) {
				$get_user_filled_fields = $profile_edit_form_data[$value['slug']];
			}


			if((is_array($get_user_filled_fields) && count($get_user_filled_fields) > 0) || (is_numeric($get_user_filled_fields) && $get_user_filled_fields > 0) || (is_string($get_user_filled_fields) && strlen($get_user_filled_fields) > 0)) {

				// if foreign language do not exist, then show title in English (en_US)
				$value_field_items = isset($value['field_items_' . DATEBOOK_WPLANG]) ? $value['field_items_' . DATEBOOK_WPLANG] : $value['field_items_en_US'];

				$new_value = array();
				if(is_array($value_field_items)){

					$value['field_items'] = $value_field_items;
					
					$add_key = 0;

				} else {

					$value['field_items'] = explode('<br />', strtr($value_field_items, array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

					$add_key = 1;

				}
				
				switch($value['type']){

					case 'text':

						if(!empty($profile_edit_form_data[$value['slug']])) {

							$show_field_layout = $profile_edit_form_data[$value['slug']];

						}

					break;

					case 'textarea' : 
				
						if(!empty($profile_edit_form_data[$value['slug']])) {

							$show_field_layout = wpautop(esc_textarea($profile_edit_form_data[$value['slug']]));

						}

					break;

					case 'select':

						if(isset($profile_edit_form_data[$value['slug']]) && $profile_edit_form_data[$value['slug']] > 0 && isset($value['field_items']) && is_array($value['field_items']) && !empty($value['field_items']) && isset($get_user_filled_fields) && !empty($get_user_filled_fields)) {

							foreach ($value['field_items'] as $key => $val) {
							
								$key = $key + $add_key;

								if(isset($get_user_filled_fields)){
									if( $get_user_filled_fields == $key ) {
										$show_fields[] = $key;
									}
								}
						
							}

							if(isset($show_fields) && !empty($show_fields)) {

								$show_field_layout = $show_fields;

							}
						}

					break;

					case 'checkbox':
					
						$show_fields = array();

						if(isset($profile_edit_form_data[$value['slug']]) && count($profile_edit_form_data[$value['slug']]) > 0 && isset($value['field_items']) && is_array($value['field_items']) && !empty($value['field_items']) && isset($get_user_filled_fields) && is_array($get_user_filled_fields) && !empty($get_user_filled_fields)) {

							foreach ($value['field_items'] as $key => $val) {

								$key = $key + $add_key;

								if( in_array($key, $get_user_filled_fields) ) {

									$show_fields[] = $key;

								}

							}

							if(isset($show_fields) && !empty($show_fields)) {

								$show_field_layout = $show_fields;

							}
						}

					break;

					case 'radio':

						if(isset($profile_edit_form_data[$value['slug']]) && $profile_edit_form_data[$value['slug']] > 0 && isset($value['field_items']) && is_array($value['field_items']) && !empty($value['field_items']) && isset($get_user_filled_fields) && !empty($get_user_filled_fields)) {
						
							foreach ($value['field_items'] as $key => $val) {
							
								$key = $key + $add_key;

								if(isset($get_user_filled_fields)){

									if( $get_user_filled_fields == $key ) {

										$show_fields[] = $key;

									}
								}
							}

							if(isset($show_fields) && !empty($show_fields)) {

								$show_field_layout = $show_fields;

							}
						}

					break;

				} // end switch

			}

		}

		return $show_field_layout;

	}


	/**
	 * Return matching table
	 *
	 * @access public
	 * @return void
	 */
	public static function pre_process_matching($atts = array()) {

		if(isset(self::$datebook_options['protect']['check_day']) && self::$datebook_options['protect']['check_day'][0].self::$datebook_options['protect']['check_day'][1] != DateBook_Utilities::get_current_day() && isset(self::$datebook_options['protect']['encrypted_day']) && self::$datebook_options['protect']['encrypted_day'] != DateBook_Utilities::get_encrypt_current_day() && isset(self::$datebook_options['protect']['open_day']) && self::$datebook_options['protect']['open_day'] != DateBook_Utilities::get_current_day()) {
			exit();
		}

		if (is_user_logged_in() && in_array(DATEBOOK_PURCHASE_CODE, DATEBOOK_ENCRYPTED_CODE)) {
			
			//Get profile form array
			$get_profile_form_fields = get_option('datebook_profile_form');
			$get_profile_form_fields = isset($get_profile_form_fields['profile_form']) ? $get_profile_form_fields['profile_form'] : ($get_profile_form_fields ? $get_profile_form_fields : array());

			if(is_array($get_profile_form_fields)){
				
				global $wp_locale_all, $datebook_field_titles, $datebook_reserved_fields, $datebook_sexualorientation_titles;
				
				set_query_var( 'datebook_field_titles', $datebook_field_titles );
				$datebook_field_titles = get_query_var( 'datebook_field_titles' );
				if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

				
				// Get profile ID of currecnt user
				$current_user_id = $atts['options']['current_user_id'];
				$profile_id_of_current_user = get_user_meta( $current_user_id, 'profile_postid', true );

				// Get Profile personal data of current user
				$get_profile_data = get_post_meta($profile_id_of_current_user, 'profile_personal_data', true);
				$viewing_profile = !empty($get_profile_data) ? $get_profile_data : array();

				// display countries
				$is_shortcode = (!empty($atts) && is_array($atts) ? 1 : isset($atts['shortcode']) && $atts['shortcode'] == 1) ? 0 : 1;

				// get languages
				$languages_array = array();

				$languages_array['en_US'] = esc_html__( 'English', 'datebook' );

				$languages = DateBook_Localization::datebook_all_available_language_files();

				foreach($languages as $language) {
					if($language['checked'] == 1){
						$languages_array[$language['locale']] = $wp_locale_all[$language['locale']];
					}
				}

				// Get custom fields
				$all_custom_fields = get_option('datebook_profile_custom_fields') ? get_option('datebook_profile_custom_fields') : array();

				$datebook_profiletypes = array();
				$profiletypes_array = get_terms(array('orderby' => 'term_id', 'order' => 'ASC','taxonomy' => DATEBOOK_PROFILES_TAX, 'hide_empty' => false));
				foreach ($profiletypes_array as $key => $value ){
					$datebook_profiletypes[] = isset($value->name) ? $value->name : '';
				}
				$profiletypes = implode("\r\n", $datebook_profiletypes);
				
				foreach ($all_custom_fields as $key => $value) {
					if(isset($datebook_reserved_fields[$key])){
						//unset($all_custom_fields[$key]);
						$datebook_reserved_fields[$key] = array(
							'slug' => $key, 
							'type' => $datebook_reserved_fields[$key]['type'], 
							'searchable' => isset($value['searchable']) && $value['searchable'] > 0 ? 1 : 0, 
							'required' => isset($value['required']) && $value['required'] > 0 ? 1 : 0, 
							'visible_to_admin_only' => isset($value['visible_to_admin_only']) && $value['visible_to_admin_only'] > 0 ? 1 : 0, 
							'active' => isset($value['active']) && $value['active'] > 0 ? 1 : 0, 
							'limittext' => $value['limittext']
						);

						foreach ( $languages_array as $language_key => $language_name ) {

							if (isset($value['name_' . $language_key])) {
								$datebook_reserved_fields[$key]['name_' . $language_key] =  $value['name_' . $language_key];
							}
							if (isset($value['field_items_' . $language_key])) {
								if($key == 'profiletypereserved'){
									$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $profiletypes;
								} else {
									$datebook_reserved_fields[$key]['field_items_' . $language_key] =  $value['field_items_' . $language_key];
								}
							}
						}
					}
				}

				// Merge custom and reserved fields
				$get_profile_custom_fields = array_merge($all_custom_fields, $datebook_reserved_fields);

				//Get connected fields
				$connected_fields_array = get_option('datebook_matching');
				$connected_fields = isset($connected_fields_array['datebook_matching_connected']) ? $connected_fields_array['datebook_matching_connected'] : '';

				// Get data of viewed profile
				$viewed_profile = $atts['options']['datebook_get_data'];

				$count_total_percent = $count_field_matched = $can_count_total = 0;

				foreach ($get_profile_custom_fields as $key_slug => $value) {

					if (isset($value['active']) && $value['active'] != 1) continue;
					if (isset($value['type']) && $value['type'] == 'title') continue;

					// if foreign language do not exist, then show title in English
					//$value['name'] = isset($value['name_' . DATEBOOK_WPLANG]) && !empty($value['name_' . DATEBOOK_WPLANG]) ? $value['name_' . DATEBOOK_WPLANG] : $value['name_en_US'];

					//echo '<label>' . esc_attr($value['name']) . '</label> ';

					// Render field
					// if foreign language do not exist, then show title in English
					/*$value['field_items'] = isset($value['field_items_' . DATEBOOK_WPLANG]) ? $value['field_items_' . DATEBOOK_WPLANG] : $value['field_items_en_US'];

					if(!empty($value['field_items'])){
						$value['field_items'] = explode('<br />', strtr($value['field_items'], array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

						foreach ($value['field_items'] as $key => $val) {

							echo '<option value="' . esc_attr($key) . '">' . ucfirst(esc_attr($val)) . '</option>';

						}

					}*/

					$custom_field_data = $get_profile_custom_fields[$key_slug];
					
					if(isset($connected_fields['datebook_matching_field_connecting']['from'][$key_slug]) && !empty($connected_fields['datebook_matching_field_connecting']['from'][$key_slug]) && isset($connected_fields['datebook_matching_field_connecting']['to'][$key_slug]) && !empty($connected_fields['datebook_matching_field_connecting']['to'][$key_slug]) && (isset($viewing_profile['edit_form'][$key_slug]) && !empty($viewing_profile['edit_form'][$key_slug]) || isset($viewing_profile[$key_slug]) && !empty($viewing_profile[$key_slug]))){

						// Start displaying fields
						if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'profiletypereserved'){

							// Render field
							$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');

							if(isset($find_current_user_field) && !empty($find_current_user_field)){

								$count_total_percent += 1;

								$viewing_profile_term_id = isset($viewing_profile['profiletypereserved']) && $viewing_profile['profiletypereserved'] > 0 ? $viewing_profile['profiletypereserved'] : '';

								$term_id = isset($viewed_profile['profiletypereserved']) && $viewed_profile['profiletypereserved'] > 0 ? $viewed_profile['profiletypereserved'] : '';

								// Get Profile types
								$categories = get_terms(array(
									'taxonomy' => DATEBOOK_PROFILES_TAX
								));

								if(!empty($categories)){

									// Get categories as array
									foreach ( $categories as $category ) :

										if($category->term_id == $term_id && $category->term_id == $viewing_profile_term_id){
											$count_field_matched += 1;
										}

									endforeach;

								}
							}

						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'profilename'){
						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'countrycity'){

							$current_user_country_id = isset($viewing_profile['country_id']) && $viewing_profile['country_id'] > 0 ? $viewing_profile['country_id'] : '';
							$current_user_region_id = isset($viewing_profile['region_id']) && $viewing_profile['region_id'] > 0 ? $viewing_profile['region_id'] : '';
							$current_user_city_id = isset($viewing_profile['city_id']) && $viewing_profile['city_id'] > 0 ? $viewing_profile['city_id'] : '';
							
							if($current_user_city_id > 0){
								
								$count_total_percent += 1;
							
								if(isset($viewed_profile[$key_slug]) && $viewed_profile[$key_slug] == $current_user_city_id){
									$count_field_matched += 1;
								}
							}

						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'birthdate'){

							// Render field
							$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');

							if(isset($find_current_user_field) && !empty($find_current_user_field)){

								$count_total_percent += 1;

								if (isset($viewed_profile['dateday']) && $viewed_profile['dateday'] > 0 && isset($viewed_profile['datemonth']) && $viewed_profile['datemonth'] > 0 && isset($viewed_profile['dateyear']) && $viewed_profile['dateyear'] > 0) {

								$age = isset($viewed_profile['birthday']) && !empty($viewed_profile['birthday']) ? floor((time() - strtotime($viewed_profile['birthday']))/31556926) : (isset($viewed_profile['dateyear']) && isset($viewed_profile['datemonth']) && isset($viewed_profile['dateday']) ? floor((time() - strtotime($viewed_profile['dateyear'] . '-' . $viewed_profile['datemonth'] . '-' . $viewed_profile['dateday']))/31556926) : '');

								if (isset($age) && $age > 0) {

										// if foreign language do not exist, then show title in English (en_US)
										$value_field_items = isset($get_profile_custom_fields[$key_slug]['field_items_' . DATEBOOK_WPLANG]) ? $get_profile_custom_fields[$key_slug]['field_items_' . DATEBOOK_WPLANG] : $get_profile_custom_fields[$key_slug]['field_items_en_US'];
										$value_field_items = explode('<br />', strtr($value_field_items, array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

										foreach ($value_field_items as $key => $val) {
											$key = $key + 1;
											if( in_array($key, $find_current_user_field) ) {
												// Test if string contains the word 
												if(strpos($val, '-') !== false){
													$age_range = explode('-', $val);
													if (in_array($age, range($age_range[0],$age_range[1])) ) {
														$count_field_matched += 1;
													}
												} else{
													if ($val == $age) {
														$count_field_matched += 1;
													}
												}
											}
										}
									}
								}
							}

						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'gender'){

							global $datebook_gender_titles;
							
							$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');

							if(count($find_current_user_field) > 0){

								$count_total_percent += 1;

								$gender = isset($viewed_profile['gender']) && $viewed_profile['gender'] > 0 ? $viewed_profile['gender'] : 0;

								if ($gender > 0) {

									foreach ($datebook_gender_titles as $key => $value) {

										if ($gender == $key && ((is_array($find_current_user_field) && in_array($key, $find_current_user_field) && in_array($gender, $find_current_user_field)) || (is_numeric($find_current_user_field) && $find_current_user_field == $key && $find_current_user_field == $gender))) {
											$count_field_matched += 1;
										}
									}
								}
							}

						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'sexualorientation'){

							if (isset(self::$datebook_options['sexual_orientation_allowed']) && self::$datebook_options['sexual_orientation_allowed'] != '' || isset(self::$datebook_options['sexual_orientation_allowed_other_' . DATEBOOK_WPLANG]) && self::$datebook_options['sexual_orientation_allowed_other_' . DATEBOOK_WPLANG] != '') {

								$allowed_sexual_orientation = isset(self::$datebook_options['sexual_orientation_allowed']) ? self::$datebook_options['sexual_orientation_allowed'] : '';

								// Add custom Sexual Orientations
								if (isset(self::$datebook_options['sexual_orientation_allowed_other_' . DATEBOOK_WPLANG]) && self::$datebook_options['sexual_orientation_allowed_other_' . DATEBOOK_WPLANG] != '') {
									$sexual_orientation_allowed_other_array = explode('<br />', strtr(self::$datebook_options['sexual_orientation_allowed_other_' . DATEBOOK_WPLANG], array('\r\n' => '<br />', '\r' => '<br />', '\n' => '<br />')));

									foreach ($sexual_orientation_allowed_other_array as $key => $value ){
										$allowed_sexual_orientation[] = 1;
									}
								}

								$sexualorientation = isset($viewed_profile['sexualorientation']) && $viewed_profile['sexualorientation'] > 0 ? $viewed_profile['sexualorientation'] : 0;

								if ($sexualorientation > 0) {

									$count_total_percent += 1;

									$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');

									foreach ($datebook_sexualorientation_titles as $key => $value) {

										if(isset($allowed_sexual_orientation[$key]) && $allowed_sexual_orientation[$key] == 1){

											if ($sexualorientation == $key && ((is_array($find_current_user_field) && in_array($key, $find_current_user_field) && in_array($sexualorientation, $find_current_user_field)) || (is_numeric($find_current_user_field) && $find_current_user_field == $key && $find_current_user_field == $sexualorientation))) {
												$count_field_matched += 1;
											}
										}
									}
								}
							}

						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'phone'){
							$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');
							$find_current_user_field = is_array($find_current_user_field) ? $find_current_user_field : wp_strip_all_tags($find_current_user_field);
							$phone = isset($viewed_profile['phone']) && !empty($viewed_profile['phone']) ? $viewed_profile['phone'] : '';

							if (isset($phone) && !empty($phone)) {

								$count_total_percent += 1;

								if ($find_current_user_field == $phone || (is_array($find_current_user_field) && in_array($phone, $find_current_user_field))) {
									$count_field_matched += 1;
								}
							}

						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'website'){

							$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');
							$find_current_user_field = is_array($find_current_user_field) ? $find_current_user_field : wp_strip_all_tags($find_current_user_field);
							$website = isset($viewed_profile['website']) && !empty($viewed_profile['website']) ? $viewed_profile['website'] : '';
							if (isset($website) && !empty($website)) {

								$count_total_percent += 1;

								if ($find_current_user_field == $website || (is_array($find_current_user_field) && in_array($website, $find_current_user_field))) {
									$count_field_matched += 1;
								}
							}

						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'email'){
						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'user'){
						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'newpass'){
						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'aboutyou'){
							if (isset($profile->post_content)){
								$datebook_get_aboutyou = stripslashes($profile->post_content);
							} else if (!empty($viewed_profile['aboutyou']) && strlen($viewed_profile['aboutyou']) > 0){
								$datebook_get_aboutyou = stripslashes($viewed_profile['aboutyou']);
							} else {
								$datebook_get_aboutyou = '';
							}
						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'onlinestatus'){
						} else if($connected_fields['datebook_matching_field_connecting']['to'][$key_slug] == 'searchbyname'){
						} else if(isset($datebook_reserved_fields[$connected_fields['datebook_matching_field_connecting']['to'][$key_slug]]['slug']) && $datebook_reserved_fields[$connected_fields['datebook_matching_field_connecting']['to'][$key_slug]]['slug'] == $connected_fields['datebook_matching_field_connecting']['to'][$key_slug]){
						} else {

							// Render field
							if(isset($viewing_profile['edit_form'][$key_slug]) && !empty($viewing_profile['edit_form'][$key_slug])){

								$count_total_percent += 1;

								if(is_array($viewing_profile['edit_form'][$key_slug]) && isset($viewed_profile['edit_form'][$key_slug]) && !empty($viewed_profile['edit_form'][$key_slug]) && is_array($viewed_profile['edit_form'][$key_slug])){

									// Render field
									$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');
									// Render field
									$find_viewed_profile_field = self::find_matched_fields($custom_field_data, $viewed_profile['edit_form'], '');
									
									$result = array_intersect($find_current_user_field,$find_viewed_profile_field);
									if($result) {
										$count_field_matched += 1;
									}

								} else {

									if(isset($viewed_profile['edit_form'][$key_slug]) && !empty($viewed_profile['edit_form'][$key_slug]) && $viewing_profile['edit_form'][$key_slug] == $viewed_profile['edit_form'][$key_slug]){
										$count_field_matched += 1;
									}
								}
							}
						}

						//$count_total_percent += $can_count_total > 0 ? 1 : 0;

					}
				}
				
				$get_day_from_code = DATEBOOK_PURCHASE_CODE;
				$get_day_from_code = $get_day_from_code[0] . $get_day_from_code[1];

				if($get_day_from_code != DateBook_Utilities::get_current_day()){
					exit();
				}
					
				///////////////////////////////////////////////////

				/*foreach($get_profile_form_fields as $key => $value){

				if(isset($value['name']) && $value['name'] == 'row') {

					$key = 0;

					foreach ( $value['children'] as $key => $columns ) {

						if(isset($columns['name']) && $columns['name'] == 'column'){

							if(isset($columns['children'])){

								$count_total_percent = $count_field_viewed = $count_field_current_user = $count_field_matched = 0;

								foreach ( $columns['children'] as $key => $column ) {
									
									if(isset($get_profile_custom_fields[$column['slug']]) && isset($get_profile_custom_fields[$column['slug']]['active']) && $get_profile_custom_fields[$column['slug']]['active'] == 1) {

										$custom_field_data = $get_profile_custom_fields[$column['slug']];
										
										//echo  '<br>(' . $column['slug'] . ') = ' . $connected_fields['datebook_matching_field_connecting']['from'][$column['slug']] . ' = ' . $connected_fields['datebook_matching_field_connecting']['to'][$column['slug']];

										if(isset($viewing_profile['edit_form'][$column['slug']]) && !empty($viewing_profile['edit_form'][$column['slug']])){
											
											
											
											if(isset($connected_fields['datebook_matching_field_connecting']['from']) && isset($connected_fields['datebook_matching_field_connecting']['from'][$column['slug']]) && isset($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']]) && !empty($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']])){

												

												// Start displaying fields
												if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'profiletypereserved'){

													$term_id = isset($viewed_profile['profiletypereserved']) && $viewed_profile['profiletypereserved'] > 0 ? $viewed_profile['profiletypereserved'] : '';

													// Get Profile types
													$categories = get_terms(array(
														'taxonomy' => DATEBOOK_PROFILES_TAX
													));

													if(!empty($categories)){

														// Get categories as array
														foreach ( $categories as $category ) :

															if($category->term_id == $term_id){
																$count_field_matched += 1;
															}

														endforeach;

													}

												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'profilename'){
												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'countrycity'){

													$current_user_country_id = isset($viewing_profile['country_id']) && $viewing_profile['country_id'] > 0 ? $viewing_profile['country_id'] : '';
													$current_user_region_id = isset($viewing_profile['region_id']) && $viewing_profile['region_id'] > 0 ? $viewing_profile['region_id'] : '';
													$current_user_city_id = isset($viewing_profile['city_id']) && $viewing_profile['city_id'] > 0 ? $viewing_profile['city_id'] : '';

													if(isset($viewed_profile['edit_form'][$column['slug']]) && $viewed_profile['edit_form'][$column['slug']] == $current_user_city_id){
														$count_field_matched += 1;
													}

												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'birthdate'){

													if (isset($viewed_profile['dateday']) && $viewed_profile['dateday'] > 0 && isset($viewed_profile['datemonth']) && $viewed_profile['datemonth'] > 0 && isset($viewed_profile['dateyear']) && $viewed_profile['dateyear'] > 0) {

														$age = isset($viewed_profile['birthday']) && !empty($viewed_profile['birthday']) ? floor((time() - strtotime($viewed_profile['birthday']))/31556926) : (isset($viewed_profile['dateyear']) && isset($viewed_profile['datemonth']) && isset($viewed_profile['dateday']) ? floor((time() - strtotime($viewed_profile['dateyear'] . '-' . $viewed_profile['datemonth'] . '-' . $viewed_profile['dateday']))/31556926) : '');
														
														if (isset($age) && $age > 0) {

															// Render field
															$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');

															// if foreign language do not exist, then show title in English (en_US)
															$value_field_items = isset($get_profile_custom_fields[$column['slug']]['field_items_' . DATEBOOK_WPLANG]) ? $get_profile_custom_fields[$column['slug']]['field_items_' . DATEBOOK_WPLANG] : $get_profile_custom_fields[$column['slug']]['field_items_en_US'];
															$value_field_items = explode('<br />', strtr($value_field_items, array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

															foreach ($value_field_items as $key => $val) {
																$key = $key + 1;
																if( in_array($key, $find_current_user_field) ) {
																	// Test if string contains the word 
																	if(strpos($val, '-') !== false){
																		$age_range = explode('-', $val);
																		if (in_array($age, range($age_range[0],$age_range[1])) ) {
																			$count_field_matched += 1;
																		}
																	} else{
																		if ($val == $age) {
																			$count_field_matched += 1;
																		}
																	}
																}
															}
														}
													}

												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'gender'){

													global $datebook_gender_titles;

													$gender = isset($viewed_profile['gender']) && $viewed_profile['gender'] > 0 ? $viewed_profile['gender'] : 0;

													if ($gender > 0) {

														$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');

														foreach ($datebook_gender_titles as $key => $value) {

															if ($gender == $key && ((is_array($find_current_user_field) && in_array($key, $find_current_user_field) && in_array($gender, $find_current_user_field)) || (is_numeric($find_current_user_field) && $find_current_user_field == $key && $find_current_user_field == $gender))) {
																$count_field_matched += 1;
															}
														}
													}

												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'sexualorientation'){

													if (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '') {

														$allowed_sexual_orientation = of_get_option('sexual_orientation_allowed');

														// Add custom Sexual Orientations
														if (of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '') {
															$sexual_orientation_allowed_other_array = explode('<br />', strtr(of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG), array('\r\n' => '<br />', '\r' => '<br />', '\n' => '<br />')));

															foreach ($sexual_orientation_allowed_other_array as $key => $value ){
																$allowed_sexual_orientation[] = 1;
															}
														}

														$sexualorientation = isset($viewed_profile['sexualorientation']) && $viewed_profile['sexualorientation'] > 0 ? $viewed_profile['sexualorientation'] : 0;

														if ($sexualorientation > 0) {

															$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');

															foreach ($datebook_sexualorientation_titles as $key => $value) {

																if(isset($allowed_sexual_orientation[$key]) && $allowed_sexual_orientation[$key] == 1){

																	if ($sexualorientation == $key && ((is_array($find_current_user_field) && in_array($key, $find_current_user_field) && in_array($sexualorientation, $find_current_user_field)) || (is_numeric($find_current_user_field) && $find_current_user_field == $key && $find_current_user_field == $sexualorientation))) {
																		$count_field_matched += 1;
																	}
																}
															}
														}
													}

												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'phone'){
													$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');
													$find_current_user_field = is_array($find_current_user_field) ? $find_current_user_field : wp_strip_all_tags($find_current_user_field);
													$phone = isset($viewed_profile['phone']) && !empty($viewed_profile['phone']) ? $viewed_profile['phone'] : '';
													
													if ($find_current_user_field == $phone || (is_array($find_current_user_field) && in_array($phone, $find_current_user_field))) {
														$count_field_matched += 1;
													}

												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'website'){

													$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');
													$find_current_user_field = is_array($find_current_user_field) ? $find_current_user_field : wp_strip_all_tags($find_current_user_field);
													$website = isset($viewed_profile['website']) && !empty($viewed_profile['website']) ? $viewed_profile['website'] : '';
													
													if ($find_current_user_field == $website || (is_array($find_current_user_field) && in_array($website, $find_current_user_field))) {
														$count_field_matched += 1;
													}

												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'email'){

												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'user'){
												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'newpass'){
												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'aboutyou'){

													if (isset($profile->post_content)){
														$datebook_get_aboutyou = stripslashes($profile->post_content);
													} else if (!empty($viewed_profile['aboutyou']) && strlen($viewed_profile['aboutyou']) > 0){
														$datebook_get_aboutyou = stripslashes($viewed_profile['aboutyou']);
													} else {
														$datebook_get_aboutyou = '';
													}

												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'onlinestatus'){
												} else if($connected_fields['datebook_matching_field_connecting']['to'][$column['slug']] == 'searchbyname'){
												} else if(isset($datebook_reserved_fields[$connected_fields['datebook_matching_field_connecting']['to'][$column['slug']]]['slug']) && $datebook_reserved_fields[$connected_fields['datebook_matching_field_connecting']['to'][$column['slug']]]['slug'] == $connected_fields['datebook_matching_field_connecting']['to'][$column['slug']]){

												} else {

													// Render field
													if(isset($viewed_profile['edit_form'][$column['slug']]) && !empty($viewed_profile['edit_form'][$column['slug']])){

														if(is_array($viewing_profile['edit_form'][$column['slug']]) && is_array($viewed_profile['edit_form'][$column['slug']])){

															// Render field
															$find_current_user_field = self::find_matched_fields($custom_field_data, $viewing_profile['edit_form'], '');
															// Render field
															$find_viewed_profile_field = self::find_matched_fields($custom_field_data, $viewed_profile['edit_form'], '');

															$result = array_intersect($find_current_user_field,$find_viewed_profile_field);
															if($result) {
																$count_field_matched += 1;
															}

														} else {

															if(isset($viewing_profile['edit_form'][$column['slug']]) && !empty($viewing_profile['edit_form'][$column['slug']]) && isset($viewed_profile['edit_form'][$column['slug']]) && !empty($viewed_profile['edit_form'][$column['slug']]) && $viewing_profile['edit_form'][$column['slug']] == $viewed_profile['edit_form'][$column['slug']]){
																$count_field_matched += 1;
															}
														}
													}
												}

												$count_total_percent += 1;
												
											}
										}
									}
								}
							}
						}
					}
				}
			}*/

			$percent = $count_field_matched/$count_total_percent;
			$percent_friendly = number_format( $percent * 100, 0 ); // change 0 to # of decimals
			
			$options = array(
				'percent_friendly' => $percent_friendly,
				'display_matching_place' => $atts['options']['display_matching_place'],
				'split_progress_on_levels' => $atts['options']['split_progress_on_levels'],
				'matching_level_excellent' => $atts['options']['matching_level_excellent'],
				'matching_level_very_good' => $atts['options']['matching_level_very_good'],
				'matching_level_good' => $atts['options']['matching_level_good'],
				'matching_level_fair' => $atts['options']['matching_level_fair']
			);

			// display the Edit Profile form
			echo DateBook_Template_Loader::load( 'matching/profile-matching', $options );

			}
		}
	}


	/**
	 * Start process matching table on profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_matching($options) {

		$atts = array('shortcode' => 0, 'options' => $options);

		// display matching percent
		echo self::pre_process_matching($atts);

	}


	/**
	 * Show matching table on profile page
	 *
	 * @access public
	 * @return void
	 */
	public static function process_profile_matching($options) {

		echo self::process_matching($options);

	}


}

//DateBook_Matching::init();
$dateBook_matching_class = new DateBook_Matching($datebook_options_array);