<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Class that adds notices
 *
 * @return void
 */
class DateBook_Add_General_Notices{

    /**
     * Notification id
     *
     * @access public
     * @var string
     */
    public $notificationId = '';

    /**
     * Notification message
     *
     * @access public
     * @var string
     */
    public $notificationMessage = '';

    /**
     * Notification class
     *
     * @access public
     * @var string
     */
    public $notificationClass = '';

    /**
     * Start date
     *
     * @access public
     * @var string
     */
    public $startDate = '';

    /**
     * End date
     *
     * @access public
     * @var string
     */
    public $endDate = '';

    function __construct( $notificationId, $notificationMessage, $notificationClass = 'updated' , $startDate = '', $endDate = '' ){
        $this->notificationId = $notificationId;
        $this->notificationMessage = $notificationMessage;
        $this->notificationClass = $notificationClass;

        if( !empty( $startDate ) && time() < strtotime( $startDate ) )
            return;

        if( !empty( $endDate ) && time() > strtotime( $endDate ) )
            return;

        add_action( 'admin_notices', array( $this, 'add_admin_notice' ) );
        add_action( 'admin_init', array( $this, 'dismiss_notification' ) );
    }


    // Display a notice that can be dismissed
    function add_admin_notice() {
        global $current_user ;
        global $pagenow;

        $user_id = $current_user->ID;
        do_action( $this->notificationId.'_before_notification_displayed', $current_user, $pagenow );

        if ( current_user_can( 'manage_options' ) ){
            // Check that the user hasn't already clicked to ignore the message
            if ( ! get_user_meta($user_id, $this->notificationId.'_stop_notification' ) ) {
                echo apply_filters($this->notificationId.'_notification_message','<div class="'. $this->notificationClass .'" >'.$this->notificationMessage.'</div>', $this->notificationMessage);
            }
            do_action( $this->notificationId.'_notification_displayed', $current_user, $pagenow );
        }
        do_action( $this->notificationId.'_after_notification_displayed', $current_user, $pagenow );
    }

    function dismiss_notification() {
        global $current_user;

        $user_id = $current_user->ID;

        do_action( $this->notificationId.'_before_notification_dismissed', $current_user );
        
        // If user clicks to ignore the notice, add that to their user meta
        if ( isset( $_GET[$this->notificationId.'_stop_notification']) && '0' == $_GET[$this->notificationId.'_stop_notification'] )
            add_user_meta( $user_id, $this->notificationId.'_stop_notification', 'true', true );

        do_action( $this->notificationId.'_after_notification_dismissed', $current_user );
    }
}






class DateBook_Plugin_Notifications {

	/**
	 *
	 */
	public $notifications = array();

	/**
	 *
	 */
	private static $_instance = null;

	/**
	 *
	 */
	protected function __construct() {}


	/**
	 *
	 *
	 */
	public static function get_instance() {

		if( is_null( self::$_instance ) )
			self::$_instance = new DateBook_Plugin_Notifications();

		return self::$_instance;

	}


	/**
	 *
	 *
	 */
	public function add_notification( $notification_id = '', $notification_message = '', $notification_class = 'update-nag', $count_in_menu = true, $count_in_submenu = array() ) {

		if( empty( $notification_id ) )
			return;

		if( empty( $notification_message ) )
			return;

		global $current_user;

		if( get_user_meta( $current_user->ID, $notification_id . '_stop_notification' ) )
			return;

		$this->notifications[$notification_id] = array(
			'id' 	  		   => $notification_id,
			'message' 		   => $notification_message,
			'class'   		   => $notification_class,
			'count_in_menu'    => $count_in_menu,
			'count_in_submenu' => $count_in_submenu
		);


		if( $this->is_plugin_page() ) {
			new DateBook_Add_General_Notices( $notification_id, $notification_message, $notification_class );
		}

	}


	/**
	 *
	 *
	 */
	public function get_notifications() {

		return $this->notifications;

	}


	/**
	 *
	 *
	 */
	public function get_notification( $notification_id = '' ) {

		if( empty( $notification_id ) )
			return null;

		$notifications = $this->get_notifications();

		if( ! empty( $notifications[$notification_id] ) )
			return $notifications[$notification_id];
		else
			return null;

	}


	/**
	 *
	 *
	 */
	public function dismiss_notification( $notification_id = '' ) {

		global $current_user;

        add_user_meta( $current_user->ID, $notification_id . '_stop_notification', 'true', true );

	}


	/**
	 *
	 *
	 */
	public function get_count_in_menu() {

		$count = 0;

		foreach( $this->notifications as $notification ) {

			if( ! empty( $notification['count_in_menu'] ) )
				$count++;

		}

		return $count;

	}


	/**
	 *
	 *
	 */
	public function get_count_in_submenu( $submenu = '' ) {

		if( empty( $submenu ) )
			return 0;

		$count = 0;

		foreach( $this->notifications as $notification ) {

			if( empty( $notification['count_in_submenu'] ) )
				continue;

			if( ! is_array( $notification['count_in_submenu'] ) )
				continue;

			if( ! in_array( $submenu, $notification['count_in_submenu'] ) )
				continue;

			$count++;

		}

		return $count;

	}


	/**
	 *
	 *
	 */
	protected function is_plugin_page() {

		if( ! empty( $_GET['page'] ) && false !== strpos( $_GET['page'], 'datebook-' ) )
			return true;

		if( ! empty( $_GET['post_type'] ) && false !== strpos( $_GET['post_type'], 'datebook-' ) )
			return true;

		if( ! empty( $_GET['post'] ) && false !== strpos( get_post_type( (int)$_GET['post'] ), 'datebook-' ) )
			return true;

		return false;

	}

}





/**
 *
 *
 */
function datebook_dismiss_admin_notifications() {

	if( ! empty( $_GET['datebook_dismiss_admin_notification'] ) ) {

		$notifications = DateBook_Plugin_Notifications::get_instance();
		$notifications->dismiss_notification( sanitize_text_field( $_GET['datebook_dismiss_admin_notification'] ) );

	}

}
add_action( 'admin_init', 'datebook_dismiss_admin_notifications' );


/**
 *
 *
 */
function datebook_add_admin_menu_notification_counts() {

	global $menu, $submenu;

	$notifications = DateBook_Plugin_Notifications::get_instance();

	/**
	 *
	 *
	 */
	if( ! empty( $menu ) ) {

		foreach( $menu as $menu_position => $menu_data ) {
			
			if( ! empty( $menu_data[2] ) && $menu_data[2] == 'datebook-subscriptions' ) {

				$menu_count = $notifications->get_count_in_menu();

				if( ! empty( $menu_count ) )
					$menu[$menu_position][0] .= '<span class="update-plugins datebook-update-plugins"><span class="plugin-count">' . $menu_count . '</span></span>';

			}

		}

	}
	

	/**
	 *
	 *
	 */
	if( ! empty( $submenu['datebook-subscriptions'] ) ) {

		foreach( $submenu['datebook-subscriptions'] as $menu_position => $menu_data ) {

			$menu_count = $notifications->get_count_in_submenu( $menu_data[2] );

			if( ! empty( $menu_count ) )
				$submenu['datebook-subscriptions'][$menu_position][0] .= '<span class="update-plugins datebook-update-plugins"><span class="plugin-count">' . $menu_count . '</span></span>';

		}

	}

}
add_action( 'admin_init', 'datebook_add_admin_menu_notification_counts', 1000 );


/**
 *
 *
 */
function datebook_add_plugin_notification( $notification_id = '', $notification_message = '', $notification_class = 'update-nag', $count_in_menu = true, $count_in_submenu = array() ) {

	$notifications = DateBook_Plugin_Notifications::get_instance();
	$notifications->add_notification( $notification_id, $notification_message, $notification_class, $count_in_menu, $count_in_submenu );

}