<?php
/*
 * Administrator panel. Shown at the top on Single Profile page.
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if (is_single()) {
	
	// Get current user ID
	if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
		$current_user_id = DATEBOOK_CURRENT_USER_ID;
	} else {
		global $current_user;
		wp_get_current_user();
		$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
	}

	$datebook_field_titles = get_query_var( 'datebook_field_titles' );
	if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

	// If profile ID is not set in post_meta table then let's insert it
	$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

	$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
	$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

	$verified = isset($datebook_get_data['verified']) ? $datebook_get_data['verified'] : 0;

?>

<div class="accordion datebook-adminpanel" id="accordionDashboard">
	<div class="card bg-white mb-3 shadow-none border border-secondary tooltip-demo">
		<div class="card-header bg-white" id="headingThree">
			<button class="btn btn-secondary collapsed m-0 p-1 pl-2 pr-2 shadow-none" type="button" data-toggle="collapse" data-target="#DateBookCollapseAdmin" aria-expanded="false" aria-controls="DateBookCollapseAdmin">+ <?php esc_html_e( 'Administration Dashboard', 'datebook' ); ?></button>
		</div>
		<div id="DateBookCollapseAdmin" class="collapse" aria-labelledby="headingThree" data-parent="#accordionDashboard">
			<div class="card-body">
				<p class="card-text">

					<?php esc_html_e( 'Profile status', 'datebook' ); ?>: 

					<?php

					// If profile is private and needs to be manually activated by an admin
					$notactive = get_post_meta($profile_id, 'notactive', true);

					if ((get_post_status() == 'publish' && $notactive == 0) || get_post_status() == 'publish') {
						echo '<span class="badge badge-success">' . esc_html__( 'Active', 'datebook' ) . '</span>';
					} else if (get_post_status() == 'private' && $notactive == 0) {
						echo '<span class="badge badge-danger">' . esc_html__( 'Inactive', 'datebook' ) . '</span> ' . esc_html__( 'User can activate his profile by completing required data', 'datebook' );
					} else if (get_post_status() == 'private' && $notactive == 1) {
						echo '<span class="badge badge-danger">' . esc_html__( 'Suspended', 'datebook' ) . '</span> ' . esc_html__( 'User can not activate his profile', 'datebook' );
					} else {
						echo '<span class="badge badge-danger">' . esc_html__( 'Inactive', 'datebook' ) . '</span> ';
					}

					?>

				</p>

				<form action="<?php echo esc_url(get_permalink($profile_id)); ?>" method="post" class="form-horizontal">
					<input type="hidden" name="action" value="publish_profile" />
					<input type="hidden" name="current_user_id" value="<?php echo absint($current_user_id); ?>" />
					<input type="hidden" name="profile_id" value="<?php echo absint($profile_id); ?>" />
					
					<input type="checkbox" name="email_notification" value="1" checked /> <?php esc_html_e( 'Send an email notification to this user that his profile has been activated/suspended', 'datebook' ); ?><br>

					<button type="submit" name="approve" value="suspend" class="btn<?php if ($notactive == 0) { echo ' btn-danger'; } else { echo ' btn-primary'; } ?> m-0" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_html_e( 'Suspended profile becomes invisible all over the website, even if it has Top or Featured statuses. User cannot activate his profile. If you unsuspend the profile then a user can activate his profile.', 'datebook' ); ?>"><?php if ($notactive == 0) { echo esc_html__( 'Suspend', 'datebook' ); } else { echo esc_html__( 'Unsuspend', 'datebook' ); } ?></button>

					<button type="submit" name="approve" value="publish" class="btn<?php if (get_post_status() == 'publish') { echo ' btn-danger'; } else { echo ' btn-success'; } ?> m-0" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_html_e( 'You can activate or deactivate this profile even if a user did not complete required data. User can activate or deactivate his profile by completing required data.', 'datebook' ); ?>"><?php if (get_post_status() == 'publish') { echo esc_html__( 'Deactivate', 'datebook' ); } else { echo esc_html__( 'Activate', 'datebook' ); } ?></button>

					<button type="submit" name="verified" class="btn<?php if ($verified == "1") { echo " btn-danger"; } else { echo " btn-primary"; } ?> m-0" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_html_e( 'Verification is a sign placed next to Profile name. It can be given only by administrator.', 'datebook' ); ?>"><?php if ($verified == "1") { echo esc_html__( 'Remove Verified status', 'datebook' ); } else { echo esc_html__( 'Set as Verified', 'datebook' ); } ?></button>
					
					

				</form>

				<div class="datebook-clear10"></div>

				<form action="<?php echo esc_url(get_permalink(get_the_ID())); ?>" method="post">

					<input type="hidden" name="action" value="upgradeprofile" />
					<input type="hidden" name="profile_id" value="<?php echo absint($profile_id); ?>" />

					<div class="row">

						<div class="col-lg-6 col-md-6 col-sm-6 datebook-padding-less">
							<div class="card border bg-white shadow-none mb-1">
								<div class="card-body">

								<h5 class="card-title d-inline-block"><?php esc_html_e( 'Featured status', 'datebook' ); ?></h5>:

								<span class="ml-1">

									<?php 
									
									$featured_status = get_post_meta(get_the_ID(), 'featured', true);

									if ($featured_status == '1') {

										echo '<span class="badge badge-success shadow-none">' . esc_html__( 'Active', 'datebook' ) . '</span> ';

									} else {

										echo '<span class="badge badge-light shadow-none">' . esc_html__( 'Inactive', 'datebook' ) . '</span> ';

									}

									if ($featured_status == '1') {

										$featured_period_ends = get_post_meta($profile_id, 'featured_ends', true) ? date("d M Y", get_post_meta($profile_id, 'featured_ends', true)) : esc_html__( 'unlimited', 'datebook' );

										echo '<span class="small">' . esc_html__( 'till', 'datebook' ) . ' ' . $featured_period_ends . '</span>';
										echo '<button type="submit" name="delete_from_featured" class="btn btn-sm btn-danger p-1">' . esc_html__( 'Cancel', 'datebook' ) . '</button>';

									}

									?>
									
								</span>

								<div class="datebook-clear10"></div>
								
								<p class="card-text m-0"><?php esc_html_e( 'Activate Featured status till', 'datebook' ); ?>:</p>

								<div class="form-row align-items-center">

									<div class="col-7">
										<input type="text" class="form-control form-control-sm" id="featureddate" name="featuredends" value="" autocomplete="off" placeholder="d/m/Y" />
									</div>
									<div class="col-5">
										<button type="submit" name="submit" class="btn btn-sm btn-primary pl-2 pr-2"><?php esc_html_e( 'Activate', 'datebook' ); ?></button>
									</div>
								</div>

							</div>
						</div>
					</div>

					<div class="col-lg-6 col-md-6 col-sm-6 datebook-padding-less">
						<div class="card border bg-white shadow-none mb-1">
							<div class="card-body">

								<h5 class="card-title d-inline-block"><?php esc_html_e( 'Top status', 'datebook' ); ?></h5>:

								<span class="ml-1">

									<?php 

									$topad_status = get_post_meta(get_the_ID(), 'topad', true);

									if ($topad_status == '1') {

										echo '<span class="badge badge-success shadow-none">' . esc_html__( 'Active', 'datebook' ) . '</span> ';

									} else {

										echo '<span class="badge badge-light shadow-none">' . esc_html__( 'Inactive', 'datebook' ) . '</span> ';

									}

									if ($topad_status == '1') {

										$topad_period_ends = get_post_meta($profile_id, 'topad_ends', true) ? date("d M Y", get_post_meta($profile_id, 'topad_ends', true)) : esc_html__( 'unlimited', 'datebook' );

										echo '<span class="small">' . esc_html__( 'till', 'datebook' ) . ' ' . $topad_period_ends . '</span>';

										echo '<button type="submit" name="delete_from_topad" class="btn btn-sm btn-danger p-1">' . esc_html__( 'Cancel', 'datebook' ). '</button>';

									}

									?>
									
								</span>

								<div class="datebook-clear10"></div>
								
								<p class="card-text m-0"><?php esc_html_e( 'Activate Top status till', 'datebook' ); ?>:</p>

								<div class="form-row align-items-center">

									<div class="col-7">
										<input type="text" class="form-control form-control-sm" id="topdate" name="topends" value="" autocomplete="off" placeholder="d/m/Y" />
									</div>
									<div class="col-5">
										<button type="submit" name="submit" class="btn btn-sm btn-primary pl-2 pr-2"><?php esc_html_e( 'Activate', 'datebook' ); ?></button>
									</div>
								</div>


							</div>
							</div>
						</div>

					</div>

				</form>

				<div class="row">
					<div class="col-lg-6 col-md-6 col-sm-6 datebook-padding-less">
						<div class="card border bg-white shadow-none mb-1">
							<div class="card-body">

							<h5 class="card-title"><?php esc_html_e( 'Profile data', 'datebook' ); ?></h5>

							<ul class="list-unstyled card-text">
								<li><?php esc_html_e( 'Profile ID', 'datebook' ); ?>: <?php echo absint($profile_id); ?> <?php edit_post_link(esc_html__( 'Edit', 'datebook' ), "", "", null, 'btn btn-sm btn-grey'); ?></li>
								<li><?php esc_html_e( 'User ID', 'datebook' ); ?>: <?php echo absint(get_the_author_meta('ID')); ?> <a class="btn btn-sm btn-grey" href="<?php echo esc_url(home_url())."/wp-admin/user-edit.php?user_id=" . absint(get_the_author_meta('ID')); ?>"> <?php esc_html_e( 'Edit', 'datebook' ); ?></a></li>
								<li><?php esc_html_e( 'Username', 'datebook' ); ?>: <?php echo esc_attr(get_the_author_meta('user_login')); ?></li>
								<li><?php esc_html_e( 'Email', 'datebook' ); ?>: <?php echo sanitize_email(get_the_author_meta('user_email')); ?></li>
								<?php /*?><li><?php esc_html_e( 'Type', 'datebook' ); ?>: <?php echo esc_attr(get_user_meta( get_the_author_meta('ID'), "profile_type", true)); ?></li><?php */?>
							</ul>
							</div>
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6 datebook-padding-less"> 

						<div class="card border bg-white shadow-none mb-1">
							<div class="card-body">

								<h5 class="card-title"><?php esc_html_e( 'Location details', 'datebook' ); ?></h5>

								<?php

								if(of_get_option('enable_iplocation')){

									do_action( 'datebook_ip_location', $datebook_get_data);

								} else {
									
									echo esc_html__( 'This function is not enabled in the theme options', 'datebook' ) . ':';
									
									echo '<br>';
									echo '<em>WordPress -> DateBook -> Dashboard -> IP Location -> Enable detection of user location by IP</em>';
									
								}

								?>

							</div>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less"> 

						<div class="card mb-0 border bg-white shadow-none">
							<div class="card-body">
								<div class="row no-gutters">
									<div class="col-md-8">
										<h5 class="card-title"><?php esc_html_e( 'Delete Profile', 'datebook' ); ?></h5>
										<p class="card-text"><?php esc_html_e( 'To completely delete the profile click this button', 'datebook' ); ?>.</p>
										<p class="card-text"><?php esc_html_e( 'All images, classified ads and tours will be deleted too', 'datebook' ); ?>.</p>
									</div>
									<div class="col-md-4">
										<form action="<?php echo esc_url(get_permalink($profile_id)); ?>" method="post">

											<input type="hidden" name="action" value="delete_profile" />
											<input type="hidden" name="profile_delete" value="<?php the_ID(); ?>" />

											<button type="submit" name="submit" class="btn btn-sm btn-grey" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_html_e( 'Confirmation popup will open before deletion', 'datebook' ); ?>" onclick="return datebook_delete_profile();"><?php esc_html_e( 'Delete profile', 'datebook' ); ?></button>

										</form>

										<p class="card-text"><small class="text-muted"><?php esc_html_e( 'this action cannot be undone', 'datebook' ); ?></small></p>
									</div>
								</div>
							</div>
						</div>

					</div>
				</div>

			</div>
    </div>
  </div>
</div>

<?php } else { ?>

<div class="datebook-custom-card card">
    <div class="card-header" id="headingThree">
      <h5 class="mb-0">
        <button class="btn btn-link collapsed p-0" type="button" data-toggle="collapse" data-target="#DateBookCollapseAdmin" aria-expanded="false" aria-controls="DateBookCollapseAdmin">+ <?php esc_html_e( 'Administration Dashboard', 'datebook' ); ?></button>
      </h5>
    </div>
    <div id="DateBookCollapseAdmin" class="collapse" aria-labelledby="headingThree" data-parent="#accordionDashboard">
      <div class="card-body">

				<p class="card-text"><?php esc_html_e( 'Administrator tools', 'datebook' ); ?></p>

			</div>
    </div>
  </div>

<?php } ?>