<?php 
/*
 * Notification about user must validate his/her email
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


$page_id = get_the_ID();

$page_link = get_permalink($page_id);

$resendactivation_url = add_query_arg( array(
	'action' => 'resendactivation'
), $page_link );

$activatedemailbyadmin_url = add_query_arg( array(
	'verifyemail' => 'activationkeybyadmin',
	'action' => 'activatedemailbyadmin'
), $page_link );

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$current_user = get_userdata($current_user_id);
$current_user_email = isset($current_user->user_email) ? $current_user->user_email : '';

?>

<div class="datebook-custom-card card">

<div class="card-body">

<h2><?php esc_html_e('Verify your email address', 'datebook'); ?></h2>

	<div class="row">
		<div class="col-lg-8 col-md-8 col-sm-8">
			<div class="jumbotron-contents">

				<div class="card shadow-none datebook-transparent">
					<div class="card-body pr-0 pl-0">

						<p><?php echo esc_html__( 'The verification link has been sent to this email address', 'datebook' ); ?>:</p>
						
						<p class="text-grey"><?php echo sanitize_email($current_user_email); ?></p>
						
						<p><?php echo esc_html__( 'Click the verification link in order to complete the registration process.', 'datebook' ); ?></p>

					</div>

					<form action="<?php echo esc_url($resendactivation_url); ?>" method="post" id="datebook-email-change-form" class="form-inline">
						<input type="hidden" name="action" value="resendactivation" />
						<p><?php echo esc_html__( 'Did not receive an email? Change your email in the form below.', 'datebook' ); ?></p>
						<div class="form-row align-items-center w-100">
							<div class="col">
								<label class="sr-only" for="datebook-email-field"><?php echo esc_html__( 'Email', 'datebook' ); ?></label>
								<input type="text" class="form-control w-100 mb-2" id="datebook-email-field" placeholder="<?php echo esc_html__( 'Enter your correct email', 'datebook' ); ?>" name="email" value="<?php echo sanitize_email($current_user_email); ?>">
							</div>
							<div class="col-auto">
								<button type="submit" name="submit" class="btn btn-primary m-0 mb-2 p-2"><?php echo esc_html__( 'Send activation to me again!', 'datebook' ); ?></button>
							</div>
						</div>
					</form>

				</div>

				<?php if (is_super_admin()) { ?>

					<a class="btn btn-success m-0" href="<?php echo esc_url($activatedemailbyadmin_url); ?>"><?php echo esc_html__( 'Activate without email', 'datebook' ); ?></a>

				<?php } ?>

			</div>
		</div>
		<div class="col-lg-4 col-md-4 col-sm-4">
			<div class="text-center"> 

				<img class="img-responsive" alt="" src="<?php echo esc_url(DATEBOOK_URL . 'assets/images/envelope.png'); ?>" /> 

			</div>
		</div>
	</div>
</div>
</div>