<?php
/**
 * Profile menu. Used in page-header.php
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

switch ($align) {
	case 'left' : $user_menu_align = ' mr-auto'; break;
	case 'center' : $user_menu_align = ' m-auto'; break;
	case 'right' : $user_menu_align = ' ml-auto'; break;
	default: $user_menu_align = ' m-auto'; break;
}

$datebook_text_color = !empty($color) ? 'color:' . $color : '';

$is_front_page = is_front_page() ? 1 : 0;

if($is_front_page == 1){
	$user_menu_position = of_get_option('user_menu_position_front') == 'inprimarymenu' ? '' : 'container';
} else {
	$user_menu_position = of_get_option('user_menu_position_other') == 'inprimarymenu' ? '' : 'container';
}

if (is_user_logged_in() || is_super_admin()) {

	global $datebook_field_titles;

	if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
		$current_user_id = DATEBOOK_CURRENT_USER_ID;
	} else {
		global $current_user;
		wp_get_current_user();
		$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
	}

	set_query_var( 'datebook_field_titles', $datebook_field_titles );
	
	$datebook_field_titles = get_query_var( 'datebook_field_titles' );
	if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

	if ($current_user_id > 0) {

		$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

		if (isset($profile_id) && $profile_id > 0) {
			
			$profile = get_post($profile_id);
			$profile_name = isset($profile->post_title) ? $profile->post_title : esc_html__( 'Deleted', 'datebook' );

			$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
			$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

			$gender = isset($datebook_get_data['gender']) ? $datebook_get_data['gender'] : 0;

		}
	}



	if (isset($profile_id) && $profile_id > 0) {

		$user_submenu_items = array();

		$login_url = add_query_arg( array(
			'action' => 'logout'
		), get_permalink(of_get_option('login_page')) );

		$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_profile_user_menu', $gender, true);

		if ($is_front_page == 1){
			$user_menu_items_in_header_array = of_get_option('user_menu_items_in_header_front');
		} else {
			$user_menu_items_in_header_array = of_get_option('user_menu_items_in_header_other');
		}
		
	?>

<nav class="navbar navbar-expand-sm shadow-none datebook-user-navbar <?php echo esc_attr($align); ?>">
	<ul class="navbar-nav navbar-user<?php /*?><?php echo esc_attr($user_menu_align); ?><?php */?> datebook-register-links">

		<?php

		if (of_get_option('points_system') == 1 && class_exists('myCRED_Core')) {

			echo '<li class="nav-item"><a class="nav-link badge badge-pill badge-light m-2 shadow-none" href="' . esc_url(get_permalink(of_get_option('my_upgrade_page'))) . '" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="' . esc_html__('My points', 'datebook') .'" style="' . esc_attr($datebook_text_color) . '">';
			echo esc_html__('My points', 'datebook') .': ' . mycred_get_users_balance($current_user_id);
			echo '</a></li>';

		}


		foreach($datebook_user_menu_items as $value => $label){

			if(isset($user_menu_items_in_header_array[$value]) && $user_menu_items_in_header_array[$value] == 1){

				if($value == 'my_messages_page' && (of_get_option('contact_method') != 1 && of_get_option('contact_method') != 3)) continue;

				if($value == 'my_upgrade_page' && DateBook_Utilities::check_if_gateway_activated() != 1) continue;

				if($value == 'my_verification_page' && of_get_option('enable_verification') != 1) continue;

				if($value == 'my_friends_page' && of_get_option('enable_friendship') != 1) continue;

				if($value == 'my_favorites_page'){
					$enable_favorite_profiles = of_get_option('enable_favorite_profiles');
					$enable_favorite = isset($enable_favorite_profiles['1']) && $enable_favorite_profiles['1'] == '1' ? 1 : 0;
					if ($enable_favorite == 0){
						continue;
					}
				}

				if($value == 'my_blacklist_page' && of_get_option('enable_blacklisted_profiles') != 1) continue;

				if($value == 'my_comments_page' && of_get_option('enable_profile_comments') != 1) continue;

				if($value == 'my_classifieds_page' && of_get_option('enable_classifieds') != 1) continue;

				if($value == 'my_tours_page' && of_get_option('enable_profile_tours') != 1) continue;


				if($showtitle == 1){
					$item_label = esc_html__($label['title'], 'datebook');
					$tooltip_out = '';
				} else {
					$item_label = '';
					$tooltip_out = ' data-toggle="tooltip" data-placement="bottom" title="" data-original-title="' . esc_html__($label['title'], 'datebook') . '"';
				}

				echo '<li class="nav-item"><a class="nav-link" style="' . esc_attr($datebook_text_color) . '" href="' . esc_url(get_permalink(of_get_option($value))) . '" ' . $tooltip_out . '>';

				if($showicon == 1){

					if ($value == 'my_views_page') {

						echo DateBook_Profile_Views::datebook_count_who_viewed_me($current_user_id);

					} else if ($value == 'my_messages_page') {

						do_action('datebook_new_msg_alert', 'withsup');
						echo '<i class="' . $label['icon'] . '"></i> ';

					} else if ($label['icon'] != '') {

						echo '<i class="' . $label['icon'] . '"></i> ';

					}
				
				}
				
				echo esc_html($item_label) .'</a></li>';

			} else {

				$user_submenu_items[$value] = $label;

			}

		}


		// Get notifications for profile
		$get_found_notifications = array();

		$get_data_notification = get_post_meta($profile_id, 'notification', true);

		if(is_array($get_data_notification) && !empty($get_data_notification)){
			
			usort($get_data_notification, 'DateBook_Profile_Notifications::sort_notification_by_time');

			foreach($get_data_notification as $key => $value){

				if($value['status'] != 'unread') continue;

				$get_found_notifications[] = $value;

			}
		}

		if(is_array($get_found_notifications) && !empty($get_found_notifications)){
			
			$count_found_notifications = count($get_found_notifications);

			?>

			<li class="nav-item dropdown">

				<a class="nav-link dropdown-toggle" style=" <?php echo esc_attr($datebook_text_color); ?>" href="<?php echo esc_url(get_permalink(of_get_option('my_notification_page'))); ?>" id="DateBookDropdownUserLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><sup><span class="badge badge-pill badge-warning"><?php echo absint($count_found_notifications); ?></span></sup><i class="fas fa-bell mr-1"></i></a>

				<ul class="dropdown-menu border-0 shadow dropdown-menu-right datebook-dropdown-menu datebook-notification-menu" aria-labelledby="DateBookDropdownUserLink">

					<a class="dropdown-item" href="<?php echo esc_url(get_permalink(of_get_option('my_notification_page'))); ?>" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="<?php echo esc_html__( 'Notifications', 'datebook' );?>"><?php echo esc_html__( 'See all notifications', 'datebook' ); ?></a>

					<div class="dropdown-divider"></div>

					<?php

					foreach($get_found_notifications as $key => $value){

						if(isset($value['status']) && $value['status'] == 'unread'){

							$time = isset($value['time']) ? $value['time'] : '';
							$referrer = isset($value['referrer']) ? $value['referrer'] : '';
							$show = isset($value['show']) ? $value['show'] : '';
							$notification_page_link = isset($value['url']) ? $value['url'] : '';
							
							$post_title = '';
							$thumbnail_url_notification = array('img_full_url' => '');
							
							if(isset($value['profile_id']) && isset($value['profile_id']) > 0){

								$current_profile_data = get_post($value['profile_id']);

								if(isset($current_profile_data->ID)){
									$post_title = isset($current_profile_data->post_title) ? $current_profile_data->post_title . ' ' : '';
									$thumbnail_url_notification = DateBook_Utilities::datebook_profile_thumbnail($value['profile_id'], 'image_profile_user_menu', '', true);
								}
							}

							$value['text'] = $post_title . $value['text'];

							$query_page_link = add_query_arg( array(
								'referrer' => $referrer,
								'show' => $show,
								'id' => $time
							), $notification_page_link );

							switch ($show) {
								case 'friends' : $add_anchor_url = '#datebook-friends-list-anchor'; break;
								case 'likes' : $add_anchor_url = ''; break;
								case 'favorites' : $add_anchor_url = ''; break;
								default: $add_anchor_url = ''; break;
							}

							echo '<a class="dropdown-item" href="' . esc_url($query_page_link) . $add_anchor_url . '">';

							if(isset($thumbnail_url_notification['img_full_url']) && $thumbnail_url_notification['img_full_url'] != ''){

								echo '<img class="float-left thumbnail mr-2 rounded" src="' . esc_url($thumbnail_url_notification['img_full_url']) . '" alt="" />';

							}

							echo esc_html__($value['text']) . '</a>';

						}
					}

					?>

				</ul>
			</li>

			<?php } else { ?>

				<li class="nav-item"><a class="nav-link" style=" <?php echo esc_attr($datebook_text_color); ?>" href="<?php echo esc_url(get_permalink(of_get_option('my_notification_page'))); ?>" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="<?php echo esc_html__( 'Notifications', 'datebook' );?>"><i class="fas fa-bell"></i></a></li>

			<?php } ?>


			<li class="nav-item datebook-profile-image"><a class="nav-link" style=" <?php echo esc_attr($datebook_text_color); ?>" href="<?php echo esc_url(get_permalink(get_user_meta( $current_user_id, 'profile_postid', true))); ?>" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="<?php echo esc_html($profile_name); ?>"><?php if($thumbnail_url['image_exists'] == 'no'){ echo '<i class="fas fa-user-circle"></i>'; } else { echo '<img class="img-circle" src="' . esc_url( $thumbnail_url['img_full_url'] ) . '" alt="" />'; } ?> <span class="sr-only"><?php echo esc_html($profile_name); ?></span></a></li>

			<?php if(count($user_submenu_items) > 0){ ?>

			<li class="nav-item dropdown">

				<a class="nav-link dropdown-toggle" style=" <?php echo esc_attr($datebook_text_color); ?>" href="#" onclick="return false" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php if($showicon == 1){ echo '<i class="fas fa-list"></i>'; } ?> <?php if($showtitle == 1){ echo ' ' . esc_html__( 'My account', 'datebook' ); } ?> <b class="caret"></b></a>

				<ul class="dropdown-menu border-0 shadow dropdown-menu-right datebook-dropdown-menu">

					<?php

					foreach($user_submenu_items as $value => $label){

						if(isset($user_menu_items_in_header_array[$value]) && $user_menu_items_in_header_array[$value] != 1){

							if($value == 'my_messages_page' && (of_get_option('contact_method') != 1 && of_get_option('contact_method') != 3)) continue;

							if($value == 'my_upgrade_page' && DateBook_Utilities::check_if_gateway_activated() != 1) continue;

							if($value == 'my_verification_page' && of_get_option('enable_verification') != 1) continue;

							if($value == 'my_friends_page' && of_get_option('enable_friendship') != 1) continue;
							
							if($value == 'my_favorites_page'){
								$enable_favorite_profiles = of_get_option('enable_favorite_profiles');
								$enable_favorite = isset($enable_favorite_profiles['1']) && $enable_favorite_profiles['1'] == '1' ? 1 : 0;
								if ($enable_favorite == 0){
									continue;
								}
							}

							if($value == 'my_blacklist_page' && of_get_option('enable_blacklisted_profiles') != 1) continue;

							if($value == 'my_comments_page' && of_get_option('enable_profile_comments') != 1) continue;

							if($value == 'my_classifieds_page' && of_get_option('enable_classifieds') != 1) continue;

							if($value == 'my_tours_page' && of_get_option('enable_profile_tours') != 1) continue;


							$item_label = esc_html__($label['title'], 'datebook');

							echo '<a class="dropdown-item" href="' . esc_url(get_permalink(of_get_option($value))) . '">';

							if($showicon == 1){

								if ($value == 'my_views_page') {

									echo DateBook_Profile_Views::datebook_count_who_viewed_me($current_user_id);

								} else if ($value == 'my_messages_page') {

									do_action('datebook_new_msg_alert', 'withsup');
									echo '<i class="' . $label['icon'] . '"></i> ';

								} else if ($label['icon'] != '') {

									echo '<i class="' . $label['icon'] . '"></i> ';

								}

							}

							echo esc_html($item_label) .'</a>';

						}
					}

					?>

					<li class="dropdown-divider"></li>

					<a class="dropdown-item" href="<?php echo esc_url($login_url); ?>"><i class="fas fa-minus-circle"></i> <?php esc_html_e( 'Logout', 'datebook' ); ?></a>

				</ul>
			</li>

			<?php } else { ?>
			
				<li class="nav-item"><a class="nav-link" style=" <?php echo esc_attr($datebook_text_color); ?>" href="<?php echo esc_url($login_url); ?>" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="<?php esc_html_e( 'Logout', 'datebook' ); ?>"><i class="fas fa-minus-circle"></i> <?php esc_html_e( 'Logout', 'datebook' ); ?></a></li>

			<?php } ?>

	</ul>
</nav>

<?php } } else { ?>

	<?php if (!is_super_admin() && of_get_option('enable_register_login')) { ?>

		<nav class="navbar navbar-expand-sm shadow-none datebook-user-navbar <?php echo esc_attr($align); ?>">
			<ul class="navbar-nav navbar-user<?php /*?><?php echo esc_attr($user_menu_align); ?><?php */?> datebook-register-links">

			<?php if (of_get_option('enable_profile_registration') == '1') { ?>

				<li class="nav-item"><a class="nav-link" style=" <?php echo esc_attr($datebook_text_color); ?>" href="<?php echo esc_url(get_permalink(of_get_option('registration_page'))); ?>"><i class="fa fa-check-circle"></i> <?php esc_html_e( 'Register', 'datebook' ); ?></a></li>

			<?php } ?>

				<li class="nav-item"><a class="nav-link" style=" <?php echo esc_attr($datebook_text_color); ?>" href="<?php echo esc_url(get_permalink(of_get_option('login_page'))); ?>"><i class="fas fa-sign-in-alt"></i> <?php esc_html_e( 'Login', 'datebook' ); ?></a></li>

			</ul>
		</nav>

<?php } }