<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( method_exists( 'DateBook_Utilities', 'protect_if_not_loggedin' ) ) { DateBook_Utilities::protect_if_not_loggedin(); }

global $datebook_alert_error, $datebook_alert_text;

if (defined('DATEBOOK_CURRENT_USER_ID') && is_numeric(DATEBOOK_CURRENT_USER_ID)) {
	$current_user_id = DATEBOOK_CURRENT_USER_ID;
} else {
	global $current_user;
	wp_get_current_user();
	$current_user_id = DateBook_Utilities::datebook_replace_user_by_admin($current_user->ID, 1);
}

$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

$profile_id = get_user_meta( $current_user_id, 'profile_postid', true );

$get_profile_data = get_post_meta($profile_id, 'profile_personal_data', true);
$datebook_get_data = !empty($get_profile_data) ? $get_profile_data : array();

$my_tours_link = get_permalink(of_get_option('my_tours_page'));

?>

<div class="datebook-custom-card card mb-3 tooltip-demo">
	<div class="card-body">

		<h2><?php esc_html_e( 'My tours', 'datebook' ); ?></h2>

		<?php if (DateBook_Utilities::datebook_show_field('wishtravel', 1)) { ?>

			<hr />

			<form action="<?php the_permalink(); ?>" method="post">

				<input type="hidden" name="action" value="intro" />

				<fieldset>
					<div class="mb-3">
						<div class="form-group">
							<div class="row">
								<div class="col-sm-3">

									<label for="datebook-wishtravel"><?php esc_html_e( 'Enable my tours', 'datebook' ); ?></label>

								</div>
								<div class="col-sm-9">
									<div class="custom-control custom-checkbox">

										<input type="checkbox" class="custom-control-input" id="datebook-wishtravel" name="wishtravel" value="1" <?php if ( isset($datebook_get_data['wishtravel']) && $datebook_get_data['wishtravel'] == '1' ) { echo ' checked="checked"'; } ?> /> <label class="custom-control-label" for="datebook-wishtravel"><?php esc_html_e( 'Yes', 'datebook' ); ?></label>

									</div>
								</div>
							</div>
						</div>

						<div class="form-group">
							<div class="row">
								<div class="col-sm-3">

									<label for="datebook-wishtraveltext"><?php esc_html_e( 'Introduction text', 'datebook' ); ?></label>

								</div>
								<div class="col-sm-9">

									<textarea name="wishtraveltext" id="datebook-wishtraveltext" rows="3" cols="42" class="form-control" maxlength="300"><?php if ( !empty($datebook_get_data['wishtraveltext']) ) { echo esc_textarea($datebook_get_data['wishtraveltext']); } ?></textarea>
									<em class="small text-grey"><?php esc_html_e( 'Example: Invite me to your country so we both have funny time', 'datebook' ); ?></em>

								</div>
							</div>
						</div>

						<button type="submit" name="change_profile_form" class="btn btn-primary"><?php esc_html_e( 'Save', 'datebook' ); ?></button>

					</div>
				</fieldset>
			</form>

		<?php } ?>


		<div class="datebook-addedtours">
			<div class="card border datebook-transparent">

				<div class="card-header">

					<?php esc_html_e( 'Tours you already added', 'datebook' ); ?>

				</div>

					<?php

					$args = array(
						'author' => $current_user_id,
						'post_type' => DATEBOOK_TOUR_TYPE,
						'post_status' => 'publish, private, draft',
						'posts_per_page' => -1,
						'orderby' => 'date',
						'order' => 'DESC'
					);

					$the_query = new WP_Query( $args );

					if ( $the_query->have_posts() ) : 
					
					?>
					
					<ul class="list-group list-group-flush">
					
					<?php

						while ( $the_query->have_posts() ) : $the_query->the_post();

							unset($city);

							$post_id = get_the_ID();

							$city_id = get_post_meta($post_id, 'city', true);

							if(isset($city_id)){

								$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
								$country = isset($term_data->country) ? $term_data->country : '';
								$region = isset($term_data->region) ? $term_data->region : '';
								$city = isset($term_data->city) ? $term_data->city : '';

							}

							$tour_title = get_the_title();
							$tour_description = get_the_content();

							$tour_start = DateBook_Utilities::datebook_date_i18n(1, get_post_meta($post_id,'start', true), false);
							$tour_end = DateBook_Utilities::datebook_date_i18n(1, get_post_meta($post_id, 'end', true), false);

							$tour_payment_status = get_post_meta($post_id, 'tour_paid', true);

							$search_countrycity = '';
							if (isset($city) && !empty($city)){
								$search_countrycity .= $city . ', ';
							}
							if (isset($region) && !empty($region)){
								$search_countrycity .= $region . ', ';
							}
							if (isset($country) && !empty($country)){
								$search_countrycity .= $country;
							}

					?>

					<li id="datebook-tour<?php echo absint($post_id); ?>" class="list-group-item">

						<div class="row">
							<div class="col-lg-10 col-md-10 col-sm-10">
							
								<h4 class="list-group-item-heading"><?php echo esc_attr($tour_title); ?></h4>

								<p class="mb-1">
								<?php if(get_post_status($post_id) == 'publish'){ ?>
									<span class="badge badge-success mr-1"><?php esc_html_e( 'Approved', 'datebook' ); ?></span>
								<?php } else { ?>
									<span class="badge badge-warning mr-1"><?php esc_html_e( 'Pending', 'datebook' ); ?></span>
								<?php } ?> 
								
								<span class="small"><strong><?php esc_html_e( 'Location', 'datebook' ); ?>:</strong> <?php echo esc_attr($search_countrycity); ?></span></p>

								<p class="small"><strong><?php esc_html_e( 'Starts', 'datebook' ); ?>:</strong> <?php echo esc_attr($tour_start); ?> &#8212; <strong><?php esc_html_e( 'Ends', 'datebook' ); ?>:</strong> <?php echo esc_attr($tour_end); ?></span></p>

								<hr>

								<div class="card border-0">
									<?php echo esc_html($tour_description); ?>
								</div>
								

							</div>

							<div class="col-lg-2 col-md-2 col-sm-2">
							
								<p><?php esc_html_e( 'ID', 'datebook' ); ?>: <?php echo absint($post_id); ?></</p>
							
								<p>

								<a id="<?php echo absint($post_id); ?>" class="btn btn-sm btn-blue-grey btn-block datebook-edittour" href="<?php echo esc_url($my_tours_link); ?>?action=edittour&tour_id=<?php echo absint($post_id); ?>" title="<?php esc_html_e( 'Edit', 'datebook' );?>"><i class="fa fa-edit"></i></a> 

								<a class="btn btn-sm btn-grey btn-block" href="<?php echo esc_url($my_tours_link); ?>?action=delete&tour_id=<?php echo absint($post_id); ?>" title="<?php esc_html_e( 'Delete', 'datebook' );?>"><i class="fa fa-trash"></i></a>

								</p>

							</div>
						</div>
					</li>

					<?php

					endwhile;
					
					?>
					
					</ul>
					
					<?php else: ?>

					<div class="card-body"><?php echo esc_html__( 'No tours yet', 'datebook' ); ?></div>
					
					<?php

				endif;
				
				wp_reset_postdata();

				?>

				
			</div>
		</div>
	</div>
</div>

<?php 

// display the Edit Profile form
include DateBook_Template_Loader::locate( 'profile/profile-tours-addbutton' );