<?php
/*
 * Single Profile
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

$can_see_profile = 1;
$can_see_images = 1;
$enable_phone = 1;
$enter_website = 1;

if($currentauth_ID > 0 && $currentauth_ID != $current_user_id && !is_super_admin()){

	$enable_subscription = DateBook_Utilities::check_if_gateway_activated() ? 1 : 0;

	if($enable_subscription == 1){

		$get_subscription_plans = get_option('datebook_subscription_plans');

		$profile_subscription_plan = isset($datebook_get_data['profile_subscription']['subscription_id']) ? $datebook_get_data['profile_subscription']['subscription_id'] : '';

		// Phone allowed in a Subscription plan
		$enable_phone = isset($get_subscription_plans[$profile_subscription_plan]['enter_phone']) && $get_subscription_plans[$profile_subscription_plan]['enter_phone'] > 0 ? 1 : 0;
		// Website allowed in a Subscription plan
		$enter_website = isset($get_subscription_plans[$profile_subscription_plan]['enter_website']) && $get_subscription_plans[$profile_subscription_plan]['enter_website'] > 0 ? 1 : 0;

	}

	// Who can see my profile
	$can_see_profile_array = DateBook_Utilities::who_can_see_my_profile($current_user_id, $currentauth, $profile_id, $datebook_get_data);

	$can_see_profile = $can_see_profile_array['allow'];
	$can_see_profile_text = $can_see_profile_array['text'];

	// Who can see my images
	$can_see_images_array = DateBook_Utilities::who_can_see_my_images($current_user_id, $currentauth, $profile_id, $datebook_get_data);

	$can_see_images = $can_see_images_array['allow'];
	$can_see_images_text = $can_see_images_array['text'];

}

$options = array(
	'current_user_id' => $current_user_id,
	'profile_id' => $profile_id,
	'datebook_get_data' => $datebook_get_data
);

// Let's check if member activated his email
//do_action('datebook_profile_all_statuses');

// Show Administrator Dashboard to control Profile
do_action('datebook_administrator_panel');

// Show Featured background images to set in Profile
if($currentauth_ID > 0 && $currentauth_ID == $current_user_id){
	do_action('datebook_featured_images_panel');
}

?>

<article>

	<?php

	$notification_from_admin = get_post_meta($profile_id, 'notification_from_admin', true);

	if ($notification_from_admin) {

		echo '<div class="alert alert-danger">'.esc_html($notification_from_admin).'</div>';

	}

	if (isset($datebook_alert_error) && $_POST['action'] == 'contacting') {

		echo '<div class="alert alert-danger">'.esc_attr($datebook_alert_error).'</div>';

	}

	if (isset($alert_success) && $_POST['action'] == 'contacting') {

		echo '<div class="alert alert-success">'.esc_attr($alert_success).'</div>';

	}

	//include DateBook_Template_Loader::locate( 'payment/profile-check-subscription' );

	// Show default profile image on left or right side
	if (self::$datebook_options['profile_image_side'] == 'right') {

		$profile_image_side = 'float-right';

	} else {

		$profile_image_side = 'float-left';

	}

	?>

	<div <?php post_class( 'datebook-profilepage' ); ?>>
	
		<?php
		
		$enable_blacklisted_profiles = self::$datebook_options['enable_blacklisted_profiles'];
		
		if ($enable_blacklisted_profiles == '1') {

			$data_array = get_user_meta( $current_user_id, 'blacklist', true);
			if ($data_array) {
				$data_array = array_unique(explode(',', $data_array));
			} else {
				$data_array = array();
			}

			if (in_array($profile_id, $data_array)) {
				
				echo '<div class="alert alert-danger datebook-profile-blocked">' . esc_html__( 'You have blocked this user', 'datebook' ) . ' <a class="btn btn-danger shadow-none m-0 p-0 pr-2 pl-2 datebook-blacklist-actions datebook-blacklist-' . absint($profile_id) . '" profile-id="' . absint($profile_id) . '" onClick="return false;" href="javascript:void(0)">' . esc_html__( 'Unblock', 'datebook' ) . '</a></div>';

			}
		}

		// Matching panel
		if(isset(self::$datebook_options['enable_profile_matching']) && self::$datebook_options['enable_profile_matching'] == 1 && isset(self::$datebook_options['display_matching_place']) && self::$datebook_options['display_matching_place'] == 1 && $currentauth_ID > 0 && $currentauth_ID != $current_user_id && !is_super_admin()){

			$options['display_matching_place'] = isset(self::$datebook_options['display_matching_place']) ? self::$datebook_options['display_matching_place'] : 1;
			$options['split_progress_on_levels'] = isset(self::$datebook_options['split_progress_on_levels']) ? self::$datebook_options['split_progress_on_levels'] : 2;
			$options['matching_level_excellent'] = isset(self::$datebook_options['matching_level_excellent']) ? self::$datebook_options['matching_level_excellent'] : 90;
			$options['matching_level_very_good'] = isset(self::$datebook_options['matching_level_very_good']) ? self::$datebook_options['matching_level_very_good'] : 80;
			$options['matching_level_good'] = isset(self::$datebook_options['matching_level_good']) ? self::$datebook_options['matching_level_good'] : 60;
			$options['matching_level_fair'] = isset(self::$datebook_options['matching_level_fair']) ? self::$datebook_options['matching_level_fair'] : 50;

			echo DateBook_Matching::process_profile_matching($options);
		}

		?>

		<div class="datebook-custom-card card mb-3 pt-2 datebook-profile-main tooltip-demo <?php echo esc_attr(sanitize_html_class($featured_class));?>">
		
		<?php

		if ($currentauth_ID > 0 && $currentauth_ID == $current_user_id || is_super_admin()) { ?>

			<div class="card-body pt-1 pb-0">

				<?php

				echo '<span>' . esc_html__( 'Profile status', 'datebook' ) . ':</span> ';

				// Show user's profile status: Active or Suspended
				if (get_post_status() == 'publish') {

					echo '<span class="badge badge-success">' . esc_html__( 'Active', 'datebook' ) . '</span>';

				} else {

					$notactive = get_post_meta($profile_id, 'notactive', true);

					if ($notactive == 1) {
						echo '<span class="badge badge-danger">' . esc_html__( 'Suspended', 'datebook' ) . '</span>';
					} else {
						echo '<span class="badge badge-danger">' . esc_html__( 'Inactive', 'datebook' ) . '</span>';
					}

				}


				// Show user's topad expiration
				if (get_post_meta($profile_id, 'topad', true) == 1 && get_post_meta($profile_id, 'topad_ends', true)) {
					echo ' <span class="badge badge-info" title="' . esc_html__( 'Your Top status is active until', 'datebook' ).': '.date("d M Y", get_post_meta($profile_id, 'topad_ends', true)) . '">' . esc_html__( 'Top', 'datebook' ) . '</span> ';
				}

				// Show user's featured expiration
				if (get_post_meta($profile_id, 'featured', true) == 1 && get_post_meta($profile_id, 'featured_ends', true)) {
					echo ' <span class="badge badge-info" title="' . esc_html__( 'Your Featured status is active until', 'datebook' ).': '.date("d M Y", get_post_meta($profile_id, 'featured_ends', true)) . '">'. esc_html__( 'Featured', 'datebook' ) . '</span> ';
				}

				?>

				<a class="btn btn-secondary btn-blue-grey btn-sm float-right" href="<?php echo esc_url(get_permalink(self::$datebook_options['my_settings_page'])); ?>"><i class="fas fa-edit"></i> <?php esc_html_e( 'Edit', 'datebook' ); ?></a>

			</div>

			<?php } ?>


			<div class="card-body">

				<div class="row mb-3">
				
					<div class="col-lg-5 col-md-5 col-sm-5 text-center datebook-defaultphoto <?php echo esc_attr($profile_image_side); ?>">

						<?php

						$show_tab = isset($_GET['show']) ? esc_attr($_GET['show']) : '';

						$all_photos_args = array(
							'post_parent' => $profile_id, 
							'post_status' => 'inherit', 
							'post_type' => 'attachment', 
							'post_mime_type' => 'image', 
							'orderby' => 'rand',
							'posts_per_page' => -1,
							'meta_query' => array(
								array('key' => DATEBOOK_IMAGE_TYPE, 'value' => DATEBOOK_PROFILE_IMAGE_TYPE, 'compare' => '=' )
							)
						);

						$all_photos = new WP_Query( $all_photos_args );

						$all_count_photos = isset($all_photos->found_posts) && $all_photos->found_posts > 0 ? $all_photos->found_posts : 0;
						
						
						// set up cache folder
						$upload_dir = wp_upload_dir();
						$cache_url  = trailingslashit( $upload_dir['baseurl'] . '/' . DATEBOOK_OPTIONS_FOLDER . '/images');

						// Show default profile image
						$thumbnail_url = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_profile', $get_data_gender, true);
						
						if($thumbnail_url['image_exists'] == 'yes'){

							$profile_image_url = $thumbnail_url['img_full_url'];

						} else {

							$profile_image_url = $cache_url . 'image_profile.png';

						}
						
						

						if ($thumbnail_url['image_exists'] == 'no') {

							echo '<div class="datebook-default-image-frame" style="background-image: url(' . esc_url($thumbnail_url['img_full_url']) . '); background-repeat: no-repeat; background-position: center; background-size: 75%">';

							echo '<img class="img-thumbnail m-auto datebook-transparent" src="'.esc_url($profile_image_url).'" alt="' . esc_attr($title_for_alt) . '" width="' . esc_attr( $thumbnail_url['width'] ) . '" height="' . esc_attr( $thumbnail_url['height'] ) . '" />';

							if($can_see_images == 0 && isset($datebook_get_data['profile_photo_id']) && !empty($datebook_get_data['profile_photo_id'])){

								echo '<div class="d-block datebook-addphoto-on-profile"><span class="d-inline-block p-2 shadow white text-dark small">' . esc_attr($can_see_images_text) . '</span></div>';

							} else if (is_user_logged_in() && $currentauth_ID > 0 && $currentauth_ID == $current_user_id) {

								echo '<div class="d-block datebook-addphoto-on-profile"><a class="btn btn-sm btn-outline-secondary d-inline-block shadow-none" href="' . esc_url(get_permalink(self::$datebook_options['my_photos_page'])).'">' . esc_html__( 'Add photo', 'datebook' ) . '</a></div>';

							}

							echo '</div>';

						} else {

							// Check if Retina enabled in Theme Options
							$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

							echo '<figure id="blueimp-gallery-links" class="text-center datebook-gallery">';
							echo '<div class="datebook-default-image-frame">';

							$image_urlbig = DateBook_Utilities::datebook_profile_thumbnail($profile_id, 'image_big', $get_data_gender, false);

							echo '<a class="d-inline-block datebook-frontphoto" href="'.esc_url($image_urlbig['img_full_url']).'"><img class="img-fluid m-auto rounded shadow" src="'.esc_url( $thumbnail_url['img_full_url'] ).'" alt="' . esc_attr($title_for_alt) . '" width="' . esc_attr( $thumbnail_url['width'] ) . '" height="' . esc_attr( $thumbnail_url['height'] ) . '"';

							if($enable_retina_images == 1) {
								echo ' data-rjs="2"';
							}

							echo '/></a>';

							if($can_see_images == 0){
								echo '<div class="d-block datebook-addphoto-on-profile"><span class="d-inline-block p-2 shadow white text-dark small">' . esc_attr($can_see_images_text) . '</span></div>';
							}

							echo '</div>';

							if (isset($show_tab) && ($show_tab == 'comments' || $show_tab == 'reviews')) {} else {

								if (isset($show_tab) && $show_tab != 'photos' && $all_count_photos > 1) {

									echo '<div class="d-inline-block mt-2 w-100 text-center clearfix datebook-thumbs">';

									$i=0;

									$display_all_imagesin_lightbox = self::$datebook_options['display_all_imagesin_lightbox'] ? 1 : 0;

									$quantity_images_under_profile = self::$datebook_options['quantity_images_under_profile'] ? self::$datebook_options['quantity_images_under_profile'] : 0;

									if($quantity_images_under_profile > 0){

										$blur_variant = of_get_option('blur_variant') ? of_get_option('blur_variant') : 0;

										while ( $all_photos->have_posts() ) : $all_photos->the_post();

											$main_image_xid = isset($datebook_get_data['profile_photo_id']) ? $datebook_get_data['profile_photo_id'] : '';

											if ($main_image_xid == get_the_title()) continue;

											$thumb_no_exist = 0;

											$photo_url = explode('.', get_the_title());

											$thumbnail_child = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_avatar']['width'] . 'x' . $datebook_image_sizes['image_avatar']['height']) . '.' . strtolower($photo_url[1]);
											$thumbnail_child_blur = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_avatar']['width'] . 'x' . $datebook_image_sizes['image_avatar']['height'] . '-blur') . '.' . strtolower($photo_url[1]);

											$thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_child;
											$thumbnail_url_blur = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_child_blur;

											if (!file_exists($targetPath . '/' . $thumbnail_child)) {

												if (!file_exists( $targetPath . '/' . get_the_title() )) {

													$thumb_noimage_name = str_replace('_','-', 'image_avatar');
													$thumbnail_url = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';
													$thumb_no_exist = 1;

												} else {

													$image = wp_get_image_editor( $targetPath . '/' . get_the_title() );
													if ( ! is_wp_error( $image ) ) {
														$image->resize( $datebook_image_sizes['image_avatar']['width'], $datebook_image_sizes['image_avatar']['height'], true );
														$image->save($targetPath . '/' . $thumbnail_child);

														// Create and blur a new image
														if($blur_variant > 0){
															$image->save($targetPath . '/' . $thumbnail_child_blur);
															$image->add_blur($targetPath . '/' . $thumbnail_child_blur);
														}
													}

												}

											} else {

												$thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_child;

											}
											
											$thumbnail_url = $can_see_images == 0 && $blur_variant > 0 ? $thumbnail_url_blur : $thumbnail_url;


											$big_thumbnail_child = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_big']['width'] . 'x' . $datebook_image_sizes['image_big']['height']) . '.' . strtolower($photo_url[1]);
											$big_thumbnail_child_blur = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_big']['width'] . 'x' . $datebook_image_sizes['image_big']['height'] . '-blur') . '.' . strtolower($photo_url[1]);
											
											$big_thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_child;
											$big_thumbnail_url_blur = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_child_blur;

											if (!file_exists($targetPath . '/' . $big_thumbnail_child)) {

												if (!file_exists( $targetPath . '/' . get_the_title() )) {

													$thumb_noimage_name = str_replace('_','-', 'image_avatar');

													$big_thumbnail_child = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';

												} else {

													$image = wp_get_image_editor( $targetPath . '/' . get_the_title() );
													if ( ! is_wp_error( $image ) ) {
														$image->resize( $datebook_image_sizes['image_big']['width'], $datebook_image_sizes['image_big']['height'], true );
														$image->save($targetPath . '/' . $big_thumbnail_child);
														
														// Create and blur a new image
														if($blur_variant > 0){
															$image->save($targetPath . '/' . $big_thumbnail_child_blur);
															$image->add_blur($targetPath . '/' . $big_thumbnail_child_blur);
														}
													}
												}

											} else {

												$big_thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_child;

											}
											
											$big_thumbnail_url = $can_see_images == 0 && $blur_variant > 0 ? $big_thumbnail_url_blur : $big_thumbnail_url;

											if ($thumb_no_exist == 0){

												$i++;

												if ($quantity_images_under_profile >= $i){

													echo '<a class="datebook-thumbs-add" href="'.esc_url($big_thumbnail_url).'" data-lightbox="example-1"><img class="rounded-circle shadow" src="'.esc_url($thumbnail_url).'" alt="'.esc_attr(get_the_title()).'" width="'.$datebook_image_sizes['image_avatar']['width'].'" height="'.$datebook_image_sizes['image_avatar']['height'].'" /></a>';

												} else if ($display_all_imagesin_lightbox == 1){

													echo '<a class="datebook-thumbs-add" href="'.esc_url($big_thumbnail_url).'" data-lightbox="example-1" style="display: none"><img class="rounded-circle shadow" src="'.esc_url($thumbnail_url).'" alt="'.esc_attr(get_the_title()).'" width="'.$datebook_image_sizes['image_avatar']['width'].'" height="'.$datebook_image_sizes['image_avatar']['height'].'" /></a>';

												}
											}

											//$i++; if ($i == $quantity_images_under_profile) break;

										endwhile;

									}

									echo '</div>';

								}
							}

							?>

						</figure>

						<div id="blueimp-gallery" class="blueimp-gallery blueimp-gallery-controls" style="display:none">
							<div class="slides"></div>
							<h3 class="title"></h3>
							<a class="prev">‹</a>
							<a class="next">›</a>
							<a class="close">×</a>
							<a class="play-pause"></a>
							<ol class="indicator"></ol>
						</div>

						<?php } ?>

					</div>
					<div class="col-lg-7 col-md-7 col-sm-7 datebook-profile-details">
						
						<header>
							<h1><?php echo esc_html($profile_name); ?>
								<?php if (isset($datebook_get_data['verified']) && $datebook_get_data['verified'] == "1") { ?>
									<sup><i class="fas fa-check-square fa-xs text-green" title="<?php echo esc_html__( 'Verified', 'datebook' ); ?>" data-toggle="tooltip" data-placement="top" data-original-title="<?php esc_html_e( 'Verified', 'datebook' ); ?>"></i></sup>
								<?php } ?>
							</h1>
						</header>
						
						<?php
							
						if ($can_see_profile == 1) {

							echo '<p class="float-right">';

							$enable_favorite_profiles = self::$datebook_options['enable_favorite_profiles'];

							if (isset($enable_favorite_profiles['1']) && $enable_favorite_profiles['1'] == '1'){

								$favorites_style = self::$datebook_options['favorites_style'] ? self::$datebook_options['favorites_style'] : 1;
								$favorite_normal_icon_color = self::$datebook_options['favorite_normal_icon_color'] ? self::$datebook_options['favorite_normal_icon_color'] : 'rgb(0, 152, 255)';
								$favorite_added_icon_color = self::$datebook_options['favorite_added_icon_color'] ? self::$datebook_options['favorite_added_icon_color'] : 'rgb(0, 228, 54)';

								$favorites_show_count = isset($enable_favorite_profiles['2']) && $enable_favorite_profiles['2'] == '1' ? 1 : 0;

								$profile_favorites = isset($datebook_get_data['favorites']['count']) && $datebook_get_data['favorites']['count'] > 0 ? $datebook_get_data['favorites']['count'] : 0;

								$favorite_options = array(
									'profile_id' => $profile_id,
									'currentauth_ID' => $currentauth_ID,
									'current_user_id' => $current_user_id,
									'profile_favorites' => $profile_favorites,
									'style' => $favorites_style,
									'normal_icon_color' => $favorite_normal_icon_color,
									'added_icon_color' => $favorite_added_icon_color,
									'show_count' => $favorites_show_count,
									'what_page' => 1
								);

								echo DateBook_Profile_Edit::process_favorite_button($favorite_options);

							}
							
							$enable_like_profiles = self::$datebook_options['enable_like_profiles'];

							if (isset($enable_like_profiles['1']) && $enable_like_profiles['1'] == '1') {
								
								$like_style = self::$datebook_options['like_style'] ? self::$datebook_options['like_style'] : 1;
								$like_normal_icon_color = self::$datebook_options['like_normal_icon_color'] ? self::$datebook_options['like_normal_icon_color'] : 'rgb(0, 152, 255)';
								$like_added_icon_color = self::$datebook_options['like_added_icon_color'] ? self::$datebook_options['like_added_icon_color'] : 'rgb(0, 228, 54)';

								$likes_show_count = isset($enable_like_profiles['2']) && $enable_like_profiles['2'] == '1' ? 1 : 0;

								$profile_likes = isset($datebook_get_data['likes']['count']) && $datebook_get_data['likes']['count'] > 0 ? $datebook_get_data['likes']['count'] : 0;

								$like_options = array(
									'profile_id' => $profile_id,
									'currentauth_ID' => $currentauth_ID,
									'current_user_id' => $current_user_id,
									'profile_likes' => $profile_likes,
									'style' => $like_style,
									'normal_icon_color' => $like_normal_icon_color,
									'added_icon_color' => $like_added_icon_color,
									'show_count' => $likes_show_count,
									'what_page' => 1
								);

								echo DateBook_Profile_Edit::process_like_button($like_options);

							}

						if(isset(self::$datebook_options['enable_profile_matching']) && self::$datebook_options['enable_profile_matching'] == 1 && isset(self::$datebook_options['display_matching_place']) && self::$datebook_options['display_matching_place'] == 2 && $currentauth_ID > 0 && $currentauth_ID != $current_user_id && !is_super_admin()){

							$options['display_matching_place'] = isset(self::$datebook_options['display_matching_place']) ? self::$datebook_options['display_matching_place'] : 2;
							$options['split_progress_on_levels'] = isset(self::$datebook_options['split_progress_on_levels']) ? self::$datebook_options['split_progress_on_levels'] : 2;
							$options['matching_level_excellent'] = isset(self::$datebook_options['matching_level_excellent']) ? self::$datebook_options['matching_level_excellent'] : 90;
							$options['matching_level_very_good'] = isset(self::$datebook_options['matching_level_very_good']) ? self::$datebook_options['matching_level_very_good'] : 80;
							$options['matching_level_good'] = isset(self::$datebook_options['matching_level_good']) ? self::$datebook_options['matching_level_good'] : 60;
							$options['matching_level_fair'] = isset(self::$datebook_options['matching_level_fair']) ? self::$datebook_options['matching_level_fair'] : 50;

							echo DateBook_Matching::process_profile_matching($options);
						}

							echo '</p>';

						}


						if ($currentauth_ID > 0){

							echo '<p class="mb-3">';

							do_action('datebook_online_status', $currentauth_ID, $get_data_gender, 1, 'full');

							echo '</p>';

						}

						DateBook_Class_Reviews::datebook_reviews_stars($profile_id);

						?>

						<p class="mb-3">

							<?php 

							$show_comma = $show_zodiac = $show_sexualorientation = $show_gender = 0;

							if (DateBook_Utilities::datebook_show_field('sexualorientation', 1) && (self::$datebook_options['sexual_orientation_allowed'] != '' || self::$datebook_options['sexual_orientation_allowed_other_' . DATEBOOK_WPLANG] != '') && isset($datebook_get_data['sexualorientation'])) {

								$show_sexualorientation = 1;

							}

							if (DateBook_Utilities::datebook_show_field('gender', 1) && (self::$datebook_options['gender_allowed'] != '' || self::$datebook_options['gender_allowed_other_' . DATEBOOK_WPLANG] != '') && isset($get_data_gender) && $get_data_gender > 0) {

								$show_gender = 1;

							}

							if (DateBook_Utilities::datebook_show_field('birthdate', 1)) {

								$show_birthdate_to_admin = DateBook_Utilities::datebook_show_field('birthdate', 4) ? 1 : 0;

								if($show_birthdate_to_admin == 0 || is_super_admin()){

									if (isset($age) && !empty($age)) {

										echo esc_attr($age);

										$show_comma = 1;

									}

									if (self::$datebook_options['enable_hide_zodiac'] == 1){

										if ($get_data_hidezodiac == 0){

											if ($show_comma == 1) {
												echo ' ';
											}

											echo wp_specialchars_decode(esc_html(DateBook_Profile_Settings::datebook_zodiac($dateday, $datemonth)), ENT_QUOTES );
											$show_comma = 1;
											$show_zodiac = 1;

										}
									}
								}
							}


							if (isset($datebook_sexualorientation_titles[$sexualorientation])) {
							
								$show_sexualorientation_to_admin = DateBook_Utilities::datebook_show_field('sexualorientation', 4) ? 1 : 0;

								if($show_sexualorientation_to_admin == 0 || is_super_admin()){
								
									if ($show_sexualorientation == 1) {

										if ($show_zodiac == 1){
											echo ' ';
										} else if ($show_comma == 1){
											echo ', ';
										}

										$sexualorientation = $sexualorientation == 2 && isset($get_data_gender) && $get_data_gender > 0 ? $get_data_gender.$sexualorientation . '00' : $sexualorientation;
										
										if(isset($datebook_sexualorientation_titles[$sexualorientation]) && !empty($datebook_sexualorientation_titles[$sexualorientation])){

											echo esc_html__( $datebook_sexualorientation_titles[$sexualorientation], 'datebook' );

										}

										$show_comma = 1;

									}
								}
							}


							if ($show_gender == 1 && isset($datebook_gender_titles[$get_data_gender])) {

								$show_gender_to_admin = DateBook_Utilities::datebook_show_field('gender', 4) ? 1 : 0;

								if($show_gender_to_admin == 0 || is_super_admin()){
								
									$gender_title = esc_html__($datebook_gender_titles[$get_data_gender], 'datebook' );

									if ($show_comma == 1 && $gender_img == '') {
										echo ', <span title="' . esc_attr($gender_title) . '">' . esc_html($gender_title) . '</span>';
									} else if ($show_comma == 1) {
										echo ' <span title="' . esc_attr($gender_title) . '" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-original-title="' . esc_attr($gender_title) . '"><i class="' . esc_attr($gender_icon) . '"></i></span>';
									}
								}
							}

							?>

						</p>

						<?php

						if (DateBook_Utilities::datebook_show_field('countrycity', 1) && isset($city) && strlen($city) > 0 && isset($country) && strlen($country) > 0) {

							$show_city_to_admin = DateBook_Utilities::datebook_show_field('countrycity', 4) ? 1 : 0;

							if($show_city_to_admin == 0 || is_super_admin()){
							
							 ?>

							<p class="mb-3" title="<?php echo esc_attr($city . ', ' . $region . ', ' . $country); ?>"><?php echo esc_attr($city . ', ' . $country); ?></p>

						<?php

							}
						}

						if ($can_see_profile == 1){

							if ($enable_phone == 1 && DateBook_Utilities::datebook_show_field('phone', 1)) {

								if (isset($datebook_get_data['phone']) && !empty($datebook_get_data['phone'])) {

									$show_phone_to_admin = DateBook_Utilities::datebook_show_field('phone', 4) ? 1 : 0;

									if($show_phone_to_admin == 0 || is_super_admin()){

										echo '<p><i class="fas fa-mobile-alt"></i> ' . esc_attr($datebook_get_data['phone']) . '</p>';

									}
								}
							}

							if ($enter_website == 1 && DateBook_Utilities::datebook_show_field('website', 1) && isset($datebook_get_data['website']) && !empty($datebook_get_data['website'])) {

								$show_website_to_admin = DateBook_Utilities::datebook_show_field('website', 4) ? 1 : 0;

								if($show_website_to_admin == 0 || is_super_admin()){

									echo '<p><i class="fas fa-link"></i> <a rel=”nofollow” href="' . esc_url($datebook_get_data['website']) . '" target="_blank">' .  esc_html__( 'Website', 'datebook' ) . '</a></p>';
									
								}
							}
							
						}
						
						$hide_buttons_to_owner = (is_user_logged_in() && $currentauth_ID > 0 && isset($current_user_id) && $current_user_id > 0 && $currentauth_ID == $current_user_id && self::$datebook_options['hide_buttons_to_owner'] == '1') ? 1 : 0;

						if($hide_buttons_to_owner == 0) { ?>
						
						<div id="datebook-login" class="mb-3 datebook-contact-block">

							<?php if (self::$datebook_options['contact_method'] == '1' || (self::$datebook_options['contact_method'] == '3' && self::$datebook_options['chat_placement'] == '1')) { ?>

								<a <?php 

									if (is_user_logged_in() && $currentauth_ID > 0 && isset($current_user_id) && $current_user_id > 0) {

										$open_message_new_window = self::$datebook_options['open_message_new_window'] ? (DateBook_Utilities::mobile_detect() == 'mobile' ? 0 : 1) : 0;

										if ($open_message_new_window == 1) {

											echo 'id="datebook-chatpopup" onclick="return false;" ';

										}

										$my_messages_page_url = add_query_arg( array(
											'action' => 'read',
											'sid' => $currentauth_ID,
											'rid' => absint($current_user_id)
										), get_permalink(self::$datebook_options['my_messages_page']) );

										echo 'href="' . esc_url($my_messages_page_url) . '"';

									} else {

										echo 'target="_blank" data-toggle="tooltip" data-placement="top" data-original-title="' .  esc_html__( 'Login to write a message', 'datebook' ) . '" href="' . esc_url(get_permalink(self::$datebook_options['login_page'])) . '"';

									} ?> class="btn btn-primary btn-message m-0 pl-4 pr-4"><i class="fas fa-envelope fa-lg mr-1"></i> <?php esc_html_e( 'Write a message', 'datebook' ); ?></a>

							<?php } else if (self::$datebook_options['contact_method'] == '2') { ?>

								<div id="datebook-emailpopup" class="btn-group" role="group">
									<div class="btn-group" role="group">
										<button id="DateBookContactBtnGroupDrop" type="button" class="btn btn-primary btn-message ml-0 mr-0 dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-envelope mr-2"></i> <?php esc_html_e( 'Write a message', 'datebook' ); ?></button>
										<?php /*?><button data-toggle="dropdown" class="btn btn-lg btn-primary btn-message dropdown-toggle datebook-emailpopup" type="button">

										<?php

										if (isset($datebook_alert_error) && $_POST['action'] == "contacting") {
											echo '<span>&#x25B2;</span>';
										} else {
											echo '<span>&#x25BC;</span>';
										}

										?>

										</button><?php */?>

										<div class="dropdown-menu datebook-dropdown-menu" aria-labelledby="DateBookContactBtnGroupDrop" <?php if (isset($datebook_alert_error) && $_POST['action'] == "contacting") { echo ' style="display: block;"'; } ?>>

											<?php include DateBook_Template_Loader::locate( 'profile/profile-contact-form' ); ?>

										</div>
									</div>
								</div>

								<?php } ?>

								<?php

								$profile_friends = isset($datebook_get_data['friends']) && $datebook_get_data['friends'] > 0 ? $datebook_get_data['friends'] : array(0);

								echo DateBook_Profile_Friends::process_friend_button($profile_id, $currentauth_ID, $current_user_id, $profile_friends);

								if (self::$datebook_options['contact_method'] == '3' && self::$datebook_options['chat_placement'] == '2') {

									// If profile ID is not set in post_meta table then let's insert it
									$profile_id_of_current_user = get_user_meta( $current_user_id, 'profile_postid', true );

									if($profile_id != $profile_id_of_current_user){

										$chat_shortcode = str_replace('profile_id', $profile_id + ($profile_id_of_current_user . '_' . $current_user_id) + ($currentauth_ID . '_' . $profile_id) + $current_user_id + $profile_id_of_current_user + $currentauth_ID, of_get_option('chat_shortcode'));

										echo do_shortcode(wp_specialchars_decode(esc_html($chat_shortcode), ENT_QUOTES ));

									}

								} ?>

							</div>

							<?php } ?>
							
					<?php

					$profile_active = '';
					$photos_active = '';
					$friends_active = '';
					$comments_active = '';
					$reviews_active = '';

					switch ($show_tab) {
						case 'profile' : $profile_active = ' active'; break;
						case 'photos'  : $photos_active = ' active'; break;
						case 'friends'  : $friends_active = ' active'; break;
						case 'comments' : $comments_active = ' active'; break;
						case 'reviews' : $reviews_active = ' active'; break;
						default: $profile_active = ' active'; break;
					}
					
					$profile_photos_url = add_query_arg( array(
						'show' => 'photos'
					), $profile_page_url );
					
					$profile_friends_url = add_query_arg( array(
						'show' => 'friends'
					), $profile_page_url );
					
					$profile_comments_url = add_query_arg( array(
						'show' => 'comments'
					), $profile_page_url );

					$profile_reviews_url = add_query_arg( array(
						'show' => 'reviews'
					), $profile_page_url );

					?>

					<ul class="nav nav-pills nav-justified pills-primary mt-4 mb-3 datebook-standard-tabs datebook-profile-tabs">
						<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap <?php echo esc_attr(sanitize_html_class($profile_active)); ?>" href="<?php echo esc_url($profile_page_url); ?>"><small><?php esc_html_e( 'Profile', 'datebook' );?></small></a></li>
						<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap <?php echo esc_attr(sanitize_html_class($photos_active)); ?>" href="<?php echo esc_url($profile_photos_url); ?>"><small><?php esc_html_e( 'Photos', 'datebook' );?></small><span class="badge badge-pill badge-light datebook-badge-info shadow-none"><?php echo absint($all_count_photos); ?></span></a></li>

						<?php

						if (self::$datebook_options['enable_friendship'] == '1') {

							$show_amount_of_friends = self::$datebook_options['show_amount_of_friends'] ? 1 : 0;

							$get_profile_friends = DateBook_Profile_Friends::get_profile_friends($currentauth_ID);
							
							?>

							<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap <?php echo esc_attr(sanitize_html_class($friends_active)); ?>" href="<?php echo esc_url($profile_friends_url); ?>"><small><?php esc_html_e( 'Friends', 'datebook' );?></small><?php if ($show_amount_of_friends == 1){ ?><span class="badge badge-pill badge-light shadow-none datebook-badge-info datebook-friends-counter"><?php echo absint($get_profile_friends['count_friends']); ?></span><?php } ?></a></li>

						<?php } ?>

						<?php if (self::$datebook_options['enable_profile_comments'] == '1') { ?>

							<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap <?php echo esc_attr(sanitize_html_class($comments_active)); ?>" href="<?php echo esc_url($profile_comments_url); ?>"><small><?php esc_html_e( 'Comments', 'datebook' );?></small><span class="badge badge-pill badge-light datebook-badge-info shadow-none"><?php echo absint(DateBook_Utilities::datebook_count_profile_comments($profile_id)); ?></span></a></li>

						<?php } ?>

						<?php if (self::$datebook_options['enable_reviews'] == '1') { ?>

							<li class="nav-item"><a class="nav-link pl-1 pr-1 text-nowrap <?php echo esc_attr(sanitize_html_class($reviews_active)); ?>" href="<?php echo esc_url($profile_reviews_url); ?>"><small><?php esc_html_e( 'Reviews', 'datebook' );?></small><span class="badge badge-pill badge-light datebook-badge-info shadow-none"><?php echo absint(DateBook_Utilities::datebook_count_profile_reviews($profile_id)); ?></span></a></li>

						<?php } ?>

					</ul>


					</div>
					
					</div>


					<?php
					
					if ($can_see_profile == 1){
					
					if (isset($_GET['show']) && $_GET['show'] == 'friends') {

							// Display comments and comment form
							if (self::$datebook_options['enable_friendship'] == '1') {
								
								$options['get_approved_friends_ids'] = $get_profile_friends['all_approved_friends'];

								DateBook_Profile_Friends::process_friends_list($options);

							}

					} else if (isset($_GET['show']) && $_GET['show'] == 'comments') {

							// Display comments and comment form
							if (self::$datebook_options['enable_profile_comments'] == '1') {

								do_action('datebook_comment_form');

							}

					} else if (isset($_GET['show']) && $_GET['show'] == 'reviews') {

							// Display comments and comment form
							if (self::$datebook_options['enable_reviews'] == '1') {

								do_action('datebook_reviews');

							}

					} else if (isset($_GET['show']) && $_GET['show'] == 'photos') {

							echo '<h2 class="mb-4">' . esc_html__( 'My photos', 'datebook' );

							if (is_user_logged_in() && $currentauth_ID > 0 && $currentauth_ID == $current_user_id ) {
								echo '<a class="btn btn-sm btn-default float-right" href="' . esc_url(get_permalink(self::$datebook_options['my_photos_page'])) . '"><i class="fa fa-image mr-1"></i> ' . esc_html__( 'Add photo', 'datebook' ) . '</a>';
							}

							echo '</h2>';

							echo '<figure id="blueimp-gallery-links" class="datebook-gallery">';
							echo '<ul class="list-inline">';

							$count_all_photos = 0;

							$blur_variant = of_get_option('blur_variant') ? of_get_option('blur_variant') : 0;
							
							$thumb_noimage_name = str_replace('_','-', 'image_gallery');
							if ($get_data_gender == 1) {
								$gender_img = '-f';
							} else if ($get_data_gender == 2) {
								$gender_img = '-m';
							} else {
								$gender_img = '-m';
							}
							
							$no_thumbnail = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';
							$no_thumbnail_blur = DATEBOOK_URL . 'assets/images/no-blur-image/no-blur-' . $thumb_noimage_name . '' . $gender_img . '-1.jpg';

							if($can_see_images == 0){

								global $wp_filesystem;
								
								$assets_blur_folder = DATEBOOK_DIR . 'assets/images/no-blur-image/';
								if(!function_exists('WP_Filesystem')){
									require_once(ABSPATH . 'wp-admin/includes/file.php');
								}
								WP_Filesystem();

								$filelist = $wp_filesystem->dirlist($assets_blur_folder);

								foreach($filelist as $i => $file){
									$pos = strpos($file['name'], $thumb_noimage_name . $gender_img);
									if ($pos !== false){
										$no_blur_image_array[] = $file['name'];
									}
								}
							}


							while ( $all_photos->have_posts() ) : $all_photos->the_post();

								$photo_url = explode('.', get_the_title());
								$thumbnail_file = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_gallery']['width'].'x' . $datebook_image_sizes['image_gallery']['height']) . '.' . strtolower($photo_url[1]);
								$thumbnail_file_blur = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_gallery']['width'].'x' . $datebook_image_sizes['image_gallery']['height'] . '-blur') . '.' . strtolower($photo_url[1]);
								
								if(isset($no_blur_image_array) && is_array($no_blur_image_array) && !empty($no_blur_image_array)){
									$no_image_rand = $no_blur_image_array[ rand( 0, ( sizeof($no_blur_image_array) -1 ) ) ];
									$no_thumbnail_blur = DATEBOOK_URL . 'assets/images/no-blur-image/' . $no_image_rand;
								}

								if (!file_exists($targetPath . '/' . $thumbnail_file)) {

									if (!file_exists( $targetPath . '/' . get_the_title() )) {

										$thumb_noimage_name = str_replace('_','-', 'image_gallery');

										$thumbnail_url = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';

									} else {

										$image = wp_get_image_editor( $targetPath . '/' . get_the_title() );
										if ( ! is_wp_error( $image ) ) {
											$image->resize( $datebook_image_sizes['image_gallery']['width'], $datebook_image_sizes['image_gallery']['height'], true );
											$image->save($targetPath . '/' . $thumbnail_file);

											// Create and blur a new image
											if($blur_variant > 0){
												$image->save($targetPath . '/' . $thumbnail_file_blur);
												$image->add_blur($targetPath . '/' . $thumbnail_file_blur);
											}
										}
									}

									$thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_file;
									$thumbnail_url_blur = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_file_blur;

								} else {

									$thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_file;
									$thumbnail_url_blur = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $thumbnail_file_blur;

								}

								$thumbnail_url = $can_see_images === 1 ? $thumbnail_url : ($blur_variant > 0 ? $thumbnail_url_blur : $no_thumbnail_blur);

								if (file_exists($targetPath . '/' . $thumbnail_file)) {

									$count_all_photos++;

									$big_thumbnail_url = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_big']['width'] . 'x' . $datebook_image_sizes['image_big']['height']) . '.' . strtolower($photo_url[1]);
									$big_thumbnail_url_blur = DateBook_Utilities::datebook_encode($photo_url[0] . '-' . $datebook_image_sizes['image_big']['width'].'x' . $datebook_image_sizes['image_big']['height'] . '-blur') . '.' . strtolower($photo_url[1]);

									if (!file_exists($targetPath . '/' . $big_thumbnail_url)) {

										if (!file_exists( $targetPath . '/' . get_the_title() )) {

											$thumb_noimage_name = str_replace('_','-', 'image_avatar');

											$big_thumbnail_url = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';
											$big_thumbnail_url_blur = DATEBOOK_URL . 'assets/images/no-' . $thumb_noimage_name . '' . $gender_img . '.png';

										} else {

											$image = wp_get_image_editor( $targetPath . '/' . get_the_title() );
											if ( ! is_wp_error( $image ) ) {
												$image->resize($datebook_image_sizes['image_big']['width'], $datebook_image_sizes['image_big']['height'], true);
												$image->add_watermark($datebook_image_sizes['image_big']['width'], $datebook_image_sizes['image_big']['height']);
												$image->save($targetPath . '/' . $big_thumbnail_url);

												// Create and blur a new image
												$image->save($targetPath . '/' . $big_thumbnail_url_blur);
												$image->add_blur($targetPath . '/' . $big_thumbnail_url_blur);
											}
										}

										$big_thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_url;
										$big_thumbnail_url_blur = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_url_blur;

									} else {

										$big_thumbnail_url = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_url;
										$big_thumbnail_url_blur = $upload_dir['baseurl'] . '/' . $upload_folder . '/' . $big_thumbnail_url_blur;

									}

									$big_thumbnail_url = ($can_see_images == 1 ? $big_thumbnail_url : $big_thumbnail_url_blur);
									
									echo '<li class="list-inline-item">';

									if ($can_see_images === 1 || $can_see_images === 0 && $blur_variant > 0){
										echo '<a class="img-fluid" href="' . esc_url($big_thumbnail_url) . '" data-lightbox="example-1">';
									}

									echo '<img class="img-thumbnail" src="' . esc_url($thumbnail_url) . '" alt="' . esc_attr(get_the_title()) . '" width="' . $datebook_image_sizes['image_gallery']['width'] . '" height="' . $datebook_image_sizes['image_gallery']['height'] . '" />';

									if ($can_see_images === 0 && $blur_variant > 0){
										echo '</a>';
									}

									echo '</li>';
								}

							endwhile;

							echo '</ul>';

							echo '</figure>';

							echo '<div id="blueimp-gallery" class="blueimp-gallery blueimp-gallery-controls" style="display:none">';
							echo '<div class="slides"></div>';
							echo '<h3 class="title"></h3>';
							echo '<a class="prev">‹</a>';
							echo '<a class="next">›</a>';
							echo '<a class="close">×</a>';
							echo '<a class="play-pause"></a>';
							echo '<ol class="indicator"></ol>';
							echo '</div>';
							
							if ($count_all_photos == 0) {
								
							?>

								<div class="card border-0">
									<div class="card-body text-center">

										<h4 class="card-title"><?php esc_html_e( 'No photos', 'datebook' ); ?></h4>

									</div>
                                    
									<img class="card-img-top" src="<?php echo esc_url(DATEBOOK_URL . 'assets/images/icon-profile-no-photos.png');?>" alt="" />
                                    
								</div>
								
							<?php

							}

						} else {


							/*if (DateBook_Utilities::datebook_show_field('aboutyou', 1)){

								$show_aboutyou_to_admin = DateBook_Utilities::datebook_show_field('aboutyou', 4) ? 1 : 0;

								if($show_aboutyou_to_admin == 0 || is_super_admin()){

									if ($can_see_profile == 1) {

										if (strlen($profile_content) > 220){
											$datebook_description_long = 1;
											$datebook_description_class = 'datebook-reveal-closed';
										} else {
											$datebook_description_long = 0;
											$datebook_description_class = '';
										}

										?>

										<div id="datebook-mainaboutme" class="card card-body bg-white shadow-sm rounded mb-2 datebook-aboutme datebook-more datebook-main-reveal">
											<div class="<?php echo sanitize_html_class($datebook_description_class); ?>">

												<?php echo wpautop(esc_textarea($profile_content)); ?>

											</div>

											<?php if ($datebook_description_long == 1) { ?>

												<div class="datebook-openabout"><span class="btn btn-sm btn-light shadow-none datebook-aboutme-more"><?php esc_html_e( 'open', 'datebook' );?></span></div>
												<div class="datebook-closeabout"><span class="btn btn-sm btn-light shadow-none datebook-aboutme-more"><?php esc_html_e( 'close', 'datebook' );?></span></div>

											<?php } ?>
								
										</div>
									
									<?php } else { ?>

										<div class="alert alert-info shadow rounded mb-2">

											<?php echo esc_attr($can_see_profile_text); ?>

										</div>

									<?php } } }*/ ?>


							<?php if ($wishtravel) { ?>

							<div class="datebook-addedtours mb-4">
								<div class="card border datebook-transparent datebook-where-i-go-tours">
									<div class="card-body">
										<h4><?php esc_html_e( 'Ready to travel', 'datebook' ); ?> <small><i class="fa fa-suitcase"></i></small></h4>
										
										<?php if ($wishtraveltext) { ?>

											<p class="card-text m-0"><em><?php echo esc_html($wishtraveltext); ?></em></p>

										<?php } ?>

									
										<?php

									$args = array(
										'post_type' => DATEBOOK_TOUR_TYPE,
										'post_status' => 'publish',
										'posts_per_page' => -1,
										'orderby' => 'start',
										'order' => 'ASC',
										'meta_key' => 'start',
										'meta_query' => array(
											array('key' => 'profile_tour_id', 'value' => $profile_id, 'compare' => '='),
											array('key' => 'end', 'value' => mktime(23, 59, 59, date("m"), date("d"), date("Y")), 'compare' => '>=')
										)
									);

									$the_query = new WP_Query( $args );

									if ($the_query->have_posts()) :

									?>
								
									<hr />

									<div class="datebook-addedtours">
										
										<h5><?php esc_html_e( 'Where I would like to go on travels', 'datebook' ); ?></h5>

									<?php

									while ( $the_query->have_posts() ) : $the_query->the_post();

									unset($city, $country);

									$city_id = get_post_meta(get_the_ID(), 'city', true);
									
									if(isset($city_id)){

										$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city_id );
										$country = isset($term_data->country) ? $term_data->country : '';
										$city = isset($term_data->city) ? $term_data->city : '';

									}

									$day_start = get_post_meta($profile_id,'start', true);
									$day_end = get_post_meta($profile_id,'end', true);
									$tour_active = '';

									if (time() > $day_start && time() < $day_end) {
										$tour_active = " success";
									}

									?>

										<div class="row datebook-margin-top20">
										<div class="col-lg-5 col-md-5 col-sm-12"> 
											<strong><?php esc_html_e( 'When', 'datebook' ); ?>:</strong> <?php echo esc_attr(date("d M Y", get_post_meta(get_the_ID(),'start', true))); ?> - <?php echo esc_attr(date("d M Y", get_post_meta(get_the_ID(),'end', true))); ?>

											<div class="datebook-clear5"></div>

											<strong><?php esc_html_e( 'Where', 'datebook' ); ?>:</strong> <?php echo esc_attr($city).", ".esc_attr($country); ?>

										</div>
										<div class="col-lg-7 col-md-7 col-sm-12 text-italic datebook-more" data-textlimit="170"> 

											<?php echo esc_html(get_the_content()); ?>
										
										</div>
										</div>

										<?php endwhile; ?>

									</div>

								<?php

								endif;

								wp_reset_postdata();

								?>

								</div>
							</div>
						</div>

					<?php } ?>
					
					<?php

					if ($currentauth_ID > 0) {

						global $allowedposttags;
						
						if(isset($profile_id) && $profile_id > 0){
							$terms = wp_get_object_terms( $profile_id, DATEBOOK_PROFILES_TAX, array( 'fields' => 'ids' ) );
							if(isset($terms[0])){
								$term_category = get_term_meta( $terms[0], 'profile_formname', true );
							}
						}
						$profile_form = isset($term_category) && !empty($term_category) ? $term_category : 'profile_form';

						// Escape all fields but keep HTML tags
						echo wp_kses(stripslashes_deep(DateBook_Forms::show_filled_fields($profile_form, $profile_edit_form_data, $currentauth_ID, $current_user_id)), $allowedposttags );

					}

				}

				} else {

					?>

					<div class="alert alert-info">

						<?php echo esc_attr($can_see_profile_text); ?>

					</div>
					
					
					<?php
					
					
				}

				wp_reset_postdata();

				?>

			</div>
				
			<?php

			$additional_profile_info = self::$datebook_options['show_profile_statistic'];
				
			if ($profile_views != '' || $additional_profile_info['2'] == 1 || $additional_profile_info['3'] == 1 || $additional_profile_info['4'] == 1) {

			?>

				<div class="card-footer border-light small datebook-profile-otherdetails">

				<?php
				
				global $allowedposttags;

				echo wp_kses($profile_views, $allowedposttags );

				if ($profile_views != '' && $additional_profile_info['2'] == 1) {
					echo ' | ';
				}	

				if ($additional_profile_info['2'] == 1) {
					echo esc_html__( 'Joined on', 'datebook' ) . ': ' . esc_attr($added_date);
				}
				
				if ($additional_profile_info['3'] == 1) {
					echo '<span class="float-right ml-2">';
					echo esc_html__( 'ID', 'datebook' ) . ': ' . esc_attr($profile_post_name) . ' ';
					echo '</span>';
				}

				if ($enable_blacklisted_profiles == '1' && !is_super_admin()) {

					if (in_array($profile_id, $data_array)) {
	
						echo '<a class="btn btn-danger small shadow-none m-0 p-0 pr-2 pl-2 float-right datebook-blacklist-actions datebook-blacklist-' . absint($profile_id) . '" profile-id="' . absint($profile_id) . '" onClick="return false;" href="javascript:void(0)">' . esc_html__( 'Blocked', 'datebook' ) . '</a>';

					} else {

						echo '<a class="btn btn-light small shadow-none m-0 p-0 pr-2 pl-2 float-right datebook-blacklist-actions datebook-blacklist-' . absint($profile_id) . '" profile-id="' . absint($profile_id) . '" onClick="return false;" href="javascript:void(0)">' . esc_html__( 'Block', 'datebook' ) . '</a>';

					}
				}

				if ($additional_profile_info['4'] == 1) {
					// Display Social buttons
					include DateBook_Template_Loader::locate( 'profile/profile-social-buttons' );
				}

				?>

				</div>

			<?php } ?>

		</div>

		<?php

		if(isset(self::$datebook_options['enable_profile_matching']) && self::$datebook_options['enable_profile_matching'] == 1 && isset(self::$datebook_options['display_matching_place']) && self::$datebook_options['display_matching_place'] == 3 && $currentauth_ID > 0 && $currentauth_ID != $current_user_id && !is_super_admin()){
			$options['display_matching_place'] = isset(self::$datebook_options['display_matching_place']) ? self::$datebook_options['display_matching_place'] : 3;
			$options['split_progress_on_levels'] = isset(self::$datebook_options['split_progress_on_levels']) ? self::$datebook_options['split_progress_on_levels'] : 2;
			$options['matching_level_excellent'] = isset(self::$datebook_options['matching_level_excellent']) ? self::$datebook_options['matching_level_excellent'] : 90;
			$options['matching_level_very_good'] = isset(self::$datebook_options['matching_level_very_good']) ? self::$datebook_options['matching_level_very_good'] : 80;
			$options['matching_level_good'] = isset(self::$datebook_options['matching_level_good']) ? self::$datebook_options['matching_level_good'] : 60;
			$options['matching_level_fair'] = isset(self::$datebook_options['matching_level_fair']) ? self::$datebook_options['matching_level_fair'] : 50;

			echo DateBook_Matching::process_profile_matching($options);
		}

		?>

	</div>
</article>