<?php
/*
 * Search form
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wpdb, $datebook_gender_titles;

$count_genders = 0;

if (DateBook_Utilities::datebook_show_field('gender', 1) && DateBook_Utilities::datebook_show_field('gender', 3) && of_get_option('gender_allowed') != '') {

	$allowed_gender = of_get_option('gender_allowed');

	// Add custom Genders
	if (of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '') {
		$allowed_gender_other_array = explode('<br />', strtr(of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG), array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

		foreach ($allowed_gender_other_array as $key => $value ){
			$allowed_gender[] = 1;
		}
	}

	if(is_array($allowed_gender)){
		$count_genders = count( array_keys( $allowed_gender, 1 )); // count active genders
	} else {
		$count_genders = 0;
	}

}

$enable_birthdate = (DateBook_Utilities::datebook_show_field('birthdate', 1) && DateBook_Utilities::datebook_show_field('birthdate', 3)) ? 1 : 0;

$enable_location = (DateBook_Utilities::datebook_show_field('countrycity', 1) && DateBook_Utilities::datebook_show_field('countrycity', 3));

	

	$datebook_field_titles = get_query_var( 'datebook_field_titles' );
	if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

	$page_id = get_the_ID();

	$is_front_page = is_front_page() ? 1 : 0;

	if(of_get_option('search_align_front') == 'right'){
		$search_align_front = 'ml-auto';
	} else if(of_get_option('search_align_front') == 'center'){
		$search_align_front = 'm-auto';
	} else if(of_get_option('search_align_front') == 'left'){
		$search_align_front = 'mr-auto';
	} else {
		$search_align_front = 'm-auto';
	}

	if ($page_id == of_get_option('search_results_page')) {
		$searchform_class = 'datebook-search-other';
		$searchform_max_width = '';
	} else {
		$searchform_class = 'datebook-search-front';
		$searchform_max_width = of_get_option('searchform_max_width') ? 'max-width:' . of_get_option('searchform_max_width') : '';
	}
	
	?>

	<div class="datebook-search-panel">
		<div class="datebook-search-form datebook-search-form-v">
			<div class="card border-0 <?php echo esc_attr($searchform_class . ' ' . $search_align_front); ?> datebook-transparent" style=" <?php echo esc_attr($searchform_max_width); ?>">

			<?php if ($page_id == of_get_option('search_results_page') || $showtitle == 1) { ?>

				<div class="card-header datebook-transparent">

					<h3><?php esc_html_e( 'Search', 'datebook' ); ?></h3>

				</div>

			<?php } ?>

			<div class="card-body">

				<form action="<?php echo esc_url(get_permalink(of_get_option('search_results_page'))); ?>" method="post">

		            <input type="hidden" name="action" value="searchprofiles" />
	    	        <input type="hidden" name="referrer" value="searchform" />

					<div class="form-group datebook-search-firstpart">

						<label class="datebook-label-title"><?php esc_html_e( 'I am looking for', 'datebook' ); ?></label>

						<div class="clear"></div>

						<div class="btn-group d-flex btn-group-toggle" data-toggle="buttons">

						<?php

						if ($count_genders > 0) {

							$search_gender = isset($_REQUEST['gender']) ? $_REQUEST['gender'] : 0;

							if(isset($count_genders) && $count_genders > 2 ) {

								echo '<select class="custom-select form-control datebook-search-btn" name="gender">';

								echo '<option value="0">' . esc_html__( 'Someone', 'datebook' ) . '</option>';

							}
						
							foreach ($datebook_gender_titles as $key => $gender_name) {

								if(isset($allowed_gender[$key]) && $allowed_gender[$key] == 1){

									$gender_active = '';
									$gender_selected = '';
									$gender_checked = '';
									$gender_icon = '';

									// Set icon
									if ($key == 1) {
										$gender_icon = 'female';
									} else if ($key == 2) {
										$gender_icon = 'male';
									}

									if ($search_gender > 0) {

										if ($key == $search_gender) {
											$gender_active = ' active';
											$gender_selected = ' selected="selected"';
											$gender_checked = 'checked';
										}

									} else if ($is_front_page == 1) {
										if ($key == 1) {
											$gender_active = ' active';
											$gender_selected = ' selected="selected"';
											$gender_checked = 'checked';
										} else {
											$gender_active = '';
											$gender_selected = '';
											$gender_checked = '';
										}
									}

									if(isset($count_genders) && $count_genders > 2 ) {

										echo '<option value="' . sanitize_key($key) . '" ' . esc_attr($gender_selected) . '>' . esc_html__( $gender_name, 'datebook' ) . '</option>';

									} else {

										echo '<label class="btn datebook-search-gender waves-effect w-100 ' . esc_attr($gender_active) . ' datebook-search-btn" title="' . esc_html__( $gender_name, 'datebook' ) . '">';

										if (isset($gender_icon)) {

											echo '<i class="fas fa-' . esc_attr($gender_icon) . ' fa-lg mr-1"></i>';

										}

										echo '<input type="radio" name="gender" class="datebook-gender" value="' . sanitize_key($key) . '" ' . esc_attr($gender_checked) . ' /> <span class="align-middle">' . esc_html__( $gender_name, 'datebook' ) . '</span></label>';

									}

								}

							}

							if(isset($count_genders) && $count_genders > 2 ) {

								echo '</select>';

							}

						} else {

							echo '<label class="btn w-100 datebook-search-gender datebook-search-btn" title="' . esc_html__( 'Someone', 'datebook' ) . '"><input type="radio" name="gender" class="datebook-gender" value="0"> <span class="align-middle">' . esc_html__( 'Someone', 'datebook' ) . '</span></label>';
						}

						?>

					</div>

					<div class="datebook-clear20"></div>
					
					<?php if ($enable_birthdate == 1) { ?>
					
					<div class="form-group pr-0 pl-0">
					
						<div id="datebook-agebox" class="datebook-age-form">

							<label for="datebook-agerange" class="datebook-label-title"><?php esc_html_e( 'between age', 'datebook' ); ?></label>

							<?php 

							$register_age_min = of_get_option('register_age_min') > 0 ? of_get_option('register_age_min') : 18;
							$register_age_max = of_get_option('register_age_max') > 0 ? of_get_option('register_age_max') : 80;
						
							$agefrom = isset($_REQUEST['agefrom']) ? $_REQUEST['agefrom'] : $register_age_min;
							$ageto = isset($_REQUEST['ageto']) ? $_REQUEST['ageto'] : $register_age_max;

							$agerange = $agefrom . ' - ' . $ageto;
							
							$age_range_layout = ($is_front_page == 1 && of_get_option( 'age_range_front' ) == 'ionrangeslider') || ($is_front_page == 0 && of_get_option( 'age_range_other' ) == 'ionrangeslider') ? 1 : (($is_front_page == 1 && of_get_option( 'age_range_front' ) == 'selector') || ($is_front_page == 0 && of_get_option( 'age_range_other' ) == 'selector') ? 2 : 1);

							//(a ? b : c) ? d : e
							//a ? b : (c ? d : e)

							if ($age_range_layout == 1) {

							?>
						
								<input type="text" id="datebook-agerange" name="agerange" value="<?php echo esc_attr($agerange);?>" class="form-control form-control-sm border-0 datebook-input-age datebook-search-btn" />
						
							<?php } else if ($age_range_layout == 2) { ?>

								<div class="form-row">
									<div class="col">
										<select class="custom-select" name="agefrom">

										<?php

										for($i = $register_age_min; $i <= $register_age_max; $i++) {

											if ($i == $agefrom) { $selected_minage = ' selected'; } else { $selected_minage = ''; }

											echo '<option value="' . esc_attr($i) . '" ' . $selected_minage . '>' . esc_attr($i) . '</option>';

										}

										?>

										</select>
									</div>
									<div class="col">
										<select class="custom-select" name="ageto">

										<?php

										for($i = $register_age_min; $i <= $register_age_max; $i++) {
										
											if ($i == $ageto) { $selected_maxage = ' selected'; } else { $selected_maxage = ''; }

											echo '<option value="' . esc_attr($i) . '" ' . $selected_maxage . '>' . esc_attr($i) . '</option>';

										}

										?>

										</select>
									</div>
								</div>
							
							<?php } ?>
							
						</div>
					</div>

					<?php } ?>

					<?php if ($enable_location == 1) { ?>

						<label for="datebook-location" class="datebook-label-title"><?php esc_html_e( 'from', 'datebook' ); ?></label>

						<div class="clear"></div>

						<?php

						$search_countrycity = '';
						$city_id = '';
						$region_id = '';
						$country_id = '';

						$search_location = 0;

						if(isset($_REQUEST['city']) && $_REQUEST['city'] > 0){
							$search_location = $_REQUEST['city'];
							$deep_level = 1;
						} else if(isset($_REQUEST['region']) && $_REQUEST['region'] > 0){
							$search_location = $_REQUEST['region'];
							$deep_level = 2;
						} else if(isset($_REQUEST['country']) && $_REQUEST['country'] > 0){
							$search_location = $_REQUEST['country'];
							$deep_level = 3;
						}

						if($search_location > 0){

							$term_data = DateBook_Utilities::datebook_get_term_by('id', $search_location, $deep_level);

							$city_title = isset($term_data->city) ? $term_data->city : '';
							$city_id = isset($term_data->city_id) ? $term_data->city_id : '';

							$region_title = isset($term_data->region) ? $term_data->region : '';
							$region_id = isset($term_data->region_id) ? $term_data->region_id : '';

							$country_title = isset($term_data->country) ? $term_data->country : '';
							$country_id = isset($term_data->country_id) ? $term_data->country_id : '';
						
							if ($city_title){
								$search_countrycity .= $city_title . ', ';
							}

							if ($region_title){
								$search_countrycity .= $region_title . ', ';
							}

							if ($country_title){
								$search_countrycity .= $country_title;
							}

						}

						?>

						<input id="datebook-locationcountry" name="country" type="hidden" value="<?php echo esc_attr($country_id);?>" />
						<input id="datebook-locationregion" name="region" type="hidden" value="<?php echo esc_attr($region_id);?>" />
						<input id="datebook-locationcity" name="city" type="hidden" value="<?php echo esc_attr($city_id);?>" />

						<input id="datebook-location" name="countrycity" readonly type="text" class="form-control form-control-sm border-0 datebook-search-btn" value="<?php echo esc_attr($search_countrycity);?>" aria-label="<?php esc_html_e( 'Location', 'datebook' ); ?>" data-toggle="modal" data-target="#dbmodalcountriespanel" all-locations="<?php echo esc_attr($show_empty_countries); ?>" placeholder="<?php esc_html_e( 'Location', 'datebook' ); ?>" />

						<?php echo DateBook_Search::datebook_countries_popup('search_form_other', $show_empty_countries, 0, 'profile'); ?>

					<?php } ?>

					<?php if ($page_id != of_get_option('search_results_page')) { ?>

						<div class="datebook-clear10 d-block d-sm-none"></div>

						<div class="datebook-clear30"></div>

						<button id="datebook-searchbutton" type="submit" class="btn btn-block m-0 datebook-search-btn datebook-search-submit"><?php esc_html_e( 'Search', 'datebook' ); ?></button>

					<?php } ?>

					<?php if ($page_id == of_get_option('search_results_page')) { ?>
			
						<?php if (of_get_option('search_advanced_show') == 1) { ?>

							<div id="datebook-advancedsearch" class="collapse">

								<div class="form-row">

								<?php

								if (of_get_option('search_online_profiles') == 1) { 

									$search_online = isset($_REQUEST['online_status']) ? $_REQUEST['online_status'] : 0;

									?>

									<div class="col-lg-3 col-md-3 col-sm-3 mb-3">
				
										<div class="custom-control custom-checkbox">
											<input type="checkbox" name="online_status" class="custom-control-input datebook-online" id="datebook-online" value="1" <?php if ($search_online == 1) { echo ' checked="checked"'; }?>/>
											<label class="custom-control-label" for="datebook-online"><?php esc_html_e( 'Online', 'datebook' ); ?></label>
										</div>
						
									</div>

									<?php
				
								}


								if (DateBook_Utilities::datebook_show_field('sexualorientation', 1) && (of_get_option('sexual_orientation_allowed') != '' || of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '')) {

									if (DateBook_Utilities::datebook_show_field('sexualorientation', 3)) {

										$search_sexualorientation = isset($_REQUEST['sexualorientation']) ? $_REQUEST['sexualorientation'] : 0;

										?>

										<div class="col-lg-3 col-md-3 col-sm-3 mb-3">
					
											<div class="custom-control custom-radio">
												<input type="radio" id="datebook-sexualorientation0" name="sexualorientation" class="custom-control-input"  value="0"<?php if (isset($search_sexualorientation) && $search_sexualorientation < 1) { echo ' checked="checked"'; }?> />
												<label class="custom-control-label" for="datebook-sexualorientation0"><?php esc_html_e( 'Any', 'datebook' ); ?></label>
											</div>

											<?php 

											$allowed_sexual_orientation = of_get_option('sexual_orientation_allowed');
											
											// Add custom Sexual Orientations
											if (of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG) != '') {
												$sexual_orientation_allowed_other_array = explode('<br />', strtr(of_get_option('sexual_orientation_allowed_other_' . DATEBOOK_WPLANG), array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

												foreach ($sexual_orientation_allowed_other_array as $key => $value ){
													$allowed_sexual_orientation[] = 1;
												}
											}


											foreach ($datebook_sexualorientation_titles as $key => $value) {

												if(isset($allowed_sexual_orientation[$key]) && $allowed_sexual_orientation[$key] == 1){

												?>

												<div class="custom-control custom-radio">
													<input type="radio" id="datebook-sexualorientation<?php echo sanitize_key($key); ?>" name="sexualorientation" class="custom-control-input"  value="<?php echo sanitize_key($key); ?>"<?php if (isset($search_sexualorientation) && $search_sexualorientation == $key) { echo ' checked="checked"'; }?> />
													<label class="custom-control-label" for="datebook-sexualorientation<?php echo sanitize_key($key); ?>"><?php echo esc_html__( $value, 'datebook' ); ?></label>
												</div>

										<?php } } ?>

									</div>

								<?php } } ?>

								<?php if (of_get_option('search_by_profilename') == 1 || of_get_option('search_by_userid') == 1 ||of_get_option('search_by_username') == 1) { ?>

									<div class="col-lg-3 col-md-3 col-sm-3 mb-3">

									<?php

									if (of_get_option('search_by_profilename') == 1 || of_get_option('search_by_userid') == 1) {

										$search_profilename_title = '';

										if (of_get_option('search_by_profilename') == 1) {

											$search_profilename_title .= esc_html__( 'Name', 'datebook' );

										}
					
										if (of_get_option('search_by_profilename') == 1 || of_get_option('search_by_userid') == 1) {

											$search_profilename_title .= ' ' . esc_html__( 'or', 'datebook' );

										}

										if (of_get_option('search_by_userid') == 1) {

											$search_profilename_title .= ' ' . esc_html__( 'ID', 'datebook' );

										}

										$search_profilename = isset($_REQUEST['searchbyprofilename']) ? $_REQUEST['searchbyprofilename'] : '';

										?>

										<div class="mb-2">
											<input id="datebook-profilename" name="searchbyprofilename" type="text" placeholder="<?php echo esc_attr($search_profilename_title); ?>" class="form-control" value="<?php echo esc_attr($search_profilename);?>" />
										</div>

									<?php } ?>

									<?php

									if (of_get_option('search_by_username') == 1) {

										$search_username = isset($_REQUEST['searchbyusername']) ? $_REQUEST['searchbyusername'] : '';

										?>

										<input id="datebook-username" name="searchbyusername" type="text" placeholder="<?php esc_html_e( 'Username', 'datebook' ); ?>" class="form-control" value="<?php echo esc_attr($search_username);?>" />

									<?php } ?>

								</div>
				
							<?php } ?>

							</div>

						</div>

					<?php } ?>

					<div class="form-row datebook-search-lastpart">
						<div class="col-lg-10 col-md-10 col-sm-10">

						<?php if (of_get_option('search_advanced_show') == '1') { ?>
					
							<a class="btn btn-link btn-sm float-right" role="button" data-toggle="collapse" href="#datebook-advancedsearch" aria-expanded="false" aria-controls="datebook-advancedsearch"><?php esc_html_e( 'Advanced search', 'datebook' ); ?></a>
						
						<?php } ?>

						</div>
			
						<div class="datebook-clear10 d-block d-sm-none"></div>

						<div class="col-lg-2 col-md-2 col-sm-2">
							<button id="datebook-searchbutton" type="submit" class="btn btn-block m-0 datebook-search-btn datebook-search-submit"><?php esc_html_e( 'Search', 'datebook' ); ?></button>
						</div>
					</div>
			
					<?php } ?>
					
					</div>

				</form>

				</div>
			</div>
		</div>
	</div>