<?php
/**
 * Template part for displaying list of tours
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 */


$datebook_field_titles = get_query_var( 'datebook_field_titles' );
if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }

if ( isset($_POST['period']) && $_POST['period'] == 2 ) {

	$page_title = esc_html__( 'Starting soon', 'datebook' );

	$direction_meta_array = array(
			'key' => 'start',
			'value' => mktime(0, 0, 0, date("m"), date("d"), date("Y")),
			'compare' => '>=',
			'type' => 'NUMERIC'
	);

} else {

	$page_title = esc_html__( 'Happening now', 'datebook' );

	$direction_meta_array = array(
			'key' => 'end',
			'value' => mktime(23, 59, 59, date("m"), date("d"), date("Y")),
			'compare' => '>=',
			'type' => 'NUMERIC'
	);

}

$in_country_city = '';
$country = 0;

if (isset($_POST['country']) && $_POST['country'] != '') {

	$country = absint($_POST['country']);

	if ($country == '0') {
		unset($country);
	}

	if ($country || $city) {
		$in_country_city .= ' ' . esc_html__( 'in', 'datebook' );
	}
	
	if (isset($_POST['city']) && $_POST['city'] != '') {
		
		$city = absint($_POST['city']);
		if ($city == '0') {
			unset($city);
		}

		$term_data = DateBook_Utilities::datebook_get_term_by( 'id', $city );
		$country_name = isset($term_data->country) ? $term_data->country : '';
		$city_name = isset($term_data->city) ? $term_data->city : '';

		$in_country_city .= ' ' . $city_name;

		$in_country_city .= ',';

		$in_country_city .= ' ' . $country_name;

	}
}

?>

<h3><?php esc_html_e( 'They are looking for fellow travelers', 'datebook' ); ?> <?php echo esc_attr($in_country_city); ?></h3>

<?php

$main_tours_cat = '';
if ($country) {
	$main_tours_key = 'country';
	$main_tours_cat = $country;

	if (isset($_POST['city']) && $_POST['city'] != '') {
		$main_tours_key = 'city';
		$main_tours_cat = $city;
	}
}

$posts_per_page = of_get_option('tours_per_page') > 0 ? of_get_option('tours_per_page') : '20'; // show 20 tours by default if not set

if ( get_query_var( 'paged' ) ) {
	$paged = get_query_var( 'paged' );
} elseif ( get_query_var( 'page' ) ) {
	$paged = get_query_var( 'page' );
} else {
	$paged = 1;
}

if ($main_tours_cat) {
	$meta_country_array = array( 'key' => $main_tours_key, 'value' => $main_tours_cat, 'compare' => '=', 'type' => 'NUMERIC' );
} else {
	$meta_country_array = array();
}

$args = array(
	'post_type' => DATEBOOK_TOUR_TYPE,
	'meta_key' => 'start',
	'post_status' => 'publish',
	'orderby' => 'start',
	'order' => 'ASC',
	'paged' => $paged,
	'posts_per_page' => $posts_per_page,
	'meta_query' => array(
		$direction_meta_array,
		$meta_country_array
	)
);

$the_query = new WP_Query( $args );

if ( $the_query->have_posts() ) : 

	global $datebook_field_titles;
	set_query_var( 'datebook_field_titles', $datebook_field_titles );

	while ( $the_query->have_posts() ) : $the_query->the_post();

		// display the Edit Profile form
		echo DateBook_Template_Loader::load( 'tours/content-tour' );

	endwhile;

	$total = ceil($the_query->found_posts / $posts_per_page);

	$base = get_permalink(of_get_option('all_tours_page'));
	$format = get_option('permalink_structure') ? 'page/%#%/' : '?paged=%#%';

	if ($the_query->found_posts > $posts_per_page) { echo '<hr />'; }

		DateBook_Utilities::datebook_custom_pagination($total, $paged, $format, $base);

else:

	esc_html_e( 'No tours yet', 'datebook' );

endif;

wp_reset_postdata();