<?php
/*
 * Classifieds style 1
 */

if ($enabled_image == 1) {
	
	// Check if Retina enabled in Theme Options
	$enable_retina_images = of_get_option('enable_retina_images') ? 1 : 0;

	?>
	<div class="blue-grey lighten-5 datebook-author-image text-center">
		<a class="thumbnail" href="<?php echo esc_url(get_permalink($profile_classifieds_id)); ?>" title="<?php the_title(); ?>"><img class="rounded-circle" src="<?php echo esc_url( $thumbnail_url['img_full_url'] ); ?>" alt="" <?php if($enable_retina_images == 1) { ?>data-rjs="2"<?php } ?> /></a>
	</div>
<?php } ?>

<div class="card-body text-center">

	<?php if(isset($profile_title) && strlen($profile_title) > 1){ ?> 

	<h6 class="card-title datebook-profile-heading datebook-ellipsis">

		<a href="<?php echo esc_url(get_permalink($profile_classifieds_id)); ?>" title="<?php the_title(); ?>"><?php echo esc_attr($profile_title); ?></a>

		<?php if($show_age == 1){ ?>
		
			<span class="small"><span title="<?php echo esc_attr($age); ?> <?php esc_html_e( 'years old', 'datebook' ); ?>"><?php echo esc_attr($age); ?></span>
			
		<?php } ?>

		<?php if ($show_gender == 1 && $gender > 0 && isset($datebook_gender_titles[$gender]) && strlen($datebook_gender_titles[$gender]) > 0){ ?>
		
			<?php if($show_age == 1){ ?>, <?php } ?>

			<span title="<?php echo esc_html__( $datebook_gender_titles[$gender], 'datebook' ); ?>"><i class="<?php echo esc_attr($gender_icon); ?>"></i></span>
		<?php } ?>

		</span>

	</h6>

	<?php } ?> 

	<?php if ($show_location == 1 && (!empty($city) || !empty($country))) { ?>

		<p class="mb-1 small text-grey">

		<?php 

		if (isset($city)) {
			echo esc_attr($city);
		}
		if (!empty($city) && !empty($country)) {
			echo ', ';
		}
		if (isset($country)) {
			echo esc_attr($country);
		}

		?>

		</p>

	<?php } ?> 

	<?php if ($enabled_date == 1) { ?>

		<p class="mb-1 small text-grey" title="<?php esc_html_e( 'Date added', 'datebook' ); ?>"><i class="fa fa-clock-o"></i> <?php echo DateBook_Utilities::datebook_date_i18n(1, get_the_date(), true); ?></p>

	<?php } ?>

	<p class="card-text mb-0"><?php echo wp_trim_words(the_title('','',FALSE), 54, ''); ?></p>

	<a class="btn btn-secondary btn-sm" href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php esc_html_e( 'Read', 'datebook' ); ?></a>

</div>