<?php
/*
Template Name: Blog
*/

get_header();

if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
	$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-blogs' . $datebook_wplang ) ? 1 : 0;
} else {
	$datebook_is_active_sidebar = is_active_sidebar( 'datebook-blogs' ) ? 1 : 0;
}

?>

<!-- content -->
<div class="row">

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-9 col-md-12 col-sm-12 <?php echo esc_attr(DATEBOOK_CONTENT_SIDE); ?>">

	<?php else : ?>

	<div class="col-lg-12 col-md-12 col-sm-12 datebook-padding-less">

	<?php endif; ?>

		<?php do_action('datebook_profile_all_statuses'); ?>

		<div class="mb-5 datebook-blogs-page">

		<?php while (have_posts()) : the_post(); ?>

			<div class="datebook-custom-card card mb-3">
				<div class="card-body">

					<h1><?php the_title(); ?></h1>

					<?php the_content(); ?>

				</div>
			</div>

		<?php

		endwhile;

		wp_reset_postdata();

		$datebook_blog_style = get_theme_mod('datebook_blog_style', 1);

		if ($datebook_blog_style == 1) {

			$datebook_blog_content = '-horizontal';

			?>

			<div class="container datebook-blog-horizontal">
				<div class="row">

		<?php

		} else if ($datebook_blog_style == 2) {

			$datebook_blog_content = '-classic';

		?>

			<div class="datebook-blog-classic">
				<div class="row">

		<?php

		} else if ($datebook_blog_style == 3) {

			$datebook_blog_content = '-overlap';

		?>

			<div class="datebook-blog-overlap">
				<div class="row">

		<?php } else if ($datebook_blog_style == 4) {

			$datebook_blog_content = '';

		?>

			<div class="datebook-blog-masonry">
				<div class="card-columns">

		<?php } else if ($datebook_blog_style == 5) {

			$datebook_blog_content = '';

			?>

			<div class="datebook-blog-mdb-masonry">
				<div class="row masonry">
					<div class="grid-sizer col-md-3" style="display:none"></div>

		<?php } ?>

			<?php

			$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

			$args = array(
				'post_type' => 'post',
				'paged' => $paged
			);

			$wp_query = new WP_Query( $args );

			if ( $wp_query->have_posts() ) {

				while ( $wp_query->have_posts() ) {

					$wp_query->the_post();

					get_template_part( 'templates/content-list/content' . $datebook_blog_content, get_post_format() );

				}

			}

			?>

			</div>
		

			<?php

			get_template_part( 'templates/post', 'pager' );

			wp_reset_postdata();

			?>
		
		</div>
		</div>
	</div>

	<?php if ( $datebook_is_active_sidebar == 1 ) : ?>

	<div class="col-lg-3 col-md-12 col-sm-12 <?php echo esc_attr(DATEBOOK_SIDEBAR_SIDE); ?>">
		<div class="datebook-leftsidebar">

			<?php
			
			if (get_theme_mod( 'datebook_multilingual_enable') == '1') {
				$datebook_wplang = DATEBOOK_WPLANG == 'en_US' ? '' : '-' . strtolower(DATEBOOK_WPLANG);
				dynamic_sidebar('datebook-blogs' . $datebook_wplang);
			} else {
				dynamic_sidebar('datebook-blogs');
			}
			
			?>

		</div>
	</div>

	<?php endif; ?>

</div>
<!-- /content -->

<?php get_footer();