<?php
/**
 * The template part for displaying a message that posts cannot be found
 *
 * Learn more: {@link https://codex.wordpress.org/Template_Hierarchy}
 *
 * @package DateBook
 * @author Pagick Themes
 * @link https://www.pagickthemes.com
 * @since 1.6
 */
?>

<div id="datebook-post-<?php the_ID(); ?>" <?php post_class('datebook-custom-card card mb-3'); ?>>
	<div class="card-body">
	
		<h1><?php esc_html_e( 'Nothing Found', 'datebook' ); ?></h1>
	
		<div class="datebook-article-content">
		
		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf( esc_html__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'datebook' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

		<?php elseif ( is_search() ) : ?>

			<p><?php echo esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'datebook' ); ?></p>

			<?php get_search_form(); ?>

		<?php else : ?>

			<p><?php echo esc_html__( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'datebook' ); ?></p>

			<?php get_search_form(); ?>

		<?php endif; ?>
		<!--end article-content-->
	
		</div>

	</div>
</div>