<?php
/**
 * Checkout billing information form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-billing.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 * @global WC_Checkout $checkout
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/** @global WC_Checkout $checkout */

$fields = $checkout->get_checkout_fields( 'billing' );

if (isset($fields) && is_array($fields) && !empty($fields)){

	$enable_woocommerce_billing_fields = of_get_option('woocommerce_billing_fields');
	
	$needs_payment = WC()->cart->needs_payment() ? 1 : 0;
	
	$count_fields = count($fields);
	$fields_class = $count_fields > 1 ? 'mb-3' : ($needs_payment == 1 && isset($enable_woocommerce_billing_fields['billing_email']) && $enable_woocommerce_billing_fields['billing_email'] == '1' ? 'mb-3' : 'd-none');

?>

<div class="woocommerce-billing-fields <?php echo esc_attr($fields_class); ?>">

	<?php
	
	$enable_billing_email = isset($enable_woocommerce_billing_fields['billing_email']) && $enable_woocommerce_billing_fields['billing_email'] == '1' ? 1 : 0;

	if($count_fields == 1 && $enable_billing_email == 0 && $needs_payment == 0){

		$fields = array('billing_email' => array('label' => 'Email address', 'required' => '1', 'type' => 'hidden', 'class' => array('0' => 'form-row-wide'), 'label_class' => array('0' => 'hidden'), 'validate' => array('0' => 'email'), 'autocomplete' => 'email username', 'priority' => '110'));

	} else {
	
		if ( wc_ship_to_billing_address_only() && WC()->cart->needs_shipping() ) : ?>

			<h3><?php esc_html_e( 'Billing &amp; Shipping', 'datebook' ); ?></h3>

		<?php else : ?>

			<h3><?php esc_html_e( 'Billing details', 'datebook' ); ?></h3>

		<?php endif; ?>
		
	<?php } ?>

	<?php do_action( 'woocommerce_before_checkout_billing_form', $checkout ); ?>

	<div class="woocommerce-billing-fields__field-wrapper">

		<?php

		foreach ($fields as $key => $field) {

			if($key == 'billing_email' && $enable_billing_email == 0) {
				$field = array('label' => 'Email address', 'required' => '1', 'type' => 'hidden', 'class' => array('0' => 'form-row-wide'), 'label_class' => array('0' => 'hidden'), 'validate' => array('0' => 'email'), 'autocomplete' => 'email username', 'priority' => '110');
			}

			if (isset( $field['country_field'], $fields[$field['country_field']])) {
				$field['country'] = $checkout->get_value( $field['country_field'] );
			}
			datebook_woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
			
		}

		?>

	</div>

	<?php do_action( 'woocommerce_after_checkout_billing_form', $checkout ); ?>

</div>

<?php

}

if ( ! is_user_logged_in() && $checkout->is_registration_enabled() ) : ?>

	<div class="woocommerce-account-fields">

		<?php if ( ! $checkout->is_registration_required() ) : ?>

			<p class="form-row form-row-wide create-account">
				<label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
					<input class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" id="createaccount" <?php checked( ( true === $checkout->get_value( 'createaccount' ) || ( true === apply_filters( 'woocommerce_create_account_default_checked', false ) ) ), true ) ?> type="checkbox" name="createaccount" value="1" /> <span><?php esc_html_e( 'Create an account?', 'datebook' ); ?></span>
				</label>
			</p>

		<?php endif; ?>

		<?php do_action( 'woocommerce_before_checkout_registration_form', $checkout ); ?>

		<?php if ( $checkout->get_checkout_fields( 'account' ) ) : ?>

			<div class="create-account">
				<?php foreach ( $checkout->get_checkout_fields( 'account' ) as $key => $field ) : ?>
					<?php woocommerce_form_field( $key, $field, $checkout->get_value( $key ) ); ?>
				<?php endforeach; ?>
				<div class="clear"></div>
			</div>

		<?php endif; ?>

		<?php do_action( 'woocommerce_after_checkout_registration_form', $checkout ); ?>
	</div>
<?php endif; ?>
