jQuery(document).ready(function($) {

	"use strict";

	// Load countries in modal window
	$(document).on('click', '#datebook-location', function(e) {

		e.preventDefault();

		var alllocations = $(this).attr('all-locations');
		var posttype = $(this).attr('post-type');

		// Check if city is already selected
		var city_selected = $("#datebook-locationcity").val();
		var region_selected = $("#datebook-locationregion").val();
		var country_selected = $("#datebook-locationcountry").val();
		var whatform = $(this).attr('form-type');

		if (city_selected > 0) {
			var loc_selected = region_selected;
			var countrystyle_title = 'listcities';
			var whatisit_title = 'cities';
		} else if (region_selected > 0) {
			var loc_selected = region_selected;
			var countrystyle_title = 'listcities';
			var whatisit_title = 'cities';
		} else if (country_selected > 0) {
			var loc_selected = country_selected;
			var countrystyle_title = 'listregions';
			var whatisit_title = 'cities';
		} else {
			var loc_selected = 0;
			var countrystyle_title = 'alllocations';
			var whatisit_title = 'countries';
		}

		// AJAX request
		$.ajax({
			type: 'GET',
			url: datebookajaxlocal.ajax_url,
			data: {
				action : 'datebook_ajax_actions',
				whatisit : whatisit_title,
				alllocations : alllocations,
				posttype : posttype,
				countrystyle : countrystyle_title,
				id : loc_selected,
				whatform : whatform,
				showprocess : 1
			},
			success: function(data){

				if (data.status === 200) {
					// Add data in Modal body
					$('.datebook-country-process').hide();
					$('.datebook-dropdowncountry').html(data.content);
				} else if (data.status === 201) {
					$('.datebook-country-process').hide();
					$('.datebook-dropdowncountry').html(data.content);
				}
			}
		});
		
	});


	// Show countries in the Popup window
	$(document).on('click', '.datebook-alllocations', function(e) {

		e.preventDefault();

		$('.datebook-countrybox').hide();
		$('.datebook-countries-process').show();

		var alllocations = $("#datebook-alllocations").val();

		$.ajax({
			type: 'GET',
			url: datebookajaxlocal.ajax_url,
			dataType: 'json',
			data: {
				action : 'datebook_ajax_actions',
				id : country,
				whatisit : 'cities',
				countrystyle : 'alllocations',
				alllocations : alllocations,
				showprocess : 0
			},
			success: function(data) {
				
				if (data.status === 200) {
					
					$('.datebook-region-process').hide();
					$('.datebook-dropdownbox').html(data.content);
					return false;
				
				} else if (data.status === 201) {

					$('.datebook-region-process').hide();
					$('.datebook-dropdownbox').html(data.message);
					return false;

				}
			}
		});
	});
	
	
	// Close popup window with countries
	var close_countries_popup = 0;

	$(document).on('click', '.datebook-close-countries', function() {

		close_countries_popup = 1;

	});

	// Show regions in the Popup window in search panel, profile, tour
	$(document).on('click', '.datebook-countryid', function(e) {

		e.preventDefault();

		// For any case, empty region and city fields
		$("#datebook-locationcity").val('');
		$("#datebook-locationregion").val('');

		// Insert id of country into hidden input for Search, Registration, Tours pages
		$("#datebook-locationcountry").val($(this).attr('id'));
		$("#datebook-location").val($(this).attr('title'));

		if (close_countries_popup === 1) {

			return false;

		} else {

			$('.datebook-countrybox').hide();
			$('.datebook-region-process').show();

			var country = $(this).attr("id");

			var alllocations = $("#datebook-alllocations").val();
			var posttype = $("#datebook-location").attr('post-type');

			$.ajax({
				type: 'GET',
				url: datebookajaxlocal.ajax_url,
				dataType: 'json',
				data: {
					action : 'datebook_ajax_actions',
					id : country,
					whatisit : 'cities',
					countrystyle : 'listregions',
					alllocations : alllocations,
					posttype : posttype,
					showprocess : 0
				},
				success: function(data) {

					if (data.status === 200) {

						$('.datebook-region-process').hide();
						$('.datebook-dropdownbox').html(data.content);
						return false;

					} else if (data.status === 201) {

						$('.datebook-region-process').hide();
						$('.datebook-dropdownbox').html(data.message);
						return false;

					}
				}
			});

		}

	});


	// Show cities in the Popup window in search panel, profile, tour
  	$(document).on('click', '.datebook-regionid', function(e) {

		e.preventDefault();

		$("#datebook-location").val($(this).attr('title'));

		// Insert id of region into hidden input for Search, Registration, Tours pages
		$("#datebook-locationregion").val($(this).attr('id'));

		var country = $(this).attr("id");
		var alllocations = $("#datebook-location").attr('all-locations');
		var posttype = $("#datebook-location").attr('post-type');

		if (close_countries_popup === 1) {

			return false;

		} else {

			$('.datebook-countrybox').hide();
			$('.datebook-city-process').show();

			$.ajax({
				type: 'GET',
				url: datebookajaxlocal.ajax_url,
				dataType: 'json',
				data: {
					action : 'datebook_ajax_actions',
					id : country,
					whatisit : 'cities',
					countrystyle : 'listcities',
					alllocations : alllocations,
					posttype : posttype,
					showprocess : 0
				},
				success: function(data) {

					if (data.status === 200) {
					
						$('.datebook-city-process').hide();
						$('.datebook-dropdownbox').html(data.content);
						return false;

					} else if (data.status === 201) {

						$('.datebook-city-process').hide();
						$('.datebook-dropdownbox').html(data.message);
						return false;

					}
				}
			});
		}
	});


	// Insert id of city into hidden input for Search, Registration, Tours pages
	$(document).on('click', '.datebook-cityid', function() {

		$("#datebook-location").val($(this).attr('title')).trigger('click');

		$(".datebook-countries-overlay").fadeOut("slow");
		$(".modal-backdrop").fadeOut("slow");
		$("#datebook-locationcity").val($(this).attr("id"));

	});


	// Show countries in the Popup window in search panel, profile, tour
	$(document).on('click', '.datebook-countryback', function() {

		close_countries_popup = 0;

		$('.datebook-countrybox').hide();
		$('.datebook-country-process').show();

		$("#datebook-locationregion").val('');
		$("#datebook-locationcountry").val('');
		$("#datebook-location").val('');

		var alllocations = $("#datebook-alllocations").val();
		var posttype = $("#datebook-location").attr('post-type');

		$.ajax({
			type: "GET",
			url: datebookajaxlocal.ajax_url,
			dataType: 'json',
			data : {
				action : 'datebook_ajax_actions',
				id : 0,
				whatisit : 'cities',
				countrystyle : 'countryback',
				alllocations : alllocations,
				posttype : posttype,
				showprocess : 0
			},
			success: function(data) {

				if (data.status === 200) {

					$('.datebook-country-process').hide();
					$('.datebook-dropdownbox').html(data.content);
					return false;

				} else if (data.status === 201) {

					$('.datebook-country-process').hide();
					$('.datebook-dropdownbox').html(data.content);
					return false;

				}
			}
		});
	});


	// Show countries in the Popup window in search panel, profile, tour
	$(document).on('click', '.datebook-regionback', function() {

		close_countries_popup = 0;

		$('.datebook-countrybox').hide();
		$('.datebook-region-process').show();

		if($('#datebook-location').val()){
			var get_location_title = $("#datebook-location").val();
			var split_location_title = get_location_title.split(',');
			
			if($("#datebook-locationcity").val()){
				var country_title = $.trim(split_location_title[2]);
			} else {
				var country_title = $.trim(split_location_title[1]);
			}
			$("#datebook-location").val(country_title);
		} else {
			$("#datebook-location").val($(this).attr('title'));
		}

		$("#datebook-locationcity").val('');
		$("#datebook-locationregion").val('');

		var country = $("#datebook-locationcountry").val();
		var alllocations = $("#datebook-alllocations").val();
		var posttype = $("#datebook-location").attr('post-type');
		var whatform = $(this).attr('form-type');

		$.ajax({
			type: "GET",
			url: datebookajaxlocal.ajax_url,
			dataType: 'json',
			data : {
				action : 'datebook_ajax_actions',
				id : country,
				whatisit : 'cities',
				countrystyle : 'regionback',
				alllocations : alllocations,
				posttype : posttype,
				whatform : whatform,
				showprocess : 0
			},
			success: function(data) {

				if (data.status === 200) {

					$('.datebook-region-process').hide();
					$('.datebook-dropdownbox').html(data.content);
					return false;

				} else if (data.status === 201) {

					$('.datebook-region-process').hide();
					$('.datebook-dropdownbox').html(data.message);
					return false;

				}
			}
		});
	});


	// Check Email
	$('#datebook-emailaddress').keyup(function() {
		var email = $('#datebook-emailaddress').val();
		$.ajax({
			type: "GET",
			data : {
				action : 'datebook_ajax_actions',
				email : email,
				whatisit : 'emailcheck'
			},
			success: function(data) {
				if (data.success === 1) {
					$('.datebook-checkemail').html(data.text);
					$('.datebook-error-emailaddress').addClass('d-none');
				}
			}
		});
	});


	// Check Login
	$('#datebook-user').keyup(function() {
		var user = $('#datebook-user').val();
		$.ajax({
			type: 'GET',
			data : {
				action : 'datebook_ajax_actions',
				user : user,
				whatisit : 'logincheck'
			},
			success: function(data) {
				if (data.success === 1) {
					$('.datebook-checkuser').html(data.text);
					$('.datebook-error-user').addClass('d-none');
				}
			}
		});
	});


  	// Delete all messages
  	$(document).on('click', '.datebook-delete-messages', function() {

		var profile_id = $(this).data('profile-id');
		var whatpage = $(this).data('whatpage');
		
  		$.ajax({
  			type: 'GET',
			url: datebookajaxlocal.ajax_my_messages_url,
			dataType: 'json',
			data : {
				action : 'datebook_message_actions',
				id : profile_id,
				whatisit : 'deletemessages'
			},
			success: function(data) {

				if (data.success === 1) {
					$('.datebook-message-tabs .datebook-messages-counter').html(data.counter);
				} else if (data.success === 2) {
					$('.datebook-message-tabs .datebook-messages-counter').html(data.counter);

					if(whatpage === 'favorites' || whatpage === 'blacklist'){

						$('.datebook-messages-quantity-' + data.profile_id).html('');

						var htmlpanel = '';

						htmlpanel += '<div class="datebook-popup datebook-popup-animate fadeInDown m-2 shadow-lg rounded">';

						htmlpanel += data.newmessage;

						htmlpanel += '</div>';

						DateBook.popup({
							position: 'top center',
							displayDelay: true,
							closeButton: false,
							closeOnClick: true,
							delay: 500000,
							divpanel: htmlpanel
						});

					} else {

						if (data.newmessage) {
   			    	        var newmessage = data.newmessage;
							$('#datebook-messages-profile-box-' + data.profile_id).fadeOut("slow", function(){
								var div = $(newmessage).hide();
								$(this).replaceWith(div);
								$('#datebook-messages-profile-box-' + data.profile_id).fadeIn("slow");
								setTimeout(function(){
									$('#datebook-messages-profile-box-' + data.profile_id).fadeOut("slow");
								}, 500000);
							});
						}
					}
				}

				return false;

			}
  		});
  	});


  	// Add to Favorites
  	$(document).on('click', '.datebook-favorited-actions', function() {

		var profile_id = $(this).data('profile-id');

		var normal_color = $('.datebook-favorited-' + profile_id).data('normal-color');
		var added_color = $('.datebook-favorited-' + profile_id).data('added-color');

		var normal_icon = $('.datebook-favorited-' + profile_id).data('normal-icon');
		var added_icon = $('.datebook-favorited-' + profile_id).data('added-icon');
		
  		$.ajax({
  			type: 'GET',
			url: datebookajaxlocal.ajax_my_messages_url,
			dataType: 'json',
			data : {
				action : 'datebook_message_actions',
				id : profile_id,
				whatisit : 'favoriteset'
			},
			success: function(data) {

				if (data.success === 1) {

					$('.datebook-favorited-' + profile_id).attr('style', added_color);
					
					$('.datebook-favorited-' + profile_id + ' i').removeClass(normal_icon);
					$('.datebook-favorited-' + profile_id + ' i').addClass(added_icon);

					$('.datebook-favorited-' + profile_id).attr('title', data.text);
					$('.datebook-favorited-' + profile_id + ' .datebook-count').html(data.youcounter);
					$('.datebook-message-tabs .datebook-favorite-counter').html(data.mycounter);

				} else if (data.success === 2) {

					$('.datebook-favorited-' + profile_id).attr('style', normal_color);
					
					$('.datebook-favorited-' + profile_id + ' i').removeClass(added_icon);
					$('.datebook-favorited-' + profile_id + ' i').addClass(normal_icon);

					$('.datebook-favorited-' + profile_id).attr('title', data.text);
					$('.datebook-favorited-' + profile_id + ' .datebook-count').html(data.youcounter);
					$('.datebook-message-tabs .datebook-favorite-counter').html(data.mycounter);

					if (data.newmessage) {
   		    	        var newmessage = data.newmessage;
						$('#datebook-messages-profile-box-' + profile_id).fadeOut("slow", function(){
							var div = $(newmessage).hide();
							$(this).replaceWith(div);
							$('#datebook-messages-profile-box-' + profile_id).fadeIn('slow');
							setTimeout(function(){
								$('#datebook-messages-profile-box-' + profile_id).fadeOut('slow');
							}, 5000);
						});

					}

				}

				return false;

			}
  		});
  	});


  	// Give Like
  	$(document).on('click', '.datebook-like-actions', function() {

		var profile_id = $(this).data('profile-id');

		var normal_color = $('.datebook-like-' + profile_id).data('normal-color');
		var added_color = $('.datebook-like-' + profile_id).data('added-color');

		var normal_icon = $('.datebook-like-' + profile_id).data('normal-icon');
		var added_icon = $('.datebook-like-' + profile_id).data('added-icon');

  		$.ajax({
  			type: 'GET',
			data : {
				action : 'datebook_ajax_buttons_profile',
				id : profile_id,
				whatisit : 'likeset'
			},
			success: function(data) {

				if (data.success === 1) {

					$('.datebook-like-' + profile_id).attr('style', added_color);
					
					$('.datebook-like-' + profile_id + ' i').removeClass(normal_icon);
					$('.datebook-like-' + profile_id + ' i').addClass(added_icon);

					$('.datebook-like-' + profile_id).attr('title', data.text);
					$('.datebook-like-' + profile_id + ' .datebook-count').html(data.youcounter);
					$('.datebook-message-tabs .datebook-like-counter').html(data.mycounter);

				} else if (data.success === 2) {

					$('.datebook-like-' + profile_id).attr('style', normal_color);
					
					$('.datebook-like-' + profile_id + ' i').removeClass(added_icon);
					$('.datebook-like-' + profile_id + ' i').addClass(normal_icon);

					$('.datebook-like-' + profile_id).attr('title', data.text);
					$('.datebook-like-' + profile_id + ' .datebook-count').html(data.youcounter);
					$('.datebook-message-tabs .datebook-like-counter').html(data.mycounter);

					if (data.newmessage) {
   		    	        var newmessage = data.newmessage;
						$('#datebook-messages-profile-box-' + profile_id).fadeOut('slow', function(){
							var div = $(newmessage).hide();
							$(this).replaceWith(div);
							$('#datebook-messages-profile-box-' + profile_id).fadeIn('slow');
							setTimeout(function(){
								$('#datebook-messages-profile-box-' + profile_id).fadeOut('slow');
							}, 5000);
						});

					}

				}

				return false;

			}
  		});
  	});


  	// Add to Blacklist
  	$(document).on('click', '.datebook-blacklist-actions', function() {

		var profile_id = $(this).data('profile-id');

  		$.ajax({
  			type: 'GET',
			url: datebookajaxlocal.ajax_my_messages_url,
			dataType: 'json',
			data : {
				action : 'datebook_message_actions',
				id : profile_id,
				whatisit : 'blacklistset'
			},
			success: function(data) {

				if (data.success === 1) {
					$('.datebook-blacklist-' + profile_id).removeClass('btn-light');
					$('.datebook-blacklist-' + profile_id).addClass('btn-danger');
					$('.datebook-blacklist-' + profile_id).html(data.text);
					$('.datebook-message-tabs .datebook-blacklist-counter').html(data.counter);
				} else if (data.success === 2) {
					$('.datebook-blacklist-' + profile_id).removeClass('btn-danger');
					$('.datebook-blacklist-' + profile_id).addClass('btn-light');
					$('.datebook-blacklist-' + profile_id).html(data.text);
					$('.datebook-message-tabs .datebook-blacklist-counter').html(data.counter);

					if (data.newmessage) {
   		    	        var newmessage = data.newmessage;
						$('#datebook-messages-profile-box-' + profile_id).fadeOut("slow", function(){
							var div = $(newmessage).hide();
							$(this).replaceWith(div);
							$('#datebook-messages-profile-box-' + profile_id).fadeIn("slow");
							setTimeout(function(){
								$('#datebook-messages-profile-box-' + profile_id).fadeOut("slow");
							}, 5000);
						});

					}

				}

				return false;

			}
  		});
  	});


  	// Add friend
  	$(document).on('click', '.datebook-add-friend', function() {
		var profile_id = $(this).attr('profile-id');
  		$.ajax({
  			type: "GET",
			data : {
				action : 'datebook_ajax_buttons_profile',
				id : profile_id,
				whatisit : 'friendrequest'
			},
			success: function(data) {

				if (data.success === 1) {
					$('.datebook-add-friend').removeClass('btn-outline-primary');
					$('.datebook-add-friend').addClass('btn-outline-warning pr-3 pl-3');
					$('.datebook-add-friend .datebook-title').html(data.text);
					$('.datebook-add-friend .datebook-count').html(data.counter);
				} else if (data.success === 2) {
					$('.datebook-add-friend').removeClass('btn-outline-warning');
					$('.datebook-add-friend').removeClass('btn-outline-success');
					$('.datebook-add-friend').addClass('btn-outline-primary pr-3 pl-3');
					$('.datebook-add-friend .datebook-title').html(data.text);
					$('.datebook-add-friend .datebook-count').html(data.counter);
				}

				return false;

			}
  		});
  	});

  	// Accept friend
  	$(document).on('click', '.datebook-accept-friend-request', function() {
		var profile_id = $(this).attr('profile-id');
  		$.ajax({
  			type: "GET",
			data : {
				action : 'datebook_ajax_buttons_profile',
				id : profile_id,
				whatisit : 'acceptfriend'
			},
			success: function(data) {

				if (data.success === 1) {
					$('.datebook-friend-id-' + profile_id + ' .datebook-accept-friend-request').remove();
					$('.datebook-friend-id-' + profile_id + ' .datebook-reject-friend-request').remove();
					$('.datebook-friend-id-' + profile_id).prependTo("#datebook-friends-list");
					$('.datebook-friends-counter').html(data.counter);

					if (data.countpending === 0) {
						$('#datebook-pending-panel').remove();						
					}
				}

				return false;

			}
  		});
  	});

  	// Reject friend
  	$(document).on('click', '.datebook-reject-friend-request', function() {
		var profile_id = $(this).attr('profile-id');
  		$.ajax({
  			type: "GET",
			data : {
				action : 'datebook_ajax_buttons_profile',
				id : profile_id,
				whatisit : 'rejectfriend'
			},
			success: function(data) {

				if (data.success === 1) {
					$('.datebook-friend-id-' + profile_id).hide();
					$('.datebook-add-friend .datebook-title').html(data.text);

					if (data.countpending === 0) {
						$('#datebook-pending-panel').remove();						
					}
				}

				return false;

			}
  		});
  	});

  	// Remove friend
  	$(document).on('click', '.datebook-remove-friend-request', function() {
		var profile_id = $(this).attr('profile-id');
  		$.ajax({
  			type: "GET",
			data : {
				action : 'datebook_ajax_buttons_profile',
				id : profile_id,
				whatisit : 'removefriend'
			},
			success: function(data) {

				if (data.success === 1) {
					$('.datebook-friend-id-' + profile_id).hide();
					$('.datebook-friends-counter').html(data.counter);
				}

				return false;

			}
  		});
  	});


  	// Activate Top and Featured statuses
  	$(document).on('click', '.datebook-activate-topfeatured', function() {
		var profile_id = $(this).attr('id');
  		$.ajax({
  			type: "GET",
			data : {
				action : 'datebook_ajax_actions',
				id : profile_id,
				whatisit : 'activate-topfeatured'
			},
			success: function(data) {
				if (data.success === 1) {

					$('#' + profile_id).removeClass('btn-success');
					$('#' + profile_id).addClass('btn-light');
					$('#' + profile_id).html(data.text);
					$('#' + profile_id).removeClass('datebook-activate-topfeatured');

					$('#' + profile_id).parent().children('.datebook-period-ends').html(data.period);
					$('#' + profile_id).parent().children('.datebook-times-left').html(data.timesleft);

					$('#' + profile_id).parent().children('.badge').removeClass('badge-info');
					$('#' + profile_id).parent().children('.badge').addClass('badge-success');

					return false;

				}
			}
  		});
  	});


	// Delete Tour
  	$(document).on('click', '.datebook-deletetour', function() {
		var tour_id = $(this).attr('id');
  		$('#datebook-tour' + tour_id + ' .datebook-optionbuttons').html('<b></b>');
  		$.ajax({
  			type: "GET",
			data : {
				action : 'datebook_ajax_actions',
				tid : tour_id,
				whatisit : 'tourdelete'
			},
  			success: function(data) {
  				$('.datebook-delete-popup').html(data).fadeIn("slow").delay(1500).fadeOut("slow");
  				$('#datebook-tour' + tour_id).slideUp("slow");
  			}
  		});
  	});


  	// Edit Tour
  	$(document).on('click', '.datebook-edittour', function() {
  		var tour_id = $(this).attr('id');
  		$('#datebook-tour' + tour_id + ' .datebook-optionbuttons em').hide();
  		$('#datebook-tour' + tour_id + ' .datebook-optionbuttons').append('<b></b>');
  		$.ajax({
  			type: "GET",
			data : {
				action : 'datebook_ajax_actions',
				tid : tour_id,
				whatisit : 'touredit'
			},
  			success: function(data) {
  				$('.datebook-addedtours').html(data);
  				$('html').scrollTop(0);
  				$('#datebook-tour'+tour_id+' .datebook-optionbuttons b').hide();
  				$('#datebook-tour'+tour_id+' .datebook-optionbuttons').append('<em>'+tour_id+'</em>');
  			}
  		});
  	});
	

	// Set Default Profile Image
	$(document).on('click', '#datebook-img-main-id', function() {
		var imgid = $(this).val();
		$.ajax({
			type: "GET",
			data : {
				action : 'datebook_ajax_actions',
				id : imgid,
				whatisit : 'defaultimage'
			},
			success: function(data) {

				$('.datebook-img-popup').html(data).slideDown("slow").delay(1500).slideUp("slow");
				$('.datebook-photocontainer .datebook-img-single span').removeClass('selected');
				$("#"+imgid+" span").addClass('selected');

				$('.datebook-photocontainer #datebook-img-main-id').removeClass('btn-primary');
				$('.datebook-photocontainer #datebook-img-main-id').addClass('btn-light');
				$("#"+imgid+" #datebook-img-main-id").removeClass('btn-light');
				$("#"+imgid+" #datebook-img-main-id").addClass('btn-primary');

			}
		});
	});


	// Rotate Profile Image
	var rotation_css = 0;

	$(document).on('click', '.datebook-rotate', function() {

		var imgid = $(this).val();

		$('.datebook-rotate-' + imgid).hide();
		$('.datebook-rotate-process-' + imgid).show();

		rotation_css = (rotation_css + 90) % 360;

		var rotation = 90;

		$.ajax({
			type: "GET",
			data : {
				action : 'datebook_ajax_actions',
				id : imgid,
				whatisit : 'rotation',
				rotation_degree : rotation
			},
			success: function(data) {

				if (data.success === 1) {
					$('.datebook-rotate-process-' + imgid).hide();
					$('.datebook-rotate-' + imgid).show();
		
					//$('.datebook-pic-rotate-' + imgid).css({'transform': 'rotate(' + rotation_css + 'deg)'});
					//$('#datebook-rotation-' + imgid).val(0);

					$('#' + data.imgid + ' .datebook-pic-rotate-' + data.imgid).attr("src", data.imgurl);
					$('#' + data.imgid + ' a').attr("href", data.imgbig);
					
					$('#' + data.imgid + ' .datebook-rotate-' + data.imgid).val(data.newimgid);
					$('#' + data.imgid + ' .datebook-rotate-' + data.imgid).addClass('datebook-rotate-' + data.newimgid);
					$('#' + data.imgid + ' .datebook-rotate-' + data.imgid).removeClass('datebook-rotate-' + data.imgid);

					$('#' + data.imgid + ' .datebook-rotate-process-' + data.imgid).addClass('datebook-rotate-process-' + data.newimgid);
					$('#' + data.imgid + ' .datebook-rotate-process-' + data.imgid).removeClass('datebook-rotate-process-' + data.imgid);

					$('#' + data.imgid + ' .datebook-pic-rotate-' + data.imgid).addClass('datebook-pic-rotate-' + data.newimgid);
					$('#' + data.imgid + ' .datebook-pic-rotate-' + data.imgid).removeClass('datebook-pic-rotate-' + data.imgid);
					
					$('#' + data.imgid + ' .datebook-default-btn-' + data.imgid).val(data.newimgid);
					$('#' + data.imgid + ' .datebook-default-btn-' + data.imgid).addClass('datebook-default-btn-' + data.newimgid);
					$('#' + data.imgid + ' .datebook-default-btn-' + data.imgid).removeClass('datebook-default-btn-' + data.imgid);

					$('#' + data.imgid + ' .datebook-delete-btn-' + data.imgid).val(data.newimgid);
					$('#' + data.imgid + ' .datebook-delete-btn-' + data.imgid).addClass('datebook-delete-btn-' + data.newimgid);
					$('#' + data.imgid + ' .datebook-delete-btn-' + data.imgid).removeClass('datebook-delete-btn-' + data.imgid);

					document.getElementById('datebook-rotation-' + data.imgid).id = 'datebook-rotation-' + data.newimgid;

					document.getElementById(data.imgid).id = data.newimgid;

					$('.datebook-img-popup').html(data.successtext).slideDown("slow").delay(1000).slideUp("slow");
				}

			}
		});
	});


	// Delete Profile Image
	$(document).on('click', '#datebook-img-delete-id', function() {

		var imgid = $(this).val();

		$.ajax({
			url: datebookajaxlocal.ajax_url,
			type: 'GET',
			dataType: "json",
			data : {
				action : 'datebook_ajax_actions',
				id : imgid,
				whatisit : 'imagedelete'
			},
			success: function(data) {

				$("#" + data.imgid).fadeOut("slow");
				$('.datebook-img-popup').html(data.successtext).slideDown("slow").delay(1000).slideUp("slow");

			}
		});
	});


	// Delete Real Image
	$(document).on('click', '#datebook-img-real-id', function() {
		var imgid = $('#datebook-img-single-id').val();
		$.ajax({
			type: "GET",
			data : {
				action : 'datebook_ajax_actions',
				id : imgid,
				whatisit : 'realphotodelete'
			},
			success: function(data) {
				$("#"+imgid).fadeOut("slow");
				$('.datebook-img-popup').html(data).slideDown("slow").delay(11000).slideUp("slow");
			}
		});
	});


  	// Select background image for Featured profile
  	$(document).on('click', '.datebook-featured-image', function() {

		var profile_id = $(this).attr('profile-id');
		var image_url = $(this).data('url');
		
		var image_id = $(this).data('id');
		
  		$.ajax({
  			type: 'GET',
			data : {
				action : 'datebook_ajax_buttons_profile',
				id : profile_id,
				image_url : image_url,
				whatisit : 'setfeaturedimage'
			},
			success: function(data) {

				var popbackground = 'white';
				var poptextcolor = 'text-dark';

				if (data.success === 1) {
					$('body').attr('style', 'background: url(' + image_url + ')');

					var popbackground = 'green lighten-2';
					var poptextcolor = 'text-white';
					$('.datebook-featured-images-panel .list-inline-item').removeClass('active');
					$('.datebook-featured-images-panel .datebook-featured-image-id-' + image_id).addClass('active');
				} else if (data.success === 2) {
					var popbackground = 'orange';
					var poptextcolor = 'text-white';
				}

				var htmlpanel = '';

				if(data.text){
					htmlpanel += '<div class="p-2 datebook-popup-animate fadeInDown shadow-lg rounded text-center ' + poptextcolor + ' ' + popbackground + '">';
					htmlpanel += '<div class="datebook-popup-title p-2">' + data.text + '</div>';
					htmlpanel += '</div>';
				}

				DateBook.popup({
					position: 'top center',
					displayDelay: true,
					closeButton: false,
					closeOnClick: true,
					delay: 5000,
					divpanel: htmlpanel
				});

				return false;

			}
  		});
  	});


	// Upload photos for profile gallery and Real Status
	$('#datebook-imageform').ajaxForm({
		
		beforeSubmit: function() {
			
			var count = 0;
			var val = $.trim($('#datebook-images').val());
			var delval = $.trim($('#datebook-img-single-id').val());
			$("#" + delval).remove();

			if (val === '') {
				var count = 1;
				$('.datebook-noimage-error').slideDown("slow").delay(5000).slideUp("slow");
			}

			if (count === 0) {
				for (var i = 0; i < $('#datebook-images').get(0).files.length; ++i) {
					var img = $('#datebook-images').get(0).files[i].name;
					var extension = img.split('.').pop().toUpperCase();
					if (extension !== "PNG" && extension !== "JPG" && extension !== "GIF" && extension !== "JPEG") {
						var count = count + 1;
						$('.datebook-noimageext-error').slideDown("slow").delay(5000).slideUp("slow");
					}
				}
			}
			
			if (count > 0) {
				return false;
			} else {
				$("#datebook-images").next('span').html("");
			}
		},
		
		beforeSend: function() {
			$('#datebook-loader').show();
			$('#datebook-image-upload').hide();
			},

		success: function(msg) {},

		complete: function(xhr) {

			$('#datebook-loader').hide();
			$('#datebook-image-upload').show();
			
			$('#datebook-images').val('');
			$('#datebook-error-div').html('');

			var result = $.parseJSON(xhr.responseText);

			var successtext = result.successtext;
			var html = '';

			if (result.success){

				var imagewidth = $('#datebook_image_width').val();
				var imageheight = $('#datebook_image_height').val();

				var imageid = result.imgid;
				var imagebig = result.imgbig;
				var imgurl = result.imgurl;

				var delrealphoto = $('#datebook-realphoto').val();

				if (delrealphoto) {

					var photoverify_name = 'img_real_id';
					var photoverify_class = 'datebook-img-real-id';

					html += '<div id="' + imageid + '" class="datebook-verificationphoto"><span class=""><a class="datebook-frontphoto" href="' + imagebig + '"><image class="thumbnail" src="' + imgurl + '" /></a><div class="datebook-clear5"></div><input type="hidden" value="' + imageid + '" id="datebook-img-single-id"><input type="button" value="Delete" id="' + photoverify_class + '" name="' + photoverify_name + '" class="btn btn-sm btn-grey"></span></div>';

				} else {

					html += '<div id="' + imageid + '" class="view p-1 text-center datebook-img-single" style="float:left;margin-right: 10px;margin-bottom: 14px;"><span class="rounded shadow-sm "><a class="white text-center datebook-frontphoto" href="' + imagebig + '" style="width:' + imagewidth + 'px; height:' + imageheight + 'px;"><img class="img-fluid m-auto datebook-pic-rotate-' + imageid + '" src="' + imgurl + '" alt=""></a><input type="hidden" name="rotation" id="datebook-rotation-' + imageid + '" value="0"><button id="datebook-rotate" class="datebook-rotate datebook-rotate-' + imageid + '" value="' + imageid + '" type="submit" data-toggle="tooltip" data-placement="top" title="" data-original-title="Rotate"><i class="fas fa-redo-alt"></i></button><div class="spinner-border spinner-border-sm datebook-rotate-process datebook-rotate-process-' + imageid + '" role="status" aria-hidden="true"></div></span><div class="datebook-clear5"></div><button id="datebook-img-main-id" class="btn btn-light btn-sm m-1 p-1 pr-3 pl-3 shadow-none waves-effect waves-light datebook-default-btn-' + imageid + '" value="' + imageid + '" type="submit" data-toggle="tooltip" data-placement="top" title="" data-original-title="Make default"><i class="fa fa-check"></i></button> <button id="datebook-img-delete-id" class="btn btn-sm btn-light m-1 p-1 pr-3 pl-3 shadow-none waves-effect waves-light datebook-delete-btn-' + imageid + '" value="' + imageid + '" type="submit" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete image"><i class="fa fa-trash"></i></button></div>';

				}

				$('.datebook-img-popup').html(successtext).slideDown("slow").delay(8000).slideUp("slow");
				$('#blueimp-gallery-links').append(html);

				$('.datebook-must-upload-photo-notification').parent().hide('slow');
				$('.datebook-must-complete-profile-notification').parent().removeClass('d-none');

			} else {

				html += successtext;

				$('.datebook-img-popup').html(successtext).slideDown("slow").delay(8000).slideUp("slow");
				
			}
			
		}
	});
	
	// Uploading Profile Image
	$(document).on('change','.datebook-image-submit', function(){
		
		//submit the form
		$('#datebook-imageform').submit();

	});

});


// Popup message for chat
var DateBook = {};

var DateBookPopup = function (settings) {

	this.$settings = null;
	this.$item = null;

	var starter = this;

	var GetSettings = function (setups) {

		setups = jQuery.extend({}, DateBook.popup.SETTINGS, setups);

		return setups;
	};

	var GetPopupBox = function () {

		var $popup = jQuery(starter.$settings.divpanel);

		if (starter.$settings.closeButton) {
			jQuery('<span class="datebook-popup-close">&times;</span>').on('click', function (pie) {
				pie.preventDefault();
				pie.stopPropagation();
				starter.remove();
			}).appendTo($popup);
		}

		$popup.on('click', function() {
			starter.remove();
		});

		if(starter.$settings.delay > 0){

			var delay = jQuery('<div class="datebook-popup-timer-loading"><div></div></div>');

			$popup.append(delay);

			var time = 0;
			var interval = 1000 / 30;
			var currentTime = new Date().getTime();

			var timer = setInterval(function () {

				time = new Date().getTime() - currentTime;

				var width = 100 * time / starter.$settings.delay;

				if (width >= 100) {
					width = 100;
					starter.remove();
					timer = clearInterval(timer);
				}

				if (starter.$settings.displayDelay) {
					delay.find('div').css('width', width + '%');
				}
			}, interval);

			$popup.on('mouseenter.datebook', function () {
				interval = 0;
			}).on('mouseleave.datebook', function () {
				interval = 1000 / 30;
			});

		}

		return $popup;

	};

	this.remove = function () {

		starter.$item.removeClass('fadeInDown').addClass('zoomOut');

		setTimeout(function () {
			starter.$item.remove();
		}, 500);

		return starter;

	};

	starter.mainfunction = function () {

		var $popup = GetPopupBox();

		if (typeof starter.$settings.position === 'string') {

			var selector = ('.datebook-popup-container') + '.' + starter.$settings.position.replace(/\s/gi, '.'), $container;

			var $precontainer = jQuery(selector);

			if ($precontainer.length === 0) {
				var $precontainer = jQuery('<div></div>').addClass(selector.replace(/\./g, ' ').trim()).appendTo('body');
			}

			var $container = $precontainer;

			if ($container.hasClass('bottom')) {
				var $container = $container.prepend($popup);
			} else {
				var $container = $container.append($popup);
			}

			if ($container.hasClass('center')) {
				$container.css('margin-left', '-' + ($container.width() / 2) + "px");
			}

		} else {

			$('body').append($popup);
			$popup.css({
				'position': 'fixed',
				right: starter.$settings.position.right,
				top: starter.$settings.position.top
			});
		}

		starter.$item = $popup;

		if (starter.$settings.sound && datebookajaxlocal.path_to_sound) {
			var getaudio = new Audio(datebookajaxlocal.path_to_sound);
			getaudio.play();
		}
		starter.$item.on('click.datebook', function () {
			if (starter.$settings.onClickUrl) {
				var windowObjectReference = null;
				var strWindowName = 'datebookchat';

				var w = datebook_chat_window.datebook_chat_width;
				var h = datebook_chat_window.datebook_chat_height;

				var left = (screen.width/2)-(w/2);
				var top = (screen.height/2)-(h/2);
				var strWindowFeatures = 'left='+left+',top='+top+',screenX=100,screenY=100,width='+w+',height='+h+',resizable,scrollbars,status';

				windowObjectReference = window.open(starter.$settings.onClickUrl, strWindowName, strWindowFeatures);
				windowObjectReference.focus();
			}
		});
		starter.$item.data('datebook', starter);
	};

	this.$settings = GetSettings(settings);

	this.mainfunction();

};

DateBook.popup = function (settings) {

	var startPopup = new DateBookPopup(settings);

	return startPopup;

};

DateBook.popup.SETTINGS = {
	delay: datebookajaxlocal.display_new_message_popup,
	closeButton: true,
};