<?php
/**
 * @package   Options_Framework
 * @author    Devin Price <devin@wptheming.com>
 * @license   GPL-2.0+
 * @link      http://wptheming.com
 * @copyright 2010-2014 WP Theming
 */

class Options_Framework_Media_Uploader {

	/**
	 * Initialize the media uploader class
	 *
	 * @since 1.7.0
	 */
	public function init() {
		add_action( 'admin_enqueue_scripts', array( $this, 'optionsframework_media_scripts' ) );
	}

	/**
	 * Media Uploader Using the WordPress Media Library.
	 *
	 * Parameters:
	 *
	 * string $_id - A token to identify this field (the name).
	 * string $_value - The value of the field, if present.
	 * string $_desc - An optional description of the field.
	 *
	 */

	static function optionsframework_uploader( $_id, $_value, $_desc = '', $_name = '', $multi_file = 'single' ) {

		// Gets the unique option id
		$options_framework = new Options_Framework;
	    $option_name = $options_framework->get_option_name();

		$output = '';
		$id = '';
		$class = '';
		$int = '';
		$value = '';
		$name = '';

		$id = strip_tags( strtolower( $_id ) );

		// If a value is passed and we don't have a stored value, use the value that's passed through.
		if ( $_value != '' && $value == '' ) {
			$value = $_value;
		}

		if ($_name != '') {
			$name = $_name;
		}
		else {
			$name = $option_name.'['.$id.']';
		}

		if ( $value ) {
			$class = ' has-file';
		}

		if ( $multi_file == 'single' ) {
			$output .= '<input id="' . $id . '" class="upload' . $class . '" type="text" name="'.$name.'" value="' . $value . '" placeholder="' . esc_html__( 'No file chosen', 'datebook' ) .'" />' . "\n";
		}

		if ( function_exists( 'wp_enqueue_media' ) ) {
			if ( ( $value == '' ) ) {
				
				if ( $multi_file == 'single' ) {
					$output .= '<input id="upload-' . $id . '" class="upload-button button" type="button" value="' . esc_html__( 'Upload', 'datebook' ) . '" />' . "\n";
				} else {
					$output .= '<input id="upload-' . $id . '" class="upload-multi-button button" type="button" value="' . esc_html__( 'Select', 'datebook' ) . '" />' . "\n";
				}
			} else {
				if ( $multi_file == 'single' ) {
					$output .= '<input id="remove-' . $id . '" class="remove-file button" type="button" value="' . esc_html__( 'Remove', 'datebook' ) . '" />' . "\n";
				} else {
					$output .= '<input id="upload-' . $id . '" class="upload-multi-button button" type="button" value="' . esc_html__( 'Select', 'datebook' ) . '" />' . "\n";
				}
			}
		} else {
			$output .= '<p><i>' . esc_html__( 'Upgrade your version of WordPress for full media support.', 'datebook' ) . '</i></p>';
		}

		if ( $_desc != '' ) {
			$output .= '<span class="of-metabox-desc">' . $_desc . '</span>' . "\n";
		}

		$output .= '<div class="parent-screenshot">' . "\n";

		if ( $value != '' ) {

			if ( $multi_file == 'single' ) {
				$output .= '<div class="screenshot" id="' . $id . '-image">' . "\n";
				$remove = '<a class="remove-image">' . esc_html__( 'Remove', 'datebook' ) . '</a>';
				$image = preg_match( '/(^.*\.jpg|jpeg|png|gif|ico*)/i', $value );
				if ( $image ) {
					$output .= '<img src="' . $value . '" alt="' . esc_html__( 'Remove', 'datebook' ) . '" />' . $remove;
				} else {
					$parts = explode( '/', $value );
					for ( $i = 0; $i < sizeof( $parts ); ++$i ) {
						$title = $parts[$i];
					}

					// No output preview if it's not an image.
					$output .= '';

					// Standard generic output if it's not an image.
					$title = esc_html__( 'View File', 'datebook' );
					$output .= '<div class="no-image"><span class="file_link"><a href="' . $value . '" target="_blank" rel="external">'.$title.'</a></span></div>';
				}
				$output .= '</div>' . "\n";

			} else if ( $multi_file == 'multi' ) {
				
				if(isset($value) && !empty($value) && is_array($value)){
					$count_image = 0;
					foreach($value as $single_image){
						$count_image++;
						$count_random = rand(1000000, 100000000000000);
						$output .= '<div class="screenshot screenshot-multi ' . $id . '-image-' . $count_image . '-' . $count_random . '" id="' . $id . '-image-' . $count_image . '">' . "\n";
						$remove = '<a class="remove-multi-image" data-id="' . $id . '-image-' . $count_image . '-' . $count_random . '">' . esc_html__( 'Remove', 'datebook' ) . '</a>';
						$image = preg_match( '/(^.*\.jpg|jpeg|png|gif|ico*)/i', $single_image );
						if ( $image ) {
							$output .= '<input type="hidden" name="datebook[featured_background_images][]" value="' . $single_image . '">';
							$output .= '<img src="' . $single_image . '" alt="' . esc_html__( 'Remove', 'datebook' ) . '" />' . $remove;
						} else {
							$parts = explode( '/', $single_image );
							for ( $i = 0; $i < sizeof( $parts ); ++$i ) {
								$title = $parts[$i];
							}

							// No output preview if it's not an image.
							$output .= '';

							// Standard generic output if it's not an image.
							$title = esc_html__( 'View File', 'datebook' );
							$output .= '<div class="no-image"><span class="file_link"><a href="' . $single_image . '" target="_blank" rel="external">'.$title.'</a></span></div>';
						}

						$output .= '</div>' . "\n";

					}
				}
			}
		} else {
			
			if ( $multi_file == 'single' ) {
				$output .= '<div class="screenshot" id="' . $id . '-image"></div>' . "\n";
			}

		}


		
		$output .= '</div>' . "\n";

		return $output;

	}

	/**
	 * Enqueue scripts for file uploader
	 */
	function optionsframework_media_scripts( $hook ) {

		$menu = Options_Framework_Admin::menu_settings();

        if ( 'datebook-options-framework' !== $menu['menu_slug'] )
	        return;

		if ( function_exists( 'wp_enqueue_media' ) )
			wp_enqueue_media();

		wp_register_script( 'of-media-uploader', OPTIONS_FRAMEWORK_DIRECTORY .'js/media-uploader.js', array( 'jquery' ), Options_Framework::VERSION );
		wp_enqueue_script( 'of-media-uploader' );
		wp_localize_script( 'of-media-uploader', 'optionsframework_l10n', array(
			'upload' => esc_html__( 'Upload', 'datebook' ),
			'remove' => esc_html__( 'Remove', 'datebook' )
		) );
	}
}