<?php
if ( !defined( 'ABSPATH' ) ) {
    exit;
}


/**
 * Implements helper functions for DateBook WooCommerce Subscription
 *
 */

if( !function_exists('datebook_wc_get_time_options')){

	/**
	 * Return the list of time options to add in product editor panel
	 *
	 */
	function datebook_wc_get_time_options(){
		$options = array(
			'minutes'   => esc_html__( 'minutes', 'datebook' ),
			'hours'   => esc_html__( 'hours', 'datebook' ),
			'days'   => esc_html__( 'days', 'datebook' ),
			'months' => esc_html__( 'months', 'datebook' ),
			'years' => esc_html__( 'years', 'datebook' ),
		);

		return apply_filters('datebook_wcaddon_time_options', $options);

	}
}


if ( !function_exists( 'datebook_wcaddon_locate_template' ) ) {

	/**
	 * Locate the templates and return the path of the file found
	 *
	 */
	function datebook_wcaddon_locate_template( $path, $var = NULL ) {

		global $woocommerce;

		if ( function_exists( 'WC' ) ) {

			$woocommerce_base = WC()->template_path();

		} elseif ( defined( 'WC_TEMPLATE_PATH' ) ) {

			$woocommerce_base = WC_TEMPLATE_PATH;

		} else {

			$woocommerce_base = $woocommerce->plugin_path() . '/templates/';

		}

		$template_woocommerce_path = $woocommerce_base . $path;
		$template_path = '/' . $path;
		$plugin_path = DATEBOOK_DIR . 'includes/payment/woocommerce/templates/' . $path;

		$located = locate_template( array(
			$template_woocommerce_path, // Search in <theme>/woocommerce/
			$template_path,             // Search in <theme>/
			$plugin_path                // Search in <plugin>/templates/
		) );

		if ( !$located && file_exists( $plugin_path ) ) {
			return apply_filters( 'datebook_wcaddon_locate_template', $plugin_path, $path );
		}

		return apply_filters( 'datebook_wcaddon_locate_template', $located, $path );

	}
}


if ( ! function_exists( 'datebook_wc_get_timestamp_from_option' ) ) {

	/**
	 * Add a date to a timestamp
	 *
	 */
	function datebook_wc_get_timestamp_from_option( $time_from, $qty, $time_opt ) {

		$timestamp = 0;
		switch ( $time_opt ) {
			case 'minutes':
				$timestamp = datebook_wc_add_date( $time_from, intval( $qty ) );
				break;
			case 'hours':
				$timestamp = datebook_wc_add_date( $time_from, 0, intval( $qty ) );
				break;
			case 'days':
				$timestamp = datebook_wc_add_date( $time_from, 0, 0, intval( $qty ) );
				break;
			//case 'weeks':
				//$timestamp = datebook_wc_add_date( $time_from, intval( $qty ) * 7 );
				//break;
			case 'months':
				$timestamp = datebook_wc_add_date( $time_from, 0, 0, 0, intval( $qty ) );
				break;
			case 'years':
				$timestamp = datebook_wc_add_date( $time_from, 0, 0, 0, 0, intval( $qty ) );
				break;
			default:
		}

		return $timestamp;
	}
}




if ( ! function_exists( 'datebook_wc_get_max_length_period' ) ) {

	/**
	 * Return the max length of period that can be accepted from paypal
	 *
	 */
	function datebook_wc_get_max_length_period() {

		$max_length = array(
			'minutes' => 60,
			'hours' => 24,
			'days' => 30,
			'weeks' => 52,
			'months' => 12,
			'years' => 10
		);

		return apply_filters( 'datebook_wc_get_max_length_period', $max_length );

	}
}


if ( ! function_exists( 'datebook_wc_validate_max_length' ) ) {

	/**
	 * Return the max length of period that can be accepted from paypal
	 *
	 */
	function datebook_wc_validate_max_length( $max_length, $time_opt ) {

		$max_lengths = datebook_wc_get_max_length_period();
		$max_length  = ( $max_length > $max_lengths[$time_opt] ) ? $max_lengths[$time_opt] : $max_length;
		
		return $max_length;

	}
}


if( !function_exists('datebook_wc_get_price_per_string')){

	/**
	 * Return the days from timestamp
	 *
	 */
	function datebook_wc_get_price_per_string( $price_per, $time_option ) {
		$price_html = ( ( $price_per == 1 ) ? '1 ' : $price_per ) . ' ';

		switch( $time_option ){
			case 'minutes':
				$price_html .= _n( 'minute', 'minutes', $price_per, 'datebook' );
				break;
			case 'hours':
				$price_html .= _n( 'hour', 'hours', $price_per, 'datebook' );
				break;
			case 'days':
				$price_html .= _n( 'day', 'days', $price_per, 'datebook' );
				break;
			case 'weeks':
				$price_html .= _n( 'week', 'weeks', $price_per, 'datebook' );
				break;
			case 'months':
				$price_html .= _n( 'month', 'months', $price_per, 'datebook' );
				break;
			case 'years':
				$price_html .= _n( 'year', 'years', $price_per, 'datebook' );
				break;
			default:
		}

		return $price_html;

	}
}

if ( ! function_exists( 'datebook_get_days' ) ) {

	/**
	 * Return the days from timestamp
	 *
	 */
	function datebook_get_days( $timestamp ) {
		$days = ceil( $timestamp / 86400 );

		return $days;
	}

}


if ( ! function_exists( 'datebook_wc_add_date' ) ) {

	/**
	 * Add day, months or year to a date
	 *
	 */

	function datebook_wc_add_date( $given_date, $minute = 0, $hour = 0, $day = 0, $mth = 0, $yr = 0 ) {
		$new_date = $given_date;
		$new_date = strtotime( "+" . $minute . " minutes", $new_date );
		$new_date = strtotime( "+" . $hour . " hours", $new_date );
		$new_date = strtotime( "+" . $day . " days", $new_date );
		$new_date = strtotime( "+" . $mth . " month", $new_date );
		$new_date = strtotime( "+" . $yr . " year", $new_date );
		return $new_date;
	}
}


if ( ! function_exists( 'datebook_wc_get_subscription' ) ) {

	/**
	 * Return the subscription object
	 *
	 */

	function datebook_wc_get_subscription( $subscription_id ) {
		return new DateBook_WC_Subscription( $subscription_id );
	}
}


if ( ! function_exists( 'datebook_wc_coupon_is_valid' ) ) {

	/**
	 * Check if a coupon is valid.
	 *
	 */
	function datebook_wc_coupon_is_valid( $coupon, $object = array() ) {
		$wc_discounts = new WC_Discounts( $object );
		$valid = $wc_discounts->is_coupon_valid( $coupon );
		$valid = is_wp_error( $valid ) ? false : $valid;

		return $valid;
	}

}


// Remove Subscription plans from WooCommerce Shop page
if(function_exists( 'WC' )){
	function bbloomer_remove_products_from_shop_page( $q ) {
		if ( ! $q->is_main_query() ) return;
		if ( ! $q->is_post_type_archive() ) return;
		if ( ! is_admin() && is_shop() ) {
			$q->set( 'meta_query', array(
				array(
					'key' => '_datebook_subscribe',
					'compare' => '!=',
					'value' => 'yes'
				)
			));
		}
		remove_action( 'pre_get_posts', 'bbloomer_remove_products_from_shop_page' );
	}
	add_action( 'pre_get_posts', 'bbloomer_remove_products_from_shop_page' );
}