<?php
if ( !defined( 'ABSPATH' ) ) { exit; }

/**
 * Implements admin features of DateBook WooCommerce Subscription
 *
 * @class   DateBook_WC_Subscription_Admin
 * @package DateBook WooCommerce Subscription
 * @since   3.0
 */


class DateBook_WC_Subscription_Admin {

        /**
         * Single instance of the class
         *
         */
        protected static $instance;

        /**
         * Returns single instance of the class
         *
         */
        public static function get_instance() {
            if ( is_null( self::$instance ) ) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        /**
         * Constructor
         *
         */
        public function __construct() {

            //product editor
            add_filter( 'product_type_options', array( $this, 'add_type_options' ) );

            //custom fields for single product
            add_action( 'woocommerce_product_options_general_product_data', array( $this, 'add_custom_fields_for_single_products' ) );
            add_action( 'woocommerce_process_product_meta', array( $this, 'save_custom_fields_for_single_products' ), 10, 2 );

        }
		

	    /**
	     * Add a product type option in single product editor
	     *
	     */
		public function add_type_options( $types ) {
            $types['datebook_subscribe'] = array(
                'id'            => '_datebook_subscribe',
                'wrapper_class' => 'show_if_simple',
                'label'         => esc_html__( 'Subscription', 'datebook' ),
                'description'   => esc_html__( 'This product will be available as a subscription', 'datebook' ),
                'default'       => 'no'
            );
            return $types;
        }

        /**
         * Add custom fields for single product
         *
         */
        public function add_custom_fields_for_single_products() {
            global $thepostid;

	        $product = wc_get_product( $thepostid );

            echo '<div class="options_group">';

            $_wcaddon_price_is_per           = datebook_get_prop( $product, '_wcaddon_price_is_per' );
            $_wcaddon_price_time_option      = datebook_get_prop( $product, '_wcaddon_price_time_option' );
            $_wcaddon_max_length             = datebook_get_prop( $product, '_wcaddon_max_length' );

            $max_lengths = datebook_wc_get_max_length_period();
			
			$time_opt = ( $_wcaddon_price_time_option ) ? $_wcaddon_price_time_option : 'days';
			
			$max_lengths_pariods = $max_lengths['minutes'] . ' | ' . $max_lengths['hours'] . ' | ' . $max_lengths['days'] . ' | ' . $max_lengths['months'] .' | ' . $max_lengths['years'];

            ?>

            <div class="options_group show_if_simple wcaddon_price_is_per">

				<div class="toolbar" style="padding-left: 12px">
            	   	<h3><?php echo esc_html__('Subscription settings','datebook') ?></h3>
				</div>
            
                <p class="form-field">
                    <label for="_wcaddon_price_is_per"><?php echo esc_html__( 'Period', 'datebook' ); ?></label>
                    <input type="text" class="short" name="_wcaddon_price_is_per" id="_wcaddon_price_is_per" value="<?php echo esc_attr( $_wcaddon_price_is_per ); ?>" style="float: left; width:15%;" />
                    <select id="_wcaddon_price_time_option" name="_wcaddon_price_time_option" class="select" style="margin-left: 3px;">
                        <?php foreach ( datebook_wc_get_time_options() as $key => $value ):
                            $select = selected( $_wcaddon_price_time_option, $key, false );
                            echo '<option value="' . $key . '" ' . $select . ' data-max="'.$max_lengths[$key].'">' . $value . '</option>';
                        endforeach;
                        ?>
                    </select>
					
					<span class="description" style="float: left; clear:none; margin-left: 10px">0 = <?php echo esc_html__( 'unlimited', 'datebook' ); ?></span>
                </p>

                <?php /*?><p class="form-field wcaddon_max_length" style="display:none">
                    <label for="_wcaddon_max_length"><?php echo esc_html__( 'Max length:', 'datebook' ); ?>
                        <a href="#" class="tips" data-tip="<?php echo esc_html__( 'Leave it empty for unlimited subscription', 'datebook' ) ?>"> [?]</a></label>
                    <input type="text" class="short" name="_wcaddon_max_length" id="_wcaddon_max_length" value="<?php echo esc_attr( $_wcaddon_max_length ); ?>" style="float: left; width:15%; " />
                    <span class="description" style="float: left; clear:none; margin-left: 10px"><span><?php echo esc_attr($time_opt); ?></span> (<?php echo esc_html__('Max', 'datebook'); ?>: <span class="max-l"><?php echo esc_attr($max_lengths[$time_opt]); ?></span>)</span>
                </p><?php */?>
                
            </div>
            </div>

<?php

        }

	    /**
	     * Save custom fields for single product
	     *
	     */
	    public function save_custom_fields_for_single_products( $post_id, $post ) {

		    $product = wc_get_product( $post_id );
		    $args    = array();

		    $args['_datebook_subscribe'] = isset( $_POST['_datebook_subscribe'] ) ? 'yes' : 'no';

		    if ( isset( $_POST['_wcaddon_price_is_per'] ) ) {
			    $args['_wcaddon_price_is_per'] = $_POST['_wcaddon_price_is_per'];
		    }


		    if ( isset( $_POST['_wcaddon_price_time_option'] ) ) {
			    $args['_wcaddon_price_time_option'] = $_POST['_wcaddon_price_time_option'];
		    }

		    if ( isset( $_POST['_wcaddon_price_time_option'] ) && isset( $_POST['_wcaddon_max_length'] ) ) {
			    $max_length = datebook_wc_validate_max_length( $_POST['_wcaddon_max_length'], $_POST['_wcaddon_price_time_option'] );
			    $args['_wcaddon_max_length'] = $max_length;
		    }

		    if ( $args ) {
			    datebook_save_prop( $product, $args );
		    }

	    }


    }


/**
 * Unique access to instance of DateBook_WC_Subscription_Admin class
 *
 */
if ( is_admin() ) {
	DateBook_WC_Subscription_Admin::get_instance();
}

/**
 * Implements admin features of DateBook WooCommerce Subscription
 *
 */

class DateBook_WC_Made_Subscriptions_Admin extends DateBook_Submenu_Page {

        /**
         * Create Menu Items
         *
         */

		static function datebook_subscriptions_page_handler() {

			// Add a panel under DateBook Plugins tab
			self::output();
        }


        /**
         *
         * Load the subscriptions on admin page
         *
         */
        public static function output() {
			
            $cpt_obj_subscriptions = new DateBook_WC_Subscriptions_List_Table();

            ?>
            
            <div class="wrap">
            	<h1><?php echo esc_html__('Subscriptions', 'datebook') ?></h1>
                <p><?php esc_html_e('Payments made by WooCommerce Subscription functions', 'datebook')?></p>
                
                <div id="poststuff">
                	<div id="post-body" class="metabox-holder">
                    	<div id="post-body-content">
                        	<div class="meta-box-sortables ui-sortable">
                            	<form method="post">
                                	<?php
									
									$cpt_obj_subscriptions->prepare_items();
									$cpt_obj_subscriptions->display();
									
									?>
								</form>
							</div>
						</div>
					</div>
                    
                    <br class="clear">
                    
				</div>
			</div>
            
		<?php

        }

}