<?php

/*-----------------------------------------------------------------------------------

	Plugin Name: Register

-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'datebook_register_widgets' );

// Register widget.
function datebook_register_widgets() {
	register_widget( 'DateBook_Register_widget' );
}

// Widget class.
class DateBook_Register_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	function __construct() {
	
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'datebook-register-widget', 'description' => esc_html__( 'Displays Register / Login box.', 'datebook' ) );

		parent::__construct( 'datebook_register_widget', esc_html__( 'DateBook: Register / Login', 'datebook' ), $widget_ops );

	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = !empty($new_instance['title']) ? strip_tags( $new_instance['title'] ) : '';
		$instance['show_terms_on_register'] = !empty($new_instance['show_terms_on_register']) ? 1 : 0;
		$instance['show_terms_on_login'] = !empty($new_instance['show_terms_on_login']) ? 1 : 0;

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		'title' => 'Register',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		$show_terms_on_register = isset($instance['show_terms_on_register']) ? (bool) $instance['show_terms_on_register'] : false;
		$show_terms_on_login = isset($instance['show_terms_on_login']) ? (bool) $instance['show_terms_on_login'] : false;
		?>
		
		<p><input type="checkbox" id="<?php echo esc_attr($this->get_field_id('show_terms_on_register')); ?>" name="<?php echo esc_attr($this->get_field_name('show_terms_on_register'));?>" <?php checked($show_terms_on_register); ?> /> <?php esc_html_e("Show \"Terms and Conditions\" on Register", 'datebook' );?></p>
		<p><input type="checkbox" id="<?php echo esc_attr($this->get_field_id('show_terms_on_login')); ?>" name="<?php echo esc_attr($this->get_field_name('show_terms_on_login')); ?>" <?php checked($show_terms_on_login); ?> /> <?php esc_html_e("Show \"Terms and Conditions\" on Login", 'datebook' );?></p>
		<?php
	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$show_terms_on_register = isset($instance['show_terms_on_register']) ? (bool)$instance['show_terms_on_register']:1;
		$show_terms_on_login = isset($instance['show_terms_on_login']) ? (bool)$instance['show_terms_on_login']:1;
		
		/* Display Widget */
		?>
		<!-- sidebar -->
		<?php if (!is_user_logged_in()) {
			
			global $datebook_gender_titles;

		$datebook_field_titles = get_query_var( 'datebook_field_titles' );
		if ( is_array( $datebook_field_titles ) ) { extract($datebook_field_titles); }
		
		/* Before widget (defined by themes). */
		echo $before_widget;

		?>
		
		
		
		<div class="card-header">
		<ul id="datebook-side-login-panel" class="nav nav-pills nav-justified" role="tablist">
			<li class="nav-item"><a class="nav-link active" id="datebook-register" data-toggle="pill" href="#db-register" role="tab" aria-controls="pills-register" aria-selected="true"><?php esc_html_e( 'Register', 'datebook' ); ?></a></li>
			<li class="nav-item"><a class="nav-link" id="datebook-login" data-toggle="pill" href="#db-login" role="tab" aria-controls="pills-login" aria-selected="false"><?php esc_html_e( 'Login', 'datebook' ); ?></a></li>
		</ul>
		</div>
		
		<div class="tab-content" id="datebook-myTabContent">
			<div class="tab-pane fade show active" id="db-register" role="tabpanel" aria-labelledby="register-tab">

			<form action="<?php echo esc_url(get_permalink(of_get_option('registration_page'))); ?>" method="post">

				<input type="hidden" name="action" value="change" />
				<input type="hidden" name="reffer" value="widget" />

				<div class="card-body">
					<div class="form-group">
						<input type="text" name="profile_name" id="datebook-profile-name" value="" class="form-control" placeholder="<?php esc_html_e( 'Your name', 'datebook' ); ?>" title="<?php esc_html_e( 'Your name', 'datebook' ); ?>" />
					</div>
					<div class="form-group">
						<input type="email" name="emailaddress" id="datebook-emailaddress" value="" class="form-control" placeholder="<?php esc_html_e( 'Your email', 'datebook' ); ?>" title="<?php esc_html_e( 'Your email', 'datebook' ); ?>" />
					</div>
					<div class="form-group">
						<input type="password" name="pass" id="datebook-pass" value="" autocomplete="off" class="form-control" placeholder="<?php esc_html_e( 'Password', 'datebook' ); ?>" title="<?php esc_html_e( 'Password', 'datebook' ); ?>" />
					</div>

					<div class="form-group">
						<div id="datebook-gender">
							<div class="datebook-register-panel">
								<div class="btn-group d-flex btn-group-toggle btn-group-justified" data-toggle="buttons">

								<?php 

								if (of_get_option('gender_allowed') != '') {
									$allowed_gender = of_get_option('gender_allowed');
								}

								// Add custom Genders
								if (of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG) != '') {
									$allowed_gender_other_array = explode('<br />', strtr(of_get_option('gender_allowed_other_' . DATEBOOK_WPLANG), array("\r\n" => '<br />', "\r" => '<br />', "\n" => '<br />')));

									foreach ($allowed_gender_other_array as $key => $value ){
										$allowed_gender[] = 1;
									}
								}

								$count_genders = count( array_keys( $allowed_gender, 1 )); // count active genders
				
								if(isset($count_genders) && $count_genders > 2 ) {

									echo '<select class="custom-select" name="gender">';

								}

								foreach ($datebook_gender_titles as $key => $value) {

									if(isset($allowed_gender[$key]) && $allowed_gender[$key] == 1){

										if ($key == 1) {
											$gender_icon = 'venus';
										} else if ($key == 2) {
											$gender_icon = 'mars';
										}

										if(isset($count_genders) && $count_genders > 2 ) {

										?>

										<option value="<?php echo sanitize_key($key); ?>"<?php if (isset($datebook_get_data['gender']) && $datebook_get_data['gender'] == $key) { echo ' selected="selected"'; } ?>><?php echo esc_html__( $value, 'datebook' ); ?></option>

									<?php } else { ?>

										<label for="<?php echo str_replace('/', '', $value); ?>" class="btn btn-secondary btn-sm form-check-label w-100 waves-effect waves-light <?php if (isset($datebook_get_data['gender']) && $datebook_get_data['gender'] == $key) { echo ' active'; } ?>" title="<?php echo sprintf( esc_html__( '%1$s', 'datebook' ), $value ); ?>">

										<?php if (isset($gender_icon)) { ?>

											<i class="fas fa-<?php echo esc_attr($gender_icon);?>"></i>
											<div class="clearfix"></div>

										<?php } ?>

											<input type="radio" name="gender" value="<?php echo sanitize_key($key); ?>" id="<?php echo str_replace("/", "", $value); ?>"<?php if (isset($datebook_get_data['gender']) && $datebook_get_data['gender'] == $key) { echo ' checked="checked"'; } ?> /> <?php echo esc_html__( $value, 'datebook' ); ?>
										</label>

										<?php

										}
									}
								}

								if(isset($count_genders) && $count_genders > 2 ) {

									echo '</select>';

								}

								?>

							</div>
						</div>
					</div>
				</div>

				<div class="datebook-clear10"></div>

				<div class="form-group">
					<button type="submit" name="submit" class="btn btn-primary btn-block ml-0 mr-0"><?php esc_html_e( 'Register', 'datebook' ); ?></button>
				</div>
			</div>
			<div class="card-footer">

				<?php if ($show_terms_on_register == 1) { ?>

				<div class="form-group text-center">

					<?php

						echo sprintf('%s <a href="%s" target="_blank">%s</a>', esc_html__( 'By submitting data you agree to our', 'datebook' ), esc_url(get_permalink(of_get_option('terms_and_conditions_url')) ), esc_html__('Terms and Conditions', 'datebook'));

						?>

				</div>

				<?php } ?>

			</div>
			</form>
			</div>
			
			
			
			<?php
			
			/*
			 * Profile Login form
			 *
			 */

			global $datebook_form_error, $datebook_alert_error, $datebook_alert_text;

			if (of_get_option('login_method') == 1 && of_get_option('registration_method') == 1) {

				$login_email_title = esc_html__( 'Email or Username', 'datebook' );

			} else if (of_get_option('login_method') == 2) {

				$login_email_title = esc_html__( 'Email', 'datebook' );

			} else if (of_get_option('login_method') == 3 && of_get_option('registration_method') == 1) {

				$login_email_title = esc_html__( 'Username', 'datebook' );

			} else {

				$login_email_title = esc_html__( 'Email', 'datebook' );

			}

			$login_url = get_permalink(of_get_option('login_page'));

			?>
			
			<div class="tab-pane fade" id="db-login" role="tabpanel" aria-labelledby="login-tab">
			
				<?php

				$google_recaptcha = of_get_option('google_recaptcha');

				if ( is_wp_error( $datebook_form_error ) ) {

					$datebook_alert_error = array();
					$datebook_alert_text = array();

				?>

				<div class="alert alert-danger text-center">

					<?php if($google_recaptcha['1'] == '1'){ ?>

					<ul class="pb-0 mb-0 text-left">

					<?php } ?>

					<?php 

						foreach($datebook_form_error->get_error_codes() as $code){

							$datebook_alert_error[$code] = $datebook_form_error->get_error_data($code);
							$datebook_alert_text[$code] = $datebook_form_error->get_error_message($code);

							if($google_recaptcha['1'] == '1'){
								echo '<li>';
							}

							echo esc_attr($datebook_alert_text[$code]);

							if($google_recaptcha['1'] == '1'){
								echo '</li>';
							}

						}

					?>

					<?php if($google_recaptcha['1'] == '1'){ ?>

					</ul>

					<?php } ?>

				</div>

				<?php } ?>

				<?php if (isset($datebook_alert_text['success_login'])) { ?>

				<div class="alert alert-success text-center">

					<?php echo esc_attr($datebook_alert_text['success_login']); ?>

				</div>

				<?php } ?>


				<form method="post" action="<?php echo esc_url($login_url); ?>" id="datebook-loginform" name="loginform">
					<input type="hidden" name="testcookie" value="1" />

					<div class="card-body">
						<div class="form-group">
							<input type="text" value="" class="form-control" id="datebook-user-login" name="log" placeholder="<?php echo esc_attr($login_email_title); ?>" />
						</div>
						<div class="form-group">
							<input type="password" value="" class="form-control" id="datebook-user-pass" name="pwd" placeholder="<?php esc_html_e( 'Password', 'datebook' ); ?>" />
						</div>
						<div class="form-group">
							<div class="custom-control custom-checkbox">
								<input type="checkbox" value="forever" id="datebook-rememberme" class="custom-control-input" name="rememberme">
								<label class="custom-control-label" for="datebook-rememberme"><?php esc_html_e( 'Remember', 'datebook' ); ?></label>
								<a href="<?php echo esc_url(get_permalink(of_get_option('forgot_password_page'))); ?>" class="float-right"><?php esc_html_e( 'Forgot?', 'datebook' ); ?></a> 
							</div>
						</div>
						
						<?php

						if ($google_recaptcha['1'] == '1') {
							
							$google_recaptcha_sitekey = of_get_option('google_recaptcha_sitekey') ? of_get_option('google_recaptcha_sitekey') : '';
							
							?>
							
							<div class="g-recaptcha" data-sitekey="<?php echo esc_attr($google_recaptcha_sitekey); ?>"></div>
							
						<?php } ?>

						<div class="datebook-clear10"></div>
						<div class="form-group">
							<button type="submit" class="btn btn-primary btn-block ml-0 mr-0" id="submit" name="submit"><?php esc_html_e( 'Login', 'datebook' ); ?></button>
						</div>
					</div>
					<div class="card-footer">

					<?php if ($show_terms_on_login == 1) { ?>

						<div class="form-group text-center">

						<?php

						echo sprintf('%s <a href="%s" target="_blank">%s</a>', esc_html__( 'By submitting data you agree to our', 'datebook' ), esc_url(get_permalink(of_get_option('terms_and_conditions_url'))), esc_html__('Terms and Conditions', 'datebook'));

						?>

						</div>

					<?php } ?>

					</div>
				</form>
			</div>
		</div>


		<?php 

		/* After widget (defined by themes). */
		echo $after_widget;
		
		} ?>
		<!-- /sidebar -->
		<?php
		
	}

}